/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.ByteFilter;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class ByteFilterOutputStream
extends FilterOutputStream {
    private final Thread worker;
    @Nullable
    private IOException byteFilterIOException;
    @Nullable
    private RuntimeException byteFilterRuntimeException;

    public ByteFilterOutputStream(final ByteFilter<?> byteFilter, final OutputStream out) {
        super(new PipedOutputStream());
        PipedInputStream pis;
        try {
            pis = new PipedInputStream((PipedOutputStream)this.out);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.worker = new Thread("ByteFilterOutputStream"){

            @Override
            public void run() {
                try {
                    try {
                        byteFilter.run(pis, out);
                    }
                    catch (IOException ioe) {
                        ByteFilterOutputStream.this.byteFilterIOException = ioe;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (RuntimeException re) {
                        ByteFilterOutputStream.this.byteFilterRuntimeException = re;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.worker.start();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.byteFilterIOException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterIOException);
        }
        if (this.byteFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterRuntimeException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this.byteFilterIOException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterIOException);
        }
        if (this.byteFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterRuntimeException);
        }
    }
}

