/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.jdisasm.ClassFileFormatException;
import de.unkrig.jdisasm.ConstantPool;
import de.unkrig.jdisasm.SignatureParser;
import de.unkrig.jdisasm.commons.nullanalysis.Nullable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassFile {
    public short minorVersion;
    public short majorVersion;
    public ConstantPool constantPool;
    public short accessFlags;
    public String thisClassName;
    @Nullable
    public String superClassName;
    public final List<String> interfaceNames = new ArrayList<String>();
    public final List<Field> fields = new ArrayList<Field>();
    public final List<Method> methods = new ArrayList<Method>();
    @Nullable
    public BootstrapMethodsAttribute bootstrapMethodsAttribute;
    @Nullable
    public DeprecatedAttribute deprecatedAttribute;
    @Nullable
    public EnclosingMethodAttribute enclosingMethodAttribute;
    @Nullable
    public InnerClassesAttribute innerClassesAttribute;
    @Nullable
    public RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
    @Nullable
    public RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
    @Nullable
    public SignatureAttribute signatureAttribute;
    @Nullable
    public SourceFileAttribute sourceFileAttribute;
    @Nullable
    public SyntheticAttribute syntheticAttribute;
    public final List<Attribute> attributes = new ArrayList<Attribute>();
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_VARARGS = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;

    public ClassFile(DataInputStream dis) throws IOException {
        int magic = dis.readInt();
        if (magic != -889275714) {
            throw new ClassFileFormatException("Wrong magic number 0x" + Integer.toHexString(magic));
        }
        this.minorVersion = dis.readShort();
        this.majorVersion = dis.readShort();
        this.constantPool = new ConstantPool(dis);
        this.accessFlags = dis.readShort();
        this.thisClassName = this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantClassInfo.class).name;
        ConstantPool.ConstantClassInfo superclassCci = this.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
        this.superClassName = superclassCci == null ? null : superclassCci.name;
        short i = dis.readShort();
        while (i > 0) {
            this.interfaceNames.add(this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantClassInfo.class).name);
            i = (short)(i - 1);
        }
        short n = dis.readShort();
        short i2 = 0;
        while (i2 < n) {
            try {
                this.fields.add(new Field(dis));
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading field #" + i2 + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Reading field #" + i2 + " of " + n + ": " + re.getMessage(), re);
            }
            i2 = (short)(i2 + 1);
        }
        n = dis.readShort();
        i2 = 0;
        while (i2 < n) {
            try {
                this.methods.add(new Method(dis));
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading method #" + i2 + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Reading method #" + i2 + " of " + n + ": " + re.getMessage(), re);
            }
            i2 = (short)(i2 + 1);
        }
        this.readAttributes(dis, new AbstractAttributeVisitor(){

            @Override
            public void visit(BootstrapMethodsAttribute bma) {
                ClassFile.this.bootstrapMethodsAttribute = bma;
                ClassFile.this.attributes.add(bma);
            }

            @Override
            public void visit(DeprecatedAttribute da) {
                ClassFile.this.deprecatedAttribute = da;
                ClassFile.this.attributes.add(da);
            }

            @Override
            public void visit(EnclosingMethodAttribute ema) {
                ClassFile.this.enclosingMethodAttribute = ema;
                ClassFile.this.attributes.add(ema);
            }

            @Override
            public void visit(InnerClassesAttribute ica) {
                ClassFile.this.innerClassesAttribute = ica;
                ClassFile.this.attributes.add(ica);
            }

            @Override
            public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                ClassFile.this.runtimeInvisibleAnnotationsAttribute = riaa;
                ClassFile.this.attributes.add(riaa);
            }

            @Override
            public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                ClassFile.this.runtimeVisibleAnnotationsAttribute = rvaa;
                ClassFile.this.attributes.add(rvaa);
            }

            @Override
            public void visit(SignatureAttribute sa) {
                ClassFile.this.signatureAttribute = sa;
                ClassFile.this.attributes.add(sa);
            }

            @Override
            public void visit(SourceFileAttribute sfa) {
                ClassFile.this.sourceFileAttribute = sfa;
                ClassFile.this.attributes.add(sfa);
            }

            @Override
            public void visit(SyntheticAttribute sa) {
                ClassFile.this.syntheticAttribute = sa;
                ClassFile.this.attributes.add(sa);
            }

            @Override
            public void visitOther(Attribute a) {
                ClassFile.this.attributes.add(a);
            }
        });
    }

    public String getJdkName() {
        switch (this.majorVersion) {
            case 51: {
                return "J2SE 7";
            }
            case 50: {
                return "J2SE 6.0";
            }
            case 49: {
                return "J2SE 5.0";
            }
            case 48: {
                return "JDK 1.4";
            }
            case 47: {
                return "JDK 1.3";
            }
            case 46: {
                return "JDK 1.2";
            }
            case 45: {
                return "JDK 1.1";
            }
        }
        return "Java " + (this.majorVersion - 44);
    }

    final void readAttributes(DataInputStream dis, AttributeVisitor visitor) throws IOException {
        int n = dis.readShort();
        int i = 0;
        while (i < n) {
            try {
                this.readAttribute(dis, visitor);
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Reading attribute #" + i + " of " + n + ": " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Reading attribute #" + i + " of " + n + ": " + re.getMessage(), re);
            }
            ++i;
        }
    }

    private void readAttribute(DataInputStream dis, AttributeVisitor visitor) throws IOException {
        String attributeName = this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        try {
            int attributeLength = dis.readInt();
            byte[] ba = new byte[attributeLength];
            dis.readFully(ba);
            ByteArrayInputStream bais = new ByteArrayInputStream(ba);
            this.readAttributeBody(attributeName, new DataInputStream(bais), visitor);
            int av = bais.available();
            if (av > 0) {
                throw new RuntimeException(String.valueOf(av) + " extraneous bytes in attribute body");
            }
        }
        catch (IOException ioe) {
            IOException ioe2 = new IOException("Reading attribute '" + attributeName + "': " + ioe.getMessage());
            ioe2.initCause(ioe);
            throw ioe2;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Reading attribute '" + attributeName + "': " + re.getMessage(), re);
        }
    }

    private void readAttributeBody(String attributeName, DataInputStream dis, AttributeVisitor visitor) throws IOException {
        if ("AnnotationDefault".equals(attributeName)) {
            visitor.visit(new AnnotationDefaultAttribute(dis, this));
        } else if ("BootstrapMethods".equals(attributeName)) {
            visitor.visit(new BootstrapMethodsAttribute(dis, this));
        } else if ("ConstantValue".equals(attributeName)) {
            visitor.visit(new ConstantValueAttribute(dis, this));
        } else if ("Code".equals(attributeName)) {
            visitor.visit(new CodeAttribute(dis, this));
        } else if ("Deprecated".equals(attributeName)) {
            visitor.visit(new DeprecatedAttribute(dis, this));
        } else if ("EnclosingMethod".equals(attributeName)) {
            visitor.visit(new EnclosingMethodAttribute(dis, this));
        } else if ("Exceptions".equals(attributeName)) {
            visitor.visit(new ExceptionsAttribute(dis, this));
        } else if ("InnerClasses".equals(attributeName)) {
            visitor.visit(new InnerClassesAttribute(dis, this));
        } else if ("LineNumberTable".equals(attributeName)) {
            visitor.visit(new LineNumberTableAttribute(dis, this));
        } else if ("LocalVariableTable".equals(attributeName)) {
            visitor.visit(new LocalVariableTableAttribute(dis, this));
        } else if ("LocalVariableTypeTable".equals(attributeName)) {
            visitor.visit(new LocalVariableTypeTableAttribute(dis, this));
        } else if ("RuntimeInvisibleAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeInvisibleAnnotationsAttribute(dis, this));
        } else if ("RuntimeInvisibleParameterAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeInvisibleParameterAnnotationsAttribute(dis, this));
        } else if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeVisibleAnnotationsAttribute(dis, this));
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            visitor.visit(new RuntimeVisibleParameterAnnotationsAttribute(dis, this));
        } else if ("Signature".equals(attributeName)) {
            visitor.visit(new SignatureAttribute(dis, this));
        } else if ("SourceFile".equals(attributeName)) {
            visitor.visit(new SourceFileAttribute(dis, this));
        } else if ("Synthetic".equals(attributeName)) {
            visitor.visit(new SyntheticAttribute(dis, this));
        } else {
            visitor.visit(new UnknownAttribute(attributeName, dis, this));
        }
    }

    static ElementValue newElementValue(DataInputStream dis, ClassFile cf) throws IOException {
        final byte tag = dis.readByte();
        if ("BCDFIJSZ".indexOf(tag) != -1) {
            final String s = cf.constantPool.getIntegerFloatLongDouble(dis.readShort());
            return new ElementValue(){

                public String toString() {
                    return s;
                }
            };
        }
        if (tag == 115) {
            final String s = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            return new ElementValue(){

                public String toString() {
                    return ConstantPool.stringToJavaLiteral(s);
                }
            };
        }
        if (tag == 101) {
            String typeName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            String constName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                final String s = SignatureParser.decodeFieldDescriptor(typeName) + "." + constName;
                return new ElementValue(){

                    public String toString() {
                        return s;
                    }
                };
            }
            catch (SignatureParser.SignatureException se) {
                throw new ClassFileFormatException("Decoding enum constant element value: " + se.getMessage(), se);
            }
        }
        if (tag == 99) {
            String classInfo = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                final String s = SignatureParser.decodeReturnType(classInfo) + ".class";
                return new ElementValue(){

                    public String toString() {
                        return s;
                    }
                };
            }
            catch (SignatureParser.SignatureException se) {
                throw new ClassFileFormatException("Decoding class element value: " + se.getMessage(), se);
            }
        }
        if (tag == 64) {
            final Annotation annotation = new Annotation(dis, cf);
            return new ElementValue(){

                public String toString() {
                    return annotation.toString();
                }
            };
        }
        if (tag == 91) {
            final ArrayList<ElementValue> values = new ArrayList<ElementValue>();
            int i = dis.readShort();
            while (i > 0) {
                values.add(ClassFile.newElementValue(dis, cf));
                --i;
            }
            return new ElementValue(){

                public String toString() {
                    Iterator it = values.iterator();
                    if (!it.hasNext()) {
                        return "{}";
                    }
                    ElementValue firstValue = (ElementValue)it.next();
                    if (!it.hasNext()) {
                        return firstValue.toString();
                    }
                    StringBuilder sb = new StringBuilder("{ ").append(firstValue.toString());
                    do {
                        sb.append(", ").append(((ElementValue)it.next()).toString());
                    } while (it.hasNext());
                    return sb.append(" }").toString();
                }
            };
        }
        return new ElementValue(){

            public String toString() {
                return "[Invalid element value tag '" + (char)tag + "']";
            }
        };
    }

    private static byte[] readByteArray(DataInputStream dis, int size) throws IOException {
        byte[] res = new byte[size];
        dis.readFully(res);
        return res;
    }

    public static abstract class AbstractAttributeVisitor
    implements AttributeVisitor {
        public abstract void visitOther(Attribute var1);

        @Override
        public void visit(BootstrapMethodsAttribute bma) {
            this.visitOther(bma);
        }

        @Override
        public void visit(AnnotationDefaultAttribute ada) {
            this.visitOther(ada);
        }

        @Override
        public void visit(CodeAttribute ca) {
            this.visitOther(ca);
        }

        @Override
        public void visit(ConstantValueAttribute cva) {
            this.visitOther(cva);
        }

        @Override
        public void visit(DeprecatedAttribute da) {
            this.visitOther(da);
        }

        @Override
        public void visit(EnclosingMethodAttribute ema) {
            this.visitOther(ema);
        }

        @Override
        public void visit(ExceptionsAttribute ea) {
            this.visitOther(ea);
        }

        @Override
        public void visit(InnerClassesAttribute ica) {
            this.visitOther(ica);
        }

        @Override
        public void visit(LineNumberTableAttribute lnta) {
            this.visitOther(lnta);
        }

        @Override
        public void visit(LocalVariableTableAttribute lvta) {
            this.visitOther(lvta);
        }

        @Override
        public void visit(LocalVariableTypeTableAttribute lvtta) {
            this.visitOther(lvtta);
        }

        @Override
        public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
            this.visitOther(riaa);
        }

        @Override
        public void visit(RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
            this.visitOther(ripaa);
        }

        @Override
        public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
            this.visitOther(rvaa);
        }

        @Override
        public void visit(RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
            this.visitOther(rvpaa);
        }

        @Override
        public void visit(SignatureAttribute sa) {
            this.visitOther(sa);
        }

        @Override
        public void visit(SourceFileAttribute sfa) {
            this.visitOther(sfa);
        }

        @Override
        public void visit(SyntheticAttribute sa) {
            this.visitOther(sa);
        }

        @Override
        public void visit(UnknownAttribute a) {
            this.visitOther(a);
        }
    }

    public static class Annotation {
        public String typeName;
        public final List<ElementValuePair> elementValuePairs = new ArrayList<ElementValuePair>();

        public Annotation(DataInputStream dis, ClassFile cf) throws IOException {
            short typeIndex = dis.readShort();
            try {
                this.typeName = SignatureParser.decodeFieldDescriptor(cf.constantPool.get((short)typeIndex, ConstantPool.ConstantUtf8Info.class).bytes).toString();
            }
            catch (SignatureParser.SignatureException e) {
                throw new ClassFileFormatException("Decoding annotation type: " + e.getMessage(), e);
            }
            int i = dis.readShort();
            while (i > 0) {
                this.elementValuePairs.add(new ElementValuePair(dis, cf));
                --i;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("@").append(this.typeName);
            if (!this.elementValuePairs.isEmpty()) {
                Iterator<ElementValuePair> it = this.elementValuePairs.iterator();
                sb.append('(').append(it.next());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next());
                }
                return sb.append(')').toString();
            }
            return sb.toString();
        }

        public static class ElementValuePair {
            public final String elementName;
            public final ElementValue elementValue;

            public ElementValuePair(DataInputStream dis, ClassFile cf) throws IOException {
                this.elementName = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.elementValue = ClassFile.newElementValue(dis, cf);
            }

            public String toString() {
                return "value".equals(this.elementName) ? this.elementValue.toString() : String.valueOf(this.elementName) + " = " + this.elementValue.toString();
            }
        }
    }

    public static class AnnotationDefaultAttribute
    implements Attribute {
        public ElementValue defaultValue;

        AnnotationDefaultAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.defaultValue = ClassFile.newElementValue(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "AnnotationDefault";
        }
    }

    public static interface Attribute {
        public void accept(AttributeVisitor var1);

        public String getName();
    }

    public static interface AttributeVisitor {
        public void visit(AnnotationDefaultAttribute var1);

        public void visit(CodeAttribute var1);

        public void visit(ConstantValueAttribute var1);

        public void visit(DeprecatedAttribute var1);

        public void visit(EnclosingMethodAttribute var1);

        public void visit(ExceptionsAttribute var1);

        public void visit(InnerClassesAttribute var1);

        public void visit(LineNumberTableAttribute var1);

        public void visit(LocalVariableTableAttribute var1);

        public void visit(LocalVariableTypeTableAttribute var1);

        public void visit(RuntimeInvisibleAnnotationsAttribute var1);

        public void visit(RuntimeInvisibleParameterAnnotationsAttribute var1);

        public void visit(RuntimeVisibleAnnotationsAttribute var1);

        public void visit(RuntimeVisibleParameterAnnotationsAttribute var1);

        public void visit(SignatureAttribute var1);

        public void visit(SourceFileAttribute var1);

        public void visit(SyntheticAttribute var1);

        public void visit(BootstrapMethodsAttribute var1);

        public void visit(UnknownAttribute var1);
    }

    public static class BootstrapMethodsAttribute
    implements Attribute {
        public List<BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethod>();

        BootstrapMethodsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readShort();
            while (i > 0) {
                this.bootstrapMethods.add(new BootstrapMethod(dis, cf));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "BootstrapMethods";
        }

        public static class BootstrapMethod {
            private final ConstantPool.ConstantMethodHandleInfo bootstrapMethod;
            public final List<ConstantPool.ConstantPoolEntry> bootstrapArguments = new ArrayList<ConstantPool.ConstantPoolEntry>();

            public BootstrapMethod(DataInputStream dis, ClassFile cf) throws IOException {
                this.bootstrapMethod = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantMethodHandleInfo.class);
                int i = dis.readShort();
                while (i > 0) {
                    this.bootstrapArguments.add(cf.constantPool.get(dis.readShort(), ConstantPool.ConstantPoolEntry.class));
                    --i;
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder().append(this.bootstrapMethod).append('(');
                Iterator<ConstantPool.ConstantPoolEntry> it = this.bootstrapArguments.iterator();
                if (it.hasNext()) {
                    sb.append(it.next());
                    while (it.hasNext()) {
                        sb.append(", ").append(it.next());
                    }
                }
                return sb.append(')').toString();
            }
        }
    }

    public static final class CodeAttribute
    implements Attribute {
        public final short maxStack;
        public final short maxLocals;
        public final byte[] code;
        public final List<ExceptionTableEntry> exceptionTable = new ArrayList<ExceptionTableEntry>();
        @Nullable
        public LocalVariableTableAttribute localVariableTableAttribute;
        @Nullable
        public LocalVariableTypeTableAttribute localVariableTypeTableAttribute;
        @Nullable
        public LineNumberTableAttribute lineNumberTableAttribute;
        public final List<Attribute> attributes = new ArrayList<Attribute>();

        CodeAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.maxStack = dis.readShort();
            this.maxLocals = dis.readShort();
            this.code = ClassFile.readByteArray(dis, dis.readInt());
            short i = dis.readShort();
            while (i > 0) {
                this.exceptionTable.add(new ExceptionTableEntry(dis, cf));
                i = (short)(i - 1);
            }
            cf.readAttributes(dis, new AbstractAttributeVisitor(){

                @Override
                public void visit(LineNumberTableAttribute lnta) {
                    CodeAttribute.this.lineNumberTableAttribute = lnta;
                    CodeAttribute.this.attributes.add(lnta);
                }

                @Override
                public void visit(LocalVariableTableAttribute lvta) {
                    CodeAttribute.this.localVariableTableAttribute = lvta;
                    CodeAttribute.this.attributes.add(lvta);
                }

                @Override
                public void visit(LocalVariableTypeTableAttribute lvtta) {
                    CodeAttribute.this.localVariableTypeTableAttribute = lvtta;
                    CodeAttribute.this.attributes.add(lvtta);
                }

                @Override
                public void visitOther(Attribute ai) {
                    CodeAttribute.this.attributes.add(ai);
                }
            });
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Code";
        }
    }

    public static final class ConstantValueAttribute
    implements Attribute {
        public final String constantValue;

        ConstantValueAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.constantValue = cf.constantPool.getIntegerFloatLongDoubleString(dis.readShort());
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "ConstantValue";
        }
    }

    public static class DeprecatedAttribute
    implements Attribute {
        public DeprecatedAttribute(DataInputStream dis, ClassFile cf) {
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Deprecated";
        }
    }

    public static interface ElementValue {
    }

    public static final class EnclosingMethodAttribute
    implements Attribute {
        public ConstantPool.ConstantClassInfo clasS;
        @Nullable
        public ConstantPool.ConstantNameAndTypeInfo method;

        EnclosingMethodAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.clasS = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class);
            this.method = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantNameAndTypeInfo.class);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "EnclosingMethod";
        }
    }

    public static class ExceptionTableEntry {
        public int startPc;
        public int endPc;
        public int handlerPc;
        @Nullable
        public ConstantPool.ConstantClassInfo catchType;

        ExceptionTableEntry(DataInputStream dis, ClassFile cf) throws IOException {
            this.startPc = 0xFFFF & dis.readShort();
            this.endPc = 0xFFFF & dis.readShort();
            this.handlerPc = 0xFFFF & dis.readShort();
            this.catchType = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
        }

        public String toString() {
            return "startPC=" + this.startPc + " endPC=" + this.endPc + " handlerPC=" + this.handlerPc + " catchType=" + this.catchType;
        }
    }

    public static final class ExceptionsAttribute
    implements Attribute {
        public final List<ConstantPool.ConstantClassInfo> exceptionNames = new ArrayList<ConstantPool.ConstantClassInfo>();

        ExceptionsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readShort();
            while (i > 0) {
                this.exceptionNames.add(cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Exceptions";
        }
    }

    public class Field {
        public short accessFlags;
        public String name;
        public String descriptor;
        @Nullable
        public ConstantValueAttribute constantValueAttribute;
        @Nullable
        public DeprecatedAttribute deprecatedAttribute;
        @Nullable
        public RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
        @Nullable
        public RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
        @Nullable
        public SignatureAttribute signatureAttribute;
        @Nullable
        public SyntheticAttribute syntheticAttribute;
        public final List<Attribute> attributes = new ArrayList<Attribute>();

        public Field(DataInputStream dis) throws IOException {
            this.accessFlags = dis.readShort();
            this.name = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            this.descriptor = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            ClassFile.this.readAttributes(dis, new AbstractAttributeVisitor(){

                @Override
                public void visit(ConstantValueAttribute cva) {
                    Field.this.constantValueAttribute = cva;
                    Field.this.attributes.add(cva);
                }

                @Override
                public void visit(DeprecatedAttribute da) {
                    Field.this.deprecatedAttribute = da;
                    Field.this.attributes.add(da);
                }

                @Override
                public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                    Field.this.runtimeInvisibleAnnotationsAttribute = riaa;
                    Field.this.attributes.add(riaa);
                }

                @Override
                public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                    Field.this.runtimeVisibleAnnotationsAttribute = rvaa;
                    Field.this.attributes.add(rvaa);
                }

                @Override
                public void visit(SignatureAttribute sa) {
                    Field.this.signatureAttribute = sa;
                    Field.this.attributes.add(sa);
                }

                @Override
                public void visit(SyntheticAttribute sa) {
                    Field.this.syntheticAttribute = sa;
                    Field.this.attributes.add(sa);
                }

                @Override
                public void visitOther(Attribute ai) {
                    Field.this.attributes.add(ai);
                }
            });
        }
    }

    public static final class InnerClassesAttribute
    implements Attribute {
        public final List<ClasS> classes = new ArrayList<ClasS>();

        InnerClassesAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readShort();
            while (i > 0) {
                this.classes.add(new ClasS(dis, cf));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "InnerClasses";
        }

        public static class ClasS {
            public final ConstantPool.ConstantClassInfo innerClassInfo;
            @Nullable
            public final ConstantPool.ConstantClassInfo outerClassInfo;
            @Nullable
            public final ConstantPool.ConstantUtf8Info innerName;
            public final short innerClassAccessFlags;

            public ClasS(DataInputStream dis, ClassFile cf) throws IOException {
                this.innerClassInfo = cf.constantPool.get(dis.readShort(), ConstantPool.ConstantClassInfo.class);
                this.outerClassInfo = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantClassInfo.class);
                this.innerName = cf.constantPool.getOptional(dis.readShort(), ConstantPool.ConstantUtf8Info.class);
                this.innerClassAccessFlags = dis.readShort();
            }
        }
    }

    public class LineNumberTableAttribute
    implements Attribute {
        public final List<LineNumberTableEntry> entries = new ArrayList<LineNumberTableEntry>();

        LineNumberTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readShort();
            while (i > 0) {
                this.entries.add(new LineNumberTableEntry(dis));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LineNumberTable";
        }
    }

    public static class LineNumberTableEntry {
        public int startPc;
        public int lineNumber;

        LineNumberTableEntry(DataInputStream dis) throws IOException {
            this.startPc = 0xFFFF & dis.readShort();
            this.lineNumber = 0xFFFF & dis.readShort();
        }
    }

    public class LocalVariableTableAttribute
    implements Attribute {
        public final List<Entry> entries = new ArrayList<Entry>();

        LocalVariableTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            short i = dis.readShort();
            while (i > 0) {
                this.entries.add(new Entry(dis, cf));
                i = (short)(i - 1);
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LocalVariableTable";
        }

        class Entry {
            public final short startPC;
            public final short length;
            public final String name;
            public final String descriptor;
            public final short index;

            Entry(DataInputStream dis, ClassFile cf) throws IOException {
                this.startPC = dis.readShort();
                this.length = dis.readShort();
                this.name = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.descriptor = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.index = dis.readShort();
            }
        }
    }

    public static class LocalVariableTypeTableAttribute
    implements Attribute {
        public final List<Entry> entries = new ArrayList<Entry>();

        LocalVariableTypeTableAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            short i = dis.readShort();
            while (i > 0) {
                this.entries.add(new Entry(dis, cf));
                i = (short)(i - 1);
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "LocalVariableTypeTable";
        }

        public static class Entry {
            public final int startPC;
            public final int length;
            public final String name;
            public final String signature;
            public final short index;

            Entry(DataInputStream dis, ClassFile cf) throws IOException {
                this.startPC = 0xFFFF & dis.readShort();
                this.length = 0xFFFF & dis.readShort();
                this.name = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.signature = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
                this.index = dis.readShort();
            }
        }
    }

    public class Method {
        public short accessFlags;
        public String name;
        public String descriptor;
        public final List<Attribute> attributes = new ArrayList<Attribute>();
        @Nullable
        public AnnotationDefaultAttribute annotationDefaultAttribute;
        @Nullable
        public CodeAttribute codeAttribute;
        @Nullable
        public DeprecatedAttribute deprecatedAttribute;
        @Nullable
        public ExceptionsAttribute exceptionsAttribute;
        @Nullable
        public RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute;
        @Nullable
        public RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute;
        @Nullable
        public RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute;
        @Nullable
        public RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute;
        @Nullable
        public SignatureAttribute signatureAttribute;
        @Nullable
        public SyntheticAttribute syntheticAttribute;

        public Method(DataInputStream dis) throws IOException {
            this.accessFlags = dis.readShort();
            this.name = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            this.descriptor = ClassFile.this.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
            try {
                ClassFile.this.readAttributes(dis, new AbstractAttributeVisitor(){

                    @Override
                    public void visit(AnnotationDefaultAttribute ada) {
                        Method.this.annotationDefaultAttribute = ada;
                        Method.this.attributes.add(ada);
                    }

                    @Override
                    public void visit(CodeAttribute ca) {
                        Method.this.codeAttribute = ca;
                        Method.this.attributes.add(ca);
                    }

                    @Override
                    public void visit(DeprecatedAttribute da) {
                        Method.this.deprecatedAttribute = da;
                        Method.this.attributes.add(da);
                    }

                    @Override
                    public void visit(ExceptionsAttribute ea) {
                        Method.this.exceptionsAttribute = ea;
                        Method.this.attributes.add(ea);
                    }

                    @Override
                    public void visit(RuntimeInvisibleAnnotationsAttribute riaa) {
                        Method.this.runtimeInvisibleAnnotationsAttribute = riaa;
                        Method.this.attributes.add(riaa);
                    }

                    @Override
                    public void visit(RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
                        Method.this.runtimeInvisibleParameterAnnotationsAttribute = ripaa;
                        Method.this.attributes.add(ripaa);
                    }

                    @Override
                    public void visit(RuntimeVisibleAnnotationsAttribute rvaa) {
                        Method.this.runtimeVisibleAnnotationsAttribute = rvaa;
                        Method.this.attributes.add(rvaa);
                    }

                    @Override
                    public void visit(RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
                        Method.this.runtimeVisibleParameterAnnotationsAttribute = rvpaa;
                        Method.this.attributes.add(rvpaa);
                    }

                    @Override
                    public void visit(SignatureAttribute sa) {
                        Method.this.signatureAttribute = sa;
                        Method.this.attributes.add(sa);
                    }

                    @Override
                    public void visit(SyntheticAttribute sa) {
                        Method.this.syntheticAttribute = sa;
                        Method.this.attributes.add(sa);
                    }

                    @Override
                    public void visitOther(Attribute ai) {
                        Method.this.attributes.add(ai);
                    }
                });
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Parsing method '" + this.name + "' [" + this.descriptor + "]: " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Parsing method '" + this.name + "' [" + this.descriptor + "]: " + re.getMessage(), re);
            }
        }

        public BootstrapMethodsAttribute getBootstrapMethodsAttribute() {
            BootstrapMethodsAttribute result = ClassFile.this.bootstrapMethodsAttribute;
            if (result == null) {
                throw new RuntimeException("BootstrapMethods attribute missing");
            }
            return result;
        }
    }

    public static class ParameterAnnotation {
        public final List<Annotation> annotations = new ArrayList<Annotation>();

        public ParameterAnnotation(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readShort();
            while (i > 0) {
                this.annotations.add(new Annotation(dis, cf));
                --i;
            }
        }
    }

    public static class RuntimeInvisibleAnnotationsAttribute
    extends RuntimeVisibleAnnotationsAttribute {
        public RuntimeInvisibleAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class RuntimeInvisibleParameterAnnotationsAttribute
    extends RuntimeVisibleParameterAnnotationsAttribute {
        public RuntimeInvisibleParameterAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            super(dis, cf);
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class RuntimeVisibleAnnotationsAttribute
    implements Attribute {
        public final List<Annotation> annotations = new ArrayList<Annotation>();

        RuntimeVisibleAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = 0xFFFF & dis.readShort();
            while (i > 0) {
                this.annotations.add(new Annotation(dis, cf));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "RuntimeVisibleAnnotations";
        }
    }

    public static class RuntimeVisibleParameterAnnotationsAttribute
    implements Attribute {
        public final List<ParameterAnnotation> parameterAnnotations = new ArrayList<ParameterAnnotation>();

        RuntimeVisibleParameterAnnotationsAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            int i = dis.readByte();
            while (i > 0) {
                this.parameterAnnotations.add(new ParameterAnnotation(dis, cf));
                --i;
            }
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "RuntimeVisibleParameterAnnotations";
        }
    }

    public static final class SignatureAttribute
    implements Attribute {
        public final String signature;

        SignatureAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.signature = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Signature";
        }
    }

    public static class SourceFileAttribute
    implements Attribute {
        public String sourceFile;

        SourceFileAttribute(DataInputStream dis, ClassFile cf) throws IOException {
            this.sourceFile = cf.constantPool.get((short)dis.readShort(), ConstantPool.ConstantUtf8Info.class).bytes;
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "SourceFile";
        }
    }

    public static class SyntheticAttribute
    implements Attribute {
        public SyntheticAttribute(DataInputStream dis, ClassFile cf) {
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return "Synthetic";
        }
    }

    public static final class UnknownAttribute
    implements Attribute {
        public final String name;
        public byte[] info;

        UnknownAttribute(String name, DataInputStream dis, ClassFile cf) throws IOException {
            this.name = name;
            this.info = ClassFile.readByteArray(dis, dis.available());
        }

        @Override
        public void accept(AttributeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

