/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.formatter;

import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class PrintfFormatter
extends Formatter {
    public static final String FORMAT_STRING_BENCHMARK = "%12$s %10$-20s %3$2d %8$s%n";
    public static final String FORMAT_STRING_COMPACT = "%4$s %6$s::%7$s %8$s%9$s%n";
    public static final String FORMAT_STRING_MESSAGE = "%8$s%n";
    public static final String FORMAT_STRING_MESSAGE_AND_EXCEPTION = "%8$s%11$s%n";
    public static final String FORMAT_STRING_MESSAGE_AND_STACK_TRACE = "%8$s%9$s%n";
    public static final String FORMAT_STRING_SIMPLE = "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n";
    public static final String FORMAT_STRING_TIME_MESSAGE = "%5$tF %5$tT.%5$tL %8$s%n";
    public static final PrintfFormatter BENCHMARK = new PrintfFormatter("%12$s %10$-20s %3$2d %8$s%n");
    public static final PrintfFormatter COMPACT = new PrintfFormatter("%4$s %6$s::%7$s %8$s%9$s%n");
    public static final PrintfFormatter MESSAGE = new PrintfFormatter("%8$s%n");
    public static final PrintfFormatter MESSAGE_AND_EXCEPTION = new PrintfFormatter("%8$s%11$s%n");
    public static final PrintfFormatter MESSAGE_AND_STACK_TRACE = new PrintfFormatter("%8$s%9$s%n");
    public static final PrintfFormatter SIMPLE = new PrintfFormatter("%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n");
    public static final PrintfFormatter TIME_MESSAGE = new PrintfFormatter("%5$tF %5$tT.%5$tL %8$s%n");
    public static final PrintfFormatter DEFAULT = SIMPLE;
    private static final String FORMAT_STRING_DEFAULT = "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n";
    private String format;
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final ThreadLocal<State> STATE_TL = new ThreadLocal();
    private static final Object THE_BENCHMARK = new Object(){

        public String toString() {
            State state = (State)STATE_TL.get();
            if (state == null) {
                state = new State();
                STATE_TL.set(state);
                state.realTime = System.nanoTime();
                state.cpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                state.userTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
                return "    -.------;    -.------;    -.------";
            }
            long realTime = System.nanoTime();
            long cpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
            long userTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
            state.realTime = realTime;
            state.cpuTime = cpuTime;
            state.userTime = userTime;
            return this.ns2ms(realTime - state.realTime) + ';' + this.ns2ms(cpuTime - state.cpuTime) + ';' + this.ns2ms(userTime - state.userTime);
        }

        private String ns2ms(long ns) {
            StringBuilder sb = new StringBuilder();
            String s1 = Integer.toString((int)(ns / 1000000L));
            if (s1.length() < 5) {
                sb.append("x    ".substring(s1.length()));
            }
            sb.append(s1);
            sb.append('.');
            String s2 = Integer.toString((int)(ns % 1000000L));
            if (s2.length() < 6) {
                sb.append("x00000".substring(s2.length()));
            }
            sb.append(s2);
            return sb.toString();
        }
    };

    public PrintfFormatter() {
        this(0, null);
    }

    protected PrintfFormatter(int dummy, @Nullable String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        this.setFormat(LogUtil.getLoggingProperty(propertyNamePrefix + ".format", (String)null));
    }

    public PrintfFormatter(String format) {
        this.setFormat(format);
    }

    public final void setFormat(String format) {
        this.format = format == null ? "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n" : ("BENCHMARK".equals(format) ? FORMAT_STRING_BENCHMARK : ("COMPACT".equals(format) ? FORMAT_STRING_COMPACT : ("DEFAULT".equals(format) ? "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n" : ("MESSAGE".equals(format) ? FORMAT_STRING_MESSAGE : ("MESSAGE_AND_EXCEPTION".equals(format) ? FORMAT_STRING_MESSAGE_AND_EXCEPTION : ("MESSAGE_AND_STACK_TRACE".equals(format) ? FORMAT_STRING_MESSAGE_AND_STACK_TRACE : ("SIMPLE".equals(format) ? "%5$tF %5$tT.%5$tL %10$-20s %3$2d %8$s%9$s%n" : format)))))));
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String format(LogRecord record) {
        String thrownText;
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            thrownText = "";
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(":");
            pw.print(thrown.getClass().getName());
            pw.print(':');
            String message = thrown.getLocalizedMessage();
            if (message != null) {
                pw.print(' ');
                pw.print(message);
            }
            pw.println();
            thrown.printStackTrace(pw);
            thrownText = sw.toString();
            thrownText = StringUtil.lessTrailingLineSeparators(thrownText);
        }
        String sourceClassName = record.getSourceClassName();
        String simpleSourceClassName = sourceClassName == null ? null : sourceClassName.substring(sourceClassName.lastIndexOf(46) + 1);
        return String.format(this.format, record.getSequenceNumber(), record.getLoggerName(), record.getThreadID(), record.getLevel(), new Date(record.getMillis()), sourceClassName, record.getSourceMethodName(), this.formatMessage(record), thrownText, simpleSourceClassName, thrown == null ? "" : ": " + thrown.toString(), THE_BENCHMARK);
    }

    private static class State {
        long realTime;
        long cpuTime;
        long userTime;

        private State() {
        }
    }
}

