/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassLoaders {
    private ClassLoaders() {
    }

    public static URL[] getAllSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories) throws IOException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        assert (classLoader != null);
        ArrayList<URL> result = new ArrayList<URL>();
        for (URL r : Collections.list(classLoader.getResources(name))) {
            result.addAll(ClassLoaders.getSubresourcesOf(r, name, includeDirectories).values());
        }
        return result.toArray(new URL[result.size()]);
    }

    public static Map<String, URL> getSubresources(@Nullable ClassLoader classLoader, String name, boolean includeDirectories) throws IOException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        assert (classLoader != null);
        URL r = classLoader.getResource(name);
        if (r == null) {
            return Collections.emptyMap();
        }
        return ClassLoaders.getSubresourcesOf(r, name, includeDirectories);
    }

    public static Map<String, URL> getSubresourcesOf(URL root, String rootName, boolean includeDirectories) throws IOException {
        String protocol = root.getProtocol();
        if (protocol.equalsIgnoreCase("jar")) {
            JarURLConnection juc = (JarURLConnection)root.openConnection();
            juc.setUseCaches(false);
            JarFile jarFile = juc.getJarFile();
            JarEntry jarEntry = juc.getJarEntry();
            if (!jarEntry.isDirectory()) {
                return Collections.singletonMap(rootName, root);
            }
            HashMap<String, URL> result = new HashMap<String, URL>();
            if (includeDirectories) {
                result.put(rootName, root);
            }
            for (JarEntry je : Collections.list(jarFile.entries())) {
                if (je.isDirectory() && !includeDirectories || !je.getName().startsWith(rootName)) continue;
                result.put(je.getName().substring(rootName.length()), new URL("jar", null, "file:/" + juc.getJarFileURL().getFile() + "!/" + je.getName()));
            }
            return result;
        }
        if (protocol.equalsIgnoreCase("file")) {
            return ClassLoaders.getFileResources(root, rootName, includeDirectories);
        }
        return Collections.singletonMap(rootName, root);
    }

    private static Map<String, URL> getFileResources(URL fileUrl, String name, boolean includeDirectories) {
        File file = new File(fileUrl.getFile());
        if (file.isFile()) {
            return Collections.singletonMap(name, fileUrl);
        }
        if (file.isDirectory()) {
            if (!name.isEmpty() && !name.endsWith("/")) {
                name = name + '/';
            }
            HashMap<String, URL> result = new HashMap<String, URL>();
            if (includeDirectories) {
                result.put(name, fileUrl);
            }
            for (File member : file.listFiles()) {
                result.putAll(ClassLoaders.getFileResources(ClassLoaders.fileUrl(member), name + member.getName(), includeDirectories));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private static URL fileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw ExceptionUtil.wrap(file.toString(), mue, IllegalStateException.class);
        }
    }
}

