/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.MarkableFileInputStream;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public abstract class CompressionFormatFactory {
    private static final String FORMATS_RESOURCE = "de/unkrig/commons/file/org/apache/commons/compress/compressors/formats";
    private static final String SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final Map<String, CompressionFormat> ALL_COMPRESSION_FORMATS;

    private CompressionFormatFactory() {
    }

    public static Collection<CompressionFormat> allFormats() {
        return ALL_COMPRESSION_FORMATS.values();
    }

    @Nullable
    public static CompressionFormat forFileName(String fileName) {
        for (CompressionFormat cf : ALL_COMPRESSION_FORMATS.values()) {
            if (!cf.isCompressedFileName(fileName)) continue;
            return cf;
        }
        return null;
    }

    public static CompressionFormat forFormatName(String compressionFormatName) throws CompressorException {
        CompressionFormat result = ALL_COMPRESSION_FORMATS.get(compressionFormatName);
        if (result == null) {
            throw new CompressorException(compressionFormatName);
        }
        return result;
    }

    @Nullable
    public static CompressionFormat forContents(InputStream is) throws IOException {
        byte[] signature = new byte[512];
        is.mark(signature.length);
        int signatureLength = IOUtils.readFully(is, signature);
        is.reset();
        for (CompressionFormat af : ALL_COMPRESSION_FORMATS.values()) {
            if (!af.matches(signature, signatureLength)) continue;
            return af;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CompressionFormat forContents(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            CompressionFormat result = CompressionFormatFactory.forContents(is);
            ((InputStream)is).close();
            CompressionFormat compressionFormat = result;
            return compressionFormat;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public static CompressionFormat forCompressorOutputStream(CompressorOutputStream compressorOutputStream) {
        for (CompressionFormat cf : ALL_COMPRESSION_FORMATS.values()) {
            try {
                if (cf.compressorOutputStream(IoUtil.NULL_OUTPUT_STREAM).getClass() != compressorOutputStream.getClass()) continue;
                return cf;
            }
            catch (CompressorException compressorException) {
            }
            catch (IOException ioe) {
                AssertionError ae = new AssertionError(cf.getClass());
                ((Throwable)((Object)ae)).initCause(ioe);
                throw ae;
            }
        }
        throw new AssertionError(compressorOutputStream.getClass());
    }

    @Deprecated
    public static long getUncompressedSize(CompressorInputStream compressorInputStream) {
        if (compressorInputStream instanceof SnappyCompressorInputStream) {
            return ((SnappyCompressorInputStream)compressorInputStream).getSize();
        }
        return -1L;
    }

    public static CompressorInputStream compressorInputStream(InputStream inputStream) throws IOException, CompressorException {
        CompressionFormat cf = CompressionFormatFactory.forContents(inputStream);
        if (cf == null) {
            throw new CompressorException("Cannot determine compression format from stream contents");
        }
        return cf.compressorInputStream(inputStream);
    }

    public static CompressorInputStream open(File compressedFile) throws IOException, CompressorException {
        MarkableFileInputStream is = new MarkableFileInputStream(compressedFile);
        try {
            CompressionFormat cf = CompressionFormatFactory.forContents(is);
            if (cf == null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new CompressorException("Cannot determine compression format from the contents of '" + compressedFile + "'");
            }
            return cf.compressorInputStream(is);
        }
        catch (IOException ioe) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
        catch (RuntimeException re) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HashMap<String, CompressionFormat> m = new HashMap<String, CompressionFormat>();
        try {
            ClassLoader cl = CompressionFormatFactory.class.getClassLoader();
            Enumeration<URL> en = cl.getResources(FORMATS_RESOURCE);
            if (!en.hasMoreElements()) {
                throw new FileNotFoundException(FORMATS_RESOURCE);
            }
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), Charset.forName("ISO8859-1")));
                try {
                    String line = br.readLine();
                    while (line != null) {
                        Class<?> compressionFormatClass;
                        CompressionFormat cf;
                        if ((line = line.trim()).length() != 0 && line.charAt(0) != '#' && m.put((cf = (CompressionFormat)(compressionFormatClass = cl.loadClass(line)).getMethod("get", new Class[0]).invoke(null, new Object[0])).getName(), cf) != null) {
                            throw new ExceptionInInitializerError("Duplicate compression format name '" + cf.getName() + "'");
                        }
                        line = br.readLine();
                    }
                    br.close();
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        ALL_COMPRESSION_FORMATS = Collections.unmodifiableMap(m);
        String packagE = ArchiveFormatFactory.class.getPackage().getName();
        String phps = System.getProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS);
        if (phps == null) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, packagE);
        } else if (!Arrays.asList(phps.split("\\|")).contains(packagE)) {
            System.setProperty(SYSTEM_PROPERTY_PROTOCOL_HANDLER_PKGS, phps + '|' + packagE);
        }
    }
}

