/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.arj;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class ArjArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".arj", ""), ".arj");
    private static final ArchiveFormat INSTANCE = new ArjArchiveFormat();

    private ArjArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "arj";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) throws ArchiveException {
        return new ArjArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException, ArchiveException {
        return new ArjArchiveInputStream(new FileInputStream(archiveFile));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) throws ArchiveException {
        throw new ArchiveException("Creation of 'arj' archives not supported");
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws ArchiveException {
        throw new ArchiveException("Creation of 'arj' archives not supported");
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) {
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return ArjArchiveInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

