/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.filetransformation;

import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.lang.protocol.Predicate;
import java.io.File;
import java.io.IOException;

public class SelectiveFileTransformer
implements FileTransformer {
    private final Predicate<? super String> pathPredicate;
    private final FileTransformer trueDelegate;
    private final FileTransformer falseDelegate;

    public SelectiveFileTransformer(Predicate<? super String> pathPredicate, FileTransformer trueDelegate, FileTransformer falseDelegate) {
        this.pathPredicate = pathPredicate;
        this.trueDelegate = trueDelegate;
        this.falseDelegate = falseDelegate;
    }

    @Override
    public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
        if (this.pathPredicate.evaluate(path)) {
            this.trueDelegate.transform(path, in, out, mode);
        } else {
            this.falseDelegate.transform(path, in, out, mode);
        }
    }

    public String toString() {
        return this.pathPredicate + " ? " + this.trueDelegate + " : " + this.falseDelegate;
    }
}

