/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.Relation;
import de.unkrig.commons.lang.protocol.Relations;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.zz.find.Find;
import java.io.File;
import java.util.ArrayList;

public class Parser {
    private final AbstractParser<TokenType> parser;
    private boolean hadAction;

    public <EX extends Throwable> Parser(final ProducerWhichThrows<String, ? extends EX> producer) {
        this.parser = new AbstractParser((ProducerWhichThrows)new ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException>(){

            @Nullable
            public AbstractScanner.Token<TokenType> produce() throws ScanException {
                String text;
                try {
                    text = (String)producer.produce();
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (ScanException)ExceptionUtil.wrap(null, (Throwable)e, ScanException.class);
                }
                if (text == null) {
                    return null;
                }
                return new AbstractScanner.Token((Enum)TokenType.LITERAL, text);
            }
        });
    }

    public Find.Expression parse() throws ParseException {
        if (this.parser.peek() == null) {
            return new Find.PrintAction();
        }
        Find.Expression result = this.parseComma();
        this.parser.eoi();
        return this.hadAction ? result : new Find.AndTest(result, new Find.PrintAction());
    }

    private Find.Expression parseComma() throws ParseException {
        Find.Expression lhs = this.parseOr();
        return this.parser.peekRead(",") ? new Find.CommaTest(lhs, this.parseComma()) : lhs;
    }

    private Find.Expression parseOr() throws ParseException {
        Find.Expression lhs = this.parseAnd();
        if (this.parser.peekRead(new String[]{"-o", "-or", "||"}) == -1) {
            return lhs;
        }
        Find.Expression rhs = this.parseOr();
        return new Find.OrTest(lhs, rhs);
    }

    private Find.Expression parseAnd() throws ParseException {
        Find.Expression lhs = this.parsePrimary();
        return this.parser.peekRead(new String[]{"-a", "-and", "&&"}) != -1 || this.parser.peek(new Object[]{"-o", "-or", "||", ")", ",", null}) == -1 ? new Find.AndTest(lhs, this.parseAnd()) : lhs;
    }

    private Find.Expression parsePrimary() throws ParseException {
        switch (this.parser.read(new Object[]{"(", "!", "-not", "-name", "-path", "-type", "-readable", "-writable", "-executable", "-size", "-mtime", "-mmin", "-print", "-echo", "-printf", "-ls", "-exec", "-pipe", "-cat", "-copy", "-disassemble", "-java-class-file", "-digest", "-checksum", "-true", "-false", "-prune", "-delete"})) {
            case 0: {
                Find.Expression result = this.parseComma();
                this.parser.read(")");
                return result;
            }
            case 1: 
            case 2: {
                return new Find.NotExpression(this.parsePrimary());
            }
            case 3: {
                return new Find.NameTest(this.parser.read().text);
            }
            case 4: {
                return new Find.PathTest(this.parser.read().text);
            }
            case 5: {
                return new Find.TypeTest(this.parser.read().text);
            }
            case 6: {
                return new Find.ReadabilityTest();
            }
            case 7: {
                return new Find.WritabilityTest();
            }
            case 8: {
                return new Find.ExecutabilityTest();
            }
            case 9: {
                return new Find.SizeTest(Parser.parseNumericArgument(this.parser.read().text));
            }
            case 10: {
                return new Find.ModificationTimeTest(Parser.parseNumericArgument(this.parser.read().text), 86400000L);
            }
            case 11: {
                return new Find.ModificationTimeTest(Parser.parseNumericArgument(this.parser.read().text), 60000L);
            }
            case 12: {
                this.hadAction = true;
                return new Find.PrintAction();
            }
            case 13: {
                this.hadAction = true;
                return new Find.EchoAction(this.parser.read().text);
            }
            case 14: {
                this.hadAction = true;
                String format = this.parser.read().text;
                ArrayList<String> argExpressions = new ArrayList<String>();
                while (!this.parser.peekRead(";")) {
                    argExpressions.add(this.parser.read().text);
                }
                return new Find.PrintfAction(format, argExpressions.toArray(new String[argExpressions.size()]));
            }
            case 15: {
                this.hadAction = true;
                return new Find.LsAction();
            }
            case 16: {
                ArrayList<String> command = new ArrayList<String>();
                while (!this.parser.peekRead(";")) {
                    command.add(this.parser.read().text);
                }
                this.hadAction = true;
                return new Find.ExecAction(command);
            }
            case 17: {
                ArrayList<String> command = new ArrayList<String>();
                while (!this.parser.peekRead(";")) {
                    command.add(this.parser.read().text);
                }
                this.hadAction = true;
                return new Find.PipeAction(command, null);
            }
            case 18: {
                this.hadAction = true;
                return new Find.CatAction(System.out);
            }
            case 19: {
                this.hadAction = true;
                boolean mkdirs = this.parser.peekRead(new String[]{"-p", "--mkdirs"}) != -1;
                return new Find.CopyAction(new File(this.parser.read().text), mkdirs);
            }
            case 20: {
                this.hadAction = true;
                boolean verbose = false;
                File sourceDirectory = null;
                boolean hideLines = false;
                boolean hideVars = false;
                boolean symbolicLabels = false;
                File toFile = null;
                while (true) {
                    if (this.parser.peekRead("-verbose")) {
                        verbose = true;
                        continue;
                    }
                    if (this.parser.peekRead("-sourceDirectory")) {
                        sourceDirectory = new File(this.parser.read().text);
                        continue;
                    }
                    if (this.parser.peekRead("-hideLines")) {
                        hideLines = true;
                        continue;
                    }
                    if (this.parser.peekRead("-hideVars")) {
                        hideVars = true;
                        continue;
                    }
                    if (this.parser.peekRead("-symbolicLabels")) {
                        symbolicLabels = true;
                        continue;
                    }
                    if (!this.parser.peekRead("-toFile")) break;
                    toFile = new File(this.parser.read().text);
                }
                return new Find.DisassembleAction(verbose, sourceDirectory, hideLines, hideVars, symbolicLabels, toFile);
            }
            case 21: {
                this.hadAction = true;
                return new Find.JavaClassFileAction(this.parser.read().text);
            }
            case 22: {
                this.hadAction = true;
                return new Find.DigestAction(this.parser.read().text);
            }
            case 23: {
                this.hadAction = true;
                return new Find.ChecksumAction((Find.ChecksumAction.ChecksumType)this.parser.readEnum((Enum[])Find.ChecksumAction.ChecksumType.values()));
            }
            case 24: {
                return Find.Test.TRUE;
            }
            case 25: {
                return Find.Test.FALSE;
            }
            case 26: {
                return new Find.PruneAction();
            }
            case 27: {
                return new Find.DeleteAction();
            }
        }
        throw new IllegalStateException();
    }

    public static Predicate<Long> parseNumericArgument(String text) {
        long multiplier;
        Relation relation;
        if (text.startsWith("+")) {
            relation = Relations.greaterThan();
            text = text.substring(1);
        } else if (text.startsWith("-")) {
            relation = Relations.lessThan();
            text = text.substring(1);
        } else {
            relation = Relations.equalTo();
        }
        if (text.endsWith("k")) {
            multiplier = 1024L;
            text = text.substring(0, text.length() - 1);
        } else if (text.endsWith("M")) {
            multiplier = 0x100000L;
            text = text.substring(0, text.length() - 1);
        } else if (text.endsWith("G")) {
            multiplier = 0x40000000L;
            text = text.substring(0, text.length() - 1);
        } else {
            multiplier = 1L;
        }
        long rhs = multiplier * Long.parseLong(text);
        return Relations.compareWithConstant((Relation)relation, (Comparable)Long.valueOf(rhs));
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    static enum TokenType {
        LITERAL;

    }
}

