/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessings;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.MavenUtil;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zip4jadapter.archivers.zip.ZipArchiveFormat;
import de.unkrig.zz.find.Find;
import de.unkrig.zz.find.Parser;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.apache.commons.compress.utils.Charsets;

public final class Main {
    private final Find find = new Find();
    private final LevelFilteredPrinter levelFilteredPrinter = new LevelFilteredPrinter();

    private Main() {
    }

    public static void main(final String[] args) {
        new Main().levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                new Main().main2(args);
            }
        });
    }

    private void main2(String[] args) {
        String arg;
        int i;
        try {
            args = CommandLineOptions.parse((String[])args, (Object)this);
        }
        catch (CommandLineOptionException cloe) {
            Printers.error((String)(cloe.getMessage() + ", try \"--help\"."));
            System.exit(1);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (i = 0; !(i >= args.length || (arg = args[i]).startsWith("-") && !"-".equals(arg) || "(".equals(arg) || "!".equals(arg)); ++i) {
            files.add(arg);
        }
        try {
            Parser parser = new Parser(ProducerUtil.fromArray((Object[])args, (int)i, (int)args.length));
            this.find.setExpression(parser.parse());
        }
        catch (ParseException pe) {
            Printers.error((String)("Parsing predicates: " + pe.getMessage()));
            System.exit(1);
        }
        catch (Exception e) {
            Printers.error((String)"Parsing predicates", (Throwable)e);
            System.exit(1);
        }
        final boolean[] hadExceptions = new boolean[1];
        ConsumerWhichThrows<IOException, IOException> exceptionHandler = new ConsumerWhichThrows<IOException, IOException>(){

            public void consume(IOException ioe) {
                Printers.error(null, (Throwable)ioe);
                hadExceptions[0] = true;
            }
        };
        this.find.setExceptionHandler((ConsumerWhichThrows<? super IOException, IOException>)exceptionHandler);
        try {
            for (String file : files) {
                try {
                    this.find.findInResource(file, ResourceProcessings.toUrl((String)file));
                }
                catch (IOException ioe) {
                    exceptionHandler.consume((Object)ioe);
                }
            }
            if (hadExceptions[0]) {
                System.exit(2);
            }
        }
        catch (Exception e) {
            Printers.error(null, (Throwable)e);
            System.exit(2);
        }
    }

    @CommandLineOption
    public static void help() throws IOException {
        ArrayList<String> algorithms = new ArrayList<String>();
        for (Provider p : Security.getProviders()) {
            for (Provider.Service s : p.getServices()) {
                if (!"MessageDigest".equals(s.getType())) continue;
                algorithms.add(s.getAlgorithm());
            }
        }
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        System.setProperty("digest.providers", ((Object)algorithms).toString());
        CommandLineOptions.printResource(Main.class, (String)"main(String[]).txt", (Charset)Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public static void version() throws IOException {
        System.out.println(MavenUtil.getMavenArtifactVersion((String)"de.unkrig.zz", (String)"zz-find"));
    }

    @CommandLineOption
    public void setLookInto(@RegexFlags(value=-1610612736) Glob fomatAndPath) {
        this.find.setLookIntoFormat((Predicate<? super String>)fomatAndPath);
    }

    @CommandLineOption(name={"depth", "descendants-first"})
    public void setDescendantsFirst() {
        this.find.setDescendantsFirst(true);
    }

    @CommandLineOption
    public void setMinDepth(int levels) {
        this.find.setMinDepth(levels);
    }

    @CommandLineOption
    public void setMaxDepth(int levels) {
        this.find.setMaxDepth(levels);
    }

    @CommandLineOption
    public void set7zInputFilePassword(String value) {
        SevenZArchiveFormat.setPassword((byte[])value.getBytes(Charsets.UTF_16LE));
    }

    @CommandLineOption
    public void setZipInputFilePassword(String value) {
        ZipArchiveFormat.setInputFilePasswordChars((char[])value.toCharArray());
    }

    @CommandLineOption
    public void setPassword(String value) {
        this.set7zInputFilePassword(value);
        this.setZipInputFilePassword(value);
    }

    @CommandLineOption
    public void setNowarn() {
        this.levelFilteredPrinter.setNoWarn();
        SimpleLogging.setNoWarn();
    }

    @CommandLineOption
    public void setQuiet() {
        this.levelFilteredPrinter.setQuiet();
        SimpleLogging.setQuiet();
    }

    @CommandLineOption
    public void setVerbose() {
        this.levelFilteredPrinter.setVerbose();
        SimpleLogging.setVerbose();
    }

    @CommandLineOption
    public void setDebug() {
        this.levelFilteredPrinter.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers((String)spec);
    }

    @CommandLineOption(name={"-zip", "-zz", "-nested-zip", "-z"})
    public static void noLongerSupported() {
        System.err.println("Command line option is no longer supported - try \"--help\".");
        System.exit(1);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

