/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.FileUtil;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessings;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ProcessUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.collections.MapUtil;
import de.unkrig.jdisasm.ClassFile;
import de.unkrig.jdisasm.Disassembler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.compressors.CompressorInputStream;

public class Find {
    private static final Logger LOGGER;
    private static final String PRUNE_PROPERTY_NAME = "$PRUNE";
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private boolean descendantsFirst;
    private int minDepth;
    private int maxDepth = Integer.MAX_VALUE;
    private Expression expression = Test.TRUE;
    private ConsumerWhichThrows<? super IOException, ? extends IOException> exceptionHandler = ConsumerUtil.throwsSubject();
    @Nullable
    private static final String REPLACE_COLON_WITH;

    public void setLookIntoFormat(Predicate<? super String> value) {
        LOGGER.log(Level.FINE, "setLookIntoFormat({0})", value);
        this.lookIntoFormat = value;
    }

    public void setDescendantsFirst(boolean value) {
        this.descendantsFirst = value;
    }

    public void setMinDepth(int levels) {
        this.minDepth = levels;
    }

    public void setMaxDepth(int levels) {
        this.maxDepth = levels;
    }

    public void setExpression(Expression value) {
        LOGGER.log(Level.FINE, "setExpression({0})", value);
        this.expression = value;
    }

    public Find setExceptionHandler(ConsumerWhichThrows<? super IOException, IOException> value) {
        this.exceptionHandler = value;
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void findInStream(InputStream is) throws IOException {
        if (this.maxDepth < 0) {
            return;
        }
        HashMap<String, Producer<? extends Object>> properties = new HashMap<String, Producer<? extends Object>>();
        properties.put("type", Find.cp("stream"));
        properties.put("path", Find.cp("-"));
        properties.put("size", Find.cp(-1L));
        this.findInStream("-", System.in, null, properties, 0);
    }

    public static File fixFile(File f) {
        String pn = f.getPath();
        String fixedPn = Find.fixPathname(pn);
        return fixedPn.contentEquals(pn) ? f : new File(fixedPn);
    }

    private static String fixPathname(String pn) {
        if (REPLACE_COLON_WITH != null) {
            pn = pn.replace(":", REPLACE_COLON_WITH);
        }
        return pn;
    }

    public void findInResource(String path, URL resource) throws IOException {
        this.findInResource(path, resource, 0);
    }

    public void findInFile(File file) throws IOException {
        this.findInResource(file.getPath(), file.toURI().toURL(), 0);
    }

    private void findInDirectory(final String directoryPath, final File directory, final int currentDepth) throws IOException {
        LOGGER.log(Level.FINER, "Processing directory \"{0}\" (path is \"{1}\")", new Object[]{directory, directoryPath});
        final boolean[] prune = new boolean[1];
        RunnableUtil.swapIf((boolean)this.descendantsFirst, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

            public void run() {
                Find.this.evaluateExpression(MapUtil.map((Object[])new Object[]{"type", Find.cp("directory"), "name", Find.cp(directory.getName()), "path", Find.cp(directoryPath), "file", Find.cp(directory), "depth", Find.cp(currentDepth), "inputStream", Find.cp(null), "readable", () -> directory.canRead(), "writable", () -> directory.canWrite(), "executable", () -> directory.canExecute(), "lastModified", () -> directory.lastModified(), "lastModifiedDate", () -> new Date(directory.lastModified()), Find.PRUNE_PROPERTY_NAME, Find.cp(prune)}));
            }
        }, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

            public void run() throws IOException {
                if (!prune[0] && currentDepth < Find.this.maxDepth) {
                    String[] memberNames = directory.list();
                    if (memberNames == null) {
                        throw new IOException(directory + ": Permission denied");
                    }
                    for (String memberName : memberNames) {
                        memberName = memberName.replace('\uf031', ':');
                        String memberPath = directoryPath + File.separatorChar + memberName;
                        try {
                            Find.this.findInResource(memberPath, new File(directory, memberName).toURI().toURL(), currentDepth + 1);
                        }
                        catch (IOException ioe) {
                            Find.this.exceptionHandler.consume((Object)ExceptionUtil.wrap((String)("Continue with next directory member after member \"" + memberPath + "\""), (Throwable)ioe));
                        }
                    }
                }
            }
        });
    }

    public static de.unkrig.commons.text.expression.Expression parse(String spec) {
        ExpressionEvaluator ee = new ExpressionEvaluator((PredicateWhichThrows)PredicateUtil.always());
        try {
            return ee.parse(spec);
        }
        catch (ParseException pe) {
            throw (IllegalArgumentException)ExceptionUtil.wrap((String)("Parsing \"" + spec + "\""), (Throwable)pe, IllegalArgumentException.class);
        }
    }

    public static de.unkrig.commons.text.expression.Expression parseExt(String spec) {
        ExpressionEvaluator ee = new ExpressionEvaluator((PredicateWhichThrows)PredicateUtil.always());
        try {
            return ee.parseExt(spec);
        }
        catch (ParseException pe) {
            throw (IllegalArgumentException)ExceptionUtil.wrap((String)("Parsing \"" + spec + "\""), (Throwable)pe, IllegalArgumentException.class);
        }
    }

    @Nullable
    private static String evaluateExpression(de.unkrig.commons.text.expression.Expression expression, Mapping<String, Object> variables) {
        variables = Mappings.union(variables, (Mapping)Mappings.constant((Object)""));
        try {
            return (String)expression.evaluateTo(variables, String.class);
        }
        catch (EvaluationException ee) {
            throw (IllegalArgumentException)ExceptionUtil.wrap((String)("Evaluating \"" + expression + "\""), (Throwable)ee, IllegalArgumentException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInResource(String path, URL resource, int currentDepth) throws IOException {
        LOGGER.log(Level.FINER, "Processing \"{0}\" (path is \"{1}\")", new Object[]{resource, path});
        if (resource.equals(ResourceProcessings.STDIN_URL)) {
            this.findInStream(System.in);
            return;
        }
        HashMap<String, Producer<? extends Object>> resourceProperties = new HashMap<String, Producer<? extends Object>>();
        File file = ResourceProcessings.isFile((URL)resource);
        if (file != null) {
            if (file.isDirectory()) {
                this.findInDirectory(path, file, currentDepth);
                return;
            }
            resourceProperties.put("type", Find.cp("file"));
            resourceProperties.put("name", Find.cp(file.getName()));
            resourceProperties.put("size", () -> file.length());
            resourceProperties.put("readable", () -> file.canRead());
            resourceProperties.put("writable", () -> file.canWrite());
            resourceProperties.put("executable", () -> file.canExecute());
            resourceProperties.put("inputStream", () -> {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fnfe) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Reading file \"" + resource + "\""), (Throwable)fnfe, RuntimeException.class);
                }
            });
            resourceProperties.put("crc", () -> {
                CRC32 cs = new CRC32();
                try (FileInputStream is = new FileInputStream(file);){
                    ChecksumAction.updateAll(cs, is);
                }
                catch (IOException ioe) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Computing CRC of file \"" + resource + "\""), (Throwable)ioe, RuntimeException.class);
                }
                return (int)cs.getValue();
            });
            resourceProperties.put("file", Find.cp(file));
            resourceProperties.put("lastModified", () -> file.lastModified());
            resourceProperties.put("lastModifiedDate", () -> new Date(file.lastModified()));
        } else {
            resourceProperties.put("type", Find.cp(resource.getProtocol() + "-resource"));
            String up = resource.getPath();
            resourceProperties.put("name", Find.cp(up.substring(up.lastIndexOf(47) + 1)));
            resourceProperties.put("size", () -> {
                try {
                    return resource.openConnection().getContentLengthLong();
                }
                catch (IOException ioe) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Querying size of resource \"" + resource + "\""), (Throwable)ioe, RuntimeException.class);
                }
            });
            resourceProperties.put("readable", Find.cp(true));
            resourceProperties.put("writable", Find.cp(false));
            resourceProperties.put("executable", Find.cp(false));
            resourceProperties.put("crc", () -> {
                CRC32 cs = new CRC32();
                try (InputStream is = resource.openConnection().getInputStream();){
                    ChecksumAction.updateAll(cs, is);
                }
                catch (IOException ioe) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Computing CRC of resource \"" + resource + "\""), (Throwable)ioe, RuntimeException.class);
                }
                return (int)cs.getValue();
            });
        }
        resourceProperties.put("url", Find.cp(resource));
        resourceProperties.put("path", Find.cp(path));
        CompressUtil.ArchiveHandler<Void> archiveHandler = this.archiveHandler(path, resourceProperties, currentDepth);
        CompressUtil.CompressorHandler<Void> compressorHandler = this.compressorHandler(path, resourceProperties, currentDepth);
        CompressUtil.NormalContentsHandler<Void> normalContentsHandler = this.normalContentsHandler(path, resourceProperties, currentDepth);
        if (file != null) {
            CompressUtil.processFile((String)path, (File)file, this.lookIntoFormat, archiveHandler, compressorHandler, normalContentsHandler);
        } else {
            URLConnection conn = resource.openConnection();
            InputStream is = conn.getInputStream();
            long lastModified = conn.getLastModified();
            Date lastModifiedDate = lastModified == 0L ? null : new Date(lastModified);
            try {
                CompressUtil.processStream((String)path, (InputStream)is, (Date)lastModifiedDate, this.lookIntoFormat, archiveHandler, compressorHandler, normalContentsHandler);
                is.close();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void findInStream(String path, InputStream inputStream, @Nullable Date lastModifiedDate, Map<String, Producer<? extends Object>> streamProperties, int currentDepth) throws IOException {
        streamProperties = new HashMap<String, Producer<? extends Object>>(streamProperties);
        streamProperties.put("type", Find.cp("contents"));
        streamProperties.put("path", Find.cp(path));
        try {
            CompressUtil.processStream((String)path, (InputStream)inputStream, (Date)lastModifiedDate, this.lookIntoFormat, this.archiveHandler(path, streamProperties, currentDepth), this.compressorHandler(path, streamProperties, currentDepth), this.normalContentsHandler(path, streamProperties, currentDepth));
        }
        catch (UnsupportedZipFeatureException uzfe) {
            throw new IOException(path + "!" + uzfe.getEntry().getName() + ": Unsupported ZIP feature \"" + uzfe.getFeature() + "\"", uzfe);
        }
        catch (IOException ioe) {
            throw (IOException)ExceptionUtil.wrap((String)path, (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw (RuntimeException)ExceptionUtil.wrap((String)path, (Throwable)re);
        }
    }

    private CompressUtil.CompressorHandler<Void> compressorHandler(final String path, final Map<String, Producer<? extends Object>> properties, final int currentDepth) {
        return new CompressUtil.CompressorHandler<Void>(){

            @Nullable
            public Void handleCompressor(final CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                RunnableUtil.swapIf((boolean)Find.this.descendantsFirst, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

                    public void run() {
                        Find.this.evaluateExpression(MapUtil.combine((Map)MapUtil.map((Object[])new Object[]{"type", Find.cp("compressed-" + ((Producer)properties.get("type")).produce()), "compressionFormat", Find.cp(compressionFormat), "depth", Find.cp(currentDepth), "inputStream", Find.cp(null)}), (Map)properties));
                    }
                }, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

                    public void run() throws IOException {
                        if (currentDepth < Find.this.maxDepth) {
                            Object o;
                            Producer vg = (Producer)properties.get("name");
                            assert (vg != null);
                            Object name = vg.produce();
                            assert (name != null);
                            Date lastModifiedDate = null;
                            Producer p = (Producer)properties.get("lastModifiedDate");
                            if (p != null && (o = p.produce()) instanceof Date) {
                                lastModifiedDate = (Date)o;
                            }
                            Find.this.findInStream(path + '%', (InputStream)compressorInputStream, lastModifiedDate, MapUtil.combine((Map)MapUtil.map((Object[])new Object[]{"compressionFormat", Find.cp(compressionFormat), "name", Find.cp(name + "%"), "size", Find.cp(-1L)}), (Map)properties), currentDepth + 1);
                        }
                    }
                });
                return null;
            }
        };
    }

    private CompressUtil.ArchiveHandler<Void> archiveHandler(final String path, final Map<String, Producer<? extends Object>> properties, final int currentDepth) {
        return new CompressUtil.ArchiveHandler<Void>(){

            @Nullable
            public Void handleArchive(final ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                final boolean[] prune = new boolean[1];
                RunnableUtil.swapIf((boolean)Find.this.descendantsFirst, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

                    public void run() {
                        Find.this.evaluateExpression(MapUtil.combine((Map)MapUtil.map((Object[])new Object[]{"type", Find.cp("archive-" + ((Producer)properties.get("type")).produce()), "path", Find.cp(path), "archiveFormat", Find.cp(archiveFormat), "depth", Find.cp(currentDepth), "inputStream", Find.cp(null), "name", properties.get("name"), Find.PRUNE_PROPERTY_NAME, Find.cp(prune)}), (Map)properties));
                    }
                }, (RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

                    public void run() throws IOException {
                        if (prune[0] || currentDepth >= Find.this.maxDepth) {
                            return;
                        }
                        ArchiveEntry ae = archiveInputStream.getNextEntry();
                        while (ae != null) {
                            try {
                                this.processEntry(archiveInputStream, archiveFormat, ae);
                            }
                            catch (RuntimeException re) {
                                throw (RuntimeException)ExceptionUtil.wrap((String)("Processing archive entry \"" + ae.getName() + "\""), (Throwable)re);
                            }
                            ae = archiveInputStream.getNextEntry();
                        }
                    }

                    private void processEntry(ArchiveInputStream archiveInputStream2, ArchiveFormat archiveFormat2, ArchiveEntry ae) throws IOException {
                        long lastModified;
                        Date lastModifiedDate;
                        String entryName = ArchiveFormatFactory.normalizeEntryName((String)ae.getName());
                        String entryPath = path + '!' + entryName;
                        Producer crcGetter = Find.methodPropertyGetter(ae, "getCrc");
                        if (crcGetter == null) {
                            crcGetter = Find.cp(-1);
                        }
                        try {
                            lastModifiedDate = ae.getLastModifiedDate();
                            lastModified = lastModifiedDate.getTime();
                        }
                        catch (UnsupportedOperationException uoe) {
                            lastModifiedDate = null;
                            lastModified = 0L;
                        }
                        HashMap<String, Producer> properties2 = new HashMap<String, Producer>();
                        properties2.put("archiveEntry", Find.cp(ae));
                        properties2.put("lastModifiedDate", Find.cp(lastModifiedDate));
                        properties2.put("lastModified", Find.cp(lastModified));
                        properties2.put("name", Find.cp(ae.getName()));
                        properties2.put("size", Find.cp(ae.getSize()));
                        properties2.put("readable", Find.cp(true));
                        properties2.put("writable", Find.cp(false));
                        properties2.put("executable", Find.cp(false));
                        properties2.put("crc", crcGetter);
                        properties2.put("compressionMethod", Find.cp(archiveFormat2.getCompressionMethod(ae)));
                        if (ae.isDirectory()) {
                            properties2.put("path", Find.cp(entryPath));
                            properties2.put("name", Find.cp(entryName));
                            properties2.put("archiveFormat", Find.cp(archiveFormat2));
                            properties2.put("type", Find.cp("directory-entry"));
                            properties2.put("depth", Find.cp(currentDepth + 1));
                            properties2.put("inputStream", Find.cp(null));
                            properties2.put("size", Find.cp(0L));
                            Find.this.evaluateExpression(properties2);
                        } else {
                            properties2.put("archiveFormat", Find.cp(archiveFormat2));
                            try {
                                Find.this.findInStream(entryPath, (InputStream)archiveInputStream2, lastModifiedDate, properties2, currentDepth + 1);
                            }
                            catch (IOException ioe) {
                                Find.this.exceptionHandler.consume((Object)ExceptionUtil.wrap((String)("Continue with next " + archiveFormat2 + " archive entry after entry \"" + entryPath + "\""), (Throwable)ioe));
                            }
                        }
                    }
                });
                return null;
            }
        };
    }

    private CompressUtil.NormalContentsHandler<Void> normalContentsHandler(final String path, final Map<String, Producer<? extends Object>> properties, final int currentDepth) {
        return new CompressUtil.NormalContentsHandler<Void>(){

            @Nullable
            public Void handleNormalContents(InputStream inputStream, @Nullable Date lastModifiedDate) {
                Producer crcGetter = () -> {
                    CRC32 cs = new CRC32();
                    try {
                        ChecksumAction.updateAll(cs, inputStream);
                    }
                    catch (IOException ioe) {
                        throw (RuntimeException)ExceptionUtil.wrap((String)("Computing CRC of \"" + path + "\""), (Throwable)ioe, RuntimeException.class);
                    }
                    return (int)cs.getValue();
                };
                Producer sizeGetter = () -> {
                    Producer sizeValueProducer = (Producer)properties.get("size");
                    if (sizeValueProducer != null) {
                        Long size = (Long)sizeValueProducer.produce();
                        assert (size != null);
                        if (size != -1L) {
                            return size;
                        }
                    }
                    try {
                        return InputStreams.skipAll((InputStream)inputStream);
                    }
                    catch (IOException ioe) {
                        throw (RuntimeException)ExceptionUtil.wrap((String)("Measuring size of \"" + path + "\""), (Throwable)ioe, RuntimeException.class);
                    }
                };
                Find.this.evaluateExpression(MapUtil.combine((Map)MapUtil.map((Object[])new Object[]{"path", Find.cp(path), "type", Find.cp("normal-" + ((Producer)properties.get("type")).produce()), "lastModifiedDate", Find.cp(lastModifiedDate), "inputStream", Find.cp(inputStream), "depth", Find.cp(currentDepth), "crc", crcGetter, "size", sizeGetter}), (Map)properties));
                return null;
            }
        };
    }

    private void evaluateExpression(Map<String, Producer<? extends Object>> properties) {
        if (this.minDepth > 0) {
            Object depthValue = properties.get("depth").produce();
            assert (depthValue instanceof Integer);
            int currentDepth = (Integer)depthValue;
            if (currentDepth < this.minDepth) {
                return;
            }
        }
        this.expression.evaluate(Find.toMapping(properties));
    }

    private static long checksum(Mapping<String, Object> properties, Checksum cs) {
        InputStream is = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
        if (is == null) {
            throw new RuntimeException("\"-checksum\" is only possible on \"normal-*\"-type contents (and not on directories, dir-type archive entries, compressed content etc.)");
        }
        try {
            ChecksumAction.updateAll(cs, is);
        }
        catch (IOException ioe) {
            throw (RuntimeException)ExceptionUtil.wrap((String)("Running '-checksum' on '" + properties + "'"), (Throwable)ioe, RuntimeException.class);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return cs.getValue();
    }

    private static Mapping<String, Object> toMapping(final Map<String, Producer<? extends Object>> map) {
        return new Mapping<String, Object>(){
            @Nullable
            Map<String, Object> lazyMap;

            public boolean containsKey(@Nullable Object key) {
                return true;
            }

            @Nullable
            public Object get(@Nullable Object key) {
                if ("_map".equals(key)) {
                    return this.getLazyMap();
                }
                if ("_keys".equals(key)) {
                    return this.getLazyMap().keySet();
                }
                if ("_values".equals(key)) {
                    return this.getLazyMap().values();
                }
                Producer valueProducer = (Producer)map.get(key);
                if (valueProducer == null) {
                    return null;
                }
                return valueProducer.produce();
            }

            private Map<String, Object> getLazyMap() {
                Map result = this.lazyMap;
                return result != null ? result : (result = MapUtil.lazyMap((Map)map));
            }
        };
    }

    @Nullable
    private static Producer<Object> methodPropertyGetter(Object target, String methodName) {
        Method method;
        try {
            method = target.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw (RuntimeException)ExceptionUtil.wrap((String)methodName, (Throwable)e, RuntimeException.class);
        }
        if (Modifier.isStatic(method.getModifiers()) || method.getParameterCount() > 0) {
            return null;
        }
        return () -> {
            try {
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw (RuntimeException)ExceptionUtil.wrap((String)methodName, (Throwable)e, RuntimeException.class);
            }
        };
    }

    private static <T> Producer<T> cp(@Nullable T constantValue) {
        return ProducerUtil.constantProducer(constantValue);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(Find.class.getName());
        REPLACE_COLON_WITH = System.getProperty("Find.replaceColonWith");
    }

    public static class DeleteAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            File file = (File)properties.get((Object)"file");
            if (file == null) {
                throw new RuntimeException("\"-delete\" is only possible on files (and not on archive entries)");
            }
            if (!FileUtil.attemptToDeleteRecursively((File)file)) {
                System.err.printf("Could not remove file \"%s\"", file.toString());
                return false;
            }
            return true;
        }

        public String toString() {
            return "(delete)";
        }
    }

    public static class PruneAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            boolean[] prune = (boolean[])Mappings.get(properties, (Object)Find.PRUNE_PROPERTY_NAME, boolean[].class);
            if (prune != null) {
                prune[0] = true;
            }
            return true;
        }

        public String toString() {
            return "(prune)";
        }
    }

    public static class ChecksumAction
    implements Action {
        private final ChecksumType checksumType;

        ChecksumAction(ChecksumType checksumType) {
            this.checksumType = checksumType;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info((String)Long.toHexString(Find.checksum((Mapping<String, Object>)properties, this.checksumType.newChecksum())));
            return true;
        }

        private static void updateAll(Checksum checksum, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                checksum.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(checksum " + (Object)((Object)this.checksumType) + ")";
        }

        static enum ChecksumType {
            CRC32{

                @Override
                Checksum newChecksum() {
                    return new CRC32();
                }
            }
            ,
            ADLER32{

                @Override
                Checksum newChecksum() {
                    return new Adler32();
                }
            };


            abstract Checksum newChecksum();
        }
    }

    public static class DigestAction
    implements Action {
        private final String algorithm;

        DigestAction(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw (IllegalArgumentException)ExceptionUtil.wrap((String)("Running '-digest' on '" + properties + "'"), (Throwable)nsae, IllegalArgumentException.class);
            }
            InputStream is = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (is == null) {
                throw new RuntimeException("\"-digest\" is only possible on \"normal-*\"-type contents (and not on directories, dir-type archive entries, compressed content etc.)");
            }
            try {
                DigestAction.updateAll(md, is);
            }
            catch (IOException ioe) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Running '-digest' on '" + properties + "'"), (Throwable)ioe, RuntimeException.class);
            }
            byte[] digest = md.digest();
            Formatter f = new Formatter();
            for (byte b : digest) {
                f.format("%02x", b & 0xFF);
            }
            Printers.info((String)f.toString());
            return true;
        }

        private static void updateAll(MessageDigest messageDigest, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(digest " + this.algorithm + ")";
        }
    }

    public static class JavaClassFileAction
    implements Action {
        private final de.unkrig.commons.text.expression.Expression expression;

        JavaClassFileAction(String expression) {
            this.expression = Find.parse(expression);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            ClassFile cf;
            InputStream in = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (in == null) {
                throw new RuntimeException("\"-java-class-file\" is only possible on \"normal-*\"-type contents (and not on directories, dir-type archive entries, compressed content etc.)");
            }
            try {
                cf = new ClassFile(new DataInputStream(in));
            }
            catch (IOException ioe) {
                return false;
            }
            System.out.println(Find.evaluateExpression(this.expression, (Mapping<String, Object>)Mappings.override(properties, (Object[])new Object[]{"cf", cf})));
            return true;
        }

        public String toString() {
            return "(Java class file)";
        }
    }

    public static class DisassembleAction
    implements Action {
        private final boolean verbose;
        @Nullable
        private final File sourceDirectory;
        private final boolean hideLines;
        private final boolean hideVars;
        private final boolean symbolicLabels;
        @Nullable
        private final File toFile;

        DisassembleAction(boolean verbose, @Nullable File sourceDirectory, boolean hideLines, boolean hideVars, boolean symbolicLabels, @Nullable File toFile) {
            this.verbose = verbose;
            this.sourceDirectory = sourceDirectory;
            this.hideLines = hideLines;
            this.hideVars = hideVars;
            this.symbolicLabels = symbolicLabels;
            this.toFile = toFile;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            final Disassembler disassembler = new Disassembler();
            disassembler.setVerbose(this.verbose);
            disassembler.setSourcePath(new File[]{this.sourceDirectory});
            disassembler.setShowLineNumbers(!this.hideLines);
            disassembler.setShowVariableNames(!this.hideVars);
            disassembler.setSymbolicLabels(this.symbolicLabels);
            final InputStream in = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (in == null) {
                throw new RuntimeException("\"-disassemble\" is only possible on \"normal-*\"-type contents (and not on directories, dir-type archive entries, compressed content etc.)");
            }
            File toFile = this.toFile;
            try {
                if (toFile == null) {
                    disassembler.disasm(in);
                } else {
                    IoUtil.outputFileOutputStream((File)toFile, (ConsumerWhichThrows)new ConsumerWhichThrows<OutputStream, IOException>(){

                        public void consume(OutputStream os) throws IOException {
                            disassembler.setOut(os);
                            disassembler.disasm(in);
                        }
                    }, (boolean)true);
                }
            }
            catch (IOException ioe) {
                return false;
            }
            return true;
        }

        public String toString() {
            return "(Disassemble .class file)";
        }
    }

    public static class PipeAction
    implements Action {
        private final List<de.unkrig.commons.text.expression.Expression> command = new ArrayList<de.unkrig.commons.text.expression.Expression>();
        @Nullable
        private final File workingDirectory;

        PipeAction(List<String> command, @Nullable File workingDirectory) {
            for (String word : command) {
                this.command.add(Find.parseExt(word));
            }
            this.workingDirectory = workingDirectory;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            InputStream in = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (in == null) {
                throw new RuntimeException("\"-pipe\" is only possible on \"normal-*\"-type contents (and not on directories, dir-type archive entries, compressed content etc.)");
            }
            ArrayList<String> command2 = new ArrayList<String>();
            for (de.unkrig.commons.text.expression.Expression word : this.command) {
                command2.add(Find.evaluateExpression(word, (Mapping<String, Object>)properties));
            }
            try {
                return ProcessUtil.execute(command2, (File)this.workingDirectory, (InputStream)in, (boolean)false, (OutputStream)System.out, (boolean)false, (OutputStream)System.err, (boolean)false);
            }
            catch (Exception e) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Running 'pipe' on '" + properties + "'"), (Throwable)e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(pipe contents to command " + this.command + ")";
        }
    }

    public static class CopyAction
    implements Action {
        private final de.unkrig.commons.text.expression.Expression tofile;
        private final boolean mkdirs;

        CopyAction(File tofile, boolean mkdirs) {
            this.tofile = Find.parseExt(tofile.getPath());
            this.mkdirs = mkdirs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            InputStream in = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (in == null) {
                return true;
            }
            String pathname = Find.evaluateExpression(this.tofile, (Mapping<String, Object>)properties);
            assert (pathname != null);
            File tofile = new File(pathname);
            assert (tofile != null);
            tofile = Find.fixFile(tofile);
            try {
                if (this.mkdirs) {
                    IoUtil.createMissingParentDirectoriesFor((File)tofile);
                }
                FileOutputStream out = new FileOutputStream(tofile);
                try {
                    IoUtil.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
                Long lastModified = (Long)Mappings.get(properties, (Object)"lastModified", Long.class);
                if (lastModified != null) {
                    tofile.setLastModified(lastModified);
                }
            }
            catch (IOException ioe) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Copying to \"" + tofile + "\""), (Throwable)ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(copy to '" + this.tofile + "')";
        }
    }

    public static class CatAction
    implements Action {
        private final OutputStream out;

        CatAction(OutputStream out) {
            this.out = out;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            InputStream is = (InputStream)Mappings.get(properties, (Object)"inputStream", InputStream.class);
            if (is == null) {
                try {
                    this.out.write(("[Entry of type " + properties.get((Object)"type") + " has no content to cat]").getBytes(StandardCharsets.ISO_8859_1));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            try {
                IoUtil.copy((InputStream)is, (OutputStream)this.out);
            }
            catch (IOException ioe) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Running '-cat' on '" + properties + "'"), (Throwable)ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(cat " + this.out + ")";
        }
    }

    public static class ExecAction
    implements Action {
        private final List<de.unkrig.commons.text.expression.Expression> command = new ArrayList<de.unkrig.commons.text.expression.Expression>();

        ExecAction(List<String> command) {
            for (String word : command) {
                this.command.add(Find.parseExt(word));
            }
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            ArrayList<String> command2 = new ArrayList<String>();
            for (de.unkrig.commons.text.expression.Expression e : this.command) {
                command2.add(Find.evaluateExpression(e, (Mapping<String, Object>)properties));
            }
            try {
                return ProcessUtil.execute(command2, null, (InputStream)System.in, (boolean)false, (OutputStream)System.out, (boolean)false, (OutputStream)System.err, (boolean)false);
            }
            catch (Exception e) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Executing '" + command2 + "'"), (Throwable)e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(exec '" + this.command + "')";
        }
    }

    public static class LsAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String type = (String)Mappings.getNonNull(properties, (String)"type", String.class);
            File file = (File)Mappings.get(properties, (Object)"file", File.class);
            Long size = (Long)Mappings.get(properties, (Object)"size", Long.class);
            char c1 = "directory".equals(type) ? (char)'d' : (type.startsWith("archive-") ? (char)'a' : ("directory-entry".equals(type) ? (char)'D' : '-'));
            boolean isReadable = file != null ? file.canRead() : true;
            boolean isWritable = file != null ? file.canWrite() : false;
            boolean isExecutable = file != null ? file.canExecute() : false;
            Printers.info((String)String.format("%c%c%c%c %10d %-10tF %<-8tT %s", Character.valueOf(c1), Character.valueOf(isReadable ? (char)'r' : '-'), Character.valueOf(isWritable ? (char)'w' : '-'), Character.valueOf(isExecutable ? (char)'x' : '-'), size != null ? size : 0L, Mappings.get(properties, (Object)"lastModifiedDate", Date.class), Mappings.getNonNull(properties, (String)"path", String.class)));
            return true;
        }

        public String toString() {
            return "(lsp)";
        }
    }

    public static class PrintfAction
    implements Action {
        private final String format;
        private final String[] argExpressions;

        PrintfAction(String format, String[] argExpressions) {
            this.format = format;
            this.argExpressions = argExpressions;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String message;
            Object[] args = new Object[this.argExpressions.length];
            for (int i = 0; i < args.length; ++i) {
                String argExpression = this.argExpressions[i];
                try {
                    args[i] = new ExpressionEvaluator((PredicateWhichThrows)Mappings.containsKeyPredicate(properties)).evaluate(argExpression, properties);
                    continue;
                }
                catch (ParseException pe) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Parsing '-printf " + argExpression + "'"), (Throwable)pe, RuntimeException.class);
                }
                catch (EvaluationException ee) {
                    throw (RuntimeException)ExceptionUtil.wrap((String)("Evaluating '-printf " + argExpression + "'"), (Throwable)ee, RuntimeException.class);
                }
            }
            try {
                message = new Formatter().format(this.format, args).out().toString();
            }
            catch (RuntimeException re) {
                throw (RuntimeException)ExceptionUtil.wrap((String)("Formatting '" + this.format + "'"), (Throwable)re);
            }
            Printers.info((String)message);
            return true;
        }

        public String toString() {
            return "(echo '" + this.format + "')";
        }
    }

    public static class EchoAction
    implements Action {
        private final de.unkrig.commons.text.expression.Expression message;

        public EchoAction(String message) {
            this.message = Find.parseExt(message);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info((String)Find.evaluateExpression(this.message, (Mapping<String, Object>)properties));
            return true;
        }

        public String toString() {
            return "(echo '" + this.message + "')";
        }
    }

    public static class PrintAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info((String)((String)Mappings.getNonNull(properties, (String)"path", String.class)));
            return true;
        }

        public String toString() {
            return "(print)";
        }
    }

    static interface Action
    extends Expression {
    }

    public static class ModificationTimeTest
    extends PredicateTest<Date> {
        public static final long DAYS = 86400000L;
        public static final long MINUTES = 60000L;

        public ModificationTimeTest(final Predicate<? super Long> predicate, final long factor) {
            super("lastModifiedDate", Date.class, new Predicate<Date>(){

                public boolean evaluate(Date lastModifiedDate) {
                    long milliseconds = System.currentTimeMillis() - lastModifiedDate.getTime();
                    long days = milliseconds / factor;
                    return predicate.evaluate((Object)days);
                }

                public String toString() {
                    return "(" + predicate + " days)";
                }
            });
        }
    }

    public static class SizeTest
    extends PredicateTest<Long> {
        public SizeTest(Predicate<? super Long> predicate) {
            super("size", Long.class, predicate);
        }
    }

    public static class ExecutabilityTest
    extends BooleanTest {
        public ExecutabilityTest() {
            super("canExecute");
        }
    }

    public static class WritabilityTest
    extends BooleanTest {
        public WritabilityTest() {
            super("canWrite");
        }
    }

    public static class ReadabilityTest
    extends BooleanTest {
        public ReadabilityTest() {
            super("canRead");
        }
    }

    public static class TypeTest
    extends GlobTest {
        public TypeTest(String typeGlob) {
            super("type", typeGlob);
        }
    }

    public static class PathTest
    extends GlobTest {
        public PathTest(String pathGlob) {
            super("path", pathGlob);
        }
    }

    public static class NameTest
    extends GlobTest {
        public NameTest(String nameGlob) {
            super("name", nameGlob);
        }
    }

    public static class GlobTest
    extends StringPredicateTest {
        GlobTest(String propertyName, String pattern) {
            super(propertyName, (Predicate<? super String>)Glob.compile((String)pattern, (int)-1610612736));
        }
    }

    public static class StringPredicateTest
    implements Test {
        private final Predicate<? super String> predicate;
        private final String propertyName;

        StringPredicateTest(String propertyName, Predicate<? super String> predicate) {
            this.propertyName = propertyName;
            this.predicate = predicate;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Object propertyValue = Mappings.get(properties, (Object)this.propertyName, Object.class);
            return propertyValue != null && this.predicate.evaluate((Object)propertyValue.toString());
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    public static abstract class PredicateTest<T>
    implements Test {
        private final Predicate<? super T> predicate;
        private final Class<T> propertyType;
        private final String propertyName;

        PredicateTest(String propertyName, Class<T> propertyType, Predicate<? super T> predicate) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.predicate = predicate;
        }

        @Override
        public final boolean evaluate(Mapping<String, Object> properties) {
            Object propertyValue = Mappings.get(properties, (Object)this.propertyName, this.propertyType);
            return propertyValue != null && this.predicate.evaluate(propertyValue);
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    public static class BooleanTest
    implements Test {
        private final String propertyName;

        public BooleanTest(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Boolean value = (Boolean)Mappings.get(properties, (Object)this.propertyName, Boolean.class);
            return value != null && value != false;
        }

        public final String toString() {
            return this.propertyName;
        }
    }

    public static class NotExpression
    extends UnaryTest {
        NotExpression(Expression operand) {
            super(operand);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return !this.operand.evaluate(properties);
        }

        public String toString() {
            return "(not " + this.operand + ")";
        }
    }

    public static class AndTest
    extends BinaryTest {
        AndTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) && this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " && " + this.rhs + ")";
        }
    }

    public static class OrTest
    extends BinaryTest {
        OrTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) || this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " || " + this.rhs + ")";
        }
    }

    public static class CommaTest
    extends BinaryTest {
        CommaTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            this.lhs.evaluate(properties);
            return this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + ", " + this.rhs + ")";
        }
    }

    public static abstract class BinaryTest
    implements Test {
        protected final Expression lhs;
        protected final Expression rhs;

        BinaryTest(Expression lhs, Expression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    public static abstract class UnaryTest
    implements Test {
        protected final Expression operand;

        UnaryTest(Expression operand) {
            this.operand = operand;
        }
    }

    public static class ConstantTest
    implements Test {
        private final boolean value;

        public ConstantTest(boolean value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static interface Test
    extends Expression {
        public static final Test TRUE = new ConstantTest(true);
        public static final Test FALSE = new ConstantTest(false);

        @Override
        public boolean evaluate(Mapping<String, Object> var1);
    }

    public static interface Expression
    extends Predicate<Mapping<String, Object>> {
        public boolean evaluate(Mapping<String, Object> var1);
    }
}

