/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.zz.find.Find;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class Parser {
    private final AbstractParser<TokenType> parser;
    private final OutputStream outOS;
    private boolean hadAction;

    public <EX extends Exception> Parser(final ProducerWhichThrows<String, ? extends EX> producer, OutputStream out) {
        this.parser = new AbstractParser<TokenType>(new ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException>(){

            @Override
            @Nullable
            public AbstractScanner.Token<TokenType> produce() throws ScanException {
                String text;
                try {
                    text = (String)producer.produce();
                }
                catch (Exception e) {
                    throw ExceptionUtil.wrap(null, e, ScanException.class);
                }
                if (text == null) {
                    return null;
                }
                return new AbstractScanner.Token<TokenType>(TokenType.LITERAL, text);
            }
        });
        this.outOS = out;
    }

    public Find.Expression parse() throws ParseException {
        if (this.parser.peek() == null) {
            return new Find.PrintAction();
        }
        Find.Expression result = this.parseComma();
        this.parser.eoi();
        return this.hadAction ? result : new Find.AndTest(result, new Find.PrintAction());
    }

    private Find.Expression parseComma() throws ParseException {
        Find.Expression lhs = this.parseOr();
        return this.parser.peekRead(",") ? new Find.CommaTest(lhs, this.parseComma()) : lhs;
    }

    private Find.Expression parseOr() throws ParseException {
        Find.Expression lhs = this.parseAnd();
        if (this.parser.peekRead("-o", "-or") == -1) {
            return lhs;
        }
        Find.Expression rhs = this.parseOr();
        return new Find.OrTest(lhs, rhs);
    }

    private Find.Expression parseAnd() throws ParseException {
        Find.Expression lhs = this.parsePrimary();
        return this.parser.peekRead("-a", "-and") != -1 || this.parser.peek("-o", "-or", ")", ",", null) == -1 ? new Find.AndTest(lhs, this.parseAnd()) : lhs;
    }

    private Find.Expression parsePrimary() throws ParseException {
        switch (this.parser.read("(", "!", "-not", "-name", "-path", "-type", "-readable", "-writable", "-executable", "-size", "-mtime", "-mmin", "-print", "-echo", "-ls", "-exec", "-pipe", "-cat", "-copy", "-disassemble", "-digest", "-checksum", "-true", "-false")) {
            case 0: {
                Find.Expression result = this.parseComma();
                this.parser.read(")");
                return result;
            }
            case 1: 
            case 2: {
                return new Find.NotExpression(this.parsePrimary());
            }
            case 3: {
                return new Find.NameTest(this.parser.read().text);
            }
            case 4: {
                return new Find.PathTest(this.parser.read().text);
            }
            case 5: {
                return new Find.TypeTest(this.parser.read().text);
            }
            case 6: {
                return new Find.ReadabilityTest();
            }
            case 7: {
                return new Find.WritabilityTest();
            }
            case 8: {
                return new Find.ExecutabilityTest();
            }
            case 9: {
                return new Find.SizeTest(Parser.parseNumericArgument(this.parser.read().text));
            }
            case 10: {
                return new Find.ModificationTimeTest(Parser.parseNumericArgument(this.parser.read().text), 86400000L);
            }
            case 11: {
                return new Find.ModificationTimeTest(Parser.parseNumericArgument(this.parser.read().text), 60000L);
            }
            case 12: {
                this.hadAction = true;
                return new Find.PrintAction();
            }
            case 13: {
                this.hadAction = true;
                return new Find.EchoAction(this.parser.read().text);
            }
            case 14: {
                this.hadAction = true;
                return new Find.LsAction();
            }
            case 15: {
                ArrayList<String> command = new ArrayList<String>();
                while (!this.parser.peekRead(";")) {
                    command.add(this.parser.read().text);
                }
                this.hadAction = true;
                return new Find.ExecAction(command);
            }
            case 16: {
                ArrayList<String> command = new ArrayList<String>();
                while (!this.parser.peekRead(";")) {
                    command.add(this.parser.read().text);
                }
                this.hadAction = true;
                return new Find.PipeAction(command, null);
            }
            case 17: {
                this.hadAction = true;
                return new Find.CatAction(this.outOS);
            }
            case 18: {
                this.hadAction = true;
                return new Find.CopyAction(new File(this.parser.read().text), false);
            }
            case 19: {
                this.hadAction = true;
                return new Find.DisassembleAction(this.parser.peekRead("-hideLines"), this.parser.peekRead("-hideVars"), null);
            }
            case 20: {
                this.hadAction = true;
                return new Find.DigestAction(this.parser.read().text);
            }
            case 21: {
                Find.ChecksumAction.ChecksumType cst;
                this.hadAction = true;
                try {
                    cst = Find.ChecksumAction.ChecksumType.valueOf(this.parser.read().text);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Invalid checksum type \"" + this.parser.read().text + "\"; allowed values are " + Arrays.toString((Object[])Find.ChecksumAction.ChecksumType.values()));
                }
                return new Find.ChecksumAction(cst);
            }
            case 22: {
                return Find.Test.TRUE;
            }
            case 23: {
                return Find.Test.FALSE;
            }
        }
        throw new IllegalStateException();
    }

    public static Predicate<Long> parseNumericArgument(String text) {
        long multiplier;
        Mode mode;
        if (text.startsWith("+")) {
            mode = Mode.MORE_THAN;
            text = text.substring(1);
        } else if (text.startsWith("-")) {
            mode = Mode.LESS_THAN;
            text = text.substring(1);
        } else {
            mode = Mode.EXACTLY;
        }
        if (text.endsWith("k")) {
            multiplier = 1024L;
            text = text.substring(0, text.length() - 1);
        } else if (text.endsWith("M")) {
            multiplier = 0x100000L;
            text = text.substring(0, text.length() - 1);
        } else if (text.endsWith("G")) {
            multiplier = 0x40000000L;
            text = text.substring(0, text.length() - 1);
        } else {
            multiplier = 1L;
        }
        final long n = multiplier * Long.parseLong(text);
        return new Predicate<Long>(){

            @Override
            public boolean evaluate(Long subject) {
                switch (mode) {
                    case EXACTLY: {
                        return subject == n;
                    }
                    case LESS_THAN: {
                        return subject < n;
                    }
                    case MORE_THAN: {
                        return subject > n;
                    }
                }
                throw new IllegalStateException();
            }

            public String toString() {
                return (mode == Mode.MORE_THAN ? "> " : (mode == Mode.LESS_THAN ? "< " : (mode == Mode.EXACTLY ? "== " : "??? "))) + n;
            }
        };
    }

    private static enum Mode {
        MORE_THAN,
        LESS_THAN,
        EXACTLY;

    }

    static enum TokenType {
        LITERAL;

    }
}

