/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ProcessUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.jdisasm.Disassembler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public class Find {
    private static final Logger LOGGER;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private boolean depth;
    private int minDepth;
    private int maxDepth = Integer.MAX_VALUE;
    private Expression expression = Test.TRUE;
    private ConsumerWhichThrows<? super IOException, IOException> exceptionHandler = ConsumerUtil.throwsSubject();

    public void setLookIntoFormat(Predicate<? super String> value) {
        LOGGER.log(Level.FINE, "setLookIntoFormat({0})", value);
        this.lookIntoFormat = value;
    }

    public void setDepth(boolean value) {
        this.depth = value;
    }

    public void setMinDepth(int levels) {
        this.minDepth = levels;
    }

    public void setMaxDepth(int levels) {
        this.maxDepth = levels;
    }

    public void setExpression(Expression value) {
        LOGGER.log(Level.FINE, "setExpression({0})", value);
        this.expression = value;
    }

    public Find setExceptionHandler(ConsumerWhichThrows<? super IOException, IOException> value) {
        this.exceptionHandler = value;
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public static String expandVariables(String s, Mapping<String, ?> variables) {
        int idx = s.indexOf(64);
        while (idx != -1 && idx != s.length() - 1) {
            block5: {
                String variableName;
                int to;
                int from;
                block4: {
                    char c;
                    block3: {
                        if ((c = s.charAt((from = idx++) + 1)) != '{') break block3;
                        to = s.indexOf(125, from + 2);
                        if (to == -1) break;
                        variableName = s.substring(from + 2, to++);
                        break block4;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        for (to = from + 2; to < s.length() && Character.isJavaIdentifierPart(s.charAt(to)); ++to) {
                        }
                        variableName = s.substring(from + 1, to);
                    }
                    break block5;
                }
                Object value = variables.get(variableName);
                String replacement = value == null ? "" : value.toString();
                s = s.substring(0, from) + replacement + s.substring(to);
                idx += replacement.length();
            }
            idx = s.indexOf(64, idx);
        }
        return s;
    }

    public void findInStream(InputStream is) throws IOException {
        if (this.maxDepth < 0) {
            return;
        }
        this.findInStream("-", System.in, Mappings.mapping("isDirectory", false, "isExecutable", false, "isReadable", true, "isWritable", false, "lastModifiedDate", new Date(), "path", "-", "size", -1L), 0);
    }

    public void findInFile(File file) throws IOException {
        this.findInDirectoryTree(file.getPath(), file, 0);
    }

    private void findInDirectoryTree(String path, File fileOrDirectory, int depth) throws IOException {
        if (fileOrDirectory.isDirectory()) {
            this.findInDirectory(path, fileOrDirectory, depth);
        } else {
            this.findInFile(path, fileOrDirectory, depth);
        }
    }

    private void findInDirectory(final String directoryPath, final File directory, final int depth) throws IOException {
        LOGGER.log(Level.FINER, "Processing directory \"{0}\" (path is \"{1}\")", new Object[]{directory, directoryPath});
        RunnableUtil.swapIf(this.depth, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() {
                Find.this.evaluateExpression(Mappings.augment(Find.fileProperties(directoryPath, directory), "type", "directory", "depth", depth));
            }
        }, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                if (depth < Find.this.maxDepth) {
                    for (String memberName : directory.list()) {
                        try {
                            Find.this.findInDirectoryTree(directoryPath + File.separatorChar + memberName, new File(directory, memberName), depth + 1);
                        }
                        catch (IOException ioe) {
                            Find.this.exceptionHandler.consume(ioe);
                        }
                    }
                }
            }
        });
    }

    public static Mapping<String, Object> fileProperties(final String path, final File file) {
        return Mappings.propertiesOf(new Object(){

            public String getAbsolutePath() {
                return file.getAbsolutePath();
            }

            public String getCanonicalPath() throws IOException {
                return file.getCanonicalPath();
            }

            public Date getLastModifiedDate() {
                return new Date(file.lastModified());
            }

            public String getName() {
                return file.getName();
            }

            public String getPath() {
                return path;
            }

            public long getSize() {
                return file.length();
            }

            public boolean isDirectory() {
                return file.isDirectory();
            }

            public boolean isFile() {
                return file.isFile();
            }

            public boolean isHidden() {
                return file.isHidden();
            }

            public boolean isReadable() {
                return file.canRead();
            }

            public boolean isWritable() {
                return file.canWrite();
            }

            public boolean isExecutable() {
                return file.canExecute();
            }

            public String toString() {
                return "File \"" + path + "\"";
            }
        });
    }

    private void findInFile(final String path, final File file, final int depth) throws IOException {
        LOGGER.log(Level.FINER, "Processing file \"{0}\" (path is \"{1}\")", new Object[]{file, path});
        CompressUtil.processFile(path, file, this.lookIntoFormat, new CompressUtil.ArchiveHandler<Void>(){

            @Override
            @Nullable
            public Void handleArchive(final ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                RunnableUtil.swapIf(Find.this.depth, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() {
                        Find.this.evaluateExpression(Mappings.augment(Find.fileProperties(path, file), "type", "archive-file", "archiveFormat", archiveFormat, "depth", depth));
                    }
                }, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() throws IOException {
                        if (depth < Find.this.maxDepth) {
                            ArchiveEntry ae;
                            while ((ae = archiveInputStream.getNextEntry()) != null) {
                                String entryPath = path + '!' + ArchiveFormatFactory.normalizeEntryName(ae.getName());
                                if (ae.isDirectory()) {
                                    Find.this.evaluateExpression(Mappings.override(Mappings.union(Mappings.propertiesOf(ae), Find.fileProperties(path, file)), "path", entryPath, "name", ArchiveFormatFactory.normalizeEntryName(ae.getName()), "archiveFormat", archiveFormat, "type", "directory-entry", "depth", depth + 1));
                                    continue;
                                }
                                try {
                                    Find.this.findInStream(entryPath, archiveInputStream, Mappings.override(Mappings.union(Mappings.propertiesOf(ae), Find.fileProperties(path, file)), "archiveFormat", archiveFormat), depth + 1);
                                }
                                catch (IOException ioe) {
                                    Find.this.exceptionHandler.consume(ioe);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        }, new CompressUtil.CompressorHandler<Void>(){

            @Override
            @Nullable
            public Void handleCompressor(final CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                RunnableUtil.swapIf(Find.this.depth, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() {
                        Find.this.evaluateExpression(Mappings.augment(Find.fileProperties(path, file), "type", "compressed-file", "compressionFormat", compressionFormat, "depth", depth));
                    }
                }, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() throws IOException {
                        if (depth < Find.this.maxDepth) {
                            Find.this.findInStream(path + '%', compressorInputStream, Mappings.override(Find.fileProperties(path, file), "compressionFormat", compressionFormat, "name", file.getName() + '%', "size", -1L), depth + 1);
                        }
                    }
                });
                return null;
            }
        }, new CompressUtil.NormalContentsHandler<Void>(){

            @Override
            @Nullable
            public Void handleNormalContents(InputStream inputStream) {
                Find.this.evaluateExpression(Mappings.augment(Find.fileProperties(path, file), "type", "file", "inputStream", inputStream, "depth", depth));
                return null;
            }
        });
    }

    private void findInStream(final String path, InputStream inputStream, final Mapping<String, Object> streamProperties, final int depth) throws IOException {
        try {
            CompressUtil.processStream(path, inputStream, this.lookIntoFormat, new CompressUtil.ArchiveHandler<Void>(){

                @Override
                @Nullable
                public Void handleArchive(final ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                    RunnableUtil.swapIf(Find.this.depth, new RunnableWhichThrows<IOException>(){

                        @Override
                        public void run() {
                            Find.this.evaluateExpression(Mappings.override(streamProperties, "path", path, "type", "archive", "archiveFormat", archiveFormat, "depth", depth));
                        }
                    }, new RunnableWhichThrows<IOException>(){

                        @Override
                        public void run() throws IOException {
                            if (depth < Find.this.maxDepth) {
                                ArchiveEntry ae = archiveInputStream.getNextEntry();
                                while (ae != null) {
                                    String entryName = ArchiveFormatFactory.normalizeEntryName(ae.getName());
                                    String entryPath = path + '!' + entryName;
                                    if (ae.isDirectory()) {
                                        Find.this.evaluateExpression(Mappings.override(Mappings.union(Mappings.propertiesOf(ae), streamProperties), "archiveFormat", archiveFormat, "path", entryPath, "name", entryName, "type", "directory-entry", "depth", depth + 1));
                                    } else {
                                        try {
                                            Find.this.findInStream(entryPath, archiveInputStream, Mappings.override(Mappings.union(Mappings.propertiesOf(ae), streamProperties), "archiveFormat", archiveFormat), depth + 1);
                                        }
                                        catch (IOException ioe) {
                                            Find.this.exceptionHandler.consume(ioe);
                                        }
                                    }
                                    ae = archiveInputStream.getNextEntry();
                                }
                            }
                        }
                    });
                    return null;
                }
            }, new CompressUtil.CompressorHandler<Void>(){

                @Override
                @Nullable
                public Void handleCompressor(final CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                    RunnableUtil.swapIf(Find.this.depth, new RunnableWhichThrows<IOException>(){

                        @Override
                        public void run() {
                            Find.this.evaluateExpression(Mappings.override(streamProperties, "type", "compressed-contents", "path", path, "compressionFormat", compressionFormat, "depth", depth));
                        }
                    }, new RunnableWhichThrows<IOException>(){

                        @Override
                        public void run() throws IOException {
                            if (depth < Find.this.maxDepth) {
                                String name = (String)streamProperties.get("name");
                                assert (name != null);
                                Find.this.findInStream(path + '%', compressorInputStream, Mappings.override(streamProperties, "compressionFormat", compressionFormat, "name", name + '%', "size", -1L), depth + 1);
                            }
                        }
                    });
                    return null;
                }
            }, new CompressUtil.NormalContentsHandler<Void>(){

                @Override
                @Nullable
                public Void handleNormalContents(final InputStream inputStream) {
                    Find.this.evaluateExpression(Mappings.override(streamProperties, "path", path, "type", "normal-contents", "inputStream", inputStream, "depth", depth, "size", new Producer<Long>(){

                        @Override
                        @Nullable
                        public Long produce() {
                            Long size = (Long)streamProperties.get("size");
                            assert (size != null);
                            if (size != -1L) {
                                return size;
                            }
                            try {
                                return IoUtil.skipAll(inputStream);
                            }
                            catch (IOException ioe) {
                                throw ExceptionUtil.wrap("Measuring size of \"" + path + "\"", ioe, RuntimeException.class);
                            }
                        }
                    }));
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap(path, ioe);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.wrap(path, re);
        }
    }

    private void evaluateExpression(Mapping<String, Object> properties) {
        if (this.minDepth > 0) {
            Object depthValue = properties.get("depth");
            assert (depthValue instanceof Integer);
            int depth = (Integer)depthValue;
            if (depth < this.minDepth) {
                return;
            }
        }
        this.expression.evaluate(properties);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(Find.class.getName());
    }

    static class ChecksumAction
    implements Action {
        private final ChecksumType checksumType;

        ChecksumAction(ChecksumType checksumType) {
            this.checksumType = checksumType;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Checksum cs = this.checksumType.newChecksum();
            InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            try {
                ChecksumAction.updateAll(cs, is);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-checksum' on '" + properties + "'", ioe, RuntimeException.class);
            }
            Printers.info(Long.toHexString(cs.getValue()));
            return true;
        }

        private static void updateAll(Checksum checksum, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                checksum.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(checksum " + (Object)((Object)this.checksumType) + ")";
        }

        static enum ChecksumType {
            CRC32{

                @Override
                Checksum newChecksum() {
                    return new CRC32();
                }
            }
            ,
            ADLER32{

                @Override
                Checksum newChecksum() {
                    return new Adler32();
                }
            };


            abstract Checksum newChecksum();
        }
    }

    static class DigestAction
    implements Action {
        private final String algorithm;

        DigestAction(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw ExceptionUtil.wrap("Running '-digest' on '" + properties + "'", nsae, IllegalArgumentException.class);
            }
            InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            try {
                DigestAction.updateAll(md, is);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-digest' on '" + properties + "'", ioe, RuntimeException.class);
            }
            byte[] digest = md.digest();
            Formatter f = new Formatter();
            for (byte b : digest) {
                f.format("%02x", b & 0xFF);
            }
            Printers.info(f.toString());
            return true;
        }

        private static void updateAll(MessageDigest messageDigest, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(digest " + this.algorithm + ")";
        }
    }

    static class DisassembleAction
    implements Action {
        private final boolean hideLines;
        private final boolean hideVars;
        @Nullable
        private final File toFile;

        DisassembleAction(boolean hideLines, boolean hideVars, @Nullable File toFile) {
            this.hideLines = hideLines;
            this.hideVars = hideVars;
            this.toFile = toFile;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            final Disassembler disassembler = new Disassembler();
            disassembler.setHideLines(this.hideLines);
            disassembler.setHideVars(this.hideVars);
            final InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            File toFile = this.toFile;
            try {
                if (toFile == null) {
                    disassembler.disasm(in);
                } else {
                    IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

                        @Override
                        public void consume(OutputStream os) throws IOException {
                            disassembler.setOut(os);
                            disassembler.disasm(in);
                        }
                    }, true);
                }
            }
            catch (IOException ioe) {
                return false;
            }
            return true;
        }

        public String toString() {
            return "(Disassemble .class file)";
        }
    }

    static class PipeAction
    implements Action {
        private final List<String> command;
        @Nullable
        private final File workingDirectory;

        PipeAction(List<String> command, @Nullable File workingDirectory) {
            this.command = command;
            this.workingDirectory = workingDirectory;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            ArrayList<String> command2 = new ArrayList<String>();
            for (String word : this.command) {
                command2.add(Find.expandVariables(word, properties));
            }
            try {
                return ProcessUtil.execute(command2, this.workingDirectory, in, false, System.out, false, System.err, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap("Running 'pipe' on '" + properties + "'", e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(pipe contents to command " + this.command + ")";
        }
    }

    static class CopyAction
    implements Action {
        private final File tofile;
        private final boolean mkdirs;

        CopyAction(File tofile, boolean mkdirs) {
            this.tofile = tofile;
            this.mkdirs = mkdirs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            try {
                File tofile = new File(Find.expandVariables(this.tofile.getPath(), properties));
                if (this.mkdirs) {
                    IoUtil.createMissingParentDirectoriesFor(tofile);
                }
                InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
                FileOutputStream out = new FileOutputStream(tofile);
                try {
                    IoUtil.copy(in, out);
                    ((OutputStream)out).close();
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running 'copy' on '" + properties + "'", ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(copy to '" + this.tofile + "')";
        }
    }

    static class CatAction
    implements Action {
        private final OutputStream out;

        CatAction(OutputStream out) {
            this.out = out;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            try {
                InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
                IoUtil.copy(is, this.out);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-cat' on '" + properties + "'", ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(cat " + this.out + ")";
        }
    }

    static class ExecAction
    implements Action {
        private final List<String> command;

        ExecAction(List<String> command) {
            this.command = command;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String path = null;
            ArrayList<String> command2 = new ArrayList<String>();
            for (String word : this.command) {
                if (word.contains("{}")) {
                    if (path == null) {
                        path = Mappings.getNonNull(properties, "path", String.class);
                    }
                    word = word.replace("{}", path);
                }
                command2.add(Find.expandVariables(word, properties));
            }
            try {
                return ProcessUtil.execute(command2, null, System.in, false, System.out, false, System.err, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap("Executing '" + command2 + "'", e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(exec '" + this.command + "')";
        }
    }

    static class LsAction
    implements Action {
        LsAction() {
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info(String.format("%c%c%c%c %10d %tF %<tT %s", Character.valueOf(Mappings.getNonNull(properties, "isDirectory", Boolean.TYPE) != false ? (char)'d' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isReadable", Boolean.TYPE) != false ? (char)'r' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isWritable", Boolean.TYPE) != false ? (char)'w' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isExecutable", Boolean.TYPE) != false ? (char)'x' : '-'), Mappings.getNonNull(properties, "size", Long.class), Mappings.getNonNull(properties, "lastModifiedDate", Date.class), Mappings.getNonNull(properties, "path", String.class)));
            return true;
        }

        public String toString() {
            return "(lsp)";
        }
    }

    static class EchoAction
    implements Action {
        private final String message;

        EchoAction(String message) {
            this.message = message;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String message = Find.expandVariables(this.message, properties);
            Printers.info(message);
            return true;
        }

        public String toString() {
            return "(echo '" + this.message + "')";
        }
    }

    static class PrintAction
    implements Action {
        PrintAction() {
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info(Mappings.getNonNull(properties, "path", String.class));
            return true;
        }

        public String toString() {
            return "(print)";
        }
    }

    static interface Action
    extends Expression {
    }

    public static class ModificationTimeTest
    extends PredicateTest<Date> {
        public static final long DAYS = 86400000L;
        public static final long MINUTES = 60000L;

        public ModificationTimeTest(final Predicate<? super Long> predicate, final long factor) {
            super("lastModifiedDate", Date.class, new Predicate<Date>(){

                @Override
                public boolean evaluate(Date lastModifiedDate) {
                    long milliseconds = System.currentTimeMillis() - lastModifiedDate.getTime();
                    long days = milliseconds / factor;
                    return predicate.evaluate(days);
                }

                public String toString() {
                    return "(" + predicate + " days)";
                }
            });
        }
    }

    public static class SizeTest
    extends PredicateTest<Long> {
        public SizeTest(Predicate<? super Long> predicate) {
            super("size", Long.class, predicate);
        }
    }

    public static class ExecutabilityTest
    extends BooleanTest {
        public ExecutabilityTest() {
            super("canExecute");
        }
    }

    public static class WritabilityTest
    extends BooleanTest {
        public WritabilityTest() {
            super("canWrite");
        }
    }

    public static class ReadabilityTest
    extends BooleanTest {
        public ReadabilityTest() {
            super("canRead");
        }
    }

    public static class TypeTest
    extends GlobTest {
        public TypeTest(String typeGlob) {
            super("type", typeGlob);
        }
    }

    public static class PathTest
    extends GlobTest {
        public PathTest(String pathGlob) {
            super("path", pathGlob);
        }
    }

    public static class NameTest
    extends GlobTest {
        public NameTest(String nameGlob) {
            super("name", nameGlob);
        }
    }

    private static class GlobTest
    extends StringPredicateTest {
        GlobTest(String propertyName, String pattern) {
            super(propertyName, Glob.compile(pattern, -1610612736));
        }
    }

    private static class StringPredicateTest
    implements Test {
        private final Predicate<? super String> predicate;
        private final String propertyName;

        StringPredicateTest(String propertyName, Predicate<? super String> predicate) {
            this.propertyName = propertyName;
            this.predicate = predicate;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Object propertyValue = Mappings.get(properties, this.propertyName, Object.class);
            return propertyValue != null && this.predicate.evaluate(propertyValue.toString());
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    private static class PredicateTest<T>
    implements Test {
        private final Predicate<? super T> predicate;
        private final Class<T> propertyType;
        private final String propertyName;

        PredicateTest(String propertyName, Class<T> propertyType, Predicate<? super T> predicate) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.predicate = predicate;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            T propertyValue = Mappings.get(properties, this.propertyName, this.propertyType);
            return propertyValue != null && this.predicate.evaluate(propertyValue);
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    private static class BooleanTest
    implements Test {
        private final String propertyName;

        BooleanTest(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Boolean value = Mappings.get(properties, this.propertyName, Boolean.class);
            return value != null && value != false;
        }

        public final String toString() {
            return this.propertyName;
        }
    }

    static class NotExpression
    extends UnaryTest {
        NotExpression(Expression operand) {
            super(operand);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return !this.operand.evaluate(properties);
        }

        public String toString() {
            return "(not " + this.operand + ")";
        }
    }

    static class AndTest
    extends BinaryTest {
        AndTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) && this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " && " + this.rhs + ")";
        }
    }

    static class OrTest
    extends BinaryTest {
        OrTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) || this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " || " + this.rhs + ")";
        }
    }

    static class CommaTest
    extends BinaryTest {
        CommaTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            this.lhs.evaluate(properties);
            return this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + ", " + this.rhs + ")";
        }
    }

    static abstract class BinaryTest
    implements Test {
        protected final Expression lhs;
        protected final Expression rhs;

        BinaryTest(Expression lhs, Expression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    static abstract class UnaryTest
    implements Test {
        protected final Expression operand;

        UnaryTest(Expression operand) {
            this.operand = operand;
        }
    }

    static class ConstantTest
    implements Test {
        private final boolean value;

        public ConstantTest(boolean value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static interface Test
    extends Expression {
        public static final Test TRUE = new ConstantTest(true);
        public static final Test FALSE = new ConstantTest(false);

        @Override
        public boolean evaluate(Mapping<String, Object> var1);
    }

    public static interface Expression
    extends Predicate<Mapping<String, Object>> {
        @Override
        public boolean evaluate(Mapping<String, Object> var1);
    }
}

