/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.ProxyPrinter;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.zz.find.AbstractElementWithOperands;
import de.unkrig.zz.find.Find;
import de.unkrig.zz.find.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;

public class AntTask
extends AbstractElementWithOperands {
    private final Find find = new Find();
    private final AndElement root = new AndElement();
    @Nullable
    private File outputFile;
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();

    public void setLookInto(String value) {
        this.find.setLookIntoFormat(Glob.compile(value, -1610612736));
    }

    public void setDepth(boolean value) {
        this.find.setDepth(value);
    }

    public void setMinDepth(int levels) {
        this.find.setMinDepth(levels);
    }

    public void setMaxDepth(int levels) {
        this.find.setMaxDepth(levels);
    }

    public void setFile(File file) {
        this.resourceCollections.add(new FileResource(file));
    }

    public void setDir(File directory) {
        this.resourceCollections.add(new FileResource(directory));
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    @Override
    public void addConfigured(ExpressionElement operand) {
        this.root.addConfigured(operand);
    }

    static MacroDef.NestedSequential newSequential(final AbstractElementWithOperands container) {
        final MacroDef macroDef = new MacroDef();
        macroDef.setProject(container.getProject());
        MacroDef.Attribute attribute = new MacroDef.Attribute();
        attribute.setName("name");
        macroDef.addConfiguredAttribute(attribute);
        attribute = new MacroDef.Attribute();
        attribute.setName("path");
        macroDef.addConfiguredAttribute(attribute);
        attribute = new MacroDef.Attribute();
        attribute.setName("entryName");
        macroDef.addConfiguredAttribute(attribute);
        ExpressionElement operand = new ExpressionElement(){

            @Override
            public Find.Expression toExpression() {
                return new Find.Expression(){

                    @Override
                    public boolean evaluate(Mapping<String, Object> properties) {
                        MacroInstance instance = new MacroInstance();
                        instance.setProject(container.getProject());
                        instance.setMacroDef(macroDef);
                        for (String attributeName : new String[]{"name", "path"}) {
                            Object attributeValue = properties.get(attributeName);
                            if (attributeValue == null) continue;
                            instance.setDynamicAttribute(attributeName, attributeValue.toString());
                        }
                        instance.execute();
                        return true;
                    }

                    public String toString() {
                        return "<sequential " + macroDef.getLocation() + ">";
                    }
                };
            }
        };
        container.addConfigured(operand);
        return macroDef.createSequential();
    }

    public void addConfigured(ResourceCollection value) {
        new Throwable().printStackTrace();
        System.err.println(value.getClass().getName());
        this.resourceCollections.add(value);
    }

    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private void execute2() {
        this.find.setExpression(this.root.toExpression());
        final boolean[] hadExceptions = new boolean[1];
        ConsumerWhichThrows<IOException, IOException> exceptionHandler = new ConsumerWhichThrows<IOException, IOException>(){

            @Override
            public void consume(IOException ioe) {
                AntTask.this.getProject().log(null, ioe, 0);
                hadExceptions[0] = true;
            }
        };
        this.find.setExceptionHandler((ConsumerWhichThrows<? super IOException, IOException>)exceptionHandler);
        for (ResourceCollection rc : this.resourceCollections) {
            Iterator it = rc.iterator();
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                try {
                    this.execute3(resource);
                }
                catch (IOException ioe) {
                    this.getProject().log(null, ioe, 0);
                    hadExceptions[0] = true;
                }
            }
        }
        if (hadExceptions[0]) {
            throw new BuildException("One or more files had i/o exceptions");
        }
    }

    private void execute3(final Resource resource) throws IOException {
        AntTask.execute4(new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                if (resource instanceof FileProvider) {
                    AntTask.this.find.findInFile(((FileProvider)((Object)resource)).getFile());
                } else {
                    InputStream is = resource.getInputStream();
                    try {
                        AntTask.this.find.findInStream(is);
                        is.close();
                    }
                    catch (IOException ioe) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }, this.outputFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute4(RunnableWhichThrows<IOException> runnable, @Nullable File outputFile, final ProjectComponent component) throws IOException {
        AbstractPrinter printer = new AbstractPrinter(){

            @Override
            public void warn(@Nullable String message) {
                component.log(message, 1);
            }

            @Override
            public void verbose(@Nullable String message) {
                component.log(message, 3);
            }

            @Override
            public void info(@Nullable String message) {
                component.log(message, 2);
            }

            @Override
            public void error(@Nullable String message) {
                component.log(message, 0);
            }

            @Override
            public void debug(@Nullable String message) {
                component.log(message, 4);
            }
        };
        if (outputFile == null) {
            Printers.withPrinter((Printer)printer, runnable);
        } else {
            final PrintStream out = new PrintStream(outputFile);
            try {
                printer = new ProxyPrinter(printer){

                    @Override
                    public void info(@Nullable String message) {
                        out.println(message);
                    }
                };
                Printers.withPrinter((Printer)printer, runnable);
                out.close();
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Find.Action redirectInfoToProperty(final Project project, final Find.Action action, final @Nullable String propertyName) {
        if (propertyName == null) {
            return action;
        }
        return new Find.Action(){

            @Override
            public boolean evaluate(final Mapping<String, Object> properties) {
                final boolean[] result = new boolean[1];
                Printers.redirectInfo((ConsumerWhichThrows<? super String, ? extends RuntimeException>)new Consumer<String>(){

                    @Override
                    public void consume(String subject) {
                        project.setProperty(propertyName, subject);
                    }
                }, new RunnableWhichThrows<RuntimeException>(){

                    @Override
                    public void run() {
                        result[0] = action.evaluate(properties);
                    }
                });
                return result[0];
            }
        };
    }

    public static class FalseElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return Find.Test.FALSE;
        }
    }

    public static class TrueElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return Find.Test.TRUE;
        }
    }

    public static class ModificationTimeElement
    implements ExpressionElement {
        @Nullable
        private Predicate<? super Long> predicate;
        private long factor;

        @Deprecated
        public void setValue(String value) {
            this.setDays(value);
        }

        public void setDays(String value) {
            if (this.predicate != null) {
                throw new BuildException("\"days=...\" and \"-minutes=...\" are mutually exclusive");
            }
            this.predicate = Parser.parseNumericArgument(value);
            this.factor = 86400000L;
        }

        public void setMinutes(String value) {
            if (this.predicate != null) {
                throw new BuildException("\"days=...\" and \"-minutes=...\" are mutually exclusive");
            }
            this.predicate = Parser.parseNumericArgument(value);
            this.factor = 60000L;
        }

        @Override
        public Find.Expression toExpression() {
            Predicate<? super Long> p = this.predicate;
            if (p == null) {
                throw new IllegalArgumentException("Exactly one of \"days=...\" and \"-minutes=...\" must be configured");
            }
            return new Find.ModificationTimeTest(p, this.factor);
        }
    }

    public static class SizeElement
    implements ExpressionElement {
        @Nullable
        private Predicate<? super Long> predicate;

        public void setValue(String value) {
            this.predicate = Parser.parseNumericArgument(value);
        }

        @Override
        public Find.Expression toExpression() {
            Predicate<? super Long> p = this.predicate;
            if (p == null) {
                throw new IllegalArgumentException("\"value\" attribute missing");
            }
            return new Find.SizeTest(p);
        }
    }

    public static class ExecutableElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.ExecutabilityTest();
        }
    }

    public static class WritableElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.WritabilityTest();
        }
    }

    public static class ReadableElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.ReadabilityTest();
        }
    }

    public static class NotElement
    extends AbstractElementWithOperands
    implements ExpressionElement {
        @Nullable
        private Find.Expression operand;

        @Override
        public void addConfigured(ExpressionElement operand) {
            if (this.operand != null) {
                throw new IllegalArgumentException("No more than one subelement allowed");
            }
            this.operand = operand.toExpression();
        }

        @Override
        public Find.Expression toExpression() {
            Find.Expression operand = this.operand;
            if (operand == null) {
                throw new BuildException("One 'expressionElement' subelement must exist");
            }
            return new Find.NotExpression(operand);
        }
    }

    public static final class TypeElement
    implements ExpressionElement {
        @Nullable
        private String value;

        public void setValue(String glob) {
            this.value = glob;
        }

        @Override
        public Find.Expression toExpression() {
            String value = this.value;
            if (value == null) {
                throw new BuildException("Attribute 'value' must be set");
            }
            return new Find.TypeTest(value);
        }
    }

    public static final class PathElement
    implements ExpressionElement {
        @Nullable
        private String value;

        public void setValue(String glob) {
            this.value = glob;
        }

        @Override
        public Find.Expression toExpression() {
            String value = this.value;
            if (value == null) {
                throw new BuildException("Attribute 'value' must be set");
            }
            return new Find.PathTest(value);
        }
    }

    public static final class NameElement
    implements ExpressionElement {
        @Nullable
        private String value;

        public void setValue(String glob) {
            this.value = glob;
        }

        @Override
        public Find.Expression toExpression() {
            String value = this.value;
            if (value == null) {
                throw new BuildException("Attribute 'value' must be set");
            }
            return new Find.NameTest(value);
        }
    }

    public static final class CommaElement
    extends AbstractElementWithOperands
    implements ExpressionElement {
        private Find.Expression predicate = Find.Test.FALSE;

        @Override
        public void addConfigured(ExpressionElement operand) {
            this.predicate = new Find.CommaTest(this.predicate, operand.toExpression());
        }

        @Override
        public Find.Expression toExpression() {
            return this.predicate;
        }
    }

    public static final class OrElement
    extends AbstractElementWithOperands
    implements ExpressionElement {
        private Find.Expression predicate = Find.Test.FALSE;

        @Override
        public void addConfigured(ExpressionElement operand) {
            this.predicate = new Find.OrTest(this.predicate, operand.toExpression());
        }

        @Override
        public Find.Expression toExpression() {
            return this.predicate;
        }
    }

    public static final class AndElement
    extends AbstractElementWithOperands
    implements ExpressionElement {
        private Find.Expression predicate = Find.Test.TRUE;

        @Override
        public void addConfigured(ExpressionElement operand) {
            this.predicate = new Find.AndTest(this.predicate, operand.toExpression());
        }

        @Override
        public Find.Expression toExpression() {
            return this.predicate;
        }
    }

    static class PropertyAction
    implements Find.Action {
        private final Project project;
        private final String propertyName;
        private final String propertyValue;

        PropertyAction(Project project, String propertyName, String propertyValue) {
            this.project = project;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String pn = Find.expandVariables(this.propertyName, properties);
            String pv = Find.expandVariables(this.propertyValue, properties);
            this.project.setProperty(pn, pv);
            return true;
        }

        public String toString() {
            return "(set property \"" + this.propertyName + "\" to \"" + this.propertyValue + "\")";
        }
    }

    public static class PropertyElement
    extends ProjectComponent
    implements ExpressionElement {
        @Nullable
        private String propertyName;
        @Nullable
        private String propertyValue;

        public void setName(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setValue(String text) {
            this.propertyValue = text;
        }

        @Override
        public Find.Expression toExpression() {
            String propertyName = this.propertyName;
            if (propertyName == null) {
                throw new BuildException("Attribute 'propertyName' must be set");
            }
            String propertyValue = this.propertyValue;
            if (propertyValue == null) {
                throw new BuildException("Attribute 'propertyValue' must be set");
            }
            return new PropertyAction(this.getProject(), propertyName, propertyValue);
        }
    }

    public static class PipeElement
    implements ExpressionElement {
        @Nullable
        private String command;

        public void setCommand(String command) {
            this.command = command;
        }

        @Override
        public Find.Expression toExpression() {
            String command = this.command;
            if (command == null) {
                throw new BuildException("Attribute 'command' must be set");
            }
            return new Find.PipeAction(Arrays.asList(command.split("\\s+")), null);
        }
    }

    public static class EchoElement
    implements ExpressionElement {
        @Nullable
        private String message;

        public void setMessage(String text) {
            this.message = text;
        }

        @Override
        public Find.Expression toExpression() {
            String message = this.message;
            if (message == null) {
                throw new BuildException("Attribute 'message' must be set");
            }
            return new Find.EchoAction(message);
        }
    }

    public static class PrintElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.PrintAction();
        }
    }

    public static class LsElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.LsAction();
        }
    }

    public static class ExecElement
    implements ExpressionElement {
        @Nullable
        private String command;

        public void setCommand(String command) {
            this.command = command;
        }

        @Override
        public Find.Expression toExpression() {
            String command = this.command;
            if (command == null) {
                throw new BuildException("Attribute 'command' must be set");
            }
            return new Find.ExecAction(Arrays.asList(command.split("\\s+")));
        }
    }

    public static class DisassembleElement
    implements ExpressionElement {
        private boolean hideLines;
        private boolean hideVars;
        @Nullable
        private File toFile;

        public void setHidesLines(boolean hideLines) {
            this.hideLines = hideLines;
        }

        public void setHidesVars(boolean hideLines) {
            this.hideLines = hideLines;
        }

        public void setToFile(File toFile) {
            this.toFile = toFile;
        }

        @Override
        public Find.Expression toExpression() {
            return new Find.DisassembleAction(this.hideLines, this.hideVars, this.toFile);
        }
    }

    public static class DigestElement
    implements ExpressionElement {
        private final Project project;
        private String algorithm = "MD5";
        @Nullable
        private String propertyName;

        public DigestElement(Project project) {
            this.project = project;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public void setProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public Find.Expression toExpression() {
            return AntTask.redirectInfoToProperty(this.project, new Find.DigestAction(this.algorithm), this.propertyName);
        }
    }

    public static class CopyElement
    implements ExpressionElement {
        @Nullable
        private File tofile;
        private boolean mkdirs;

        public void setTofile(File value) {
            this.tofile = value;
        }

        public void setMkdirs(boolean value) {
            this.mkdirs = value;
        }

        @Override
        public Find.Expression toExpression() {
            File tofile = this.tofile;
            if (tofile == null) {
                throw new BuildException("Attribute 'tofile=\"<file>\"' not set");
            }
            return new Find.CopyAction(tofile, this.mkdirs);
        }
    }

    public static class ChecksumElement
    implements ExpressionElement {
        private final Project project;
        private Find.ChecksumAction.ChecksumType type = Find.ChecksumAction.ChecksumType.CRC32;
        @Nullable
        private String propertyName;

        public ChecksumElement(Project project) {
            this.project = project;
        }

        public void setType(Find.ChecksumAction.ChecksumType type) {
            this.type = type;
        }

        public void setProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public Find.Expression toExpression() {
            return AntTask.redirectInfoToProperty(this.project, new Find.ChecksumAction(this.type), this.propertyName);
        }
    }

    public static class CatElement
    implements ExpressionElement {
        @Override
        public Find.Expression toExpression() {
            return new Find.CatAction(System.out);
        }
    }

    public static interface ExpressionElement {
        public Find.Expression toExpression();
    }
}

