/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.jdisasm.SignatureParser;
import de.unkrig.jdisasm.commons.nullanalysis.Nullable;
import java.io.DataInputStream;
import java.io.IOException;

public class ConstantPool {
    final ConstantPoolEntry[] entries;

    public ConstantPool(DataInputStream dis) throws IOException {
        int count = 0xFFFF & dis.readShort();
        abstract class RawEntry {
            RawEntry() {
            }

            abstract ConstantPoolEntry cook();

            ConstantClassInfo getConstantClassInfo(short index) {
                return (ConstantClassInfo)this.get(index);
            }

            ConstantNameAndTypeInfo getConstantNameAndTypeInfo(short index) {
                return (ConstantNameAndTypeInfo)this.get(index);
            }

            ConstantUtf8Info getConstantUtf8Info(short index) {
                return (ConstantUtf8Info)this.get(index);
            }

            abstract ConstantPoolEntry get(short var1);
        }
        RawEntry[] rawEntries = new RawEntry[count];
        int i = 1;
        while (i < count) {
            abstract class RawEntry2
            extends RawEntry {
                private final /* synthetic */ RawEntry[] val$rawEntries;

                RawEntry2(RawEntry[] rawEntryArray) {
                    this.val$rawEntries = rawEntryArray;
                }

                @Override
                ConstantPoolEntry get(short index) {
                    if (ConstantPool.this.entries[0xFFFF & index] == null) {
                        ConstantPool.this.entries[0xFFFF & index] = new ConstantPoolEntry(){

                            @Nullable
                            public String toString() {
                                return null;
                            }
                        };
                        ConstantPool.this.entries[0xFFFF & index] = this.val$rawEntries[0xFFFF & index].cook();
                    }
                    return ConstantPool.this.entries[0xFFFF & index];
                }
            }
            RawEntry2 re;
            int idx = i++;
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short nameIndex;
                        {
                            super(rawEntryArray);
                            this.nameIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantClassInfo(this.getConstantUtf8Info((short)this.nameIndex).bytes.replace('/', '.'));
                        }
                    };
                    break;
                }
                case 9: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(rawEntryArray);
                            this.classIndex = dataInputStream.readShort();
                            this.nameAndTypeIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantFieldrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 10: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(rawEntryArray);
                            this.classIndex = dataInputStream.readShort();
                            this.nameAndTypeIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 11: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short classIndex;
                        final short nameAndTypeIndex;
                        {
                            super(rawEntryArray);
                            this.classIndex = dataInputStream.readShort();
                            this.nameAndTypeIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantInterfaceMethodrefInfo(this.getConstantClassInfo(this.classIndex), this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 8: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short stringIndex;
                        {
                            super(rawEntryArray);
                            this.stringIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantStringInfo(this.getConstantUtf8Info((short)this.stringIndex).bytes);
                        }
                    };
                    ++i;
                    break;
                }
                case 3: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final int byteS;
                        {
                            super(rawEntryArray);
                            this.byteS = dataInputStream.readInt();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantIntegerInfo(this.byteS);
                        }
                    };
                    ++i;
                    break;
                }
                case 4: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final float byteS;
                        {
                            super(rawEntryArray);
                            this.byteS = dataInputStream.readFloat();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantFloatInfo(this.byteS);
                        }
                    };
                    ++i;
                    break;
                }
                case 5: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final long bytes;
                        {
                            super(rawEntryArray);
                            this.bytes = dataInputStream.readLong();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantLongInfo(this.bytes);
                        }
                    };
                    i += 2;
                    break;
                }
                case 6: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final double bytes;
                        {
                            super(rawEntryArray);
                            this.bytes = dataInputStream.readDouble();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantDoubleInfo(this.bytes);
                        }
                    };
                    i += 2;
                    break;
                }
                case 12: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short nameIndex;
                        final short descriptorIndex;
                        {
                            super(rawEntryArray);
                            this.nameIndex = dataInputStream.readShort();
                            this.descriptorIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantNameAndTypeInfo(this.getConstantUtf8Info(this.nameIndex), this.getConstantUtf8Info(this.descriptorIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 1: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final String bytes;
                        {
                            super(rawEntryArray);
                            this.bytes = dataInputStream.readUTF();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantUtf8Info(this.bytes);
                        }
                    };
                    ++i;
                    break;
                }
                case 15: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final byte referenceKind;
                        final short referenceIndex;
                        {
                            super(rawEntryArray);
                            this.referenceKind = dataInputStream.readByte();
                            this.referenceIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodHandleInfo(this.referenceKind, this.get(this.referenceIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 16: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short descriptorIndex;
                        {
                            super(rawEntryArray);
                            this.descriptorIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantMethodTypeInfo(this.getConstantUtf8Info(this.descriptorIndex));
                        }
                    };
                    ++i;
                    break;
                }
                case 18: {
                    re = new RawEntry2(this, dis, rawEntries){
                        final short bootstrapMethodAttrIndex;
                        final short nameAndTypeIndex;
                        {
                            super(rawEntryArray);
                            this.bootstrapMethodAttrIndex = dataInputStream.readShort();
                            this.nameAndTypeIndex = dataInputStream.readShort();
                        }

                        @Override
                        ConstantPoolEntry cook() {
                            return new ConstantInvokeDynamicInfo(this.bootstrapMethodAttrIndex, this.getConstantNameAndTypeInfo(this.nameAndTypeIndex));
                        }
                    };
                    ++i;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid cp_info tag '" + tag + "' on entry #" + i + " of " + count);
                }
            }
            rawEntries[idx] = re;
        }
        this.entries = new ConstantPoolEntry[count];
        i = 0;
        while (i < count) {
            try {
                if (this.entries[i] == null && rawEntries[i] != null) {
                    this.entries[i] = rawEntries[i].cook();
                }
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Cooking CP entry #" + i + " of " + count + ": " + re.getMessage(), re);
            }
            ++i;
        }
    }

    public <T extends ConstantPoolEntry> T get(short index, Class<T> clasS) {
        int ii = 0xFFFF & index;
        if (ii == 0 || ii >= this.entries.length) {
            throw new IllegalArgumentException("Illegal constant pool index " + ii + " - only 1..." + (this.entries.length - 1) + " allowed");
        }
        ConstantPoolEntry e = this.entries[ii];
        if (e == null) {
            throw new NullPointerException("Unusable CP entry " + index);
        }
        if (!clasS.isAssignableFrom(e.getClass())) {
            throw new RuntimeException("CP entry #" + index + " is a '" + e.getClass().getName() + "', not a '" + clasS.getName() + "'");
        }
        ConstantPoolEntry result = e;
        return (T)result;
    }

    @Nullable
    public <T extends ConstantPoolEntry> T getOptional(short index, Class<T> clasS) {
        if (index == 0) {
            return null;
        }
        int ii = 0xFFFF & index;
        if (ii >= this.entries.length) {
            throw new IllegalArgumentException("Illegal constant pool index " + ii + " - only 0..." + (this.entries.length - 1) + " allowed");
        }
        ConstantPoolEntry e = this.entries[ii];
        if (e == null) {
            throw new NullPointerException("Unusable CP entry " + index);
        }
        if (!clasS.isAssignableFrom(e.getClass())) {
            throw new RuntimeException("CP entry #" + index + " is a '" + e.getClass().getName() + "', not a '" + clasS.getName() + "'");
        }
        ConstantPoolEntry result = e;
        return (T)result;
    }

    public String getIntegerFloatClassString(short index) {
        ConstantPoolEntry e = this.get(index, ConstantPoolEntry.class);
        if (e instanceof ConstantIntegerInfo) {
            return e.toString();
        }
        if (e instanceof ConstantFloatInfo) {
            return e.toString();
        }
        if (e instanceof ConstantClassInfo) {
            return e.toString();
        }
        if (e instanceof ConstantStringInfo) {
            return e.toString();
        }
        throw new ClassCastException("CP index " + (0xFFFF & index) + ": " + e);
    }

    public String getIntegerFloatLongDoubleString(short index) {
        ConstantPoolEntry e = this.get(index, ConstantPoolEntry.class);
        if (e instanceof ConstantIntegerInfo) {
            return e.toString();
        }
        if (e instanceof ConstantFloatInfo) {
            return e.toString();
        }
        if (e instanceof ConstantLongInfo) {
            return e.toString();
        }
        if (e instanceof ConstantDoubleInfo) {
            return e.toString();
        }
        if (e instanceof ConstantStringInfo) {
            return ConstantPool.stringToJavaLiteral(((ConstantStringInfo)e).string);
        }
        throw new ClassCastException("CP index " + (0xFFFF & index) + ": " + e);
    }

    public String getLongDoubleString(short index) {
        ConstantPoolEntry e = this.get(index, ConstantPoolEntry.class);
        if (e instanceof ConstantLongInfo) {
            return e.toString();
        }
        if (e instanceof ConstantDoubleInfo) {
            return e.toString();
        }
        if (e instanceof ConstantStringInfo) {
            return ConstantPool.stringToJavaLiteral(((ConstantStringInfo)e).string);
        }
        throw new ClassCastException("CP index " + (0xFFFF & index) + ": " + e);
    }

    public String getIntegerFloatLongDouble(short index) {
        ConstantPoolEntry e = this.get(index, ConstantPoolEntry.class);
        if (e instanceof ConstantIntegerInfo) {
            return e.toString();
        }
        if (e instanceof ConstantFloatInfo) {
            return e.toString();
        }
        if (e instanceof ConstantLongInfo) {
            return e.toString();
        }
        if (e instanceof ConstantDoubleInfo) {
            return e.toString();
        }
        throw new ClassCastException("CP index " + (0xFFFF & index) + ": " + e);
    }

    public int getSize() {
        return this.entries.length;
    }

    public static String stringToJavaLiteral(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int idx = "\r\n\"\t\b".indexOf(c);
            if (idx == -1) {
                ++i;
            } else {
                s = String.valueOf(s.substring(0, i)) + '\\' + "rn\"tb".charAt(idx) + s.substring(i + 1);
                i += 2;
            }
            if (i < 80) continue;
            return String.valueOf('\"') + s.substring(0, i) + "\"...";
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static class ConstantClassInfo
    implements ConstantPoolEntry {
        public final String name;

        public ConstantClassInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return String.valueOf(this.name) + ".class";
        }
    }

    public static class ConstantDoubleInfo
    implements ConstantPoolEntry {
        public final double bytes;

        public ConstantDoubleInfo(double bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return String.valueOf(this.bytes) + "D";
        }
    }

    public static class ConstantFieldrefInfo
    implements ConstantPoolEntry {
        public final ConstantClassInfo clasS;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantFieldrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            this.clasS = clasS;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            try {
                return String.valueOf(this.clasS.name) + "::" + SignatureParser.decodeFieldDescriptor(this.nameAndType.descriptor.toString()) + " " + this.nameAndType.name;
            }
            catch (SignatureParser.SignatureException e) {
                return String.valueOf(this.clasS.name) + "::" + this.nameAndType;
            }
        }
    }

    public static class ConstantFloatInfo
    implements ConstantPoolEntry {
        public final float bytes;

        public ConstantFloatInfo(float bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return String.valueOf(this.bytes) + "F";
        }
    }

    public static class ConstantIntegerInfo
    implements ConstantPoolEntry {
        public final int bytes;

        public ConstantIntegerInfo(int bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return Integer.toString(this.bytes);
        }
    }

    public static class ConstantInterfaceMethodrefInfo
    implements ConstantPoolEntry {
        public final ConstantClassInfo clasS;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantInterfaceMethodrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            this.clasS = clasS;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            try {
                return String.valueOf(this.clasS.name) + ":::" + SignatureParser.decodeMethodDescriptor(this.nameAndType.descriptor.toString()).toString(this.clasS.name, this.nameAndType.name.toString());
            }
            catch (SignatureParser.SignatureException e) {
                return String.valueOf(this.clasS.name) + ":::" + this.nameAndType;
            }
        }
    }

    public static class ConstantInvokeDynamicInfo
    implements ConstantPoolEntry {
        public final short bootstrapMethodAttrIndex;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantInvokeDynamicInfo(short bootstrapMethodAttrIndex, ConstantNameAndTypeInfo nameAndType) {
            this.bootstrapMethodAttrIndex = bootstrapMethodAttrIndex;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            return String.valueOf(this.bootstrapMethodAttrIndex) + ":" + this.nameAndType.name.toString();
        }
    }

    public static class ConstantLongInfo
    implements ConstantPoolEntry {
        public final long bytes;

        public ConstantLongInfo(long bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return String.valueOf(this.bytes) + "L";
        }
    }

    public static class ConstantMethodHandleInfo
    implements ConstantPoolEntry {
        public final short referenceKind;
        public final ConstantPoolEntry reference;

        public ConstantMethodHandleInfo(byte referenceKind, ConstantPoolEntry reference) {
            this.referenceKind = referenceKind;
            this.reference = reference;
        }

        public String toString() {
            return String.valueOf(this.referenceKind == 1 ? "REF_getField" : (this.referenceKind == 2 ? "REF_getStatic" : (this.referenceKind == 3 ? "REF_putField" : (this.referenceKind == 4 ? "REF_putStatic" : (this.referenceKind == 5 ? "REF_invokeVirtual" : (this.referenceKind == 6 ? "REF_invokeStatic" : (this.referenceKind == 7 ? "REF_invokeSpecial" : (this.referenceKind == 8 ? "REF_newInvokeSpecial" : (this.referenceKind == 9 ? "REF_invokeInterface" : "REF_??? (" + this.referenceKind + ")"))))))))) + ":" + this.reference.toString();
        }
    }

    public static class ConstantMethodTypeInfo
    implements ConstantPoolEntry {
        public final ConstantUtf8Info descriptor;

        public ConstantMethodTypeInfo(ConstantUtf8Info descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            try {
                return SignatureParser.decodeMethodDescriptor(this.descriptor.toString()).toString();
            }
            catch (SignatureParser.SignatureException e) {
                return this.descriptor.toString();
            }
        }
    }

    public static class ConstantMethodrefInfo
    implements ConstantPoolEntry {
        public final ConstantClassInfo clasS;
        public final ConstantNameAndTypeInfo nameAndType;

        public ConstantMethodrefInfo(ConstantClassInfo clasS, ConstantNameAndTypeInfo nameAndType) {
            this.clasS = clasS;
            this.nameAndType = nameAndType;
        }

        public String toString() {
            try {
                return String.valueOf(this.clasS.name) + "::" + SignatureParser.decodeMethodDescriptor(this.nameAndType.descriptor.toString()).toString(this.clasS.name, this.nameAndType.name.toString());
            }
            catch (SignatureParser.SignatureException e) {
                return String.valueOf(this.clasS.name) + "::" + this.nameAndType;
            }
        }
    }

    public static class ConstantNameAndTypeInfo
    implements ConstantPoolEntry {
        public final ConstantUtf8Info name;
        public final ConstantUtf8Info descriptor;

        public ConstantNameAndTypeInfo(ConstantUtf8Info name, ConstantUtf8Info descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public String toString() {
            try {
                return this.name + " : " + (this.descriptor.bytes.indexOf(40) == -1 ? SignatureParser.decodeFieldDescriptor(this.descriptor.bytes) : SignatureParser.decodeMethodDescriptor(this.descriptor.bytes));
            }
            catch (SignatureParser.SignatureException e) {
                return this.name + " : " + this.descriptor;
            }
        }
    }

    public static interface ConstantPoolEntry {
    }

    public static class ConstantStringInfo
    implements ConstantPoolEntry {
        public final String string;

        public ConstantStringInfo(String string) {
            this.string = string;
        }

        public String toString() {
            return ConstantPool.stringToJavaLiteral(this.string);
        }
    }

    public static class ConstantUtf8Info
    implements ConstantPoolEntry {
        public final String bytes;

        public ConstantUtf8Info(String bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.bytes;
        }
    }
}

