/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.ScannerUtil;
import de.unkrig.commons.text.scanner.StatefulScanner;
import de.unkrig.commons.text.scanner.StringScanner;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;

public final class JavaScanner {
    private static final EnumSet<TokenType> IGNORABLES = EnumSet.of(TokenType.C_COMMENT, new TokenType[]{TokenType.MULTI_LINE_C_COMMENT_BEGINNING, TokenType.MULTI_LINE_C_COMMENT_MIDDLE, TokenType.MULTI_LINE_C_COMMENT_END, TokenType.CXX_COMMENT, TokenType.SPACE});

    private JavaScanner() {
    }

    public static StringScanner<TokenType> rawStringScanner() {
        StatefulScanner<TokenType, State> scanner = new StatefulScanner<TokenType, State>(State.class);
        scanner.addRule("\\s+", TokenType.SPACE);
        scanner.addRule("//.*(?:\r\n|\r|\n)?", TokenType.CXX_COMMENT);
        scanner.addRule("/\\*.*?\\*/", TokenType.C_COMMENT);
        scanner.addRule("(?s)/\\*.*", TokenType.MULTI_LINE_C_COMMENT_BEGINNING, State.IN_MULTI_LINE_C_COMMENT);
        scanner.addRule(State.IN_MULTI_LINE_C_COMMENT, ".*?\\*/", TokenType.MULTI_LINE_C_COMMENT_END);
        scanner.addRule(State.IN_MULTI_LINE_C_COMMENT, "(?s).+", TokenType.MULTI_LINE_C_COMMENT_MIDDLE, State.IN_MULTI_LINE_C_COMMENT);
        scanner.addRule("(?:abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|extends|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|native|new|package|private|protected|public|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|transient|try|void|volatile|while)(?![\\p{L}\\p{Nd}_$])", TokenType.KEYWORD);
        scanner.addRule("[\\p{L}\\p{Nl}\\p{Sc}\\p{Pc}][\\p{L}\\p{Nl}\\p{Sc}\\p{Pc}\\p{Nd}\\p{Mn}\\p{Mc}\\x00-\\x08\\x0E-\\x1B\\x7F-\\x9F]*", TokenType.IDENTIFIER);
        scanner.addRule("\\d+\\.\\d*(?:[eE][+\\-]?\\d+)?[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\.\\d+(?:[eE][+\\-]?\\d+)?[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\d+[eE][+\\-]?\\d+[fFdD]?", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("\\d+([eE][+\\-]?\\d+)?[fFdD]", TokenType.FLOATING_POINT_LITERAL);
        scanner.addRule("(?:[1-9]\\d*|0x\\p{XDigit}+|0[0-7]*)(L|l)?", TokenType.INTEGER_LITERAL);
        scanner.addRule("'(?:\\\\[btnfr\"'\\\\]|\\\\u\\p{XDigit}{4}|\\\\[0-7]|\\\\[0-7][0-7]|\\\\[0-3][0-7][0-7]|[^'])'", TokenType.CHARACTER_LITERAL);
        scanner.addRule("\\\"(?:\\\\[btnfr\"'\\\\]|\\\\u\\p{XDigit}{4}|\\\\[0-7]|\\\\[0-7][0-7]|\\\\[0-3][0-7][0-7]|[^\"])*+\\\"", TokenType.STRING_LITERAL);
        scanner.addRule("\\(|\\)|\\{|\\}|\\[|]|;|\\.|,", TokenType.SEPARATOR);
        scanner.addRule(">>>=|<<=|>>=|>>>|\\+=|-=|\\*=|/=|&=|\\|=|\\^=|%=|==|<=|>=|!=|&&|\\|\\||\\+\\+|--|<<|>>|=|>|<|!|~|\\?|:|\\+|-|\\*|/|&|\\||\\^|%|@", TokenType.OPERATOR);
        return scanner;
    }

    public static StringScanner<TokenType> stringScanner() {
        return ScannerUtil.filter(JavaScanner.rawStringScanner(), new Predicate<AbstractScanner.Token<TokenType>>(){

            @Override
            public boolean evaluate(@Nullable AbstractScanner.Token<TokenType> token) {
                return token == null || !IGNORABLES.contains(token.type);
            }
        });
    }

    public static ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException> combineMultiLineCComments(final ProducerWhichThrows<? extends AbstractScanner.Token<TokenType>, ? extends ScanException> delegate) {
        return new ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException>(){

            @Override
            @Nullable
            public AbstractScanner.Token<TokenType> produce() throws ScanException {
                AbstractScanner.Token t = (AbstractScanner.Token)delegate.produce();
                if (t == null || t.type != TokenType.MULTI_LINE_C_COMMENT_BEGINNING) {
                    return t;
                }
                StringBuilder commentText = new StringBuilder(t.text);
                do {
                    if ((t = (AbstractScanner.Token)delegate.produce()) == null) {
                        throw new ScanException("Input ends in the middle of a multi-line C comment");
                    }
                    commentText.append(t.text);
                    if (t.type != TokenType.MULTI_LINE_C_COMMENT_END) continue;
                    return new AbstractScanner.Token<TokenType>(TokenType.C_COMMENT, commentText.toString());
                } while ($assertionsDisabled || t.type == TokenType.MULTI_LINE_C_COMMENT_MIDDLE);
                throw new AssertionError();
            }
        };
    }

    public static ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException> compressSpaces(final ProducerWhichThrows<? extends AbstractScanner.Token<TokenType>, ? extends ScanException> delegate) {
        return new ProducerWhichThrows<AbstractScanner.Token<TokenType>, ScanException>(){
            @Nullable
            AbstractScanner.Token<TokenType> lookahead;

            @Override
            @Nullable
            public AbstractScanner.Token<TokenType> produce() throws ScanException {
                AbstractScanner.Token t;
                if (this.lookahead != null) {
                    t = this.lookahead;
                    this.lookahead = null;
                } else {
                    t = (AbstractScanner.Token)delegate.produce();
                }
                if (t == null || t.type != TokenType.SPACE) {
                    return t;
                }
                String s = t.text;
                while ((t = (AbstractScanner.Token)delegate.produce()) != null) {
                    if (t.type != TokenType.SPACE) {
                        this.lookahead = t;
                        return new AbstractScanner.Token<TokenType>(TokenType.SPACE, s);
                    }
                    s = String.valueOf(s) + t.text;
                }
                return new AbstractScanner.Token<TokenType>(TokenType.SPACE, s);
            }
        };
    }

    public static Reader unicodeEscapesDecodingReader(Reader delegate) {
        return new FilterReader(delegate){
            int state;
            char lookahead;

            @Override
            public int read() throws IOException {
                switch (this.state) {
                    case 0: {
                        int c = this.in.read();
                        if (c == -1) {
                            return -1;
                        }
                        if (c != 92) {
                            return c;
                        }
                        c = this.in.read();
                        if (c == -1) {
                            return 92;
                        }
                        if (c != 117) {
                            this.lookahead = (char)c;
                            this.state = 1;
                            return 92;
                        }
                        int d = Character.digit((char)this.in.read(), 16);
                        if (d >= 0) {
                            int codepoint = d;
                            d = Character.digit((char)this.in.read(), 16);
                            if (d >= 0) {
                                codepoint = (codepoint << 4) + d;
                                d = Character.digit((char)this.in.read(), 16);
                                if (d >= 0) {
                                    codepoint = (codepoint << 4) + d;
                                    d = Character.digit((char)this.in.read(), 16);
                                    if (d >= 0) {
                                        return (char)(codepoint << 4) + d;
                                    }
                                }
                            }
                        }
                        throw new IOException("Invalid unicode escape");
                    }
                    case 1: {
                        this.state = 0;
                        return this.lookahead;
                    }
                }
                throw new IllegalStateException(Integer.toString(this.state));
            }

            @Override
            public int read(@Nullable char[] buf, int off, int len) throws IOException {
                if (!$assertionsDisabled && buf == null) {
                    throw new AssertionError();
                }
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buf[off] = (char)c;
                int i = 1;
                while (i < len) {
                    c = this.read();
                    if (c == -1) {
                        return i;
                    }
                    buf[off + i] = (char)c;
                    ++i;
                }
                return len;
            }

            @Override
            public long skip(long n) throws IOException {
                int i = 0;
                while ((long)i < n) {
                    if (this.read() == -1) {
                        return i;
                    }
                    ++i;
                }
                return n;
            }

            @Override
            public boolean ready() throws IOException {
                return this.state == 1 || this.in.ready();
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public void mark(int readAheadLimit) {
                throw new UnsupportedOperationException("mark");
            }

            @Override
            public void reset() {
                throw new UnsupportedOperationException("reset");
            }

            @Override
            public void close() throws IOException {
                this.in.close();
                this.state = 0;
            }
        };
    }

    private static enum State {
        IN_MULTI_LINE_C_COMMENT;

    }

    public static enum TokenType {
        SPACE,
        CXX_COMMENT,
        C_COMMENT,
        MULTI_LINE_C_COMMENT_BEGINNING,
        MULTI_LINE_C_COMMENT_MIDDLE,
        MULTI_LINE_C_COMMENT_END,
        KEYWORD,
        IDENTIFIER,
        SEPARATOR,
        OPERATOR,
        STRING_LITERAL,
        CHARACTER_LITERAL,
        INTEGER_LITERAL,
        FLOATING_POINT_LITERAL;

    }
}

