/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.json;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Json {
    private Json() {
    }

    public static class Array
    implements Value {
        public final List<Value> elements;

        public Array(List<Value> values) {
            this.elements = Collections.unmodifiableList(new ArrayList<Value>(values));
        }

        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return this.elements.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Array && ((Array)obj).elements.equals(this.elements);
        }
    }

    public static class False
    implements Value {
        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return 238545234;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof False;
        }
    }

    public static class Member {
        public final StrinG name;
        public final Value value;

        public Member(StrinG string, Value value) {
            this.name = string;
            this.value = value;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof Member)) {
                return false;
            }
            Member that = (Member)obj;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
    }

    public static class Null
    implements Value {
        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return 61278954;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Null;
        }
    }

    public static class NumbeR
    implements Value {
        public final Number value;

        public NumbeR(String text) {
            this.value = text.indexOf(46) != -1 || text.indexOf(101) != -1 || text.indexOf(69) != -1 ? (Number)Double.parseDouble(text) : (Number)Long.parseLong(text);
        }

        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof NumbeR && ((NumbeR)obj).value.equals(this.value);
        }
    }

    public static class ObjecT
    implements Value {
        public final List<Member> members;

        public ObjecT(List<Member> stringValuePairs) {
            this.members = Collections.unmodifiableList(new ArrayList<Member>(stringValuePairs));
        }

        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return this.members.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ObjecT && ((ObjecT)obj).members.equals(this.members);
        }
    }

    public static class StrinG
    implements Value {
        public final String text;

        public StrinG(String text) {
            this.text = text;
        }

        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof StrinG && ((StrinG)obj).text.equals(this.text);
        }
    }

    public static class True
    implements Value {
        @Override
        public void accept(ValueVisitor visitor) {
            visitor.visit(this);
        }

        public int hashCode() {
            return 723688273;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof True;
        }
    }

    public static interface Value {
        public void accept(ValueVisitor var1);
    }

    public static interface ValueVisitor {
        public void visit(StrinG var1);

        public void visit(NumbeR var1);

        public void visit(ObjecT var1);

        public void visit(Array var1);

        public void visit(True var1);

        public void visit(False var1);

        public void visit(Null var1);
    }
}

