/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;

public class Files {
    private final Object desc;

    public Files(Object[] desc) {
        this.desc = desc;
    }

    public Files(File file) throws IOException, ArchiveException, CompressorException {
        this.desc = Files.load(file);
    }

    private static Object load(File file) throws IOException, ArchiveException, CompressorException {
        if (file.isDirectory()) {
            return Files.loadDir(file);
        }
        ArchiveFormat af = ArchiveFormatFactory.forFileName(file.getName());
        if (af != null) {
            return Files.loadArchiveFile(file, af);
        }
        CompressionFormat cf = CompressionFormatFactory.forFileName(file.getName());
        if (cf != null) {
            return Files.loadCompressedFile(file, cf);
        }
        return Files.loadPlainFile(file);
    }

    private static Object load(InputStream is) throws IOException, ArchiveException, CompressorException {
        ArchiveFormat af;
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        if ((af = ArchiveFormatFactory.forContents(is)) != null) {
            return Files.loadArchive(af.archiveInputStream(is));
        }
        CompressionFormat cf = CompressionFormatFactory.forContents(is);
        if (cf != null) {
            return Files.load(cf.compressorInputStream(is));
        }
        return Files.loadReader(new InputStreamReader(is));
    }

    private static Object[] loadArchiveFile(File archiveFile, ArchiveFormat af) throws IOException, ArchiveException, CompressorException {
        ArchiveInputStream ais = af.open(archiveFile);
        try {
            Object[] entries = Files.loadArchive(ais);
            ais.close();
            Object[] objectArray = entries;
            return objectArray;
        }
        finally {
            try {
                ais.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Object loadCompressedFile(File file, CompressionFormat cf) throws IOException, ArchiveException, CompressorException {
        FileInputStream is = new FileInputStream(file);
        try {
            CompressorInputStream cis = cf.compressorInputStream(is);
            Object contents = Files.load(cis);
            cis.close();
            Object object = contents;
            return object;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    private static Object[] loadArchive(ArchiveInputStream ais) throws IOException, ArchiveException, CompressorException {
        ArrayList<Object> result = new ArrayList<Object>();
        ArchiveEntry ae = ais.getNextEntry();
        while (ae != null) {
            result.add(ae.getName());
            result.add(Files.load(ais));
            ae = ais.getNextEntry();
        }
        return result.toArray();
    }

    @Nullable
    public String diff(Files that) {
        return Files.diff("", this.desc, that.desc);
    }

    @Nullable
    public static String diff(String name, Object desc1, Object desc2) {
        if (desc1 instanceof String) {
            if (desc2 instanceof String) {
                if (desc1.equals(desc2)) {
                    return null;
                }
                return String.valueOf(name) + ": Contents should be '" + ((String)desc1).replace('\n', '|') + "', not '" + ((String)desc2).replace('\n', '|') + "'";
            }
            return String.valueOf(name) + " should be a plain member / ZIP entry";
        }
        if (desc2 instanceof String) {
            return String.valueOf(name) + " should be a directory or ZIP file";
        }
        name = String.valueOf(name) + (name.endsWith(".zip") ? (char)'!' : '/');
        TreeMap<String, Object> entries1 = new TreeMap<String, Object>();
        Object[] oa = (Object[])desc1;
        int i = 0;
        while (i < oa.length) {
            entries1.put((String)oa[i++], oa[i++]);
        }
        TreeMap<String, Object> entries2 = new TreeMap<String, Object>();
        Object[] oa2 = (Object[])desc2;
        int i2 = 0;
        while (i2 < oa2.length) {
            entries2.put((String)oa2[i2++], oa2[i2++]);
        }
        Iterator it1 = entries1.entrySet().iterator();
        Iterator it2 = entries2.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry entry1 = it1.next();
            if (it2.hasNext()) {
                String name2;
                Map.Entry entry2 = it2.next();
                String name1 = (String)entry1.getKey();
                int cmp = name1.compareTo(name2 = (String)entry2.getKey());
                if (cmp < 0) {
                    return String.valueOf(name) + name1 + " missing";
                }
                if (cmp > 0) {
                    return "Unexpected " + name + name2;
                }
                String diff = Files.diff(String.valueOf(name) + name1, entry1.getValue(), entry2.getValue());
                if (diff == null) continue;
                return diff;
            }
            return String.valueOf(name) + (String)entry1.getKey() + " missing";
        }
        if (it2.hasNext()) {
            return "Unexpected " + name + (String)it2.next().getKey();
        }
        return null;
    }

    public void save(File file) throws IOException {
        Files.saveFile(file, this.desc);
    }

    private static void saveFile(File file, @Nullable Object desc) throws IOException {
        CompressionFormat cf = CompressionFormatFactory.forFileName(file.getName());
        if (cf != null) {
            CompressorOutputStream cos;
            assert (desc != null);
            try {
                cos = cf.create(file);
            }
            catch (CompressorException ce) {
                throw new IOException(ce);
            }
            Files.save(desc, cf.getUncompressedFileName(file.getName()), cos);
            cos.close();
            return;
        }
        if (desc instanceof String) {
            String contents = (String)desc;
            FileOutputStream os = new FileOutputStream(file);
            try {
                Files.saveContents(contents, os);
                ((OutputStream)os).close();
            }
            finally {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
            return;
        }
        if (desc instanceof Object[]) {
            Object[] entries = (Object[])desc;
            ArchiveFormat af = ArchiveFormatFactory.forFileName(file.getName());
            if (af != null) {
                Files.saveArchive(entries, af, file);
            } else {
                Files.saveDir(entries, file);
            }
        } else if (desc == null) {
            file.mkdirs();
        } else {
            throw new IllegalArgumentException(String.valueOf(desc));
        }
    }

    private static void saveDir(Object[] desc, File dir) throws IOException {
        dir.mkdirs();
        int i = 0;
        while (i < desc.length) {
            Files.saveFile(new File(dir, (String)desc[i++]), desc[i++]);
        }
    }

    private static void saveArchive(Object[] entries, ArchiveFormat af, File archiveFile) throws FileNotFoundException, IOException {
        ArchiveOutputStream aos;
        try {
            aos = af.create(archiveFile);
        }
        catch (ArchiveException ae) {
            throw new IOException(ae);
        }
        try {
            Files.saveArchive(entries, af, aos);
            aos.close();
        }
        finally {
            try {
                aos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void save(Object desc, String fileName, OutputStream os) throws IOException {
        CompressionFormat cf = CompressionFormatFactory.forFileName(fileName);
        if (cf != null) {
            CompressorOutputStream cos;
            try {
                cos = cf.compressorOutputStream(os);
            }
            catch (CompressorException ce) {
                throw new IOException(ce);
            }
            Files.save(desc, cf.getUncompressedFileName(fileName), cos);
            try {
                cos.getClass().getMethod("finish", new Class[0]).invoke((Object)cos, new Object[0]);
            }
            catch (Exception e) {
                cos.flush();
            }
            return;
        }
        if (desc instanceof String) {
            String contents = (String)desc;
            Files.saveContents(contents, os);
        } else if (desc instanceof Object[]) {
            ArchiveOutputStream aos;
            Object[] entries = (Object[])desc;
            ArchiveFormat af = ArchiveFormatFactory.forFileName(fileName);
            if (af == null) {
                throw new IllegalArgumentException("Could not deduce archive format from file name '" + fileName + "'");
            }
            try {
                aos = af.archiveOutputStream(os);
            }
            catch (ArchiveException ae) {
                throw new IllegalArgumentException(ae);
            }
            Files.saveArchive(entries, af, aos);
            aos.finish();
        } else {
            throw new IllegalArgumentException(String.valueOf(desc));
        }
    }

    private static void saveContents(String contents, OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os);
        w.write(contents);
        ((Writer)w).flush();
    }

    private static void saveArchive(Object[] entries, ArchiveFormat archiveFormat, ArchiveOutputStream aos) throws IOException {
        int i = 0;
        while (i < entries.length) {
            Object desc;
            final String entryName = (String)entries[i++];
            if ((desc = entries[i++]) == null) {
                archiveFormat.writeDirectoryEntry(aos, entryName);
                continue;
            }
            archiveFormat.writeEntry(aos, entryName, (ConsumerWhichThrows<? super OutputStream, ? extends IOException>)new ConsumerWhichThrows<OutputStream, IOException>(){

                @Override
                public void consume(OutputStream os) throws IOException {
                    Files.save(desc, entryName, os);
                }
            });
        }
    }

    private static Object[] loadDir(File dir) throws IOException, ArchiveException, CompressorException {
        File[] members = dir.listFiles();
        Object[] oa = new Object[2 * members.length];
        int i = 0;
        while (i < members.length) {
            File member = members[i];
            oa[2 * i] = member.getName();
            oa[2 * i + 1] = Files.load(member);
            ++i;
        }
        return oa;
    }

    public static Object loadPlainFile(File file) throws IOException {
        FileReader r = new FileReader(file);
        try {
            String text = Files.loadReader(r);
            ((Reader)r).close();
            String string = text;
            return string;
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (Exception exception) {}
        }
    }

    private static String loadReader(Reader r) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        char[] ca = new char[1024];
        while ((n = r.read(ca)) != -1) {
            sb.append(ca, 0, n);
        }
        return sb.toString();
    }
}

