/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.security.Permission;
import org.junit.Assert;

public final class AssertExit {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private AssertExit() {
    }

    public static <EX extends Exception> void assertExitStatusEqual(int expected, RunnableWhichThrows<EX> runnable) throws EX {
        AssertExit.assertExitStatusEqual(null, expected, runnable);
    }

    public static <EX extends Exception> void assertExitStatusNotEqual(int notExpected, RunnableWhichThrows<EX> runnable) throws EX {
        AssertExit.assertExitStatusNotEqual(null, notExpected, runnable);
    }

    public static <EX extends Exception> void assertExitStatusEqual(@Nullable String message, int expected, RunnableWhichThrows<EX> runnable) throws EX {
        AssertExit.assertExit(message, PredicateUtil.equal(expected), runnable);
    }

    public static <EX extends Exception> void assertExitStatusNotEqual(@Nullable String message, int notExpected, RunnableWhichThrows<EX> runnable) throws EX {
        AssertExit.assertExit(message, PredicateUtil.notEqual(notExpected), runnable);
    }

    public static <EX extends Exception> void assertExit(@Nullable String message, Predicate<Integer> expected, RunnableWhichThrows<EX> runnable) throws EX {
        SecurityManager oldSecurityManager = System.getSecurityManager();
        @NotNullByDefault(value=false)
        class NoExitSecurityManager
        extends SecurityManager {
            NoExitSecurityManager() {
            }

            @Override
            public void checkExit(int status) {
                class ExitError
                extends Error {
                    private static final long serialVersionUID = 1L;
                    private final int status;

                    ExitError(int status) {
                        this.status = status;
                    }

                    public int getStatus() {
                        return this.status;
                    }
                }
                throw new ExitError(status);
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        }
        System.setSecurityManager(new NoExitSecurityManager());
        try {
            try {
                runnable.run();
                String m = "Did not exit";
                Assert.fail((String)(message == null ? m : String.valueOf(message) + ": " + m));
            }
            catch (ExitError ee) {
                Assert.assertTrue((String)message, (boolean)expected.evaluate(ee.getStatus()));
                System.setSecurityManager(oldSecurityManager);
            }
        }
        finally {
            System.setSecurityManager(oldSecurityManager);
        }
    }
}

