/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io.pipe;

import de.unkrig.commons.io.pipe.AbstractPipe;
import de.unkrig.commons.io.pipe.AbstractRingBuffer;
import de.unkrig.commons.io.pipe.Pipe;
import de.unkrig.commons.io.pipe.PipeUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public final class PipeFactory {
    private static final Method UNMAP_METHOD;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        try {
            Class<?> fileChannelImplClass = Class.forName("sun.nio.ch.FileChannelImpl");
            UNMAP_METHOD = fileChannelImplClass.getDeclaredMethod("unmap", MappedByteBuffer.class);
            UNMAP_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private PipeFactory() {
    }

    public static Pipe byteArrayRingBuffer(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        return new AbstractRingBuffer(capacity, capacity){
            final byte[] ba;
            {
                this.ba = new byte[n];
            }

            @Override
            public void get(long pos, byte[] buf, int off, int len) {
                System.arraycopy(this.ba, (int)pos, buf, off, len);
            }

            @Override
            public void put(byte[] buf, int off, int len, long pos) {
                System.arraycopy(buf, off, this.ba, (int)pos, len);
            }

            @Override
            public void close() {
            }
        };
    }

    public static Pipe randomAccessTempFileRingBuffer(long capacity) throws IOException {
        return PipeFactory.randomAccessFileRingBuffer(File.createTempFile("rATFRB-", ".tmp"), capacity, true);
    }

    public static Pipe randomAccessFileRingBuffer(File file, long capacity, boolean deleteFileOnClose) throws IOException {
        if (capacity < 1L) {
            throw new IllegalArgumentException();
        }
        if (deleteFileOnClose) {
            file.deleteOnExit();
        }
        final RandomAccessFile raf = new RandomAccessFile(file, "rw");
        AbstractRingBuffer result = new AbstractRingBuffer(capacity){

            @Override
            public void get(long pos, byte[] buf, int off, int len) throws IOException {
                raf.seek(pos);
                raf.read(buf, off, len);
            }

            @Override
            public void put(byte[] buf, int off, int len, long pos) throws IOException {
                raf.seek(pos);
                raf.write(buf, off, len);
            }

            @Override
            public synchronized void close() throws IOException {
                raf.close();
            }
        };
        return deleteFileOnClose ? PipeUtil.deleteFileOnClose(result, file) : result;
    }

    public static Pipe byteBufferRingBuffer(ByteBuffer delegate) {
        return new AbstractRingBuffer(delegate.capacity(), delegate){
            @Nullable
            ByteBuffer delegate2;
            {
                this.delegate2 = byteBuffer;
            }

            @Override
            public void get(long pos, byte[] buf, int off, int len) {
                if (!$assertionsDisabled && pos > Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                ByteBuffer d = this.delegate2;
                if (d == null) {
                    throw new IllegalStateException("Pipe closed");
                }
                d.position((int)pos);
                d.get(buf, off, len);
            }

            @Override
            public void put(byte[] buf, int off, int len, long pos) {
                if (!$assertionsDisabled && pos > Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                ByteBuffer d = this.delegate2;
                if (d == null) {
                    throw new IllegalStateException("Pipe closed");
                }
                d.position((int)pos);
                d.put(buf, off, len);
            }

            @Override
            public void close() {
                this.delegate2 = null;
            }
        };
    }

    public static Pipe mappedTempFileRingBuffer(int capacity) throws IOException {
        return PipeFactory.mappedFileRingBuffer(File.createTempFile("mTFRB-", ".tmp"), capacity, true);
    }

    public static Pipe mappedFileRingBuffer(File file, int capacity, boolean deleteFileOnClose) throws IOException {
        if (deleteFileOnClose) {
            file.deleteOnExit();
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        Pipe pipe = PipeFactory.mappedChannelRingBuffer(raf.getChannel(), capacity);
        raf.close();
        return deleteFileOnClose ? PipeUtil.deleteFileOnClose(pipe, file) : pipe;
    }

    private static Pipe mappedChannelRingBuffer(FileChannel fileChannel, int capacity) throws IOException {
        MappedByteBuffer mbb = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
        return PipeFactory.mappedByteBufferRingBuffer(mbb, true);
    }

    private static Pipe mappedByteBufferRingBuffer(final MappedByteBuffer mappedByteBuffer, boolean unmapOnClose) {
        Pipe pipe = PipeFactory.byteBufferRingBuffer(mappedByteBuffer);
        return unmapOnClose ? PipeUtil.onClose(pipe, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() {
                PipeFactory.unmap(mappedByteBuffer);
            }
        }) : pipe;
    }

    private static void unmap(MappedByteBuffer mappedByteBuffer) {
        try {
            UNMAP_METHOD.invoke(null, mappedByteBuffer);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap("Unmapping file channel", e, RuntimeException.class);
        }
    }

    public static Pipe elasticPipe() {
        return PipeFactory.elasticPipe(ProducerUtil.fromIndexTransformer(new TransformerWhichThrows<Integer, Pipe, IOException>(){

            @Override
            public Pipe transform(Integer index) throws IOException {
                switch (index) {
                    case 0: {
                        return PipeFactory.byteBufferRingBuffer(ByteBuffer.allocateDirect(300000));
                    }
                    case 1: {
                        return PipeFactory.mappedTempFileRingBuffer(10000000);
                    }
                    case 3: {
                        return PipeFactory.randomAccessTempFileRingBuffer(Long.MAX_VALUE);
                    }
                }
                throw new IllegalStateException("elasticPipe");
            }
        }));
    }

    public static Pipe elasticPipe(final ProducerWhichThrows<? extends Pipe, ? extends IOException> pipes) {
        return new AbstractPipe(){
            final LinkedList<Pipe> curr = new LinkedList();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                6 var4_4 = this;
                synchronized (var4_4) {
                    while (true) {
                        if (this.curr.isEmpty()) {
                            return 0;
                        }
                        int n = this.curr.getFirst().read(buf, off, len);
                        if (n > 0) {
                            return n;
                        }
                        this.curr.removeFirst().close();
                    }
                }
            }

            @Override
            public int write(byte[] buf, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                6 var4_4 = this;
                synchronized (var4_4) {
                    while (true) {
                        int n;
                        if (this.curr.isEmpty()) {
                            this.curr.add((Pipe)pipes.produce());
                        }
                        if ((n = this.curr.getLast().write(buf, off, len)) > 0) {
                            return n;
                        }
                        this.curr.add((Pipe)pipes.produce());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void close() throws IOException {
                var1_1 = this;
                synchronized (var1_1) {
                    it = this.curr.iterator();
                    try {
                        while (it.hasNext()) {
                            ((Pipe)it.next()).close();
                        }
                        if (true) ** GOTO lbl25
                    }
                    catch (Throwable var3_3) {
                        ** while (it.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ((Pipe)it.next()).close();
                        }
                        catch (Exception var4_4) {
                            // empty catch block
                        }
                        continue;
                    }
lbl18:
                    // 1 sources

                    throw var3_3;
                    do {
                        try {
                            ((Pipe)it.next()).close();
                        }
                        catch (Exception var4_5) {
                            // empty catch block
                        }
lbl25:
                        // 3 sources

                    } while (it.hasNext());
                }
            }

            @Override
            public boolean isFull() {
                return false;
            }

            @Override
            public boolean isEmpty() {
                if (this.curr.isEmpty()) {
                    return true;
                }
                if (!this.curr.getFirst().isEmpty()) {
                    return false;
                }
                this.curr.removeFirst();
                return this.curr.isEmpty();
            }
        };
    }
}

