/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.InputStream;

@NotNullByDefault(value=false)
public class ConcatInputStream
extends InputStream {
    private final Producer<? extends InputStream> delegates;
    private final boolean closeStreams;
    @Nullable
    private InputStream current = IoUtil.EMPTY_INPUT_STREAM;

    public ConcatInputStream(Producer<? extends InputStream> delegates, boolean closeStreams) {
        this.closeStreams = closeStreams;
        this.delegates = delegates;
    }

    @Override
    public int available() throws IOException {
        InputStream is = this.current;
        return is == null ? 0 : is.available();
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            InputStream is;
            while ((is = (InputStream)this.delegates.produce()) != null) {
                is.close();
            }
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        return this.read(buffer, 0, 1) == -1 ? -1 : 0xFF & buffer[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream is;
        while ((is = this.current) != null) {
            int n = is.read(b, off, len);
            if (n != -1) {
                return n;
            }
            if (this.closeStreams) {
                is.close();
            }
            this.current = (InputStream)this.delegates.produce();
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        InputStream is;
        while ((is = this.current) != null) {
            long result = is.skip(n);
            if (result > 0L) {
                return result;
            }
            this.current = (InputStream)this.delegates.produce();
        }
        return 0L;
    }
}

