/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.gzip;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;

public final class GzipCompressionFormat
implements CompressionFormat {
    private static final CompressionFormat INSTANCE = new GzipCompressionFormat();

    private GzipCompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "gz";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return GzipUtils.isCompressedFilename(fileName);
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return GzipUtils.getCompressedFilename(fileName);
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return GzipUtils.getUncompressedFilename(fileName);
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new GzipCompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        FileInputStream is = new FileInputStream(compressedFile);
        try {
            return new GzipCompressorInputStream(is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws IOException {
        return new GzipCompressorOutputStream(os);
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws IOException {
        FileOutputStream os = new FileOutputStream(compressedFile);
        try {
            return new GzipCompressorOutputStream(os);
        }
        catch (IOException ioe) {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return GzipCompressorInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

