/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.bzip2;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;

public final class BZip2CompressionFormat
implements CompressionFormat {
    private static final CompressionFormat INSTANCE = new BZip2CompressionFormat();

    private BZip2CompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "bzip2";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return BZip2Utils.isCompressedFilename(fileName);
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return BZip2Utils.getCompressedFilename(fileName);
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return BZip2Utils.getUncompressedFilename(fileName);
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new BZip2CompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        FileInputStream is = new FileInputStream(compressedFile);
        try {
            return new BZip2CompressorInputStream(is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws IOException {
        return new BZip2CompressorOutputStream(os);
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws IOException {
        FileOutputStream os = new FileOutputStream(compressedFile);
        try {
            return new BZip2CompressorOutputStream(os);
        }
        catch (IOException ioe) {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return BZip2CompressorInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

