/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.tar;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.pipe.PipeUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class TarArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".tar", ""), ".tar");
    private static final ArchiveFormat INSTANCE = new TarArchiveFormat();

    private TarArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "tar";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        return new TarArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return new TarArchiveInputStream(new FileInputStream(archiveFile));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        return new TarArchiveOutputStream(os);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new TarArchiveOutputStream(new FileOutputStream(archiveFile));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeEntry(final ArchiveOutputStream archiveOutputStream, String name, final ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (archiveOutputStream instanceof TarArchiveOutputStream) ** GOTO lbl4
        throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
lbl-1000:
        // 1 sources

        {
            name = name.substring(0, name.length() - 1);
lbl4:
            // 2 sources

            ** while (name.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        tae = new TarArchiveEntry(name);
        PipeUtil.temporaryStorage(new PipeUtil.FillerAndDrainer(){
            long count;

            @Override
            public void fill(OutputStream os) throws IOException {
                this.count = IoUtil.writeAndCount(writeContents, os);
            }

            @Override
            public void drain(InputStream is) throws IOException {
                tae.setSize(this.count);
                archiveOutputStream.putArchiveEntry(tae);
                IoUtil.copy(is, archiveOutputStream);
                archiveOutputStream.closeArchiveEntry();
            }
        });
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof TarArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        if (!name.endsWith("/")) {
            name = String.valueOf(name) + '/';
        }
        archiveOutputStream.putArchiveEntry(new TarArchiveEntry(name));
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(final ArchiveOutputStream archiveOutputStream, final ArchiveEntry archiveEntry, final @Nullable String name, final ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof TarArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        PipeUtil.temporaryStorage(new PipeUtil.FillerAndDrainer(){
            long count;

            @Override
            public void fill(OutputStream os) throws IOException {
                if (!archiveEntry.isDirectory()) {
                    this.count = IoUtil.writeAndCount(writeContents, os);
                }
            }

            @Override
            public void drain(InputStream is) throws IOException {
                TarArchiveEntry ntae = new TarArchiveEntry(name != null ? name : archiveEntry.getName());
                ntae.setModTime(archiveEntry.getLastModifiedDate());
                ntae.setSize(this.count);
                if (archiveEntry instanceof TarArchiveEntry) {
                    TarArchiveEntry tae = (TarArchiveEntry)archiveEntry;
                    ntae.setDevMajor(tae.getDevMajor());
                    ntae.setDevMinor(tae.getDevMinor());
                    ntae.setGroupId(tae.getGroupId());
                    ntae.setGroupName(tae.getGroupName());
                    ntae.setLinkName(tae.getLinkName());
                    ntae.setMode(tae.getMode());
                    ntae.setUserId(tae.getUserId());
                    ntae.setUserName(tae.getUserName());
                }
                archiveOutputStream.putArchiveEntry(ntae);
                IoUtil.copy(is, archiveOutputStream);
                archiveOutputStream.closeArchiveEntry();
            }
        });
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return TarArchiveInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

