/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.cpio;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.pipe.PipeUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class CpioArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".cpio", ""), ".cpio");
    private static final ArchiveFormat INSTANCE = new CpioArchiveFormat();

    private CpioArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "cpio";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        return new CpioArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return new CpioArchiveInputStream(new FileInputStream(archiveFile));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        return new CpioArchiveOutputStream(os);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new CpioArchiveOutputStream(new FileOutputStream(archiveFile));
    }

    @Override
    public void writeEntry(final ArchiveOutputStream archiveOutputStream, final String name, final ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof CpioArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        PipeUtil.temporaryStorage(new PipeUtil.FillerAndDrainer(){
            long count;

            @Override
            public void fill(OutputStream os) throws IOException {
                this.count = IoUtil.writeAndCount(writeContents, os);
            }

            @Override
            public void drain(InputStream is) throws IOException {
                archiveOutputStream.putArchiveEntry(new CpioArchiveEntry(name, this.count));
                IoUtil.copy(is, archiveOutputStream);
                archiveOutputStream.closeArchiveEntry();
            }
        });
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof CpioArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        CpioArchiveEntry cae = new CpioArchiveEntry(name);
        cae.setMode(16384L);
        archiveOutputStream.putArchiveEntry(cae);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof CpioArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        class MyPipeUser
        implements PipeUtil.FillerAndDrainer {
            int checksum;
            long count;
            private final /* synthetic */ ArchiveEntry val$archiveEntry;
            private final /* synthetic */ ConsumerWhichThrows val$writeContents;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ ArchiveOutputStream val$archiveOutputStream;

            MyPipeUser(ArchiveEntry archiveEntry, ConsumerWhichThrows consumerWhichThrows, String string, ArchiveOutputStream archiveOutputStream) {
                this.val$archiveEntry = archiveEntry;
                this.val$writeContents = consumerWhichThrows;
                this.val$name = string;
                this.val$archiveOutputStream = archiveOutputStream;
            }

            @Override
            public void fill(OutputStream os) throws IOException {
                if (this.val$archiveEntry.isDirectory()) {
                    return;
                }
                this.count = IoUtil.writeAndCount(this.val$writeContents, new FilterOutputStream(os){

                    @Override
                    public void write(int b) throws IOException {
                        checksum += b;
                        this.out.write(b);
                        super.close();
                    }
                });
            }

            @Override
            public void drain(InputStream is) throws IOException {
                CpioArchiveEntry ncae = new CpioArchiveEntry(this.val$name != null ? this.val$name : this.val$archiveEntry.getName());
                ncae.setSize(this.count);
                ncae.setTime(this.val$archiveEntry.getLastModifiedDate().getTime());
                ncae.setChksum(this.checksum & 0xFF);
                if (this.val$archiveEntry instanceof CpioArchiveEntry) {
                    CpioArchiveEntry cae = (CpioArchiveEntry)this.val$archiveEntry;
                    ncae.setDevice(cae.getDevice());
                    ncae.setGID(cae.getGID());
                    ncae.setInode(cae.getInode());
                    ncae.setMode(cae.getMode());
                    ncae.setNumberOfLinks(cae.getNumberOfLinks());
                    ncae.setRemoteDevice(cae.getRemoteDevice());
                    ncae.setUID(cae.getUID());
                }
                this.val$archiveOutputStream.putArchiveEntry(ncae);
                IoUtil.copy(is, this.val$archiveOutputStream);
                this.val$archiveOutputStream.closeArchiveEntry();
            }
        }
        PipeUtil.temporaryStorage(new MyPipeUser(archiveEntry, writeContents, name, archiveOutputStream));
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return CpioArchiveInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

