/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.contentstransformation;

import de.unkrig.commons.file.contentstransformation.ContentsTransformations;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.contentstransformation.ContentsTransformerByteFilter;
import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.lang.protocol.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SelectiveContentsTransformer
implements ContentsTransformer {
    private final Predicate<? super String> namePredicate;
    private final ContentsTransformer transformer;
    private final ContentsTransformer delegate;

    public SelectiveContentsTransformer(Predicate<? super String> namePredicate, ContentsTransformer transformer, ContentsTransformer delegate) {
        this.namePredicate = namePredicate;
        this.transformer = transformer;
        this.delegate = delegate;
    }

    @Override
    public void transform(String name, InputStream is, OutputStream os) throws IOException {
        if (!this.namePredicate.evaluate(name)) {
            this.delegate.transform(name, is, os);
            return;
        }
        if (this.delegate == ContentsTransformations.COPY) {
            this.transformer.transform(name, is, os);
            return;
        }
        if (this.transformer == ContentsTransformations.COPY) {
            this.delegate.transform(name, is, os);
            return;
        }
        this.delegate.transform(name, new ByteFilterInputStream(is, new ContentsTransformerByteFilter(this.transformer, name)), os);
    }

    public String toString() {
        return "(" + this.namePredicate + " ? " + this.delegate + " => " + this.transformer + " : " + this.delegate + ")";
    }
}

