/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.zz.diff.Diff;
import de.unkrig.zz.diff.DocumentDiff;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class Main {
    private final Diff diff = new Diff();
    private final LevelFilteredPrinter levelFilteredPrinter = new LevelFilteredPrinter(AbstractPrinter.getContextPrinter());
    @Nullable
    private File outputFile;

    public static void main(final String[] args) {
        final Main main = new Main();
        main.levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                main.main2(args);
            }
        });
    }

    private void main2(String[] args) {
        try {
            this.main3(args);
        }
        catch (Exception e) {
            Printers.error(null, e);
            System.exit(1);
        }
    }

    private void main3(String[] args) throws Exception {
        if ((args = CommandLineOptions.parse(args, this)).length != 2) {
            Printers.error("Wrong number of file or directory names - try \"--help\".");
            System.exit(2);
        }
        this.main4(new File(args[0]), new File(args[1]));
    }

    private void main4(final File file1, final File file2) throws Exception {
        Printers.redirectToFile(AbstractPrinter.Level.INFO, this.outputFile, null, new RunnableWhichThrows<Exception>(){

            @Override
            public void run() throws Exception {
                Main.this.main5(file1, file2);
            }
        });
    }

    private void main5(File file1, File file2) throws Exception {
        long differenceCount = this.diff.execute(file1, file2);
        if (differenceCount > 0L) {
            System.exit(1);
        }
    }

    @CommandLineOption
    public void help() throws IOException {
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        CommandLineOptions.printResource(Main.class, "main(String[]).txt", Charset.forName("UTF-8"), System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void setPath(@RegexFlags(value=-1610612736) Glob pathPredicate) {
        this.diff.setPathPredicate(pathPredicate);
    }

    @CommandLineOption
    public void setLookInto(@RegexFlags(value=-1610612736) Glob discriminator) {
        this.diff.setLookInto(discriminator);
    }

    @CommandLineOption(name={"path-equivalence", "pe"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addPathEquivalence(Pattern pathRegex) {
        this.diff.addEquivalentPath(pathRegex);
    }

    @Deprecated
    @CommandLineOption(name={"ne"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addNameEquivalence(Pattern pathRegex) {
        this.addPathEquivalence(pathRegex);
    }

    @CommandLineOption
    public void setNoRecurseSubdirctories() {
        this.diff.setRecurseSubdirectories(false);
    }

    @CommandLineOption(name={"disassemble", "da"})
    public void setDisassemble() {
        this.diff.setDisassembleClassFiles(true);
    }

    @CommandLineOption
    public void setDaNoLines() {
        this.diff.setDisassembleClassFilesButHideLines(true);
    }

    @CommandLineOption
    public void setDaNoVars() {
        this.diff.setDisassembleClassFilesButHideVars(true);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addLineEquivalence(@RegexFlags(value=-1610612736) Glob pathPattern, Pattern lineRegex) {
        this.diff.addEquivalentLine(new Diff.LineEquivalence(pathPattern, lineRegex));
    }

    @CommandLineOption(name={"ignore", "I"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addIgnore(@RegexFlags(value=-1610612736) Glob pathPattern, Pattern lineRegex) {
        this.diff.addIgnore(new Diff.LineEquivalence(pathPattern, lineRegex));
    }

    @CommandLineOption(name={"ignore-whitespace", "w"})
    public void setIgnoreWhitespace() {
        this.diff.setIgnoreWhitespace(true);
    }

    @CommandLineOption(group={AddedFileModeOptionGroup.class})
    public void setAddedFile(Diff.AbsentFileMode mode) {
        this.diff.setAddedFileMode(mode);
    }

    @CommandLineOption(group={DeletedFileModeOptionGroup.class})
    public void setDeletedFile(Diff.AbsentFileMode mode) {
        this.diff.setDeletedFileMode(mode);
    }

    @CommandLineOption(name={"new-file", "N"}, group={AddedFileModeOptionGroup.class, DeletedFileModeOptionGroup.class})
    public void setNewFile() {
        this.diff.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
        this.diff.setDeletedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
    }

    @CommandLineOption(group={AddedFileModeOptionGroup.class, DeletedFileModeOptionGroup.class})
    public void setUnidirectionalNewFile() {
        this.diff.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
        this.diff.setDeletedFileMode(Diff.AbsentFileMode.REPORT);
    }

    @CommandLineOption
    public void setUnchangedFiles() {
        this.diff.setReportUnchangedFiles(true);
    }

    @CommandLineOption
    public void setEncoding(Charset charsetName) {
        this.diff.setCharset(charsetName);
    }

    @CommandLineOption
    public void setOut(File outputFile) {
        this.outputFile = outputFile;
    }

    @CommandLineOption(group={DiffModeOptionGroup.class})
    public void setNormal() {
        this.diff.setDiffMode(Diff.DiffMode.NORMAL);
    }

    @CommandLineOption(group={DiffModeOptionGroup.class})
    public void setExist() {
        this.diff.setDiffMode(Diff.DiffMode.EXIST);
    }

    @CommandLineOption(name={"brief", "q"}, group={DiffModeOptionGroup.class})
    public void setBrief() {
        this.diff.setDiffMode(Diff.DiffMode.BRIEF);
    }

    @CommandLineOption(name={"context", "c"}, group={DiffModeOptionGroup.class})
    public void setContext() {
        this.diff.setDiffMode(Diff.DiffMode.CONTEXT);
    }

    @CommandLineOption(name={"Context", "C"}, group={DiffModeOptionGroup.class})
    public void setContext2(int amount) {
        this.diff.setDiffMode(Diff.DiffMode.CONTEXT);
        this.diff.setContextSize(amount);
    }

    @CommandLineOption(name={"unified", "u"}, group={DiffModeOptionGroup.class})
    public void setUnified() {
        this.diff.setDiffMode(Diff.DiffMode.UNIFIED);
    }

    @CommandLineOption(name={"Unified"}, group={DiffModeOptionGroup.class})
    public void setUnified2(int amount) {
        this.diff.setDiffMode(Diff.DiffMode.UNIFIED);
        this.diff.setContextSize(amount);
    }

    @CommandLineOption
    public void setKeepGoing() {
        this.diff.setExceptionHandler(new ExceptionHandler<IOException>(){

            @Override
            public void handle(String path, IOException ioe) {
                Printers.error(path, ioe.getMessage());
            }

            @Override
            public void handle(String path, RuntimeException re) {
                Printers.error(path, re.getMessage());
            }
        });
    }

    @CommandLineOption
    public void setSequential() {
        this.diff.setSequential(true);
    }

    @CommandLineOption
    public void setJavaTokenization() {
        this.diff.setTokenization(DocumentDiff.Tokenization.JAVA);
    }

    @CommandLineOption
    public void setIgnoreCStyleComments() {
        this.diff.setIgnoreCStyleComments(true);
    }

    @CommandLineOption(name={"ignore-c++-style-comments"})
    public void setIgnoreCppStyleComments() {
        this.diff.setIgnoreCPlusPlusStyleComments(true);
    }

    @CommandLineOption
    public void setIgnoreDocComments() {
        this.diff.setIgnoreDocComments(true);
    }

    @CommandLineOption
    public void setNoWarn() {
        this.levelFilteredPrinter.setNoWarn();
    }

    @CommandLineOption
    public void setQuiet() {
        this.levelFilteredPrinter.setQuiet();
    }

    @CommandLineOption
    public void setVerbose() {
        this.levelFilteredPrinter.setVerbose();
    }

    @CommandLineOption
    public void setDebug() {
        this.levelFilteredPrinter.setDebug();
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    @CommandLineOptionGroup
    static interface DiffModeOptionGroup {
    }

    @CommandLineOptionGroup
    static interface DeletedFileModeOptionGroup {
    }

    @CommandLineOptionGroup
    static interface AddedFileModeOptionGroup {
    }
}

