/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.jdisasm.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.io.charstream.StringCharStream;
import de.unkrig.jdisasm.io.charstream.UnexpectedCharacterException;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SignatureParser {
    public static final ClassTypeSignature OBJECT = new ClassTypeSignature("java.lang.", "Object", Collections.<TypeArgument>emptyList(), Collections.<SimpleClassTypeSignature>emptyList());
    public static final PrimitiveTypeSignature BYTE = new PrimitiveTypeSignature("byte");
    public static final PrimitiveTypeSignature CHAR = new PrimitiveTypeSignature("char");
    public static final PrimitiveTypeSignature DOUBLE = new PrimitiveTypeSignature("double");
    public static final PrimitiveTypeSignature FLOAT = new PrimitiveTypeSignature("float");
    public static final PrimitiveTypeSignature INT = new PrimitiveTypeSignature("int");
    public static final PrimitiveTypeSignature LONG = new PrimitiveTypeSignature("long");
    public static final PrimitiveTypeSignature SHORT = new PrimitiveTypeSignature("short");
    public static final PrimitiveTypeSignature BOOLEAN = new PrimitiveTypeSignature("boolean");
    public static final TypeSignature VOID = new TypeSignature(){

        @Override
        public String toString() {
            return "void";
        }
    };
    private static final PrimitiveTypeSignature[] PRIMITIVE_TYPES = new PrimitiveTypeSignature[]{BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, BOOLEAN};

    private SignatureParser() {
    }

    public static ClassSignature decodeClassSignature(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            ClassSignature cls = SignatureParser.parseClassSignature(scs);
            scs.eoi();
            return cls;
        }
        catch (SignatureException e) {
            throw new SignatureException("Class signature '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Class signature '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Class signature '" + s + "': " + e.getMessage(), e);
        }
    }

    public static MethodTypeSignature decodeMethodTypeSignature(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            MethodTypeSignature mts = SignatureParser.parseMethodTypeSignature(scs);
            scs.eoi();
            return mts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Method type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Method type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Method type signature '" + s + "': " + e.getMessage(), e);
        }
    }

    public static TypeSignature decodeTypeSignature(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            TypeSignature ts = SignatureParser.parseTypeSignature(scs);
            scs.eoi();
            return ts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
    }

    public static FieldTypeSignature decodeFieldTypeSignature(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            FieldTypeSignature fts = SignatureParser.parseFieldTypeSignature(scs);
            scs.eoi();
            return fts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Field type signature '" + s + "': " + e.getMessage(), e);
        }
    }

    public static MethodTypeSignature decodeMethodDescriptor(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            MethodTypeSignature mts = SignatureParser.parseMethodDescriptor(scs);
            scs.eoi();
            return mts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Method descriptor '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Method descriptor '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Method descriptor '" + s + "': " + e.getMessage(), e);
        }
    }

    public static TypeSignature decodeFieldDescriptor(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            TypeSignature ts = SignatureParser.parseFieldDescriptor(scs);
            scs.eoi();
            return ts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Field descriptor '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Field descriptor '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Field descriptor '" + s + "': " + e.getMessage(), e);
        }
    }

    public static TypeSignature decodeReturnType(String s) throws SignatureException {
        try {
            StringCharStream scs = new StringCharStream(s);
            TypeSignature ts = SignatureParser.parseReturnType(scs);
            scs.eoi();
            return ts;
        }
        catch (SignatureException e) {
            throw new SignatureException("Return type '" + s + "': " + e.getMessage(), e);
        }
        catch (EOFException e) {
            throw new SignatureException("Return type '" + s + "': " + e.getMessage(), e);
        }
        catch (UnexpectedCharacterException e) {
            throw new SignatureException("Return type '" + s + "': " + e.getMessage(), e);
        }
    }

    private static TypeSignature parseFieldDescriptor(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        return SignatureParser.parseTypeSignature(scs);
    }

    private static MethodTypeSignature parseMethodDescriptor(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        return SignatureParser.parseMethodTypeSignature(scs);
    }

    private static ClassSignature parseClassSignature(StringCharStream scs) throws EOFException, SignatureException, UnexpectedCharacterException {
        ArrayList<FormalTypeParameter> ftps = new ArrayList<FormalTypeParameter>();
        if (scs.peekRead('<')) {
            while (!scs.peekRead('>')) {
                ftps.add(SignatureParser.parseFormalTypeParameter(scs));
            }
        }
        ClassTypeSignature cts = SignatureParser.parseClassTypeSignature(scs);
        ArrayList<ClassTypeSignature> siss = new ArrayList<ClassTypeSignature>();
        while (!scs.atEoi()) {
            siss.add(SignatureParser.parseClassTypeSignature(scs));
        }
        return new ClassSignature(ftps, cts, siss);
    }

    private static MethodTypeSignature parseMethodTypeSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        ArrayList<FormalTypeParameter> ftps = new ArrayList<FormalTypeParameter>();
        if (scs.peekRead('<')) {
            while (!scs.peekRead('>')) {
                ftps.add(SignatureParser.parseFormalTypeParameter(scs));
            }
        }
        scs.read('(');
        ArrayList<TypeSignature> pts = new ArrayList<TypeSignature>();
        while (!scs.peekRead(')')) {
            pts.add(SignatureParser.parseTypeSignature(scs));
        }
        TypeSignature rt = SignatureParser.parseReturnType(scs);
        ArrayList<ThrowsSignature> tts = new ArrayList<ThrowsSignature>();
        while (!scs.atEoi()) {
            tts.add(SignatureParser.parseThrowsSignature(scs));
        }
        return new MethodTypeSignature(ftps, pts, rt, tts);
    }

    private static TypeSignature parseReturnType(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        if (scs.peekRead('V')) {
            return VOID;
        }
        return SignatureParser.parseTypeSignature(scs);
    }

    private static ThrowsSignature parseThrowsSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        scs.read('^');
        return scs.peek('T') ? SignatureParser.parseTypeVariableSignature(scs) : SignatureParser.parseClassTypeSignature(scs);
    }

    private static ClassTypeSignature parseClassTypeSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        String scn;
        scs.read('L');
        String ps = "";
        ArrayList<TypeArgument> tas = new ArrayList<TypeArgument>();
        block6: while (true) {
            String s = SignatureParser.parseIdentifier(scs);
            switch (scs.peek("<./;")) {
                case 0: {
                    scs.read('<');
                    scn = s;
                    while (!scs.peekRead('>')) {
                        tas.add(SignatureParser.parseTypeArgument(scs));
                    }
                    break block6;
                }
                case 1: {
                    scn = s;
                    break block6;
                }
                case 2: {
                    ps = String.valueOf(ps) + s + '/';
                    scs.read();
                    continue block6;
                }
                case 3: {
                    scn = s;
                    break block6;
                }
                default: {
                    scs.read("<./;");
                    continue block6;
                }
            }
            break;
        }
        ArrayList<SimpleClassTypeSignature> ss = new ArrayList<SimpleClassTypeSignature>();
        while (scs.peekRead('.')) {
            ss.add(SignatureParser.parseSimpleClassTypeSignature(scs));
        }
        scs.read(';');
        return new ClassTypeSignature(ps, scn, tas, ss);
    }

    private static String parseIdentifier(StringCharStream scs) throws EOFException, SignatureException {
        char c = scs.read();
        if (!Character.isJavaIdentifierStart(c)) {
            throw new SignatureException("Identifier expected instead of '" + c + "'");
        }
        StringBuilder sb = new StringBuilder().append(c);
        while (Character.isJavaIdentifierPart(scs.peek())) {
            sb.append(scs.read());
        }
        return sb.toString();
    }

    private static TypeVariableSignature parseTypeVariableSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        scs.read('T');
        String identifier = SignatureParser.parseIdentifier(scs);
        scs.read(';');
        return new TypeVariableSignature(identifier);
    }

    private static FormalTypeParameter parseFormalTypeParameter(StringCharStream scs) throws EOFException, SignatureException, UnexpectedCharacterException {
        String identifier = SignatureParser.parseIdentifier(scs);
        scs.read(':');
        FieldTypeSignature cb = !scs.peek(':') ? SignatureParser.parseFieldTypeSignature(scs) : null;
        ArrayList<FieldTypeSignature> ibs = new ArrayList<FieldTypeSignature>();
        while (scs.peekRead(':')) {
            ibs.add(SignatureParser.parseFieldTypeSignature(scs));
        }
        return new FormalTypeParameter(identifier, cb, ibs);
    }

    private static TypeSignature parseTypeSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        int idx = scs.peekRead("BCDFIJSZ");
        if (idx != -1) {
            return PRIMITIVE_TYPES[idx];
        }
        return SignatureParser.parseFieldTypeSignature(scs);
    }

    private static FieldTypeSignature parseFieldTypeSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        switch (scs.peek("L[T")) {
            case 0: {
                return SignatureParser.parseClassTypeSignature(scs);
            }
            case 1: {
                return SignatureParser.parseArrayTypeSignature(scs);
            }
            case 2: {
                return SignatureParser.parseTypeVariableSignature(scs);
            }
        }
        throw new SignatureException("Class type signature, array type signature or type variable signature expected");
    }

    private static FieldTypeSignature parseArrayTypeSignature(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        scs.read('[');
        return new ArrayTypeSignature(SignatureParser.parseTypeSignature(scs));
    }

    private static SimpleClassTypeSignature parseSimpleClassTypeSignature(StringCharStream scs) throws EOFException, SignatureException, UnexpectedCharacterException {
        String scn = SignatureParser.parseIdentifier(scs);
        ArrayList<TypeArgument> ta = new ArrayList<TypeArgument>();
        if (scs.peekRead('<')) {
            while (!scs.peekRead('>')) {
                ta.add(SignatureParser.parseTypeArgument(scs));
            }
        }
        return new SimpleClassTypeSignature(scn, ta);
    }

    private static TypeArgument parseTypeArgument(StringCharStream scs) throws EOFException, UnexpectedCharacterException, SignatureException {
        if (scs.peekRead('+')) {
            return new TypeArgument(TypeArgument.Mode.EXTENDS, SignatureParser.parseFieldTypeSignature(scs));
        }
        if (scs.peekRead('-')) {
            return new TypeArgument(TypeArgument.Mode.SUPER, SignatureParser.parseFieldTypeSignature(scs));
        }
        if (scs.peekRead('*')) {
            return new TypeArgument(TypeArgument.Mode.ANY, null);
        }
        return new TypeArgument(TypeArgument.Mode.NONE, SignatureParser.parseFieldTypeSignature(scs));
    }

    public static class ArrayTypeSignature
    implements FieldTypeSignature {
        public final TypeSignature componentTypeSignature;

        public ArrayTypeSignature(TypeSignature componentTypeSignature) {
            this.componentTypeSignature = componentTypeSignature;
        }

        @Override
        public String toString() {
            return String.valueOf(this.componentTypeSignature.toString()) + "[]";
        }
    }

    public static class ClassSignature {
        public final List<FormalTypeParameter> formalTypeParameters;
        public ClassTypeSignature superclassSignature;
        public final List<ClassTypeSignature> superinterfaceSignatures;

        public ClassSignature(List<FormalTypeParameter> formalTypeParameters, ClassTypeSignature superclassSignature, List<ClassTypeSignature> superinterfaceSignatures) {
            this.formalTypeParameters = formalTypeParameters;
            this.superclassSignature = superclassSignature;
            this.superinterfaceSignatures = superinterfaceSignatures;
        }

        public String toString(String className) {
            Iterator<Object> it;
            StringBuilder sb = new StringBuilder(className);
            if (!this.formalTypeParameters.isEmpty()) {
                it = this.formalTypeParameters.iterator();
                sb.append('<').append(it.next().toString());
                while (it.hasNext()) {
                    sb.append(", ").append(((FormalTypeParameter)it.next()).toString());
                }
                sb.append('>');
            }
            sb.append(" extends ").append(this.superclassSignature.toString());
            if (!this.superinterfaceSignatures.isEmpty()) {
                it = this.superinterfaceSignatures.iterator();
                sb.append(" implements ").append(((ClassTypeSignature)it.next()).toString());
                while (it.hasNext()) {
                    sb.append(", ").append(((ClassTypeSignature)it.next()).toString());
                }
            }
            return sb.toString();
        }
    }

    public static class ClassTypeSignature
    implements ThrowsSignature,
    FieldTypeSignature {
        public final String packageSpecifier;
        public final String simpleClassName;
        public final List<TypeArgument> typeArguments;
        public final List<SimpleClassTypeSignature> suffixes;

        public ClassTypeSignature(String packageSpecifier, String simpleClassName, List<TypeArgument> typeArguments, List<SimpleClassTypeSignature> suffixes) {
            this.packageSpecifier = packageSpecifier;
            this.simpleClassName = simpleClassName;
            this.typeArguments = typeArguments;
            this.suffixes = suffixes;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.packageSpecifier.replace('/', '.')).append(this.simpleClassName);
            if (!this.typeArguments.isEmpty()) {
                Iterator<TypeArgument> it = this.typeArguments.iterator();
                sb.append('<').append(it.next().toString());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next().toString());
                }
                sb.append('>');
            }
            for (SimpleClassTypeSignature suffix : this.suffixes) {
                sb.append('.').append(suffix.toString());
            }
            return sb.toString();
        }
    }

    public static interface FieldTypeSignature
    extends TypeSignature {
        @Override
        public String toString();
    }

    public static class FormalTypeParameter {
        public final String identifier;
        @Nullable
        public final FieldTypeSignature classBound;
        public final List<FieldTypeSignature> interfaceBounds;

        public FormalTypeParameter(String identifier, @Nullable FieldTypeSignature classBound, List<FieldTypeSignature> interfaceBounds) {
            this.identifier = identifier;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
        }

        public String toString() {
            FieldTypeSignature cb = this.classBound;
            if (cb == null) {
                Iterator<FieldTypeSignature> it = this.interfaceBounds.iterator();
                if (!it.hasNext()) {
                    return this.identifier;
                }
                StringBuilder sb = new StringBuilder(this.identifier).append(" extends ").append(it.next().toString());
                while (it.hasNext()) {
                    sb.append(" & ").append(it.next().toString());
                }
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder(this.identifier).append(" extends ").append(cb.toString());
            for (FieldTypeSignature ib : this.interfaceBounds) {
                sb.append(" & ").append(ib.toString());
            }
            return sb.toString();
        }
    }

    public static class MethodTypeSignature {
        public final List<FormalTypeParameter> formalTypeParameters;
        public final List<TypeSignature> parameterTypes;
        public final TypeSignature returnType;
        public final List<ThrowsSignature> thrownTypes;

        public MethodTypeSignature(List<FormalTypeParameter> formalTypeParameters, List<TypeSignature> parameterTypes, TypeSignature returnType, List<ThrowsSignature> thrownTypes) {
            this.formalTypeParameters = formalTypeParameters;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.thrownTypes = thrownTypes;
        }

        public String toString(String declaringClassName, String methodName) {
            Iterator<Object> it;
            StringBuilder sb = new StringBuilder();
            if (!this.formalTypeParameters.isEmpty()) {
                it = this.formalTypeParameters.iterator();
                sb.append(String.valueOf('<') + it.next().toString());
                while (it.hasNext()) {
                    sb.append(", " + ((FormalTypeParameter)it.next()).toString());
                }
                sb.append("> ");
            }
            if ("<init>".equals(methodName) && this.returnType == VOID) {
                sb.append(declaringClassName);
            } else {
                sb.append(declaringClassName).append('.').append(methodName);
            }
            sb.append('(');
            it = this.parameterTypes.iterator();
            if (it.hasNext()) {
                while (true) {
                    sb.append(((TypeSignature)it.next()).toString());
                    if (!it.hasNext()) break;
                    sb.append(", ");
                }
            }
            sb.append(')');
            if (this.returnType != VOID) {
                sb.append(" => ").append(this.returnType.toString());
            }
            return sb.toString();
        }

        public String toString() {
            Iterator<Object> it;
            StringBuilder sb = new StringBuilder();
            if (!this.formalTypeParameters.isEmpty()) {
                it = this.formalTypeParameters.iterator();
                sb.append(String.valueOf('<') + ((FormalTypeParameter)it.next()).toString());
                while (it.hasNext()) {
                    sb.append(", " + ((FormalTypeParameter)it.next()).toString());
                }
                sb.append("> ");
            }
            sb.append('(');
            it = this.parameterTypes.iterator();
            if (it.hasNext()) {
                sb.append(it.next());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next());
                }
            }
            sb.append(')');
            if (this.returnType != VOID) {
                sb.append(" => ").append(this.returnType.toString());
            }
            return sb.toString();
        }
    }

    public static class PrimitiveTypeSignature
    implements TypeSignature {
        public final String typeName;

        PrimitiveTypeSignature(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public String toString() {
            return this.typeName;
        }
    }

    public static class SignatureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SignatureException(String message) {
            super(message);
        }

        public SignatureException(String message, Throwable t) {
            super(message, t);
        }
    }

    public static class SimpleClassTypeSignature {
        public final String simpleClassName;
        public final List<TypeArgument> typeArguments;

        public SimpleClassTypeSignature(String simpleClassName, List<TypeArgument> typeArguments) {
            this.simpleClassName = simpleClassName;
            this.typeArguments = typeArguments;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.simpleClassName);
            if (!this.typeArguments.isEmpty()) {
                Iterator<TypeArgument> it = this.typeArguments.iterator();
                sb.append('<').append(it.next().toString());
                while (it.hasNext()) {
                    sb.append(", ").append(it.next().toString());
                }
                sb.append('>');
            }
            return sb.toString();
        }
    }

    public static interface ThrowsSignature {
    }

    public static class TypeArgument {
        public final Mode mode;
        @Nullable
        public final FieldTypeSignature fieldTypeSignature;

        public TypeArgument(Mode mode, @Nullable FieldTypeSignature fieldTypeSignature) {
            assert (mode == Mode.ANY ^ fieldTypeSignature == null);
            this.mode = mode;
            this.fieldTypeSignature = fieldTypeSignature;
        }

        public String toString() {
            FieldTypeSignature fts = this.fieldTypeSignature;
            switch (this.mode) {
                case EXTENDS: {
                    assert (fts != null);
                    return "extends " + fts.toString();
                }
                case SUPER: {
                    assert (fts != null);
                    return "super " + fts.toString();
                }
                case ANY: {
                    return "*";
                }
                case NONE: {
                    assert (fts != null);
                    return fts.toString();
                }
            }
            throw new IllegalStateException();
        }

        static enum Mode {
            EXTENDS,
            SUPER,
            ANY,
            NONE;

        }
    }

    public static interface TypeSignature {
        public String toString();
    }

    public static class TypeVariableSignature
    implements ThrowsSignature,
    FieldTypeSignature {
        public String identifier;

        public TypeVariableSignature(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public String toString() {
            return this.identifier;
        }
    }
}

