/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.jdisasm.ClassFile;
import de.unkrig.jdisasm.ConstantPool;
import de.unkrig.jdisasm.SignatureParser;
import de.unkrig.jdisasm.commons.nullanalysis.NotNullByDefault;
import de.unkrig.jdisasm.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.protocol.zip.Handler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Disassembler {
    private static final List<ConstantPool.ConstantClassInfo> NO_CONSTANT_CLASS_INFOS = Collections.emptyList();
    private static final List<SignatureParser.ThrowsSignature> NO_THROWS_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.TypeSignature> NO_TYPE_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.ClassTypeSignature> NO_CLASS_TYPE_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.FormalTypeParameter> NO_FORMAL_TYPE_PARAMETERS = Collections.emptyList();
    private static final List<ClassFile.ParameterAnnotation> NO_PARAMETER_ANNOTATIONS = Collections.emptyList();
    private PrintWriter pw = new PrintWriter(System.out);
    boolean verbose;
    @Nullable
    private File sourceDirectory;
    private boolean hideLines;
    private boolean hideVars;
    private boolean symbolicLabels;
    @Nullable
    private String thisClassPackageName;
    @Nullable
    private Map<Integer, String> branchTargets;
    private static final Pattern IS_URL = Pattern.compile("\\w\\w+:.*");
    private static final Instruction[] OPCODE_TO_INSTRUCTION = Disassembler.compileInstructions("50  aaload\n83  aastore\n1   aconst_null\n25  aload           localvariableindex1\n42  aload_0         implicitlocalvariableindex\n43  aload_1         implicitlocalvariableindex\n44  aload_2         implicitlocalvariableindex\n45  aload_3         implicitlocalvariableindex\n189 anewarray       class2\n176 areturn\n190 arraylength\n58  astore          localvariableindex1\n75  astore_0        implicitlocalvariableindex\n76  astore_1        implicitlocalvariableindex\n77  astore_2        implicitlocalvariableindex\n78  astore_3        implicitlocalvariableindex\n191 athrow\n51  baload\n84  bastore\n16  bipush          signedbyte\n52  caload\n85  castore\n192 checkcast       class2\n144 d2f\n142 d2i\n143 d2l\n99  dadd\n49  daload\n82  dastore\n152 dcmpg\n151 dcmpl\n14  dconst_0\n15  dconst_1\n111 ddiv\n24  dload           localvariableindex1\n38  dload_0         implicitlocalvariableindex\n39  dload_1         implicitlocalvariableindex\n40  dload_2         implicitlocalvariableindex\n41  dload_3         implicitlocalvariableindex\n107 dmul\n119 dneg\n115 drem\n175 dreturn\n57  dstore          localvariableindex1\n71  dstore_0        implicitlocalvariableindex\n72  dstore_1        implicitlocalvariableindex\n73  dstore_2        implicitlocalvariableindex\n74  dstore_3        implicitlocalvariableindex\n103 dsub\n89  dup\n90  dup_x1\n91  dup_x2\n92  dup2\n93  dup2_x1\n94  dup2_x2\n141 f2d\n139 f2i\n140 f2l\n98  fadd\n48  faload\n81  fastore\n150 fcmpg\n149 fcmpl\n11  fconst_0\n12  fconst_1\n13  fconst_2\n110 fdiv\n23  fload           localvariableindex1\n34  fload_0         implicitlocalvariableindex\n35  fload_1         implicitlocalvariableindex\n36  fload_2         implicitlocalvariableindex\n37  fload_3         implicitlocalvariableindex\n106 fmul\n118 fneg\n114 frem\n174 freturn\n56  fstore          localvariableindex1\n67  fstore_0        implicitlocalvariableindex\n68  fstore_1        implicitlocalvariableindex\n69  fstore_2        implicitlocalvariableindex\n70  fstore_3        implicitlocalvariableindex\n102 fsub\n180 getfield        fieldref2\n178 getstatic       fieldref2\n167 goto            branchoffset2\n200 goto_w          branchoffset4\n145 i2b\n146 i2c\n135 i2d\n134 i2f\n133 i2l\n147 i2s\n96  iadd\n46  iaload\n126 iand\n79  iastore\n2   iconst_m1\n3   iconst_0\n4   iconst_1\n5   iconst_2\n6   iconst_3\n7   iconst_4\n8   iconst_5\n108 idiv\n165 if_acmpeq       branchoffset2\n166 if_acmpne       branchoffset2\n159 if_icmpeq       branchoffset2\n160 if_icmpne       branchoffset2\n161 if_icmplt       branchoffset2\n162 if_icmpge       branchoffset2\n163 if_icmpgt       branchoffset2\n164 if_icmple       branchoffset2\n153 ifeq            branchoffset2\n154 ifne            branchoffset2\n155 iflt            branchoffset2\n156 ifge            branchoffset2\n157 ifgt            branchoffset2\n158 ifle            branchoffset2\n199 ifnonnull       branchoffset2\n198 ifnull          branchoffset2\n132 iinc            localvariableindex1 signedbyte\n21  iload           localvariableindex1\n26  iload_0         implicitlocalvariableindex\n27  iload_1         implicitlocalvariableindex\n28  iload_2         implicitlocalvariableindex\n29  iload_3         implicitlocalvariableindex\n104 imul\n116 ineg\n193 instanceof      class2\n186 invokedynamic   dynamiccallsite\n185 invokeinterface interfacemethodref2\n183 invokespecial   methodref2\n184 invokestatic    methodref2\n182 invokevirtual   methodref2\n128 ior\n112 irem\n172 ireturn\n120 ishl\n122 ishr\n54  istore          localvariableindex1\n59  istore_0        implicitlocalvariableindex\n60  istore_1        implicitlocalvariableindex\n61  istore_2        implicitlocalvariableindex\n62  istore_3        implicitlocalvariableindex\n100 isub\n124 iushr\n130 ixor\n168 jsr             branchoffset2\n201 jsr_w           branchoffset4\n138 l2d\n137 l2f\n136 l2i\n97  ladd\n47  laload\n127 land\n80  lastore\n148 lcmp\n9   lconst_0\n10  lconst_1\n18  ldc             intfloatclassstring1\n19  ldc_w           intfloatclassstring2\n20  ldc2_w          longdouble2\n109 ldiv\n22  lload           localvariableindex1\n30  lload_0         implicitlocalvariableindex\n31  lload_1         implicitlocalvariableindex\n32  lload_2         implicitlocalvariableindex\n33  lload_3         implicitlocalvariableindex\n105 lmul\n117 lneg\n171 lookupswitch    lookupswitch\n129 lor\n113 lrem\n173 lreturn\n121 lshl\n123 lshr\n55  lstore          localvariableindex1\n63  lstore_0        implicitlocalvariableindex\n64  lstore_1        implicitlocalvariableindex\n65  lstore_2        implicitlocalvariableindex\n66  lstore_3        implicitlocalvariableindex\n101 lsub\n125 lushr\n131 lxor\n194 monitorenter\n195 monitorexit\n197 multianewarray  class2 unsignedbyte\n187 new             class2\n188 newarray        atype\n0   nop\n87  pop\n88  pop2\n181 putfield        fieldref2\n179 putstatic       fieldref2\n169 ret             localvariableindex1\n177 return\n53  saload\n86  sastore\n17  sipush          signedshort\n95  swap\n170 tableswitch     tableswitch\n196 wide            wide\n");
    private static final Instruction[] OPCODE_TO_WIDE_INSTRUCTION = Disassembler.compileInstructions("21  iload           localvariableindex2\n23  fload           localvariableindex2\n25  aload           localvariableindex2\n22  lload           localvariableindex2\n24  dload           localvariableindex2\n54  istore          localvariableindex2\n56  fstore          localvariableindex2\n58  astore          localvariableindex2\n55  lstore          localvariableindex2\n57  dstore          localvariableindex2\n169 ret             localvariableindex2\n132 iinc            localvariableindex2 signedshort\n");

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException {
        block20: {
            Handler.registerMe();
            d = new Disassembler();
            i = 0;
            while (i < args.length) {
                arg = args[i];
                if (arg.charAt(0) != '-' || arg.length() == 1) break;
                if ("-o".equals(arg)) {
                    d.setOut(new FileOutputStream(args[++i]));
                } else if ("-verbose".equals(arg)) {
                    d.setVerbose(true);
                } else if ("-src".equals(arg)) {
                    d.setSourceDirectory(new File(args[++i]));
                } else if ("-hide-lines".equals(arg)) {
                    d.setHideLines(true);
                } else if ("-hide-vars".equals(arg)) {
                    d.setHideVars(true);
                } else if ("-symbolic-labels".equals(arg)) {
                    d.setSymbolicLabels(true);
                } else if ("-help".equals(arg)) {
                    System.out.printf("Prints a disassembly listing of the given JAVA[TM] class files (or STDIN) to%nSTDOUT.%nUsage:%n  java %1$s [ <option> ] ... [ <class-file-name> | <class-file-url> | '-' ] ...%nValid options are:%n  -o <output-file>   Store disassembly output in a file.%n  -verbose%n  -src <source-dir>  Interweave the output with the class file's source code.%n  -hide-lines        Don't print the line numbers.%n  -hide-vars         Don't print the local variable names.%n  -symbolic-labels   Use symbolic labels instead of offsets.%n", new Object[]{Disassembler.class.getName()});
                    System.exit(0);
                } else {
                    System.err.println("Unrecognized command line option \"" + arg + "\"; try \"-help\".");
                    System.exit(1);
                }
                ++i;
            }
            if (i != args.length) ** GOTO lbl46
            d.disasm(System.in);
            break block20;
lbl-1000:
            // 1 sources

            {
                name = args[i];
                if ("-".equals(name)) {
                    d.disasm(System.in);
                } else if (Disassembler.IS_URL.matcher(name).matches()) {
                    d.disasm(new URL(name));
                } else {
                    d.disasm(new File(name));
                }
                ++i;
lbl46:
                // 2 sources

                ** while (i < args.length)
            }
        }
    }

    public void setOut(Writer writer) {
        this.pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setOut(OutputStream stream) {
        this.pw = new PrintWriter(stream);
    }

    public void setOut(OutputStream stream, String charsetName) throws UnsupportedEncodingException {
        this.pw = new PrintWriter(new OutputStreamWriter(stream, charsetName));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setHideLines(boolean hideLines) {
        this.hideLines = hideLines;
    }

    public void setHideVars(boolean hideVars) {
        this.hideVars = hideVars;
    }

    public void setSymbolicLabels(boolean symbolicLabels) {
        this.symbolicLabels = symbolicLabels;
    }

    private void print(String s) {
        this.pw.print(s);
    }

    private void println() {
        this.pw.println();
    }

    private void println(String s) {
        this.pw.println(s);
    }

    private void printf(String format, Object ... args) {
        this.pw.printf(format, args);
    }

    public void disasm(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            try {
                this.pw.println();
                this.pw.println("// *** Disassembly of '" + file + "'.");
                this.disasm(is);
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Disassembling '" + file + "': " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Disassembling '" + file + "': " + re.getMessage(), re);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void disasm(URL location) throws IOException {
        InputStream is = location.openConnection().getInputStream();
        try {
            try {
                this.pw.println();
                this.pw.println("// *** Disassembly of '" + location + "'.");
                this.disasm(is);
            }
            catch (IOException ioe) {
                IOException ioe2 = new IOException("Disassembling '" + location + "': " + ioe.getMessage());
                ioe2.initCause(ioe);
                throw ioe2;
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Disassembling '" + location + "': " + re.getMessage(), re);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void disasm(InputStream stream) throws IOException {
        try {
            this.disassembleClassFile(new DataInputStream(stream));
        }
        finally {
            this.pw.flush();
        }
    }

    private void disassembleClassFile(DataInputStream dis) throws IOException {
        ClassFile.SourceFileAttribute sfa;
        ClassFile.InnerClassesAttribute ica;
        ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
        ClassFile.RuntimeInvisibleAnnotationsAttribute riaa;
        ClassFile.EnclosingMethodAttribute ema;
        ClassFile cf = new ClassFile(dis);
        this.println();
        this.println("// Class file version = " + cf.majorVersion + "." + cf.minorVersion + " (" + cf.getJdkName() + ")");
        String tcpn = this.thisClassPackageName = cf.thisClassName.substring(0, cf.thisClassName.lastIndexOf(46) + 1);
        if (tcpn.length() > 0) {
            this.println();
            this.println("package " + tcpn.substring(0, tcpn.length() - 1) + ";");
        }
        if ((ema = cf.enclosingMethodAttribute) != null) {
            ConstantPool.ConstantNameAndTypeInfo m = ema.method;
            String methodName = m == null ? "[initializer]" : m.name.bytes;
            Iterator<ClassFile.Annotation> className = ema.clasS.name;
            this.println();
            this.println("// This class is enclosed by method '" + this.beautify((String)((Object)className)) + ("<init>".equals(methodName) ? "(...)" : "." + methodName + "(...)") + "'.");
        }
        this.println();
        if ((cf.accessFlags & 0x1000) != 0 || cf.syntheticAttribute != null) {
            this.println("// This is a synthetic class.");
        }
        if (cf.deprecatedAttribute != null) {
            this.println("/** @deprecated */");
        }
        if ((riaa = cf.runtimeInvisibleAnnotationsAttribute) != null) {
            for (ClassFile.Annotation a : riaa.annotations) {
                this.println(a.toString());
            }
        }
        if ((rvaa = cf.runtimeVisibleAnnotationsAttribute) != null) {
            for (ClassFile.Annotation a : rvaa.annotations) {
                this.println(a.toString());
            }
        }
        this.print(String.valueOf(Disassembler.decodeAccess((short)(cf.accessFlags & 0xFFFFFFDF & 0xFFFFEFFF & ((cf.accessFlags & 0x200) != 0 ? -1025 : 65535) & ((cf.accessFlags & 0x4000) != 0 ? -17 : 65535)))) + ((cf.accessFlags & 0x6200) == 0 ? "class " : ""));
        ClassFile.SignatureAttribute sa = cf.signatureAttribute;
        if (sa != null) {
            this.print(this.beautify(this.decodeClassSignature(sa.signature).toString(cf.thisClassName)));
        } else {
            this.print(this.beautify(cf.thisClassName));
            String scn = cf.superClassName;
            if (scn != null && !"java.lang.Object".equals(scn)) {
                this.print(" extends " + this.beautify(scn));
            }
            List<String> ifs = cf.interfaceNames;
            if ((cf.accessFlags & 0x2000) != 0) {
                if (ifs.contains("java.lang.annotation.Annotation")) {
                    ifs = new ArrayList<String>(ifs);
                    ifs.remove("java.lang.annotation.Annotation");
                } else {
                    this.print(" /* WARNING: This annotation type does not implement \"java.lang.annotation.Annotation\"! */");
                }
            }
            if (!ifs.isEmpty()) {
                Iterator<String> it = ifs.iterator();
                this.print(" implements " + this.beautify(it.next()));
                while (it.hasNext()) {
                    this.print(", " + this.beautify(it.next()));
                }
            }
        }
        this.println(" {");
        if (this.verbose) {
            this.println();
            this.println("    // Constant pool dump:");
            ConstantPool cp = cf.constantPool;
            int i = 0;
            while (i < cp.getSize()) {
                ConstantPool.ConstantPoolEntry constantPoolEntry = cp.getOptional((short)i, ConstantPool.ConstantPoolEntry.class);
                if (constantPoolEntry != null) {
                    this.println("    //   #" + i + ": " + this.beautify(constantPoolEntry.toString()));
                }
                ++i;
            }
        }
        if ((ica = cf.innerClassesAttribute) != null) {
            this.println();
            this.println("    // Enclosing/enclosed types:");
            for (ClassFile.InnerClassesAttribute.ClasS c : ica.classes) {
                this.println("    //   " + this.toString(c));
            }
        }
        this.disassembleFields(cf.fields);
        HashMap<Integer, String> sourceLines = new HashMap<Integer, String>();
        if (this.sourceDirectory != null && (sfa = cf.sourceFileAttribute) != null) {
            File sourceFile = new File(this.sourceDirectory, sfa.sourceFile);
            if (!sourceFile.exists()) {
                String toplevelClassName = cf.thisClassName;
                int idx = toplevelClassName.indexOf(36);
                if (idx != -1) {
                    toplevelClassName = toplevelClassName.substring(0, idx);
                }
                sourceFile = new File(this.sourceDirectory, String.valueOf(toplevelClassName.replace('.', File.separatorChar)) + ".java");
            }
            if (sourceFile.exists()) {
                LineNumberReader lnr = new LineNumberReader(new FileReader(sourceFile));
                try {
                    String sl;
                    while ((sl = lnr.readLine()) != null) {
                        sourceLines.put(lnr.getLineNumber(), sl);
                    }
                }
                finally {
                    try {
                        lnr.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (ClassFile.Method m : cf.methods) {
            this.disassembleMethod(m, cf, sourceLines);
        }
        this.println("}");
        this.printAttributes(cf.attributes, "// ", new ClassFile.Attribute[]{cf.deprecatedAttribute, ema, cf.innerClassesAttribute, cf.runtimeInvisibleAnnotationsAttribute, cf.runtimeVisibleAnnotationsAttribute, cf.signatureAttribute, cf.sourceFileAttribute, cf.syntheticAttribute}, AttributeContext.CLASS);
    }

    private void disassembleMethod(ClassFile.Method method, ClassFile cf, Map<Integer, String> sourceLines) {
        try {
            ClassFile.CodeAttribute ca;
            Iterator<Object> it;
            ClassFile.ExceptionsAttribute ea;
            SignatureParser.MethodTypeSignature mts;
            ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
            ClassFile.RuntimeInvisibleAnnotationsAttribute riaa;
            this.println();
            if ((method.accessFlags & 0x1000) != 0 || method.syntheticAttribute != null) {
                this.println("    // (Synthetic method)");
            }
            if ((method.accessFlags & 0x40) != 0) {
                this.println("    // (Bridge method)");
            }
            if (method.deprecatedAttribute != null) {
                this.println("    /** @deprecated */");
            }
            if ((riaa = method.runtimeInvisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : riaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            if ((rvaa = method.runtimeVisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : rvaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            this.print("    " + Disassembler.decodeAccess((short)(method.accessFlags & 0xFFFFEFFF & 0xFFFFFFBF & 0xFFFFFF7F & ((cf.accessFlags & 0x200) != 0 ? -1026 : 65535))));
            ClassFile.SignatureAttribute sa = method.signatureAttribute;
            SignatureParser.MethodTypeSignature methodTypeSignature = mts = sa == null ? this.decodeMethodDescriptor(method.descriptor) : this.decodeMethodTypeSignature(sa.signature);
            if (!mts.formalTypeParameters.isEmpty()) {
                Iterator<SignatureParser.FormalTypeParameter> it2 = mts.formalTypeParameters.iterator();
                this.print("<" + this.beautify(it2.next().toString()));
                while (it2.hasNext()) {
                    this.print(", " + this.beautify(it2.next().toString()));
                }
                this.print(">");
            }
            List<ConstantPool.ConstantClassInfo> exceptionNames = (ea = method.exceptionsAttribute) == null ? NO_CONSTANT_CLASS_INFOS : ea.exceptionNames;
            String functionName = method.name;
            if (!("<clinit>".equals(functionName) && (method.accessFlags & 8) != 0 && exceptionNames.isEmpty() && mts.formalTypeParameters.isEmpty() && mts.parameterTypes.isEmpty() && mts.returnType == SignatureParser.VOID && mts.thrownTypes.isEmpty())) {
                if ("<init>".equals(functionName) && (method.accessFlags & 0x618) == 0 && mts.formalTypeParameters.isEmpty() && mts.returnType == SignatureParser.VOID) {
                    this.print(this.beautify(cf.thisClassName));
                    this.printParameters(method.runtimeInvisibleParameterAnnotationsAttribute, method.runtimeVisibleParameterAnnotationsAttribute, mts.parameterTypes, method, (short)1, (method.accessFlags & 0x80) != 0);
                } else {
                    this.print(String.valueOf(this.beautify(mts.returnType.toString())) + ' ');
                    this.print(functionName);
                    this.printParameters(method.runtimeInvisibleParameterAnnotationsAttribute, method.runtimeVisibleParameterAnnotationsAttribute, mts.parameterTypes, method, (method.accessFlags & 8) == 0 ? (short)1 : 0, (method.accessFlags & 0x80) != 0);
                }
            }
            if (!mts.thrownTypes.isEmpty()) {
                it = mts.thrownTypes.iterator();
                this.print(" throws " + this.beautify(((SignatureParser.ThrowsSignature)it.next()).toString()));
                while (it.hasNext()) {
                    this.print(", " + this.beautify(((SignatureParser.ThrowsSignature)it.next()).toString()));
                }
            } else if (!exceptionNames.isEmpty()) {
                it = exceptionNames.iterator();
                this.print(" throws " + this.beautify(((ConstantPool.ConstantClassInfo)it.next()).name));
                while (it.hasNext()) {
                    this.print(", " + this.beautify(((ConstantPool.ConstantClassInfo)it.next()).name));
                }
            }
            ClassFile.AnnotationDefaultAttribute ada = method.annotationDefaultAttribute;
            if (ada != null) {
                this.print("default " + ada.defaultValue);
            }
            if ((ca = method.codeAttribute) == null) {
                this.println(";");
            } else {
                this.println(" {");
                try {
                    this.disassembleBytecode(new ByteArrayInputStream(ca.code), ca.exceptionTable, ca.lineNumberTableAttribute, sourceLines, cf.constantPool, method);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.println("    }");
            }
            this.printAttributes(method.attributes, "    // ", new ClassFile.Attribute[]{method.annotationDefaultAttribute, method.codeAttribute, method.deprecatedAttribute, method.exceptionsAttribute, method.runtimeInvisibleAnnotationsAttribute, method.runtimeInvisibleParameterAnnotationsAttribute, method.runtimeVisibleAnnotationsAttribute, method.runtimeVisibleParameterAnnotationsAttribute, method.signatureAttribute, method.syntheticAttribute}, AttributeContext.METHOD);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException("Method '" + method.name + "' " + method.descriptor, rte);
        }
    }

    private void disassembleFields(List<ClassFile.Field> fields) {
        for (ClassFile.Field field : fields) {
            ClassFile.SignatureAttribute sa;
            ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
            this.println();
            ClassFile.RuntimeInvisibleAnnotationsAttribute riaa = field.runtimeInvisibleAnnotationsAttribute;
            if (riaa != null) {
                for (ClassFile.Annotation a : riaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            if ((rvaa = field.runtimeVisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : rvaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            if ((field.accessFlags & 0x1000) != 0 || field.syntheticAttribute != null) {
                this.println("    // (Synthetic field)");
            }
            if (field.deprecatedAttribute != null) {
                this.println("    /** @deprecated */");
            }
            String parametrizedType = this.beautify((sa = field.signatureAttribute) == null ? this.decodeFieldDescriptor(field.descriptor).toString() : this.decodeFieldTypeSignature(sa.signature).toString());
            String prefix = "    " + Disassembler.decodeAccess((short)(field.accessFlags & 0xFFFFEFFF)) + parametrizedType + " ";
            ClassFile.ConstantValueAttribute cva = field.constantValueAttribute;
            if (cva == null) {
                this.printf("%-40s %s;%n", prefix, field.name);
            } else {
                this.printf("%-40s %-15s = %s;%n", prefix, field.name, cva.constantValue);
            }
            this.printAttributes(field.attributes, "    // ", new ClassFile.Attribute[]{field.constantValueAttribute, field.deprecatedAttribute, field.runtimeInvisibleAnnotationsAttribute, field.runtimeVisibleAnnotationsAttribute, field.signatureAttribute, field.syntheticAttribute}, AttributeContext.FIELD);
        }
    }

    private String toString(ClassFile.InnerClassesAttribute.ClasS c) {
        ConstantPool.ConstantClassInfo oci = c.outerClassInfo;
        ConstantPool.ConstantClassInfo ici = c.innerClassInfo;
        return String.valueOf(oci == null ? "[local class]" : this.beautify(oci.name)) + " { " + Disassembler.decodeAccess((short)(c.innerClassAccessFlags & ((c.innerClassAccessFlags & 0x200) != 0 ? -1033 : 65535))) + ((c.innerClassAccessFlags & 0x6200) == 0 ? "class " : "") + this.beautify(ici.name) + " }";
    }

    private void printAttributes(List<ClassFile.Attribute> attributes, String prefix, ClassFile.Attribute[] excludedAttributes, AttributeContext context) {
        ArrayList<ClassFile.Attribute> tmp = new ArrayList<ClassFile.Attribute>(attributes);
        if (!this.verbose) {
            tmp.removeAll(Arrays.asList(excludedAttributes));
        }
        if (tmp.isEmpty()) {
            return;
        }
        Collections.sort(tmp, new Comparator<ClassFile.Attribute>(){

            @Override
            public int compare(@Nullable ClassFile.Attribute a1, @Nullable ClassFile.Attribute a2) {
                if (!$assertionsDisabled && a1 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && a2 == null) {
                    throw new AssertionError();
                }
                return a1.getName().compareTo(a2.getName());
            }
        });
        this.println(String.valueOf(prefix) + (this.verbose ? "Attributes:" : "Unprocessed attributes:"));
        PrintAttributeVisitor visitor = new PrintAttributeVisitor(String.valueOf(prefix) + "  ", context);
        for (ClassFile.Attribute a : tmp) {
            a.accept(visitor);
        }
    }

    private void printParameters(@Nullable ClassFile.RuntimeInvisibleParameterAnnotationsAttribute ripaa, @Nullable ClassFile.RuntimeVisibleParameterAnnotationsAttribute rvpaa, List<SignatureParser.TypeSignature> parameterTypes, ClassFile.Method method, short firstIndex, boolean varargs) {
        Iterator ipas = (ripaa == null ? NO_PARAMETER_ANNOTATIONS : ripaa.parameterAnnotations).iterator();
        this.print("(");
        Iterator<ClassFile.ParameterAnnotation> vpas = (rvpaa == null ? NO_PARAMETER_ANNOTATIONS : rvpaa.parameterAnnotations).iterator();
        Iterator<SignatureParser.TypeSignature> it = parameterTypes.iterator();
        if (it.hasNext()) {
            while (true) {
                SignatureParser.TypeSignature pts = it.next();
                if (ipas.hasNext()) {
                    for (ClassFile.Annotation a : ((ClassFile.ParameterAnnotation)ipas.next()).annotations) {
                        this.print(String.valueOf(a.toString()) + ' ');
                    }
                }
                if (vpas.hasNext()) {
                    for (ClassFile.Annotation a : vpas.next().annotations) {
                        this.print(String.valueOf(a.toString()) + ' ');
                    }
                }
                if (varargs && !it.hasNext() && pts instanceof SignatureParser.ArrayTypeSignature) {
                    this.print(String.valueOf(this.beautify(((SignatureParser.ArrayTypeSignature)pts).componentTypeSignature.toString())) + "...");
                } else {
                    this.print(this.beautify(pts.toString()));
                }
                this.print(String.valueOf(' ') + this.getLocalVariable((short)firstIndex, (int)0, (ClassFile.Method)method).name);
                if (!it.hasNext()) break;
                firstIndex = (short)(firstIndex + 1);
                this.print(", ");
            }
        }
        this.print(")");
    }

    /*
     * Unable to fully structure code
     */
    private void disassembleBytecode(InputStream is, List<ClassFile.ExceptionTableEntry> exceptionTable, @Nullable ClassFile.LineNumberTableAttribute lineNumberTableAttribute, Map<Integer, String> sourceLines, ConstantPool cp, ClassFile.Method method) throws IOException {
        if (!Disassembler.$assertionsDisabled && this.branchTargets != null) {
            throw new AssertionError();
        }
        this.branchTargets = new HashMap<Integer, String>();
        try {
            block28: {
                block29: {
                    tryStarts = new TreeMap<Integer, HashSet<Integer>>();
                    tryEnds = new TreeMap<Integer, TreeMap<T, V>>();
                    for (ClassFile.ExceptionTableEntry e : exceptionTable) {
                        s = (HashSet<Integer>)tryStarts.get(e.startPc);
                        if (s == null) {
                            s = new HashSet<Integer>();
                            tryStarts.put(e.startPc, s);
                        }
                        s.add(e.endPc);
                        m = (TreeMap<T, ArrayList<ClassFile.ExceptionTableEntry>>)tryEnds.get(e.endPc);
                        if (m == null) {
                            m = new TreeMap<T, ArrayList<ClassFile.ExceptionTableEntry>>(Collections.<T>reverseOrder());
                            tryEnds.put(e.endPc, m);
                        }
                        if ((l = (ArrayList<ClassFile.ExceptionTableEntry>)m.get(e.startPc)) == null) {
                            l = new ArrayList<ClassFile.ExceptionTableEntry>();
                            m.put(e.startPc, l);
                        }
                        l.add(e);
                    }
                    cis = new CountingInputStream(is);
                    dis = new DataInputStream(cis);
                    lines = new TreeMap<Integer, String>();
                    block6: while (true) {
                        instructionOffset = (int)cis.getCount();
                        opcode = dis.read();
                        if (opcode == -1) break block28;
                        instruction = Disassembler.OPCODE_TO_INSTRUCTION[opcode];
                        if (instruction == null) {
                            lines.put(instructionOffset, "??? (invalid opcode \"" + opcode + "\")");
                            continue;
                        }
                        try {
                            lines.put(instructionOffset, String.valueOf(instruction.getMnemonic()) + this.disassembleOperands(instruction.getOperands(), dis, instructionOffset, method, cp));
                        }
                        catch (RuntimeException rte) {
                            it = lines.entrySet().iterator();
lbl45:
                            // 2 sources

                            while (it.hasNext()) {
                                break block6;
                            }
                            break block29;
                        }
                    }
                    e = it.next();
                    this.println("#" + e.getKey() + " " + (String)e.getValue());
                    ** GOTO lbl45
                }
                throw new RuntimeException("Instruction '" + instruction + "', pc=" + instructionOffset, rte);
            }
            indentation = "        ";
            for (Map.Entry<K, V> e : lines.entrySet()) {
                instructionOffset = (Integer)e.getKey();
                text = (String)e.getValue();
                it = tryEnds.entrySet().iterator();
                while (it.hasNext()) {
                    e2 = it.next();
                    endPc = (Integer)e2.getKey();
                    if (endPc > instructionOffset) break;
                    startPc2Ete = (SortedMap)e2.getValue();
                    for (List etes : startPc2Ete.values()) {
                        if (endPc < instructionOffset) {
                            this.error("Exception table entry ends at invalid code array index " + endPc + " (current instruction offset is " + instructionOffset + ")");
                        }
                        indentation = indentation.substring(4);
                        this.print(String.valueOf(indentation) + "} catch (");
                        it2 = etes.iterator();
                        while (true) {
                            ete = (ClassFile.ExceptionTableEntry)it2.next();
                            ct = ete.catchType;
                            this.print(String.valueOf(ct == null ? "[all exceptions]" : this.beautify(ct.name)) + " => " + this.branchTarget(ete.handlerPc));
                            if (!it2.hasNext()) break;
                            this.print(", ");
                        }
                        this.println(")");
                    }
                    it.remove();
                }
                bts = this.branchTargets;
                if (!Disassembler.$assertionsDisabled && bts == null) {
                    throw new AssertionError();
                }
                label = bts.get(instructionOffset);
                if (label != null) {
                    this.println(label);
                }
                it = tryStarts.entrySet().iterator();
                while (it.hasNext()) {
                    sc = it.next();
                    startPc = (Integer)sc.getKey();
                    if (startPc > instructionOffset) break;
                    i = ((Set)sc.getValue()).size();
                    while (i > 0) {
                        if (startPc < instructionOffset) {
                            this.error("Exception table entry starts at invalid code array index " + startPc + " (current instruction offset is " + instructionOffset + ")");
                        }
                        this.println(String.valueOf(indentation) + "try {");
                        indentation = String.valueOf(indentation) + "    ";
                        --i;
                    }
                    it.remove();
                }
                if (!(lineNumberTableAttribute == null || (lineNumber = Disassembler.findLineNumber(lineNumberTableAttribute, instructionOffset)) == -1 || (sourceLine = sourceLines.get(lineNumber)) == null && this.hideLines)) {
                    sb = new StringBuilder(indentation);
                    if (sourceLine == null) {
                        sb.append("// Line ").append(lineNumber);
                    } else {
                        sb.append("// ");
                        if (sb.length() < 40) {
                            spc = new char[40 - sb.length()];
                            Arrays.fill(spc, ' ');
                            sb.append(spc);
                        }
                        if (!this.hideLines) {
                            sb.append("Line ").append(lineNumber).append(": ");
                        }
                        sb.append(sourceLine);
                    }
                    this.println(sb.toString());
                }
                this.println(String.valueOf(indentation) + text);
            }
        }
        finally {
            this.branchTargets = null;
        }
    }

    @Nullable
    private String branchTarget(int offset) {
        Map<Integer, String> bts = this.branchTargets;
        assert (bts != null);
        String label = bts.get(offset);
        if (label == null) {
            label = this.symbolicLabels ? "L" + (1 + bts.size()) : "#" + offset;
            bts.put(offset, label);
        }
        return label;
    }

    private static int findLineNumber(ClassFile.LineNumberTableAttribute lnta, int offset) {
        for (ClassFile.LineNumberTableEntry lnte : lnta.entries) {
            if (lnte.startPc != offset) continue;
            return lnte.lineNumber;
        }
        return -1;
    }

    String disassembleOperands(Operand[] operands, DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < operands.length) {
            sb.append(operands[i].disassemble(dis, instructionOffset, method, cp, this));
            ++i;
        }
        return sb.toString();
    }

    private static Instruction[] compileInstructions(String instructions) {
        Instruction[] result = new Instruction[256];
        StringTokenizer st1 = new StringTokenizer(instructions, "\n");
        while (st1.hasMoreTokens()) {
            Operand[] operands;
            StringTokenizer st2 = new StringTokenizer(st1.nextToken());
            int opcode = Integer.parseInt(st2.nextToken());
            String mnemonic = st2.nextToken();
            if (!st2.hasMoreTokens()) {
                operands = new Operand[]{};
            } else {
                ArrayList<2> l = new ArrayList<2>();
                while (st2.hasMoreTokens()) {
                    Operand operand;
                    String s = st2.nextToken();
                    if ("intfloatclassstring1".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = (short)(0xFF & dis.readByte());
                                String t = cp.getIntegerFloatClassString(index);
                                if (Character.isJavaIdentifierStart(t.charAt(0))) {
                                    t = d.beautify(t);
                                }
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("intfloatclassstring2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                String t = cp.getIntegerFloatClassString(index);
                                if (Character.isJavaIdentifierStart(t.charAt(0))) {
                                    t = d.beautify(t);
                                }
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("longdouble2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                String t = cp.getLongDoubleString(index);
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("fieldref2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                ConstantPool.ConstantFieldrefInfo fr = cp.get(index, ConstantPool.ConstantFieldrefInfo.class);
                                String t = String.valueOf(d.beautify(d.decodeFieldDescriptor(fr.nameAndType.descriptor.bytes).toString())) + ' ' + d.beautify(fr.clasS.name) + '.' + fr.nameAndType.name.bytes;
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("methodref2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                ConstantPool.ConstantMethodrefInfo mr = cp.get(index, ConstantPool.ConstantMethodrefInfo.class);
                                String t = d.beautify(d.decodeMethodDescriptor(mr.nameAndType.descriptor.bytes).toString(mr.clasS.name, mr.nameAndType.name.bytes));
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("interfacemethodref2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                dis.readByte();
                                dis.readByte();
                                ConstantPool.ConstantInterfaceMethodrefInfo imr = cp.get(index, ConstantPool.ConstantInterfaceMethodrefInfo.class);
                                String t = d.beautify(d.decodeMethodDescriptor(imr.nameAndType.descriptor.bytes).toString(imr.clasS.name, imr.nameAndType.name.bytes));
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("class2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                String name = cp.get((short)index, ConstantPool.ConstantClassInfo.class).name;
                                String t = d.beautify(name.startsWith("[") ? d.decodeFieldDescriptor(name).toString() : name.replace('/', '.'));
                                if (d.verbose) {
                                    t = String.valueOf(t) + " (" + (0xFFFF & index) + ")";
                                }
                                return String.valueOf(' ') + t;
                            }
                        };
                    } else if ("localvariableindex1".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                byte index = dis.readByte();
                                LocalVariable lv = d.getLocalVariable((short)(0xFF & index), instructionOffset + 2, method);
                                return d.beautify(lv.toString());
                            }
                        };
                    } else if ("localvariableindex2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                LocalVariable lv = d.getLocalVariable(index, instructionOffset + 4, method);
                                return d.beautify(lv.toString());
                            }
                        };
                    } else if ("implicitlocalvariableindex".equals(s)) {
                        final short index = Short.parseShort(mnemonic.substring(mnemonic.length() - 1));
                        mnemonic = mnemonic.substring(0, mnemonic.length() - 2);
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) {
                                LocalVariable lv = d.getLocalVariable(index, instructionOffset + 1, method);
                                return d.beautify(lv.toString());
                            }
                        };
                    } else if ("branchoffset2".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                return " " + d.branchTarget(instructionOffset + dis.readShort());
                            }
                        };
                    } else if ("branchoffset4".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                return " " + d.branchTarget(instructionOffset + dis.readInt());
                            }
                        };
                    } else if ("signedbyte".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                return " " + dis.readByte();
                            }
                        };
                    } else if ("unsignedbyte".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                return " " + (0xFF & dis.readByte());
                            }
                        };
                    } else if ("atype".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                byte b = dis.readByte();
                                return b == 4 ? " BOOLEAN" : (b == 5 ? " CHAR" : (b == 6 ? " FLOAT" : (b == 7 ? " DOUBLE" : (b == 8 ? " BYTE" : (b == 9 ? " SHORT" : (b == 10 ? " INT" : (b == 11 ? " LONG" : " " + (0xFF & b))))))));
                            }
                        };
                    } else if ("signedshort".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                return " " + dis.readShort();
                            }
                        };
                    } else if ("tableswitch".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                int npads = 3 - instructionOffset % 4;
                                int i = 0;
                                while (i < npads) {
                                    byte padByte = dis.readByte();
                                    if (padByte != 0) {
                                        throw new RuntimeException("'tableswitch' pad byte #" + i + " is not zero, but " + (0xFF & padByte));
                                    }
                                    ++i;
                                }
                                StringBuilder sb = new StringBuilder(" default => ");
                                sb.append(d.branchTarget(instructionOffset + dis.readInt()));
                                int low = dis.readInt();
                                int high = dis.readInt();
                                int i2 = low;
                                while (i2 <= high) {
                                    sb.append(", ").append(i2).append(" => ");
                                    sb.append(d.branchTarget(instructionOffset + dis.readInt()));
                                    ++i2;
                                }
                                return sb.toString();
                            }
                        };
                    } else if ("lookupswitch".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                int npads = 3 - instructionOffset % 4;
                                int i = 0;
                                while (i < npads) {
                                    byte padByte = dis.readByte();
                                    if (padByte != 0) {
                                        throw new RuntimeException("'tableswitch' pad byte #" + i + " is not zero, but " + (0xFF & padByte));
                                    }
                                    ++i;
                                }
                                StringBuilder sb = new StringBuilder(" default => ");
                                sb.append(d.branchTarget(instructionOffset + dis.readInt()));
                                int npairs = dis.readInt();
                                int i2 = 0;
                                while (i2 < npairs) {
                                    int match = dis.readInt();
                                    int offset = instructionOffset + dis.readInt();
                                    sb.append(", ").append(match).append(" => ").append(d.branchTarget(offset));
                                    ++i2;
                                }
                                return sb.toString();
                            }
                        };
                    } else if ("dynamiccallsite".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                short index = dis.readShort();
                                if (dis.readByte() != 0 || dis.readByte() != 0) {
                                    throw new RuntimeException("'invokevirtual' pad byte is not zero");
                                }
                                ClassFile.BootstrapMethodsAttribute.BootstrapMethod bm = method.getBootstrapMethodsAttribute().bootstrapMethods.get(cp.get((short)index, ConstantPool.ConstantInvokeDynamicInfo.class).bootstrapMethodAttrIndex);
                                return " " + bm + "." + cp.get((short)index, ConstantPool.ConstantInvokeDynamicInfo.class).nameAndType;
                            }
                        };
                    } else if ("wide".equals(s)) {
                        operand = new Operand(){

                            @Override
                            public String disassemble(DataInputStream dis, int instructionOffset, ClassFile.Method method, ConstantPool cp, Disassembler d) throws IOException {
                                int subopcode = 0xFF & dis.readByte();
                                Instruction wideInstruction = OPCODE_TO_WIDE_INSTRUCTION[subopcode];
                                if (wideInstruction == null) {
                                    return "Invalid opcode " + subopcode + " after opcode WIDE";
                                }
                                return String.valueOf(wideInstruction.getMnemonic()) + d.disassembleOperands(wideInstruction.getOperands(), dis, instructionOffset, method, cp);
                            }
                        };
                    } else {
                        throw new RuntimeException("Unknown operand \"" + s + "\"");
                    }
                    l.add(operand);
                }
                operands = l.toArray(new Operand[l.size()]);
            }
            mnemonic = String.valueOf(mnemonic) + "               ".substring(mnemonic.length());
            result[opcode] = new Instruction(mnemonic, operands);
        }
        return result;
    }

    private LocalVariable getLocalVariable(short localVariableIndex, int instructionOffset, ClassFile.Method method) {
        short firstParameter;
        short s = firstParameter = (method.accessFlags & 8) == 0 ? (short)1 : 0;
        if (localVariableIndex < firstParameter) {
            return new LocalVariable(null, "this");
        }
        ClassFile.SignatureAttribute sa = method.signatureAttribute;
        SignatureParser.MethodTypeSignature mts = sa != null ? this.decodeMethodTypeSignature(sa.signature) : this.decodeMethodDescriptor(method.descriptor);
        List<SignatureParser.TypeSignature> parameterTypes = mts.parameterTypes;
        int firstLocalVariable = firstParameter + parameterTypes.size();
        String defaultName = localVariableIndex < firstLocalVariable ? "p" + (1 + localVariableIndex - firstParameter) : "v" + (1 + localVariableIndex - firstLocalVariable);
        ClassFile.CodeAttribute ca = method.codeAttribute;
        if (!(ca == null || localVariableIndex < firstLocalVariable && this.hideVars)) {
            ClassFile.LocalVariableTableAttribute lvta;
            ClassFile.LocalVariableTypeTableAttribute lvtta = ca.localVariableTypeTableAttribute;
            if (lvtta != null) {
                for (ClassFile.LocalVariableTypeTableAttribute.Entry lvtte : lvtta.entries) {
                    if (instructionOffset < lvtte.startPC || instructionOffset > lvtte.startPC + lvtte.length || localVariableIndex != lvtte.index) continue;
                    return new LocalVariable(this.decodeFieldTypeSignature(lvtte.signature), this.hideVars ? defaultName : lvtte.name);
                }
            }
            if ((lvta = ca.localVariableTableAttribute) != null) {
                for (ClassFile.LocalVariableTableAttribute.Entry lvte : lvta.entries) {
                    if (instructionOffset < lvte.startPC || instructionOffset > lvte.startPC + lvte.length || localVariableIndex != lvte.index) continue;
                    return new LocalVariable(this.decodeFieldDescriptor(lvte.descriptor), this.hideVars ? defaultName : lvte.name);
                }
            }
        }
        if (localVariableIndex < firstLocalVariable) {
            return new LocalVariable(parameterTypes.get(localVariableIndex - firstParameter), defaultName);
        }
        return new LocalVariable(null, defaultName);
    }

    private SignatureParser.ClassSignature decodeClassSignature(String cs) {
        try {
            return SignatureParser.decodeClassSignature(cs);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding class signature '" + cs + "': " + e.getMessage());
            return new SignatureParser.ClassSignature(NO_FORMAL_TYPE_PARAMETERS, SignatureParser.OBJECT, NO_CLASS_TYPE_SIGNATURES);
        }
    }

    private SignatureParser.FieldTypeSignature decodeFieldTypeSignature(String fs) {
        try {
            return SignatureParser.decodeFieldTypeSignature(fs);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding field type signature '" + fs + "': " + e.getMessage());
            return SignatureParser.OBJECT;
        }
    }

    private SignatureParser.MethodTypeSignature decodeMethodTypeSignature(String ms) {
        try {
            return SignatureParser.decodeMethodTypeSignature(ms);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding method type signature '" + ms + "': " + e.getMessage());
            return new SignatureParser.MethodTypeSignature(NO_FORMAL_TYPE_PARAMETERS, NO_TYPE_SIGNATURES, SignatureParser.VOID, NO_THROWS_SIGNATURES);
        }
    }

    private SignatureParser.TypeSignature decodeFieldDescriptor(String fd) {
        try {
            return SignatureParser.decodeFieldDescriptor(fd);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding field descriptor '" + fd + "': " + e.getMessage());
            return SignatureParser.INT;
        }
    }

    private SignatureParser.MethodTypeSignature decodeMethodDescriptor(String md) {
        try {
            return SignatureParser.decodeMethodDescriptor(md);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding method descriptor '" + md + "': " + e.getMessage());
            return new SignatureParser.MethodTypeSignature(NO_FORMAL_TYPE_PARAMETERS, NO_TYPE_SIGNATURES, SignatureParser.VOID, NO_THROWS_SIGNATURES);
        }
    }

    private void error(String message) {
        this.pw.println("*** Error: " + message);
    }

    private static String decodeAccess(short n) {
        StringBuilder sb = new StringBuilder();
        if ((n & 1) != 0) {
            sb.append("public ");
            n = (short)(n & 0xFFFFFFFE);
        }
        if ((n & 2) != 0) {
            sb.append("private ");
            n = (short)(n & 0xFFFFFFFD);
        }
        if ((n & 4) != 0) {
            sb.append("protected ");
            n = (short)(n & 0xFFFFFFFB);
        }
        if ((n & 0x400) != 0) {
            sb.append("abstract ");
            n = (short)(n & 0xFFFFFBFF);
        }
        if ((n & 8) != 0) {
            sb.append("static ");
            n = (short)(n & 0xFFFFFFF7);
        }
        if ((n & 0x10) != 0) {
            sb.append("final ");
            n = (short)(n & 0xFFFFFFEF);
        }
        if ((n & 0x80) != 0) {
            sb.append("transient ");
            n = (short)(n & 0xFFFFFF7F);
        }
        if ((n & 0x40) != 0) {
            sb.append("volatile ");
            n = (short)(n & 0xFFFFFFBF);
        }
        if ((n & 0x20) != 0) {
            sb.append("synchronized ");
            n = (short)(n & 0xFFFFFFDF);
        }
        if ((n & 0x100) != 0) {
            sb.append("native ");
            n = (short)(n & 0xFFFFFEFF);
        }
        if ((n & 0x800) != 0) {
            sb.append("strictfp ");
            n = (short)(n & 0xFFFFF7FF);
        }
        if ((n & 0x1000) != 0) {
            sb.append("synthetic ");
            n = (short)(n & 0xFFFFEFFF);
        }
        if ((n & 0x2000) != 0) {
            sb.append("@");
            n = (short)(n & 0xFFFFDFFF);
        }
        if ((n & 0x200) != 0) {
            sb.append("interface ");
            n = (short)(n & 0xFFFFFDFF);
        }
        if ((n & 0x4000) != 0) {
            sb.append("enum ");
            n = (short)(n & 0xFFFFBFFF);
        }
        if (n != 0) {
            sb.append("+ " + n + " ");
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String beautify(String s) {
        i = 0;
        block0: while (true) {
            if (i == s.length()) {
                return s;
            }
            if (!Character.isJavaIdentifierStart(s.charAt(i))) {
                ++i;
                continue;
            }
            var6_7 = new String[]{"java.lang.", this.thisClassPackageName};
            var5_6 = var6_7.length;
            var4_5 = 0;
            while (var4_5 < var5_6) {
                pkg = var6_7[var4_5];
                if (s.substring(i).startsWith(pkg)) {
                    s = String.valueOf(s.substring(0, i)) + s.substring(i + pkg.length());
                    break;
                }
                ++var4_5;
            }
            while (true) {
                if (i == s.length()) {
                    return s;
                }
                c = s.charAt(i);
                if (c == '.' || Character.isJavaIdentifierPart(c)) ** break;
                continue block0;
                ++i;
            }
            break;
        }
    }

    private static enum AttributeContext {
        CLASS,
        FIELD,
        METHOD;

    }

    @NotNullByDefault(value=false)
    private static class CountingInputStream
    extends FilterInputStream {
        private long count;

        CountingInputStream(InputStream is) {
            super(is);
        }

        @Override
        public int read() throws IOException {
            int res = super.read();
            if (res != -1) {
                ++this.count;
            }
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = super.read(b, off, len);
            if (res != -1) {
                this.count += (long)res;
            }
            return res;
        }

        public long getCount() {
            return this.count;
        }
    }

    private static class Instruction {
        private final String mnemonic;
        private final Operand[] operands;

        Instruction(String mnemonic, Operand[] operands) {
            this.mnemonic = mnemonic;
            this.operands = operands;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public Operand[] getOperands() {
            return this.operands;
        }

        public String toString() {
            return this.mnemonic;
        }
    }

    class LocalVariable {
        @Nullable
        final SignatureParser.TypeSignature typeSignature;
        final String name;

        LocalVariable(SignatureParser.TypeSignature typeSignature, String name) {
            this.typeSignature = typeSignature;
            this.name = name;
        }

        public String toString() {
            SignatureParser.TypeSignature ts = this.typeSignature;
            return ts == null ? " [" + this.name + ']' : " [" + ts.toString() + ' ' + this.name + ']';
        }
    }

    private static interface Operand {
        public String disassemble(DataInputStream var1, int var2, ClassFile.Method var3, ConstantPool var4, Disassembler var5) throws IOException;
    }

    public class PrintAttributeVisitor
    implements ClassFile.AttributeVisitor {
        private final String prefix;
        private final AttributeContext context;

        public PrintAttributeVisitor(String prefix, AttributeContext context) {
            this.prefix = prefix;
            this.context = context;
        }

        @Override
        public void visit(ClassFile.AnnotationDefaultAttribute ada) {
            Disassembler.this.println(String.valueOf(this.prefix) + "AnnotationDefault:");
            Disassembler.this.println(String.valueOf(this.prefix) + "  " + ada.defaultValue.toString());
        }

        @Override
        public void visit(ClassFile.BootstrapMethodsAttribute bma) {
            Disassembler.this.println(String.valueOf(this.prefix) + "BootstrapMethods:");
            for (ClassFile.BootstrapMethodsAttribute.BootstrapMethod bm : bma.bootstrapMethods) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + bm);
            }
        }

        @Override
        public void visit(ClassFile.CodeAttribute ca) {
            Disassembler.this.println(String.valueOf(this.prefix) + "Code:");
            Disassembler.this.println(String.valueOf(this.prefix) + "  max_locals = " + ca.maxLocals);
            Disassembler.this.println(String.valueOf(this.prefix) + "  max_stack = " + ca.maxStack);
            Disassembler.this.println(String.valueOf(this.prefix) + "  code = {");
            this.print(ca.code);
            Disassembler.this.println(String.valueOf(this.prefix) + "  }");
            if (!ca.attributes.isEmpty()) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  attributes = {");
                PrintAttributeVisitor pav = new PrintAttributeVisitor(String.valueOf(this.prefix) + "    ", AttributeContext.METHOD);
                List<ClassFile.Attribute> tmp = ca.attributes;
                Collections.sort(tmp, new Comparator<ClassFile.Attribute>(){

                    @Override
                    public int compare(@Nullable ClassFile.Attribute a1, @Nullable ClassFile.Attribute a2) {
                        if (!$assertionsDisabled && a1 == null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && a2 == null) {
                            throw new AssertionError();
                        }
                        return a1.getName().compareTo(a2.getName());
                    }
                });
                for (ClassFile.Attribute a : tmp) {
                    a.accept(pav);
                }
                Disassembler.this.println(String.valueOf(this.prefix) + "  }");
            }
        }

        private void print(byte[] data) {
            int i = 0;
            while (i < data.length) {
                Disassembler.this.print(String.valueOf(this.prefix) + "   ");
                int j = 0;
                while (j < 32) {
                    int idx = i + j;
                    if (idx >= data.length) break;
                    Disassembler.this.printf("%c%02x", new Object[]{Character.valueOf(j == 16 ? (char)'-' : ' '), 0xFF & data[idx]});
                    ++j;
                }
                Disassembler.this.println();
                i += 32;
            }
        }

        @Override
        public void visit(ClassFile.ConstantValueAttribute cva) {
            Disassembler.this.println(String.valueOf(this.prefix) + "ConstantValue:");
            Disassembler.this.println(String.valueOf(this.prefix) + "  constant_value = " + cva.constantValue);
        }

        @Override
        public void visit(ClassFile.DeprecatedAttribute da) {
            Disassembler.this.println(String.valueOf(this.prefix) + "DeprecatedAttribute:");
            Disassembler.this.println(String.valueOf(this.prefix) + "  -");
        }

        @Override
        public void visit(ClassFile.EnclosingMethodAttribute ema) {
            Disassembler.this.println(String.valueOf(this.prefix) + "EnclosingMethod:");
            ConstantPool.ConstantNameAndTypeInfo m = ema.method;
            Disassembler.this.println(String.valueOf(this.prefix) + "  class/method = " + (m == null ? "(none)" : Disassembler.this.beautify(Disassembler.this.decodeMethodDescriptor(m.descriptor.bytes).toString(ema.clasS.name, m.name.bytes))));
        }

        @Override
        public void visit(ClassFile.ExceptionsAttribute ea) {
            Disassembler.this.println(String.valueOf(this.prefix) + "Exceptions:");
            for (ConstantPool.ConstantClassInfo en : ea.exceptionNames) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + en.name);
            }
        }

        @Override
        public void visit(ClassFile.InnerClassesAttribute ica) {
            Disassembler.this.println(String.valueOf(this.prefix) + "InnerClasses:");
            for (ClassFile.InnerClassesAttribute.ClasS c : ica.classes) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + Disassembler.this.toString(c));
            }
        }

        @Override
        public void visit(ClassFile.LineNumberTableAttribute lnta) {
            Disassembler.this.println(String.valueOf(this.prefix) + "LineNumberTable:");
            for (ClassFile.LineNumberTableEntry e : lnta.entries) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + e.startPc + " => Line " + e.lineNumber);
            }
        }

        @Override
        public void visit(ClassFile.LocalVariableTableAttribute lvta) {
            Disassembler.this.println(String.valueOf(this.prefix) + "LocalVariableTable:");
            for (ClassFile.LocalVariableTableAttribute.Entry e : lvta.entries) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + (0xFFFF & e.startPC) + "+" + e.length + ": " + e.index + " = " + Disassembler.this.beautify(Disassembler.this.decodeFieldDescriptor(e.descriptor).toString()) + " " + e.name);
            }
        }

        @Override
        public void visit(ClassFile.LocalVariableTypeTableAttribute lvtta) {
            Disassembler.this.println(String.valueOf(this.prefix) + "LocalVariableTypeTable:");
            for (ClassFile.LocalVariableTypeTableAttribute.Entry e : lvtta.entries) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + e.startPC + "+" + e.length + ": " + e.index + " = " + Disassembler.this.beautify(Disassembler.this.decodeFieldTypeSignature(e.signature).toString()) + " " + e.name);
            }
        }

        @Override
        public void visit(ClassFile.RuntimeInvisibleAnnotationsAttribute riaa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "RuntimeInvisibleAnnotations:");
            for (ClassFile.Annotation a : riaa.annotations) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + a.toString());
            }
        }

        @Override
        public void visit(ClassFile.RuntimeVisibleAnnotationsAttribute rvaa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "RuntimeVisibleAnnotations:");
            for (ClassFile.Annotation a : rvaa.annotations) {
                Disassembler.this.println(String.valueOf(this.prefix) + "  " + a.toString());
            }
        }

        @Override
        public void visit(ClassFile.RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "RuntimeInvisibleParameterAnnotations:");
            for (ClassFile.ParameterAnnotation pa : ripaa.parameterAnnotations) {
                for (ClassFile.Annotation a : pa.annotations) {
                    Disassembler.this.println(String.valueOf(this.prefix) + "  " + a.toString());
                }
            }
        }

        @Override
        public void visit(ClassFile.RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "RuntimeVisibleParameterAnnotations:");
            for (ClassFile.ParameterAnnotation pa : rvpaa.parameterAnnotations) {
                for (ClassFile.Annotation a : pa.annotations) {
                    Disassembler.this.println(String.valueOf(this.prefix) + "  " + a.toString());
                }
            }
        }

        @Override
        public void visit(ClassFile.SignatureAttribute sa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "Signature:");
            switch (this.context) {
                case CLASS: {
                    Disassembler.this.println(String.valueOf(this.prefix) + "  " + Disassembler.this.decodeClassSignature(sa.signature).toString("[this-class]"));
                    break;
                }
                case FIELD: {
                    Disassembler.this.println(String.valueOf(this.prefix) + "  " + Disassembler.this.decodeFieldTypeSignature(sa.signature).toString());
                    break;
                }
                case METHOD: {
                    Disassembler.this.println(String.valueOf(this.prefix) + "  " + Disassembler.this.decodeMethodTypeSignature(sa.signature).toString("[declaring-class]", "[this-method]"));
                }
            }
        }

        @Override
        public void visit(ClassFile.SourceFileAttribute sfa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "SourceFile:");
            Disassembler.this.println(String.valueOf(this.prefix) + "  " + sfa.sourceFile);
        }

        @Override
        public void visit(ClassFile.SyntheticAttribute sa) {
            Disassembler.this.println(String.valueOf(this.prefix) + "Synthetic:");
            Disassembler.this.println(String.valueOf(this.prefix) + " -");
        }

        @Override
        public void visit(ClassFile.UnknownAttribute ua) {
            Disassembler.this.println(String.valueOf(this.prefix) + ua.name + ":");
            Disassembler.this.println(String.valueOf(this.prefix) + "  data = {");
            this.print(ua.info);
            Disassembler.this.println(String.valueOf(this.prefix) + "}");
        }
    }
}

