/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;

public abstract class CommandLineOptionException
extends Exception {
    private static final long serialVersionUID = 1L;

    private static String join(String[] optionNames) {
        switch (optionNames.length) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return '\"' + optionNames[0] + '\"';
            }
        }
        StringBuilder sb = new StringBuilder("\"");
        int i = 0;
        while (true) {
            sb.append(optionNames[i++]);
            if (i == optionNames.length) {
                return sb.append('\"').toString();
            }
            sb.append(i == optionNames.length - 1 ? "\" and \"" : "\", \"");
        }
    }

    public CommandLineOptionException(String message) {
        super(message);
    }

    public CommandLineOptionException(String message, Throwable cause) {
        super(message, cause);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public static class ArgumentConversionFailed
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final String argument;
        private final Class<?> targetType;

        protected ArgumentConversionFailed(String argument, Class<?> targetType, Throwable cause) {
            super("Converting option argument \"" + argument + "\" to \"" + targetType.getSimpleName() + ": " + cause.getMessage(), cause);
            this.argument = argument;
            this.targetType = targetType;
        }

        public String getArgument() {
            return this.argument;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }
    }

    public static class ConflictingOptions
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final CommandLineOptionGroup optionGroup;
        private final CommandLineOption option;
        private final String optionName;

        protected ConflictingOptions(CommandLineOptionGroup optionGroup, CommandLineOption option, String optionName) {
            super("Option \"" + optionName + "\" is exclusive with a preceding option");
            this.optionGroup = optionGroup;
            this.option = option;
            this.optionName = optionName;
        }

        public CommandLineOptionGroup getOptionGroup() {
            return this.optionGroup;
        }

        public CommandLineOption getOption() {
            return this.option;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static class DuplicateOption
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final CommandLineOption option;
        private final String optionName;
        private final String[] optionNames;

        protected DuplicateOption(CommandLineOption option, String optionName, String[] optionNames) {
            super("Option \"" + optionName + "\" must appear at most once");
            this.option = option;
            this.optionName = optionName;
            this.optionNames = optionNames;
        }

        public CommandLineOption getOption() {
            return this.option;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public String[] getOptionNames() {
            return this.optionNames;
        }
    }

    public static class OptionArgumentMissing
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final CommandLineOption option;
        private final String optionName;
        private final int argumentIndex;

        protected OptionArgumentMissing(CommandLineOption option, String optionName, int argumentIndex) {
            super("Argument #" + (argumentIndex + 1) + " for command line option \"" + optionName + "\" is missing");
            this.option = option;
            this.optionName = optionName;
            this.argumentIndex = argumentIndex;
        }

        public CommandLineOption getOption() {
            return this.option;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public int getArgumentIndex() {
            return this.argumentIndex;
        }
    }

    public static class RequiredOptionGroupMissing
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final CommandLineOptionGroup optionGroup;
        private final String[] optionNames;

        protected RequiredOptionGroupMissing(CommandLineOptionGroup optionGroup, String[] optionNames) {
            super(optionGroup.cardinality() == CommandLineOptionGroup.Cardinality.EXACTLY_ONE ? "Exactly one of " + CommandLineOptionException.join(optionNames) + " must be specified" : "One or more of " + CommandLineOptionException.join(optionNames) + " must be specified");
            this.optionGroup = optionGroup;
            this.optionNames = optionNames;
        }

        public CommandLineOptionGroup getOptionGroup() {
            return this.optionGroup;
        }

        public String[] getOptionNames() {
            return this.optionNames;
        }
    }

    public static class RequiredOptionMissing
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final CommandLineOption option;
        private final String[] optionNames;

        protected RequiredOptionMissing(CommandLineOption option, String[] optionNames) {
            super(optionNames.length == 1 ? "Required command line option \"" + optionNames[0] + "\" is missing" : "Exactly one of command line options " + CommandLineOptionException.join(optionNames) + " must be given");
            this.option = option;
            this.optionNames = optionNames;
        }

        public CommandLineOption getOption() {
            return this.option;
        }

        public String[] getOptionNames() {
            return this.optionNames;
        }
    }

    public static class UnrecognizedOption
    extends CommandLineOptionException {
        private static final long serialVersionUID = 1L;
        private final String optionName;

        protected UnrecognizedOption(String optionName) {
            super("Unrecognized command line option \"" + optionName + "\"");
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }
}

