/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.parser;

import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.util.Arrays;

public class AbstractParser<TT extends Enum<TT>> {
    protected final ProducerWhichThrows<? extends AbstractScanner.Token<TT>, ? extends ScanException> scanner;
    @Nullable
    private AbstractScanner.Token<TT> current;

    public AbstractParser(ProducerWhichThrows<? extends AbstractScanner.Token<TT>, ? extends ScanException> scanner) {
        this.scanner = scanner;
    }

    @Nullable
    public AbstractScanner.Token<TT> peek() throws ParseException {
        if (this.current == null) {
            this.current = this.produceToken();
        }
        return this.current;
    }

    @Nullable
    public String peek(TT tokenType) throws ParseException {
        this.peek();
        return this.current != null && this.current.type == tokenType ? this.current.text : null;
    }

    public boolean peek(@Nullable String text) throws ParseException {
        this.peek();
        AbstractScanner.Token<TT> current = this.current;
        return current == null ? text == null : current.text.equals(text);
    }

    public int peek(Object ... tokenTypeOrText) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        for (int i = 0; i < tokenTypeOrText.length; ++i) {
            Object ttot = tokenTypeOrText[i];
            if (!(c == null ? ttot == null : ((Enum)c.type).equals(ttot) || c.text.equals(ttot))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public String peekRead(TT tokenType) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null || c.type != tokenType) {
            return null;
        }
        String result = c.text;
        this.current = null;
        return result;
    }

    public boolean peekRead(@Nullable String text) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null) {
            return text == null;
        }
        if (!c.text.equals(text)) {
            return false;
        }
        this.current = null;
        return true;
    }

    public int peekRead(String ... texts) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null) {
            return -1;
        }
        for (int i = 0; i < texts.length; ++i) {
            if (!c.text.equals(texts[i])) continue;
            this.current = null;
            return i;
        }
        return -1;
    }

    @Nullable
    public <T extends Enum<T>> T peekReadEnum(T ... values) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null) {
            return null;
        }
        for (T value : values) {
            if (!c.text.equals(((Enum)value).toString())) continue;
            this.current = null;
            return value;
        }
        return null;
    }

    @Nullable
    public AbstractScanner.Token<TT> peekRead(TT ... tokenTypes) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null) {
            return null;
        }
        for (TT tokenType : tokenTypes) {
            if (c.type != tokenType) continue;
            this.current = null;
            return c;
        }
        return null;
    }

    public AbstractScanner.Token<TT> read() throws ParseException {
        if (this.current != null) {
            AbstractScanner.Token<TT> result = this.current;
            this.current = null;
            return result;
        }
        AbstractScanner.Token<TT> result = this.produceToken();
        if (result == null) {
            throw new ParseException("Unexpected end of input");
        }
        return result;
    }

    public String read(TT tokenType) throws ParseException {
        AbstractScanner.Token<TT> result = this.read();
        if (result.type != tokenType) {
            throw new ParseException("'" + tokenType + "' expected instead of '" + result + "'");
        }
        return result.text;
    }

    public void read(String text) throws ParseException {
        AbstractScanner.Token<TT> t = this.read();
        if (!t.text.equals(text)) {
            throw new ParseException("'" + text + "' expected instead of '" + t + "'");
        }
    }

    public int read(Object ... tokenTypeOrText) throws ParseException {
        AbstractScanner.Token<TT> c = this.peek();
        if (c == null) {
            throw new ParseException("One of " + Arrays.toString(tokenTypeOrText) + " expected instead of end-of-input");
        }
        for (int i = 0; i < tokenTypeOrText.length; ++i) {
            Object ttot = tokenTypeOrText[i];
            if (!((Enum)c.type).equals(ttot) && !c.text.equals(ttot)) continue;
            this.current = null;
            return i;
        }
        throw new ParseException("One of " + Arrays.toString(tokenTypeOrText) + " expected instead of '" + c + "'");
    }

    public void eoi() throws ParseException {
        AbstractScanner.Token<TT> t = this.peek();
        if (t != null) {
            throw new ParseException("Expected end-of-input instead of '" + t + "'");
        }
    }

    @Nullable
    private AbstractScanner.Token<TT> produceToken() throws ParseException {
        try {
            return this.scanner.produce();
        }
        catch (ScanException se) {
            throw new ParseException(se);
        }
    }
}

