/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class CompressionURLStreamHandler
extends URLStreamHandler {
    protected abstract InputStream open(InputStream var1) throws IOException;

    @Override
    protected URLConnection openConnection(@Nullable URL url) {
        assert (url != null);
        return new URLConnection(url){
            @Nullable
            private URL container;

            @Override
            public void connect() throws IOException {
                if (this.connected) {
                    return;
                }
                String authority = this.url.getAuthority();
                String host = this.url.getHost();
                String path = this.url.getPath();
                int port = this.url.getPort();
                String query = this.url.getQuery();
                String ref = this.url.getRef();
                String userInfo = this.url.getUserInfo();
                if (authority != null) {
                    throw new IllegalArgumentException(this.url + ": 'Authority' not allowed");
                }
                if (host.length() > 0) {
                    throw new IllegalArgumentException(this.url + ": 'Host' not allowed");
                }
                if (port != -1) {
                    throw new IllegalArgumentException(this.url + ": 'Port' not allowed");
                }
                if (query != null) {
                    throw new IllegalArgumentException(this.url + ": 'Query' not allowed");
                }
                if (ref != null) {
                    throw new IllegalArgumentException(this.url + ": 'Fragment' not allowed");
                }
                if (userInfo != null) {
                    throw new IllegalArgumentException(this.url + ": 'User info' not allowed");
                }
                this.container = new URL(path);
                this.connected = true;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                URL container = this.container;
                assert (container != null);
                return CompressionURLStreamHandler.this.open(container.openStream());
            }
        };
    }
}

