/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class NestedZipFileStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final ZipFile zipFile;
    private ZipInputStream[] currentNestedZips = new ZipInputStream[0];
    private String[] currentNestedNames = new String[0];

    public NestedZipFileStream(File file) throws IOException {
        super(null);
        try {
            this.zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw (IOException)ExceptionUtil.wrap((String)("Opening '" + file + "'"), (Throwable)ioe);
        }
    }

    @Override
    public void close() throws IOException {
        for (int j = 0; j < this.currentNestedZips.length; ++j) {
            if (this.currentNestedZips[j] == null) continue;
            this.currentNestedZips[j].close();
            this.currentNestedZips[j] = null;
        }
        this.zipFile.close();
    }

    @Nullable
    public ZipEntry getEntry(String[] names) throws IOException {
        block23: {
            int i;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "ENTRY names={0}", Arrays.asList(names));
            }
            if (names.length == 0) {
                throw new IllegalArgumentException();
            }
            for (i = 0; i < names.length - 1 && i < this.currentNestedNames.length && names[i].equals(this.currentNestedNames[i]); ++i) {
            }
            if (i == 0) {
                for (int j = this.currentNestedZips.length - 1; j >= 0; --j) {
                    if (this.currentNestedZips[j] == null) continue;
                    this.currentNestedZips[j].close();
                    this.currentNestedZips[j] = null;
                }
            } else {
                ZipEntry ze;
                int j;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Attempt reuse from level {0}", i);
                }
                Object[] tmp = new ZipInputStream[names.length];
                System.arraycopy(this.currentNestedZips, 0, tmp, 0, i);
                for (j = this.currentNestedZips.length - 1; j >= i; --j) {
                    if (this.currentNestedZips[j] == null) continue;
                    this.currentNestedZips[j].close();
                }
                this.currentNestedZips = tmp;
                tmp = new String[names.length];
                System.arraycopy(this.currentNestedNames, 0, tmp, 0, i);
                this.currentNestedNames = tmp;
                do {
                    if ((ze = this.currentNestedZips[i - 1].getNextEntry()) != null) continue;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Attempted reuse failed on level {0}", i);
                    }
                    for (j = i - 1; j >= 0; --j) {
                        if (this.currentNestedZips[j] == null) continue;
                        this.currentNestedZips[j].close();
                        this.currentNestedZips[j] = null;
                    }
                    break block23;
                } while (!ze.getName().equals(names[i]));
                if (i == names.length - 1) {
                    this.in = this.currentNestedZips[i - 1];
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Attempted reuse successful");
                    }
                    return ze;
                }
                this.currentNestedZips[i] = new ZipInputStream(this.currentNestedZips[i - 1]);
                this.currentNestedNames[i] = ze.getName();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Reusing level {0}", i);
                }
                ++i;
                while (i < names.length) {
                    do {
                        if ((ze = this.currentNestedZips[i - 1].getNextEntry()) != null) continue;
                        return null;
                    } while (!ze.getName().equals(names[i]));
                    if (i == names.length - 1) {
                        this.in = this.currentNestedZips[i - 1];
                        return ze;
                    }
                    this.currentNestedZips[i] = new ZipInputStream(this.currentNestedZips[i - 1]);
                    this.currentNestedNames[i] = ze.getName();
                    ++i;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Processing ''{0}''", this.zipFile.getName() + "!" + names[0]);
        }
        this.currentNestedZips = new ZipInputStream[names.length - 1];
        this.currentNestedNames = new String[names.length - 1];
        ZipEntry ze = this.zipFile.getEntry(names[0]);
        if (ze == null) {
            return null;
        }
        this.in = this.zipFile.getInputStream(ze);
        if (names.length == 1) {
            return ze;
        }
        this.currentNestedNames[0] = names[0];
        this.currentNestedZips[0] = new ZipInputStream(this.in);
        int idx = 1;
        ZipEntry ze2;
        while ((ze2 = this.currentNestedZips[idx - 1].getNextEntry()) != null) {
            if (!ze2.getName().equals(names[idx])) continue;
            this.in = this.currentNestedZips[idx - 1];
            if (idx == names.length - 1) {
                return ze2;
            }
            this.currentNestedNames[idx] = ze2.getName();
            this.currentNestedZips[idx] = new ZipInputStream(this.currentNestedZips[idx - 1]);
            ++idx;
        }
        return null;
    }

    static {
        LOGGER.setParent(Logger.getLogger(NestedZipFileStream.class.getName()));
    }
}

