/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.sevenz.SevenZArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessings;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zip4jadapter.archivers.zip.ZipArchiveFormat;
import de.unkrig.zz.diff.Diff;
import de.unkrig.zz.diff.DocumentDiff;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.Charsets;

public class Main {
    private final Diff diff = new Diff();
    private final LevelFilteredPrinter levelFilteredPrinter = new LevelFilteredPrinter();
    @Nullable
    private File outputFile;

    public static void main(final String[] args) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> cacheModeClass = cl.loadClass("de.unkrig.commons.net.authenticator.CustomAuthenticator$CacheMode");
            Class<?> storeModeClass = cl.loadClass("de.unkrig.commons.net.authenticator.CustomAuthenticator$StoreMode");
            Authenticator customAuthenticator = (Authenticator)cl.loadClass("de.unkrig.commons.net.authenticator.CustomAuthenticator").getConstructor(cacheModeClass, storeModeClass).newInstance(cacheModeClass.getEnumConstants()[2], storeModeClass.getEnumConstants()[2]);
            Authenticator.setDefault(customAuthenticator);
        }
        catch (Exception cl) {
            // empty catch block
        }
        final Main main = new Main();
        main.levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                main.main2(args);
            }
        });
    }

    private void main2(String[] args) {
        try {
            this.main3(args);
        }
        catch (Exception e) {
            Printers.error(null, (Throwable)e);
            System.exit(1);
        }
    }

    private void main3(String[] args) throws Exception {
        if ((args = CommandLineOptions.parse((String[])args, (Object)this)).length != 2) {
            Printers.error((String)"Wrong number of file or directory names - try \"--help\".");
            System.exit(2);
        }
        this.main4(ResourceProcessings.toUrl((String)args[0]), ResourceProcessings.toUrl((String)args[1]));
    }

    private void main4(final URL resource1, final URL resource2) throws Exception {
        Printers.redirectToFile((AbstractPrinter.Level)AbstractPrinter.Level.INFO, (File)this.outputFile, null, (RunnableWhichThrows)new RunnableWhichThrows<Exception>(){

            public void run() throws Exception {
                Main.this.main5(resource1, resource2);
            }
        });
    }

    private void main5(URL resource1, URL resource2) throws Exception {
        long differenceCount = this.diff.execute(resource1, resource2);
        if (differenceCount > 0L) {
            System.exit(1);
        }
    }

    @CommandLineOption
    public void help() throws IOException {
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        CommandLineOptions.printResource(Main.class, (String)"main(String[]).txt", (Charset)Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void setPath(@RegexFlags(value=-1610612736) Glob glob) {
        this.diff.setPathPredicate((Predicate<? super String>)glob);
    }

    @CommandLineOption
    public void setLookInto(@RegexFlags(value=-1610612736) Glob discriminator) {
        this.diff.setLookInto((Predicate<? super String>)discriminator);
    }

    @CommandLineOption(name={"path-equivalence", "pe"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addPathEquivalence(Pattern pathRegex) {
        this.diff.addEquivalentPath(pathRegex);
    }

    @Deprecated
    @CommandLineOption(name={"ne"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addNameEquivalence(Pattern pathRegex) {
        this.addPathEquivalence(pathRegex);
    }

    @CommandLineOption
    public void setNoRecurseSubdirctories() {
        this.diff.setRecurseSubdirectories(false);
    }

    @CommandLineOption(name={"disassemble", "da"})
    public void setDisassemble() {
        this.diff.setDisassembleClassFiles(true);
    }

    @CommandLineOption
    public void setDaVerbose() {
        this.diff.setDisassembleClassFilesVerbose(true);
    }

    @CommandLineOption
    public void setDaSourceDirectory(File directory) {
        this.diff.setDisassembleClassFilesSourceDirectory(directory);
    }

    @CommandLineOption
    public void setDaNoLines() {
        this.diff.setDisassembleClassFilesButHideLines(true);
    }

    @CommandLineOption
    public void setDaNoVars() {
        this.diff.setDisassembleClassFilesButHideVars(true);
    }

    @CommandLineOption
    public void setDaSymbolicLabels() {
        this.diff.setDisassembleClassFilesSymbolicLabels(true);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addLineEquivalence(@RegexFlags(value=-1610612736) Glob pathPattern, Pattern lineRegex) {
        this.diff.addEquivalentLine(new DocumentDiff.LineEquivalence((Predicate<? super String>)pathPattern, lineRegex));
    }

    @CommandLineOption(name={"ignore", "I"}, cardinality=CommandLineOption.Cardinality.ANY)
    public void addIgnore(@RegexFlags(value=-1610612736) Glob pathPattern, Pattern lineRegex) {
        this.diff.addIgnore(new DocumentDiff.LineEquivalence((Predicate<? super String>)pathPattern, lineRegex));
    }

    @CommandLineOption(name={"ignore-whitespace", "w"})
    public void setIgnoreWhitespace() {
        this.diff.setIgnoreWhitespace(true);
    }

    @CommandLineOption(group={AddedFileModeOptionGroup.class})
    public void setAddedFile(Diff.AbsentFileMode mode) {
        this.diff.setAddedFileMode(mode);
    }

    @CommandLineOption(group={DeletedFileModeOptionGroup.class})
    public void setDeletedFile(Diff.AbsentFileMode mode) {
        this.diff.setDeletedFileMode(mode);
    }

    @CommandLineOption(name={"new-file", "N"}, group={AddedFileModeOptionGroup.class, DeletedFileModeOptionGroup.class})
    public void setNewFile() {
        this.diff.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
        this.diff.setDeletedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
    }

    @CommandLineOption(group={AddedFileModeOptionGroup.class, DeletedFileModeOptionGroup.class})
    public void setUnidirectionalNewFile() {
        this.diff.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
        this.diff.setDeletedFileMode(Diff.AbsentFileMode.REPORT);
    }

    @CommandLineOption
    public void setUnchangedFiles() {
        this.diff.setReportUnchangedFiles(true);
    }

    @CommandLineOption
    public void setEncoding(Charset charsetName) {
        this.diff.setCharset(charsetName);
    }

    @CommandLineOption
    public void setOut(File outputFile) {
        this.outputFile = outputFile;
    }

    @CommandLineOption(group={DiffModeOptionGroup.class})
    public void setNormal() {
        this.diff.setDiffMode(Diff.DiffMode.NORMAL);
    }

    @CommandLineOption(group={DiffModeOptionGroup.class})
    public void setExist() {
        this.diff.setDiffMode(Diff.DiffMode.EXIST);
    }

    @CommandLineOption(name={"brief", "q"}, group={DiffModeOptionGroup.class})
    public void setBrief() {
        this.diff.setDiffMode(Diff.DiffMode.BRIEF);
    }

    @CommandLineOption(name={"context", "c"}, group={DiffModeOptionGroup.class})
    public void setContext() {
        this.diff.setDiffMode(Diff.DiffMode.CONTEXT);
    }

    @CommandLineOption(name={"Context", "C"}, group={DiffModeOptionGroup.class})
    public void setContext2(int amount) {
        this.diff.setDiffMode(Diff.DiffMode.CONTEXT);
        this.diff.setContextSize(amount);
    }

    @CommandLineOption(name={"unified", "u"}, group={DiffModeOptionGroup.class})
    public void setUnified() {
        this.diff.setDiffMode(Diff.DiffMode.UNIFIED);
    }

    @CommandLineOption(name={"Unified"}, group={DiffModeOptionGroup.class})
    public void setUnified2(int amount) {
        this.diff.setDiffMode(Diff.DiffMode.UNIFIED);
        this.diff.setContextSize(amount);
    }

    @CommandLineOption
    public void setKeepGoing() {
        this.diff.setExceptionHandler(new ExceptionHandler<IOException>(){

            public void handle(String path, IOException ioe) {
                Printers.error((String)path, (Object[])new Object[]{ioe.getMessage()});
            }

            public void handle(String path, RuntimeException re) {
                Printers.error((String)path, (Object[])new Object[]{re.getMessage()});
            }
        });
    }

    @CommandLineOption
    public void setSequential() {
        this.diff.setSequential(true);
    }

    @CommandLineOption
    public void setJavaTokenization() {
        this.diff.setTokenization(DocumentDiff.Tokenization.JAVA);
    }

    @CommandLineOption
    public void setIgnoreCStyleComments() {
        this.diff.setIgnoreCStyleComments(true);
    }

    @CommandLineOption(name={"ignore-c++-style-comments"})
    public void setIgnoreCppStyleComments() {
        this.diff.setIgnoreCPlusPlusStyleComments(true);
    }

    @CommandLineOption
    public void setIgnoreDocComments() {
        this.diff.setIgnoreDocComments(true);
    }

    @CommandLineOption
    public void set7zInputFilePassword(String value) {
        SevenZArchiveFormat.setPassword((byte[])value.getBytes(Charsets.UTF_16LE));
    }

    @CommandLineOption
    public void setZipInputFilePassword(String value) {
        ZipArchiveFormat.setInputFilePasswordChars((char[])value.toCharArray());
    }

    @CommandLineOption
    public void setPassword(String value) {
        this.set7zInputFilePassword(value);
        this.setZipInputFilePassword(value);
    }

    @CommandLineOption
    public void setNowarn() {
        this.levelFilteredPrinter.setNoWarn();
        SimpleLogging.setNoWarn();
    }

    @CommandLineOption
    public void setQuiet() {
        this.levelFilteredPrinter.setQuiet();
        SimpleLogging.setQuiet();
    }

    @CommandLineOption
    public void setVerbose() {
        this.levelFilteredPrinter.setVerbose();
        SimpleLogging.setVerbose();
    }

    @CommandLineOption
    public void setDebug() {
        this.levelFilteredPrinter.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
        SimpleLogging.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers((String)spec);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    @CommandLineOptionGroup
    static interface DiffModeOptionGroup {
    }

    @CommandLineOptionGroup
    static interface DeletedFileModeOptionGroup {
    }

    @CommandLineOptionGroup
    static interface AddedFileModeOptionGroup {
    }
}

