/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessings;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessor;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.util.TreeComparator;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import de.unkrig.zz.diff.DocumentDiff;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Diff
extends DocumentDiff {
    private static final ThreadPoolExecutor PARALLEL_EXECUTOR_SERVICE;
    private Predicate<? super String> pathPredicate = PredicateUtil.always();
    private final List<Pattern> equivalentPaths = new ArrayList<Pattern>();
    private AbsentFileMode addedFileMode = AbsentFileMode.REPORT;
    private AbsentFileMode deletedFileMode = AbsentFileMode.REPORT;
    private boolean reportUnchangedFiles;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private DiffMode diffMode = DiffMode.NORMAL;
    private ExceptionHandler<IOException> exceptionHandler = ExceptionHandler.defaultHandler();
    private boolean sequential;
    private boolean recurseSubdirectories = true;
    private static final RuntimeException TERMINATE;
    private final Comparator<? super NodeWithPath> normalizedPathComparator = new Comparator<NodeWithPath>(){

        @Override
        public int compare(@Nullable NodeWithPath node1, @Nullable NodeWithPath node2) {
            assert (node1 != null);
            assert (node2 != null);
            return Diff.this.normalize(node1.getPath()).compareTo(Diff.this.normalize(node2.getPath()));
        }
    };

    public void setRecurseSubdirectories(boolean value) {
        this.recurseSubdirectories = value;
    }

    public void setAddedFileMode(AbsentFileMode value) {
        this.addedFileMode = value;
    }

    public void setDeletedFileMode(AbsentFileMode value) {
        this.deletedFileMode = value;
    }

    public void setReportUnchangedFiles(boolean value) {
        this.reportUnchangedFiles = value;
    }

    public void setLookInto(Predicate<? super String> value) {
        this.lookIntoFormat = value;
    }

    public void setDiffMode(DiffMode value) {
        this.diffMode = value;
        switch (this.diffMode) {
            case NORMAL: {
                this.setDocumentDiffMode(DocumentDiff.DocumentDiffMode.NORMAL);
                break;
            }
            case CONTEXT: {
                this.setDocumentDiffMode(DocumentDiff.DocumentDiffMode.CONTEXT);
                break;
            }
            case UNIFIED: {
                this.setDocumentDiffMode(DocumentDiff.DocumentDiffMode.UNIFIED);
                break;
            }
        }
    }

    public void setExceptionHandler(ExceptionHandler<IOException> value) {
        this.exceptionHandler = value;
    }

    public void setSequential(boolean value) {
        this.sequential = value;
    }

    public void setPathPredicate(Predicate<? super String> pathPredicate) {
        this.pathPredicate = pathPredicate;
    }

    public void addEquivalentPath(Pattern path) {
        this.equivalentPaths.add(path);
    }

    public long execute(URL resource1, URL resource2) throws IOException, InterruptedException {
        if (resource1.equals(ResourceProcessings.STDIN_URL) && resource2.equals(ResourceProcessings.STDIN_URL)) {
            throw new IOException("At most one of the two inputs can be \"-\" (standard input)");
        }
        SquadExecutor squadExecutor = new SquadExecutor(this.sequential || PARALLEL_EXECUTOR_SERVICE.getQueue().size() > 0 ? ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE : PARALLEL_EXECUTOR_SERVICE);
        ResourceProcessor<NodeWithPath> rp = this.resourceProcessor((SquadExecutor<NodeWithPath>)squadExecutor);
        Printers.verbose((String)"Scanning ''{0}''...", (Object[])new Object[]{resource1});
        NodeWithPath node1 = (NodeWithPath)rp.process("", resource1);
        if (node1 == null) {
            Printers.error((String)("\"" + resource1 + "\" does not exist or all subnodes are excluded"));
            return 0L;
        }
        Printers.verbose((String)"Scanning ''{0}''...", (Object[])new Object[]{resource2});
        NodeWithPath node2 = (NodeWithPath)rp.process("", resource2);
        if (node2 == null) {
            Printers.error((String)("\"" + resource2 + "\" does not exist or all subnodes are excluded"));
            return 0L;
        }
        try {
            squadExecutor.awaitCompletion();
        }
        catch (ExecutionException ee) {
            try {
                throw ee.getCause();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
        Printers.verbose((String)"Computing differences...");
        long differenceCount = this.diff(node1, node2);
        Printers.verbose((String)"{0,choice,0#No differences|1#1 difference|1<{0} differences} found.", (Object[])new Object[]{differenceCount});
        return differenceCount;
    }

    public long execute(ProducerWhichThrows<? extends InputStream, IOException> opener1, ProducerWhichThrows<? extends InputStream, IOException> opener2) throws IOException {
        Printers.verbose((String)"Scanning first stream...");
        NodeWithPath node1 = this.scanStream(opener1);
        Printers.verbose((String)"Scanning second stream...");
        NodeWithPath node2 = this.scanStream(opener2);
        Printers.verbose((String)"Computing differences...");
        long differenceCount = this.diff(node1, node2);
        Printers.verbose((String)"{0,choice,0#No differences|1#1 difference|1<{0} differences} found.", (Object[])new Object[]{differenceCount});
        return differenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeWithPath scanStream(ProducerWhichThrows<? extends InputStream, IOException> opener) throws IOException {
        NodeWithPath node1;
        ContentsProcessor<NodeWithPath> dcp = this.contentsProcessor();
        InputStream stream1 = (InputStream)AssertionUtil.notNull((Object)opener.produce());
        try {
            node1 = (NodeWithPath)dcp.process("", stream1, null, -1L, -1L, opener);
            stream1.close();
        }
        finally {
            try {
                stream1.close();
            }
            catch (Exception exception) {}
        }
        assert (node1 != null);
        return node1;
    }

    private ResourceProcessor<NodeWithPath> resourceProcessor(SquadExecutor<NodeWithPath> squadExecutor) {
        FileProcessings.DirectoryCombiner<NodeWithPath> directoryEntryCombiner = new FileProcessings.DirectoryCombiner<NodeWithPath>(){

            @Nullable
            public NodeWithPath combine(String directoryPath, File directory, List<NodeWithPath> combinables) {
                TreeSet<NodeWithPath> memberNodes = new TreeSet<NodeWithPath>(Diff.this.normalizedPathComparator);
                for (NodeWithPath c : combinables) {
                    if (c == null) continue;
                    memberNodes.add(c);
                }
                return new DirectoryNode(directoryPath, memberNodes);
            }
        };
        ContentsProcessings.ArchiveCombiner<NodeWithPath> archiveEntryCombiner = new ContentsProcessings.ArchiveCombiner<NodeWithPath>(){

            @Nullable
            public NodeWithPath combine(String archivePath, List<NodeWithPath> archiveCombinables) {
                TreeSet<NodeWithPath> archiveNodes = new TreeSet<NodeWithPath>(Diff.this.normalizedPathComparator);
                for (NodeWithPath ac : archiveCombinables) {
                    if (ac == null) continue;
                    archiveNodes.add(ac);
                }
                return new ArchiveNode(archivePath, archiveNodes);
            }
        };
        return ResourceProcessings.recursiveCompressedAndArchiveResourceProcessor(this.lookIntoFormat, this.pathPredicate, null, (boolean)this.recurseSubdirectories, (FileProcessings.DirectoryCombiner)directoryEntryCombiner, (ContentsProcessings.ArchiveCombiner)archiveEntryCombiner, this.contentsProcessor(), squadExecutor, this.exceptionHandler);
    }

    private ContentsProcessor<NodeWithPath> contentsProcessor() {
        ContentsProcessor<NodeWithPath> normalContentsProcessor = new ContentsProcessor<NodeWithPath>(){

            @Nullable
            public NodeWithPath process(final String path, InputStream inputStream, @Nullable Date lastModifiedDate, long size, long crc32, final ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                int finalCrc;
                long finalSize;
                if (size != -1L && crc32 != -1L) {
                    finalSize = size;
                    finalCrc = (int)crc32;
                } else {
                    SizeAndCrc32 sizeAndCrc32 = Diff.sizeAndCrc32(inputStream);
                    finalSize = sizeAndCrc32.getSize();
                    finalCrc = sizeAndCrc32.getCrc32();
                }
                return new DocumentNode(path){

                    @Override
                    public InputStream open() throws IOException {
                        return (InputStream)AssertionUtil.notNull((Object)opener.produce());
                    }

                    @Override
                    public long getSize() {
                        return finalSize;
                    }

                    @Override
                    public int getCrc32() {
                        return finalCrc;
                    }

                    @Override
                    public String toString() {
                        return path;
                    }
                };
            }
        };
        return ContentsProcessings.recursiveCompressedAndArchiveContentsProcessor(this.lookIntoFormat, this.pathPredicate, (ContentsProcessings.ArchiveCombiner)new ContentsProcessings.ArchiveCombiner<NodeWithPath>(){

            @Nullable
            public NodeWithPath combine(String archivePath, List<NodeWithPath> combinables) {
                TreeSet<NodeWithPath> archiveEntries = new TreeSet<NodeWithPath>(Diff.this.normalizedPathComparator);
                archiveEntries.addAll(combinables);
                return new ArchiveNode(archivePath, archiveEntries);
            }
        }, (ContentsProcessor)normalContentsProcessor, this.exceptionHandler);
    }

    private String normalize(String path) {
        for (Pattern pathEquivalence : this.equivalentPaths) {
            Matcher matcher = pathEquivalence.matcher(path.substring(1));
            if (!matcher.matches()) continue;
            path = path.substring(0, 1);
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                path = path + matcher.group(i);
            }
        }
        return path;
    }

    private long diff(NodeWithPath node1, NodeWithPath node2) throws IOException {
        final long[] differenceCount = new long[1];
        TreeComparator<NodeWithPath, IOException> treeComparator = new TreeComparator<NodeWithPath, IOException>(){

            protected void nodeAdded(NodeWithPath node) throws IOException {
                switch (Diff.this.addedFileMode) {
                    case REPORT: {
                        Diff.this.reportFileAdded(node.getPath());
                        break;
                    }
                    case COMPARE_WITH_EMPTY: {
                        for (DocumentNode document : this.getDocuments(node)) {
                            String path = document.getPath();
                            Diff.this.reportFileAdded(path);
                            differenceCount[0] = differenceCount[0] + Diff.this.diff("(missing)", path, InputStreams.EMPTY, document.open());
                        }
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }

            protected void nodeDeleted(NodeWithPath node) throws IOException {
                switch (Diff.this.deletedFileMode) {
                    case REPORT: {
                        Diff.this.reportFileDeleted(node.getPath());
                        break;
                    }
                    case COMPARE_WITH_EMPTY: {
                        for (DocumentNode document : this.getDocuments(node)) {
                            differenceCount[0] = differenceCount[0] + Diff.this.diff(document.getPath(), "(missing)", document.open(), InputStreams.EMPTY);
                        }
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }

            private List<DocumentNode> getDocuments(NodeWithPath node) {
                SortedSet children = node.children();
                if (children == null) {
                    return Collections.singletonList((DocumentNode)node);
                }
                ArrayList<DocumentNode> result = new ArrayList<DocumentNode>();
                for (NodeWithPath child : children) {
                    result.addAll(this.getDocuments(child));
                }
                return result;
            }

            protected void nonLeafNodeChangedToLeafNode(NodeWithPath node1, NodeWithPath node2) {
                Diff.this.reportFileChanged(node1.getPath(), node2.getPath());
            }

            protected void leafNodeChangedToNonLeafNode(NodeWithPath node1, NodeWithPath node2) {
                Diff.this.reportFileChanged(node1.getPath(), node2.getPath());
            }

            protected void leafNodeRemains(NodeWithPath node1, NodeWithPath node2) throws IOException {
                block5: {
                    final DocumentNode document1 = (DocumentNode)node1;
                    final DocumentNode document2 = (DocumentNode)node2;
                    final String path1 = document1.getPath();
                    final String path2 = document2.getPath();
                    if (document1.getSize() == document2.getSize() && document1.getCrc32() == document2.getCrc32()) {
                        Diff.this.reportFileUnchanged(path1, path2);
                        return;
                    }
                    if (Diff.this.diffMode == DiffMode.EXIST) {
                        Diff.this.reportFileUnchanged(path1, path2);
                    } else {
                        try {
                            final AbstractPrinter cp = AbstractPrinter.getContextPrinter();
                            cp.redirect(AbstractPrinter.Level.INFO, (ConsumerWhichThrows)new Consumer<String>(){
                                boolean first = true;

                                public void consume(String message) {
                                    if (this.first) {
                                        this.first = false;
                                        Diff.this.reportFileChanged(path1, path2);
                                        if (Diff.this.diffMode == DiffMode.BRIEF) {
                                            throw TERMINATE;
                                        }
                                    }
                                    cp.info(message);
                                }
                            }).run((RunnableWhichThrows)new RunnableWhichThrows<IOException>(){

                                public void run() throws IOException {
                                    long dc = Diff.this.diff(path1, path2, document1.open(), document2.open());
                                    if (dc == 0L) {
                                        Diff.this.reportFileUnchanged(path1, path2);
                                    } else {
                                        differenceCount[0] = differenceCount[0] + dc;
                                    }
                                }
                            });
                        }
                        catch (RuntimeException re) {
                            if (re == TERMINATE) break block5;
                            throw re;
                        }
                    }
                }
            }
        };
        treeComparator.compare((TreeComparator.Node)node1, (TreeComparator.Node)node2);
        return differenceCount[0];
    }

    protected void reportFileAdded(String path) {
        Printers.verbose((String)"''{0}'' added", (Object[])new Object[]{path});
        switch (this.diffMode) {
            case EXIST: 
            case BRIEF: {
                Printers.info((String)(path.length() == 0 ? "File added" : "+ " + path.substring(1)));
                break;
            }
            case NORMAL: 
            case CONTEXT: 
            case UNIFIED: {
                if (path.length() <= 0) break;
                Printers.info((String)("File added " + path.substring(1)));
            }
        }
    }

    protected void reportFileDeleted(String path) {
        Printers.verbose((String)"''{0}'' deleted", (Object[])new Object[]{path});
        switch (this.diffMode) {
            case EXIST: 
            case BRIEF: {
                Printers.info((String)(path.length() == 0 ? "File deleted" : "- " + path.substring(1)));
                break;
            }
            case NORMAL: 
            case CONTEXT: 
            case UNIFIED: {
                if (path.length() <= 0) break;
                Printers.info((String)("File deleted " + path.substring(1)));
            }
        }
    }

    protected void reportFileChanged(String path1, String path2) {
        Printers.verbose((String)"''{0}'' and ''{1}'' changed", (Object[])new Object[]{path1, path2});
        switch (this.diffMode) {
            case EXIST: 
            case BRIEF: {
                Printers.info((String)(!path1.isEmpty() && !path2.isEmpty() ? "File changed" : "! " + path2.substring(1)));
                break;
            }
            case NORMAL: 
            case CONTEXT: 
            case UNIFIED: {
                if (path1.isEmpty() || path2.isEmpty()) break;
                Printers.info((String)("File changed " + path2.substring(1)));
            }
        }
    }

    protected void reportFileUnchanged(String path1, String path2) {
        Printers.verbose((String)"''{0}'' and ''{1}'' unchanged", (Object[])new Object[]{path1, path2});
        if (this.reportUnchangedFiles) {
            switch (this.diffMode) {
                case EXIST: 
                case BRIEF: {
                    Printers.info((String)(path1.length() == 0 ? "File unchanged" : "= " + path2.substring(1)));
                    break;
                }
                case NORMAL: 
                case CONTEXT: 
                case UNIFIED: {
                    if (path1.length() <= 0) break;
                    Printers.info((String)("File unchanged " + path2.substring(1)));
                }
            }
        }
    }

    public static SizeAndCrc32 sizeAndCrc32(InputStream inputStream) throws IOException {
        int count;
        long size = 0L;
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[8192];
        while ((count = inputStream.read(buffer)) != -1) {
            crc32.update(buffer, 0, count);
            size += (long)count;
        }
        final long finalSize = size;
        final int finalCrc32 = (int)crc32.getValue();
        return new SizeAndCrc32(){

            @Override
            public long getSize() {
                return finalSize;
            }

            @Override
            public int getCrc32() {
                return finalCrc32;
            }
        };
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        PARALLEL_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 3, ThreadUtil.DAEMON_THREAD_FACTORY);
        TERMINATE = new RuntimeException(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable initCause(@Nullable Throwable cause) {
                return this;
            }
        };
    }

    public static interface SizeAndCrc32 {
        public long getSize();

        public int getCrc32();
    }

    private abstract class DocumentNode
    extends NodeWithPath {
        DocumentNode(String path) {
            super(path);
        }

        @Nullable
        public SortedSet<NodeWithPath> children() {
            return null;
        }

        public abstract long getSize();

        public abstract int getCrc32() throws IOException;

        public abstract InputStream open() throws IOException;

        @Override
        public String toString() {
            return "doc:" + this.getPath();
        }
    }

    private class ArchiveNode
    extends NodeWithPath {
        private final SortedSet<NodeWithPath> archiveNodes;

        ArchiveNode(String path, SortedSet<NodeWithPath> archiveNodes) {
            super(path);
            this.archiveNodes = archiveNodes;
        }

        @Nullable
        public SortedSet<NodeWithPath> children() {
            return this.archiveNodes;
        }

        @Override
        public String toString() {
            return "archive:" + this.getPath();
        }
    }

    private class DirectoryNode
    extends NodeWithPath {
        private final SortedSet<NodeWithPath> children;

        DirectoryNode(String path, SortedSet<NodeWithPath> children) {
            super(path);
            this.children = children;
        }

        public SortedSet<NodeWithPath> children() {
            return this.children;
        }

        @Override
        public String toString() {
            return "dir:" + this.getPath();
        }
    }

    private abstract class NodeWithPath
    implements TreeComparator.Node<NodeWithPath> {
        private final String path;

        NodeWithPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public abstract String toString();
    }

    public static enum AbsentFileMode {
        REPORT,
        COMPARE_WITH_EMPTY,
        IGNORE;

    }

    public static enum DiffMode {
        EXIST,
        BRIEF,
        NORMAL,
        CONTEXT,
        UNIFIED;

    }
}

