/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentstransformation.ContentsTransformations;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.contentstransformation.SelectiveContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.IncludeExclude;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Patch {
    private static final Logger LOGGER = Logger.getLogger(Patch.class.getName());
    private static final Combiner DEFAULT_COMBINER = new Combiner(){

        @Override
        public void combineDirectory(String directoryPath, ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException> memberAdder) {
        }

        @Override
        public void combineArchive(String archivePath, ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException> entryAdder) {
        }
    };
    private boolean saveSpace = true;
    private boolean keepOriginals;
    private final List<ContentsTransformation> contentsTransformations = new ArrayList<ContentsTransformation>();
    private Predicate<? super String> fileAndArchiveEntryRemoval = PredicateUtil.never();
    private final IncludeExclude fileAndArchiveEntryRenaming = new IncludeExclude();
    private Combiner combiner = DEFAULT_COMBINER;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    @Nullable
    private Comparator<Object> directoryMemberNameComparator = Collator.getInstance();
    private ExceptionHandler<IOException> exceptionHandler = ExceptionHandler.defaultHandler();

    public void setSaveSpace(boolean value) {
        LOGGER.log(Level.FINER, "setSaveSpace(''{0}'')", value);
        this.saveSpace = value;
    }

    public void setKeepOriginals(boolean value) {
        LOGGER.log(Level.FINER, "setKeepOriginals(''{0}'')", value);
        this.keepOriginals = value;
    }

    public void setLookIntoFormat(Predicate<? super String> value) {
        LOGGER.log(Level.FINER, "setLookInto(''{0}'')", value);
        this.lookIntoFormat = value;
    }

    public void setDirectoryMemberNameComparator(@Nullable Comparator<Object> directoryMemberNameComparator) {
        this.directoryMemberNameComparator = directoryMemberNameComparator;
    }

    public ExceptionHandler<IOException> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler<IOException> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ContentsTransformer addContentsTransformation(Predicate<? super String> pathPredicate, ContentsTransformer contentsTransformer) {
        LOGGER.log(Level.FINER, "addContentsTransformation(''{0}'', ''{1}'')", new Object[]{pathPredicate, contentsTransformer});
        this.contentsTransformations.add(0, new ContentsTransformation(pathPredicate, contentsTransformer));
        return contentsTransformer;
    }

    public void addRemoval(Predicate<? super String> removal) {
        LOGGER.log(Level.FINER, "addRemoval(''{0}'')", removal);
        this.fileAndArchiveEntryRemoval = PredicateUtil.or(this.fileAndArchiveEntryRemoval, removal);
    }

    public void addRenaming(Glob value) {
        LOGGER.log(Level.FINER, "addRenaming(''{0}'')", value);
        this.fileAndArchiveEntryRenaming.addInclude(value, false);
    }

    public void addAddition(final Predicate<? super String> condition, final String name, final File contents) {
        LOGGER.log(Level.FINER, "addAddition(''{0}'', ''{1}'', ''{2}'')", new Object[]{condition, name, contents});
        final FileTransformations.NameAndContents nac = new FileTransformations.NameAndContents(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public InputStream open() throws FileNotFoundException {
                return new FileInputStream(contents);
            }

            public String toString() {
                return name;
            }
        };
        final Combiner old = this.combiner;
        this.combiner = new Combiner(){

            @Override
            public void combineDirectory(String directoryPath, ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException> memberAdder) throws IOException {
                old.combineDirectory(directoryPath, memberAdder);
                if (condition.evaluate(directoryPath)) {
                    LOGGER.log(Level.CONFIG, "{0}: Adding ''{1}''", new Object[]{directoryPath, nac});
                    memberAdder.consume(nac);
                }
            }

            @Override
            public void combineArchive(String archivePath, ConsumerWhichThrows<? super FileTransformations.NameAndContents, ? extends IOException> entryAdder) throws IOException {
                old.combineArchive(archivePath, entryAdder);
                if (condition.evaluate(archivePath)) {
                    LOGGER.log(Level.CONFIG, "{0}: Adding ''{1}''", new Object[]{archivePath, nac});
                    entryAdder.consume(nac);
                }
            }
        };
    }

    public FileTransformer fileTransformer(boolean lookIntoDirectories, boolean renameOrRemoveTopLevelFiles) {
        ContentsTransformer contentsTransformer = this.rawContentsTransformer();
        FileTransformer fileTransformer = FileTransformations.recursiveCompressedAndArchiveFileTransformer(this.lookIntoFormat, this.fileAndArchiveEntryRemoval, this.fileAndArchiveEntryRenaming, this.combiner, contentsTransformer, this.keepOriginals, this.exceptionHandler);
        if (lookIntoDirectories) {
            fileTransformer = FileTransformations.directoryTreeTransformer(this.directoryMemberNameComparator, this.fileAndArchiveEntryRemoval, this.fileAndArchiveEntryRenaming, this.combiner, fileTransformer, this.saveSpace, this.keepOriginals, this.exceptionHandler);
        }
        if (renameOrRemoveTopLevelFiles) {
            fileTransformer = FileTransformations.renameRemoveFileTransformer(this.fileAndArchiveEntryRemoval, this.fileAndArchiveEntryRenaming, fileTransformer, this.keepOriginals);
        }
        return fileTransformer;
    }

    public ContentsTransformer contentsTransformer() {
        ContentsTransformer contentsTransformer = this.rawContentsTransformer();
        contentsTransformer = ContentsTransformations.recursiveCompressedAndArchiveContentsTransformer(this.lookIntoFormat, this.fileAndArchiveEntryRemoval, this.fileAndArchiveEntryRenaming, this.combiner, contentsTransformer, this.exceptionHandler);
        return contentsTransformer;
    }

    private ContentsTransformer rawContentsTransformer() {
        ContentsTransformer contentsTransformer = ContentsTransformations.COPY;
        for (ContentsTransformation ct : this.contentsTransformations) {
            contentsTransformer = new SelectiveContentsTransformer(ct.pathPredicate, ct.contentsTransformer, contentsTransformer);
        }
        return contentsTransformer;
    }

    private static interface Combiner
    extends FileTransformations.DirectoryCombiner,
    FileTransformations.ArchiveCombiner {
    }

    private static class ContentsTransformation {
        public Predicate<? super String> pathPredicate;
        public ContentsTransformer contentsTransformer;

        ContentsTransformation(Predicate<? super String> pathPredicate, ContentsTransformer contentsTransformer) {
            this.pathPredicate = pathPredicate;
            this.contentsTransformer = contentsTransformer;
        }
    }
}

