/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.StringStream;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.zz.patch.PatchTextTransformer;
import de.unkrig.zz.patch.diff.DiffParser;
import java.io.File;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.ChainableReader;

@NotNullByDefault(value=false)
public class AntFilter
extends ProjectComponent
implements ChainableReader {
    @Nullable
    private File patchFile;
    private Charset patchFileCharset = Charset.defaultCharset();
    private PatchTextTransformer.Condition condition = PatchTextTransformer.Condition.ALWAYS;

    public void setPatchFile(File value) {
        this.patchFile = value;
    }

    public void setPatchFileEncoding(String value) {
        this.patchFileCharset = Charset.forName(value);
    }

    public void setCondition(String condition) throws ParseException {
        final Expression expression = new ExpressionEvaluator("hunks", "hunkIndex", "hunk", "lineNumber").parse(condition);
        this.condition = new PatchTextTransformer.Condition(){

            @Override
            public boolean evaluate(@NotNull String path, @NotNull List<DiffParser.Hunk> hunks, int hunkIndex, @NotNull DiffParser.Hunk hunk, int lineNumber) {
                try {
                    return ExpressionEvaluator.toBoolean(expression.evaluate(Mappings.mapping("hunks", hunks, "hunkIndex", hunkIndex, "lineNumber", lineNumber)));
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
            }
        };
    }

    public Reader chain(final Reader reader) {
        PipedReader pipedReader;
        List<DiffParser.Hunk> hunks;
        File patchFile = this.patchFile;
        if (patchFile == null) {
            throw new BuildException("Attribute 'patchFile' must be set");
        }
        try {
            hunks = DiffParser.parse((File)patchFile, (Charset)this.patchFileCharset).get((int)0).hunks;
        }
        catch (StringStream.UnexpectedElementException uee) {
            throw new BuildException((Throwable)uee);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        final PipedWriter pipedWriter = new PipedWriter();
        try {
            pipedReader = new PipedReader(pipedWriter);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        final PatchTextTransformer textTransformer = new PatchTextTransformer(hunks, this.condition);
        ThreadUtil.runInBackground(new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                textTransformer.transform("", reader, pipedWriter);
                pipedWriter.close();
                reader.close();
            }
        }, "ant-patch-filter");
        return pipedReader;
    }
}

