/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.grep;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessings;
import de.unkrig.commons.file.contentsprocessing.ContentsProcessor;
import de.unkrig.commons.file.contentsprocessing.SelectiveContentsProcessor;
import de.unkrig.commons.file.fileprocessing.FileProcessings;
import de.unkrig.commons.file.fileprocessing.FileProcessor;
import de.unkrig.commons.io.ByteFilterInputStream;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.concurrent.ConcurrentUtil;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import de.unkrig.zz.grep.DisassemblerByteFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grep {
    @Nullable
    private String label;
    private boolean withPath;
    private boolean withLineNumber;
    private boolean withByteOffset;
    private int afterContext;
    private int beforeContext;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private Charset charset = Charset.defaultCharset();
    private Operation operation = Operation.NORMAL;
    private int maxCount = Integer.MAX_VALUE;
    private boolean inverted;
    private boolean disassembleClassFiles;
    private boolean disassembleClassFilesVerbose;
    @Nullable
    private File disassembleClassFilesSourceDirectory;
    private boolean disassembleClassFilesButHideLines;
    private boolean disassembleClassFilesButHideVars;
    private boolean disassembleClassFilesSymbolicLabels;
    @Nullable
    private Comparator<Object> directoryMemberNameComparator = Collator.getInstance();
    private ExceptionHandler<IOException> exceptionHandler = ExceptionHandler.defaultHandler();
    private final List<Search> searches = new ArrayList<Search>();
    boolean linesSelected;

    public void setLabel(String value) {
        this.label = value;
    }

    public void setWithPath(boolean value) {
        this.withPath = value;
    }

    public void setWithLineNumber(boolean value) {
        this.withLineNumber = value;
    }

    public void setWithByteOffset(boolean value) {
        this.withByteOffset = value;
    }

    public void setAfterContext(int value) {
        this.afterContext = value;
    }

    public void setBeforeContext(int value) {
        this.beforeContext = value;
    }

    public void setLookIntoFormat(Predicate<? super String> value) {
        this.lookIntoFormat = value;
    }

    public void setCharset(Charset value) {
        this.charset = value;
    }

    public void setOperation(Operation value) {
        this.operation = value;
    }

    public void setMaxCount(int n) {
        this.maxCount = n;
    }

    public void setInverted(boolean value) {
        this.inverted = value;
    }

    public void setDisassembleClassFiles(boolean value) {
        this.disassembleClassFiles = value;
    }

    public void setDisassembleClassFilesVerbose(boolean value) {
        this.disassembleClassFilesVerbose = value;
    }

    public void setDisassembleClassFilesSourceDirectory(@Nullable File value) {
        this.disassembleClassFilesSourceDirectory = value;
    }

    public void setDisassembleClassFilesButHideLines(boolean value) {
        this.disassembleClassFilesButHideLines = value;
    }

    public void setDisassembleClassFilesButHideVars(boolean value) {
        this.disassembleClassFilesButHideVars = value;
    }

    public void setDisassembleClassFilesSymbolicLabels(boolean value) {
        this.disassembleClassFilesSymbolicLabels = value;
    }

    public void addSearch(Glob path, String regex, boolean caseSensitive) {
        this.searches.add(new Search(path, Pattern.compile(regex, caseSensitive ? 0 : 2)));
    }

    public void setExceptionHandler(ExceptionHandler<IOException> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setDirectoryMemberNameComparator(@Nullable Comparator<Object> directoryMemberNameComparator) {
        this.directoryMemberNameComparator = directoryMemberNameComparator;
    }

    public boolean getLinesSelected() {
        return this.linesSelected;
    }

    public ContentsProcessor<Void> contentsProcessor() {
        return new ContentsProcessor<Void>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @Nullable
            public Void process(String path, InputStream is, long size, long crc32, ProducerWhichThrows<? extends InputStream, ? extends IOException> opener) throws IOException {
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                for (Search search : Grep.this.searches) {
                    if (!search.path.matches(path)) continue;
                    patterns.add(search.pattern);
                }
                if (patterns.isEmpty()) {
                    return null;
                }
                Printers.verbose(path);
                if (Grep.this.disassembleClassFiles && path.endsWith(".class")) {
                    DisassemblerByteFilter disassemblerByteFilter = new DisassemblerByteFilter();
                    disassemblerByteFilter.setVerbose(Grep.this.disassembleClassFilesVerbose);
                    disassemblerByteFilter.setSourceDirectory(Grep.this.disassembleClassFilesSourceDirectory);
                    disassemblerByteFilter.setHideLines(Grep.this.disassembleClassFilesButHideLines);
                    disassemblerByteFilter.setHideVars(Grep.this.disassembleClassFilesButHideVars);
                    disassemblerByteFilter.setSymbolicLabels(Grep.this.disassembleClassFilesSymbolicLabels);
                    is = new ByteFilterInputStream(is, disassemblerByteFilter);
                }
                ConsumerUtil.Produmer<Long, Number> bytesRead = ConsumerUtil.cumulate();
                if (Grep.this.withByteOffset) {
                    is = InputStreams.wye(is, OutputStreams.lengthWritten(bytesRead));
                }
                int matchCountInDocument = 0;
                int lineNumber = 1;
                LinkedList<String> beforeContext = new LinkedList<String>();
                int afterContextLinesToPrint = 0;
                PushbackReader pbr = new PushbackReader(new BufferedReader(new InputStreamReader(is, Grep.this.charset)));
                block16: while (true) {
                    long byteOffset = (Long)AssertionUtil.notNull(bytesRead.produce());
                    String line = Grep.readLine(pbr);
                    if (line == null) break;
                    if (afterContextLinesToPrint > 0) {
                        Printers.info(this.composeMatch(path, lineNumber, byteOffset, line, '-'));
                    }
                    boolean lineContainsMatches = false;
                    block17: for (Pattern pattern : patterns) {
                        Matcher m = pattern.matcher(line);
                        block18: while (m.find()) {
                            switch (Grep.this.operation) {
                                case NORMAL: 
                                case COUNT: 
                                case FILES_WITH_MATCHES: 
                                case FILES_WITHOUT_MATCH: 
                                case QUIET: {
                                    lineContainsMatches = true;
                                    break block17;
                                }
                                case ONLY_MATCHING: {
                                    Printers.info(this.composeMatch(path, lineNumber, byteOffset, m.group(0), ':'));
                                }
                                default: {
                                    continue block18;
                                }
                            }
                        }
                    }
                    if (lineContainsMatches ^ Grep.this.inverted) {
                        Grep.this.linesSelected = true;
                        ++matchCountInDocument;
                        switch (Grep.this.operation) {
                            case NORMAL: {
                                while (!beforeContext.isEmpty()) {
                                    Printers.info((String)beforeContext.remove());
                                }
                                Printers.info(this.composeMatch(path, lineNumber, byteOffset, line, ':'));
                                afterContextLinesToPrint = Grep.this.afterContext + 1;
                                break;
                            }
                            case COUNT: 
                            case ONLY_MATCHING: {
                                break;
                            }
                            case FILES_WITH_MATCHES: 
                            case FILES_WITHOUT_MATCH: 
                            case QUIET: {
                                break block16;
                            }
                        }
                        if (matchCountInDocument >= Grep.this.maxCount) break;
                    }
                    if (afterContextLinesToPrint == 0 && Grep.this.beforeContext > 0) {
                        if (beforeContext.size() >= Grep.this.beforeContext) {
                            beforeContext.remove();
                        }
                        beforeContext.add(this.composeMatch(path, lineNumber, byteOffset, line, '-'));
                    }
                    if (afterContextLinesToPrint > 0) {
                        --afterContextLinesToPrint;
                    }
                    ++lineNumber;
                }
                switch (Grep.this.operation) {
                    case NORMAL: 
                    case QUIET: 
                    case ONLY_MATCHING: {
                        return null;
                    }
                    case COUNT: {
                        Printers.info(path + ':' + matchCountInDocument);
                        return null;
                    }
                    case FILES_WITH_MATCHES: {
                        if (matchCountInDocument <= 0) return null;
                        Printers.info(path);
                        return null;
                    }
                    case FILES_WITHOUT_MATCH: {
                        if (matchCountInDocument != 0) return null;
                        Printers.info(path);
                        return null;
                    }
                }
                return null;
            }

            private String composeMatch(String path, int lineNumber, long byteOffset, String text, char separator) {
                StringBuilder sb = new StringBuilder();
                if (Grep.this.withPath) {
                    sb.append(Grep.this.label != null ? Grep.this.label : path).append(separator);
                }
                if (Grep.this.withLineNumber) {
                    sb.append(lineNumber).append(separator);
                }
                if (Grep.this.withByteOffset) {
                    sb.append(byteOffset).append(separator);
                }
                sb.append(text);
                return sb.toString();
            }
        };
    }

    public FileProcessor<Void> fileProcessor(boolean lookIntoDirectories) {
        Predicate<Object> pathPredicate = PredicateUtil.never();
        for (Search search : this.searches) {
            pathPredicate = PredicateUtil.or(pathPredicate, search.path);
        }
        FileProcessor<Void> fp = FileProcessings.recursiveCompressedAndArchiveFileProcessor(this.lookIntoFormat, PredicateUtil.always(), ContentsProcessings.nopArchiveCombiner(), new SelectiveContentsProcessor<Void>(pathPredicate, this.contentsProcessor(), ContentsProcessings.nopContentsProcessor()), this.exceptionHandler);
        if (lookIntoDirectories) {
            fp = FileProcessings.directoryTreeProcessor(pathPredicate, fp, this.directoryMemberNameComparator, FileProcessings.nopDirectoryCombiner(), new SquadExecutor(ConcurrentUtil.SEQUENTIAL_EXECUTOR_SERVICE), this.exceptionHandler);
        }
        return fp;
    }

    @Nullable
    static String readLine(PushbackReader pbr) throws IOException {
        int c = pbr.read();
        if (c == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1000);
        while (c != -1 && c != 10) {
            if (c == 13) {
                c = pbr.read();
                if (c == 10) break;
                pbr.unread(c);
                break;
            }
            if (sb.length() < 65536) {
                sb.append((char)c);
            }
            c = pbr.read();
        }
        return sb.toString();
    }

    private final class Search {
        final Glob path;
        final Pattern pattern;

        Search(Glob path, Pattern pattern) {
            this.path = path;
            this.pattern = pattern;
        }
    }

    public static enum Operation {
        NORMAL,
        COUNT,
        FILES_WITH_MATCHES,
        FILES_WITHOUT_MATCH,
        ONLY_MATCHING,
        QUIET;

    }
}

