/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.find;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.FileUtil;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.file.resourceprocessing.ResourceProcessings;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ProcessUtil;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.RunnableUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.jdisasm.Disassembler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.compressors.CompressorInputStream;

public class Find {
    private static final String PRUNE_PROPERTY_NAME = "$PRUNE";
    private static final Logger LOGGER;
    private Predicate<? super String> lookIntoFormat = PredicateUtil.always();
    private boolean descendantsFirst;
    private int minDepth;
    private int maxDepth = Integer.MAX_VALUE;
    private Expression expression = Test.TRUE;
    private ConsumerWhichThrows<? super IOException, IOException> exceptionHandler = ConsumerUtil.throwsSubject();

    public void setLookIntoFormat(Predicate<? super String> value) {
        LOGGER.log(Level.FINE, "setLookIntoFormat({0})", value);
        this.lookIntoFormat = value;
    }

    public void setDescendantsFirst(boolean value) {
        this.descendantsFirst = value;
    }

    public void setMinDepth(int levels) {
        this.minDepth = levels;
    }

    public void setMaxDepth(int levels) {
        this.maxDepth = levels;
    }

    public void setExpression(Expression value) {
        LOGGER.log(Level.FINE, "setExpression({0})", value);
        this.expression = value;
    }

    public Find setExceptionHandler(ConsumerWhichThrows<? super IOException, IOException> value) {
        this.exceptionHandler = value;
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void findInStream(InputStream is) throws IOException {
        if (this.maxDepth < 0) {
            return;
        }
        this.findInStream("-", System.in, Mappings.mapping("isDirectory", false, "isExecutable", false, "isReadable", true, "isWritable", false, "lastModifiedDate", new Date(), "path", "-", "size", -1L), 0);
    }

    public void findInResource(String path, URL resource) throws IOException {
        this.findInResource(path, resource, 0);
    }

    public void findInFile(File file) throws IOException {
        this.findInResource(file.getPath(), file.toURI().toURL(), 0);
    }

    private void findInDirectory(final String directoryPath, final File directory, final int currentDepth) throws IOException {
        LOGGER.log(Level.FINER, "Processing directory \"{0}\" (path is \"{1}\")", new Object[]{directory, directoryPath});
        final boolean[] prune = new boolean[1];
        RunnableUtil.swapIf(this.descendantsFirst, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() {
                Find.this.evaluateExpression(Mappings.augment(Find.fileProperties(directoryPath, directory), "type", "directory", "depth", currentDepth, Find.PRUNE_PROPERTY_NAME, prune));
            }
        }, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                if (!prune[0] && currentDepth < Find.this.maxDepth) {
                    String[] memberNames = directory.list();
                    if (memberNames == null) {
                        throw new IOException(directory + ": Permission denied");
                    }
                    for (String memberName : memberNames) {
                        String memberPath = directoryPath + File.separatorChar + memberName;
                        try {
                            Find.this.findInResource(memberPath, new File(directory, memberName).toURI().toURL(), currentDepth + 1);
                        }
                        catch (IOException ioe) {
                            Find.this.exceptionHandler.consume(ExceptionUtil.wrap("Continue with next directory member after member \"" + memberPath + "\"", ioe));
                        }
                    }
                }
            }
        });
    }

    public static Mapping<String, Object> fileProperties(final String path, final File file) {
        return Mappings.propertiesOf(new Object(){

            public String getAbsolutePath() {
                return file.getAbsolutePath();
            }

            public String getCanonicalPath() throws IOException {
                return file.getCanonicalPath();
            }

            public File getFile() {
                return file;
            }

            public Date getLastModifiedDate() {
                return new Date(file.lastModified());
            }

            public String getName() {
                return file.getName();
            }

            public String getPath() {
                return path;
            }

            public long getSize() {
                return file.length();
            }

            public boolean isDirectory() {
                return file.isDirectory();
            }

            public boolean isFile() {
                return file.isFile();
            }

            public boolean isHidden() {
                return file.isHidden();
            }

            public boolean isReadable() {
                return file.canRead();
            }

            public boolean isWritable() {
                return file.canWrite();
            }

            public boolean isExecutable() {
                return file.canExecute();
            }

            public String toString() {
                return "File \"" + path + "\"";
            }
        });
    }

    public static Mapping<String, Object> resourceProperties(final String path, final URL resource) {
        try {
            return Mappings.augment(Find.fileProperties(path, new File(resource.toURI())), "type", "file");
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Mappings.propertiesOf(new Object(){

                public String getType() {
                    return resource.getProtocol() + "-resource";
                }

                public String getAuthority() {
                    return resource.getAuthority();
                }

                public int getDefaultPort() {
                    return resource.getDefaultPort();
                }

                public String getExternalForm() {
                    return resource.toExternalForm();
                }

                public String getFile() {
                    return resource.getFile();
                }

                public String getHost() {
                    return resource.getHost();
                }

                public String getPath() {
                    return path;
                }

                public int getPort() {
                    return resource.getPort();
                }

                public String getProtocol() {
                    return resource.getProtocol();
                }

                public String getQuery() {
                    return resource.getQuery();
                }

                public String getRef() {
                    return resource.getRef();
                }

                public String getUserInfo() {
                    return resource.getUserInfo();
                }

                public String toString() {
                    return "Resource \"" + path + "\"";
                }
            });
        }
    }

    public static de.unkrig.commons.text.expression.Expression parseExt(String spec) {
        ExpressionEvaluator ee = new ExpressionEvaluator(PredicateUtil.always());
        try {
            return ee.parseExt(spec);
        }
        catch (ParseException pe) {
            throw ExceptionUtil.wrap("Parsing \"" + spec + "\"", pe, IllegalArgumentException.class);
        }
    }

    @Nullable
    private static String evaluateExpression(de.unkrig.commons.text.expression.Expression expression, Mapping<String, Object> variables) {
        variables = Mappings.union(variables, Mappings.constant(""));
        try {
            return expression.evaluateTo(variables, String.class);
        }
        catch (EvaluationException ee) {
            throw ExceptionUtil.wrap("Evaluating \"" + expression + "\"", ee, IllegalArgumentException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInResource(String path, URL resource, int currentDepth) throws IOException {
        LOGGER.log(Level.FINER, "Processing \"{0}\" (path is \"{1}\")", new Object[]{resource, path});
        File file = ResourceProcessings.isFile(resource);
        if (file != null && file.isDirectory()) {
            this.findInDirectory(path, file, currentDepth);
            return;
        }
        Mapping<String, Object> resourceProperties = Find.resourceProperties(path, resource);
        CompressUtil.ArchiveHandler<Void> archiveHandler = this.archiveHandler(path, resourceProperties, currentDepth);
        CompressUtil.CompressorHandler<Void> compressorHandler = this.compressorHandler(path, resourceProperties, currentDepth);
        CompressUtil.NormalContentsHandler<Void> normalContentsHandler = this.normalContentsHandler(path, resourceProperties, currentDepth);
        File file2 = ResourceProcessings.isFile(resource);
        if (file2 != null) {
            CompressUtil.processFile(path, file2, this.lookIntoFormat, archiveHandler, compressorHandler, normalContentsHandler);
        } else {
            InputStream is = resource.openStream();
            try {
                CompressUtil.processStream(path, is, this.lookIntoFormat, archiveHandler, compressorHandler, normalContentsHandler);
                is.close();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void findInStream(String path, InputStream inputStream, Mapping<String, Object> streamProperties, int currentDepth) throws IOException {
        streamProperties = Mappings.override(streamProperties, "type", "contents", "path", path);
        try {
            CompressUtil.processStream(path, inputStream, this.lookIntoFormat, this.archiveHandler(path, streamProperties, currentDepth), this.compressorHandler(path, streamProperties, currentDepth), this.normalContentsHandler(path, streamProperties, currentDepth));
        }
        catch (UnsupportedZipFeatureException uzfe) {
            throw new IOException(path + "!" + uzfe.getEntry().getName() + ": Unsupported ZIP feature \"" + uzfe.getFeature() + "\"", uzfe);
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap(path, ioe);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.wrap(path, re);
        }
    }

    private CompressUtil.CompressorHandler<Void> compressorHandler(final String path, final Mapping<String, Object> properties, final int currentDepth) {
        return new CompressUtil.CompressorHandler<Void>(){

            @Override
            @Nullable
            public Void handleCompressor(final CompressorInputStream compressorInputStream, final CompressionFormat compressionFormat) throws IOException {
                RunnableUtil.swapIf(Find.this.descendantsFirst, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() {
                        Find.this.evaluateExpression(Mappings.override(properties, "type", "compressed-" + properties.get("type"), "path", path, "compressionFormat", compressionFormat, "depth", currentDepth));
                    }
                }, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() throws IOException {
                        if (currentDepth < Find.this.maxDepth) {
                            Object name = properties.get("name");
                            assert (name != null);
                            Find.this.findInStream(path + '%', compressorInputStream, Mappings.override(properties, "compressionFormat", compressionFormat, "name", name + "%", "size", -1L), currentDepth + 1);
                        }
                    }
                });
                return null;
            }
        };
    }

    private CompressUtil.ArchiveHandler<Void> archiveHandler(final String path, final Mapping<String, Object> properties, final int currentDepth) {
        return new CompressUtil.ArchiveHandler<Void>(){

            @Override
            @Nullable
            public Void handleArchive(final ArchiveInputStream archiveInputStream, final ArchiveFormat archiveFormat) throws IOException {
                final boolean[] prune = new boolean[1];
                RunnableUtil.swapIf(Find.this.descendantsFirst, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() {
                        Find.this.evaluateExpression(Mappings.override(properties, "type", "archive-" + properties.get("type"), "archiveFormat", archiveFormat, "depth", currentDepth, Find.PRUNE_PROPERTY_NAME, prune[0]));
                    }
                }, new RunnableWhichThrows<IOException>(){

                    @Override
                    public void run() throws IOException {
                        if (prune[0] || currentDepth >= Find.this.maxDepth) {
                            return;
                        }
                        ArchiveEntry ae = archiveInputStream.getNextEntry();
                        while (ae != null) {
                            String entryName = ArchiveFormatFactory.normalizeEntryName(ae.getName());
                            String entryPath = path + '!' + entryName;
                            if (ae.isDirectory()) {
                                Find.this.evaluateExpression(Mappings.override(Mappings.union(Mappings.propertiesOf(ae), properties), "path", entryPath, "name", entryName, "archiveFormat", archiveFormat, "type", "directory-entry", "depth", currentDepth + 1));
                            } else {
                                try {
                                    Find.this.findInStream(entryPath, archiveInputStream, Mappings.override(Mappings.union(Mappings.propertiesOf(ae), properties), "archiveFormat", archiveFormat), currentDepth + 1);
                                }
                                catch (IOException ioe) {
                                    Find.this.exceptionHandler.consume(ExceptionUtil.wrap("Continue with next " + archiveFormat + " archive entry after entry \"" + entryPath + "\"", ioe));
                                }
                            }
                            ae = archiveInputStream.getNextEntry();
                        }
                    }
                });
                return null;
            }
        };
    }

    private CompressUtil.NormalContentsHandler<Void> normalContentsHandler(final String path, final Mapping<String, Object> properties, final int currentDepth) {
        return new CompressUtil.NormalContentsHandler<Void>(){

            @Override
            @Nullable
            public Void handleNormalContents(final InputStream inputStream) {
                Find.this.evaluateExpression(Mappings.override(properties, "path", path, "type", "normal-" + properties.get("type"), "inputStream", inputStream, "depth", currentDepth, "size", new Producer<Long>(){

                    @Override
                    @Nullable
                    public Long produce() {
                        Long size = (Long)properties.get("size");
                        assert (size != null);
                        if (size != -1L) {
                            return size;
                        }
                        try {
                            return InputStreams.skipAll(inputStream);
                        }
                        catch (IOException ioe) {
                            throw ExceptionUtil.wrap("Measuring size of \"" + path + "\"", ioe, RuntimeException.class);
                        }
                    }
                }));
                return null;
            }
        };
    }

    private void evaluateExpression(Mapping<String, Object> properties) {
        if (this.minDepth > 0) {
            Object depthValue = properties.get("depth");
            assert (depthValue instanceof Integer);
            int currentDepth = (Integer)depthValue;
            if (currentDepth < this.minDepth) {
                return;
            }
        }
        this.expression.evaluate(properties);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(Find.class.getName());
    }

    public static class DeleteAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            File file = (File)properties.get("file");
            if (file == null) {
                throw new RuntimeException("\"-delete\" is only possible on files (and not on archive entries)");
            }
            if (!FileUtil.attemptToDeleteRecursively(file)) {
                System.err.printf("Could not remove file \"%s\"", file.toString());
                return false;
            }
            return true;
        }

        public String toString() {
            return "(delete)";
        }
    }

    public static class PruneAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            boolean[] prune = Mappings.get(properties, Find.PRUNE_PROPERTY_NAME, boolean[].class);
            if (prune != null) {
                prune[0] = true;
            }
            return true;
        }

        public String toString() {
            return "(prune)";
        }
    }

    public static class ChecksumAction
    implements Action {
        private final ChecksumType checksumType;

        ChecksumAction(ChecksumType checksumType) {
            this.checksumType = checksumType;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Checksum cs = this.checksumType.newChecksum();
            InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            try {
                ChecksumAction.updateAll(cs, is);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-checksum' on '" + properties + "'", ioe, RuntimeException.class);
            }
            Printers.info(Long.toHexString(cs.getValue()));
            return true;
        }

        private static void updateAll(Checksum checksum, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                checksum.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(checksum " + (Object)((Object)this.checksumType) + ")";
        }

        static enum ChecksumType {
            CRC32{

                @Override
                Checksum newChecksum() {
                    return new CRC32();
                }
            }
            ,
            ADLER32{

                @Override
                Checksum newChecksum() {
                    return new Adler32();
                }
            };


            abstract Checksum newChecksum();
        }
    }

    public static class DigestAction
    implements Action {
        private final String algorithm;

        DigestAction(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw ExceptionUtil.wrap("Running '-digest' on '" + properties + "'", nsae, IllegalArgumentException.class);
            }
            InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            try {
                DigestAction.updateAll(md, is);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-digest' on '" + properties + "'", ioe, RuntimeException.class);
            }
            byte[] digest = md.digest();
            Formatter f = new Formatter();
            for (byte b : digest) {
                f.format("%02x", b & 0xFF);
            }
            Printers.info(f.toString());
            return true;
        }

        private static void updateAll(MessageDigest messageDigest, InputStream inputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int n;
            while ((n = inputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, n);
            }
            return;
        }

        public String toString() {
            return "(digest " + this.algorithm + ")";
        }
    }

    public static class DisassembleAction
    implements Action {
        private final boolean verbose;
        @Nullable
        private final File sourceDirectory;
        private final boolean hideLines;
        private final boolean hideVars;
        private final boolean symbolicLabels;
        @Nullable
        private final File toFile;

        DisassembleAction(boolean verbose, @Nullable File sourceDirectory, boolean hideLines, boolean hideVars, boolean symbolicLabels, @Nullable File toFile) {
            this.verbose = verbose;
            this.sourceDirectory = sourceDirectory;
            this.hideLines = hideLines;
            this.hideVars = hideVars;
            this.symbolicLabels = symbolicLabels;
            this.toFile = toFile;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            final Disassembler disassembler = new Disassembler();
            disassembler.setVerbose(this.verbose);
            disassembler.setSourcePath(new File[]{this.sourceDirectory});
            disassembler.setShowLineNumbers(!this.hideLines);
            disassembler.setShowVariableNames(!this.hideVars);
            disassembler.setSymbolicLabels(this.symbolicLabels);
            final InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            File toFile = this.toFile;
            try {
                if (toFile == null) {
                    disassembler.disasm(in);
                } else {
                    IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

                        @Override
                        public void consume(OutputStream os) throws IOException {
                            disassembler.setOut(os);
                            disassembler.disasm(in);
                        }
                    }, true);
                }
            }
            catch (IOException ioe) {
                return false;
            }
            return true;
        }

        public String toString() {
            return "(Disassemble .class file)";
        }
    }

    public static class PipeAction
    implements Action {
        private final List<de.unkrig.commons.text.expression.Expression> command = new ArrayList<de.unkrig.commons.text.expression.Expression>();
        @Nullable
        private final File workingDirectory;

        PipeAction(List<String> command, @Nullable File workingDirectory) {
            for (String word : command) {
                this.command.add(Find.parseExt(word));
            }
            this.workingDirectory = workingDirectory;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
            ArrayList<String> command2 = new ArrayList<String>();
            for (de.unkrig.commons.text.expression.Expression word : this.command) {
                command2.add(Find.evaluateExpression(word, properties));
            }
            try {
                return ProcessUtil.execute(command2, this.workingDirectory, in, false, System.out, false, System.err, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap("Running 'pipe' on '" + properties + "'", e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(pipe contents to command " + this.command + ")";
        }
    }

    public static class CopyAction
    implements Action {
        private final de.unkrig.commons.text.expression.Expression tofile;
        private final boolean mkdirs;

        CopyAction(File tofile, boolean mkdirs) {
            this.tofile = Find.parseExt(tofile.getPath());
            this.mkdirs = mkdirs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            File tofile = new File(Find.evaluateExpression(this.tofile, properties));
            assert (tofile != null);
            try {
                if (this.mkdirs) {
                    IoUtil.createMissingParentDirectoriesFor(tofile);
                }
                InputStream in = Mappings.getNonNull(properties, "inputStream", InputStream.class);
                FileOutputStream out = new FileOutputStream(tofile);
                try {
                    IoUtil.copy(in, out);
                    ((OutputStream)out).close();
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Copying \"" + properties + "\" to \"" + tofile + "\"", ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(copy to '" + this.tofile + "')";
        }
    }

    public static class CatAction
    implements Action {
        private final OutputStream out;

        CatAction(OutputStream out) {
            this.out = out;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            try {
                InputStream is = Mappings.getNonNull(properties, "inputStream", InputStream.class);
                IoUtil.copy(is, this.out);
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Running '-cat' on '" + properties + "'", ioe, RuntimeException.class);
            }
            return true;
        }

        public String toString() {
            return "(cat " + this.out + ")";
        }
    }

    public static class ExecAction
    implements Action {
        private final List<de.unkrig.commons.text.expression.Expression> command = new ArrayList<de.unkrig.commons.text.expression.Expression>();

        ExecAction(List<String> command) {
            for (String word : command) {
                this.command.add(Find.parseExt(word));
            }
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            ArrayList<String> command2 = new ArrayList<String>();
            for (de.unkrig.commons.text.expression.Expression e : this.command) {
                command2.add(Find.evaluateExpression(e, properties));
            }
            try {
                return ProcessUtil.execute(command2, null, System.in, false, System.out, false, System.err, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap("Executing '" + command2 + "'", e, RuntimeException.class);
            }
        }

        public String toString() {
            return "(exec '" + this.command + "')";
        }
    }

    public static class LsAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info(String.format("%c%c%c%c %10d %tF %<tT %s", Character.valueOf(Mappings.getNonNull(properties, "isDirectory", Boolean.TYPE) != false ? (char)'d' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isReadable", Boolean.TYPE) != false ? (char)'r' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isWritable", Boolean.TYPE) != false ? (char)'w' : '-'), Character.valueOf(Mappings.getNonNull(properties, "isExecutable", Boolean.TYPE) != false ? (char)'x' : '-'), Mappings.getNonNull(properties, "size", Long.class), Mappings.getNonNull(properties, "lastModifiedDate", Date.class), Mappings.getNonNull(properties, "path", String.class)));
            return true;
        }

        public String toString() {
            return "(lsp)";
        }
    }

    public static class PrintfAction
    implements Action {
        private final String format;
        private final String[] argExpressions;

        PrintfAction(String format, String[] argExpressions) {
            this.format = format;
            this.argExpressions = argExpressions;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            String message;
            Object[] args = new Object[this.argExpressions.length];
            for (int i = 0; i < args.length; ++i) {
                String argExpression = this.argExpressions[i];
                try {
                    args[i] = new ExpressionEvaluator(Mappings.containsKeyPredicate(properties)).evaluate(argExpression, properties);
                    continue;
                }
                catch (ParseException pe) {
                    throw ExceptionUtil.wrap("Parsing '" + argExpression + "'", pe, RuntimeException.class);
                }
                catch (EvaluationException ee) {
                    throw ExceptionUtil.wrap("Evaluating '" + argExpression + "'", ee, RuntimeException.class);
                }
            }
            try {
                message = new Formatter().format(this.format, args).out().toString();
            }
            catch (RuntimeException re) {
                throw ExceptionUtil.wrap("Formatting '" + this.format + "'", re);
            }
            Printers.info(message);
            return true;
        }

        public String toString() {
            return "(echo '" + this.format + "')";
        }
    }

    public static class EchoAction
    implements Action {
        private final de.unkrig.commons.text.expression.Expression message;

        EchoAction(String message) {
            this.message = Find.parseExt(message);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info(Find.evaluateExpression(this.message, properties));
            return true;
        }

        public String toString() {
            return "(echo '" + this.message + "')";
        }
    }

    public static class PrintAction
    implements Action {
        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Printers.info(Mappings.getNonNull(properties, "path", String.class));
            return true;
        }

        public String toString() {
            return "(print)";
        }
    }

    static interface Action
    extends Expression {
    }

    public static class ModificationTimeTest
    extends PredicateTest<Date> {
        public static final long DAYS = 86400000L;
        public static final long MINUTES = 60000L;

        public ModificationTimeTest(final Predicate<? super Long> predicate, final long factor) {
            super("lastModifiedDate", Date.class, new Predicate<Date>(){

                @Override
                public boolean evaluate(Date lastModifiedDate) {
                    long milliseconds = System.currentTimeMillis() - lastModifiedDate.getTime();
                    long days = milliseconds / factor;
                    return predicate.evaluate(days);
                }

                public String toString() {
                    return "(" + predicate + " days)";
                }
            });
        }
    }

    public static class SizeTest
    extends PredicateTest<Long> {
        public SizeTest(Predicate<? super Long> predicate) {
            super("size", Long.class, predicate);
        }
    }

    public static class ExecutabilityTest
    extends BooleanTest {
        public ExecutabilityTest() {
            super("canExecute");
        }
    }

    public static class WritabilityTest
    extends BooleanTest {
        public WritabilityTest() {
            super("canWrite");
        }
    }

    public static class ReadabilityTest
    extends BooleanTest {
        public ReadabilityTest() {
            super("canRead");
        }
    }

    public static class TypeTest
    extends GlobTest {
        public TypeTest(String typeGlob) {
            super("type", typeGlob);
        }
    }

    public static class PathTest
    extends GlobTest {
        public PathTest(String pathGlob) {
            super("path", pathGlob);
        }
    }

    public static class NameTest
    extends GlobTest {
        public NameTest(String nameGlob) {
            super("name", nameGlob);
        }
    }

    public static class GlobTest
    extends StringPredicateTest {
        GlobTest(String propertyName, String pattern) {
            super(propertyName, Glob.compile(pattern, -1610612736));
        }
    }

    public static class StringPredicateTest
    implements Test {
        private final Predicate<? super String> predicate;
        private final String propertyName;

        StringPredicateTest(String propertyName, Predicate<? super String> predicate) {
            this.propertyName = propertyName;
            this.predicate = predicate;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Object propertyValue = Mappings.get(properties, this.propertyName, Object.class);
            return propertyValue != null && this.predicate.evaluate(propertyValue.toString());
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    public static abstract class PredicateTest<T>
    implements Test {
        private final Predicate<? super T> predicate;
        private final Class<T> propertyType;
        private final String propertyName;

        PredicateTest(String propertyName, Class<T> propertyType, Predicate<? super T> predicate) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.predicate = predicate;
        }

        @Override
        public final boolean evaluate(Mapping<String, Object> properties) {
            T propertyValue = Mappings.get(properties, this.propertyName, this.propertyType);
            return propertyValue != null && this.predicate.evaluate(propertyValue);
        }

        public final String toString() {
            return "( " + this.propertyName + " =* '" + this.predicate + "')";
        }
    }

    public static class BooleanTest
    implements Test {
        private final String propertyName;

        public BooleanTest(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            Boolean value = Mappings.get(properties, this.propertyName, Boolean.class);
            return value != null && value != false;
        }

        public final String toString() {
            return this.propertyName;
        }
    }

    public static class NotExpression
    extends UnaryTest {
        NotExpression(Expression operand) {
            super(operand);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return !this.operand.evaluate(properties);
        }

        public String toString() {
            return "(not " + this.operand + ")";
        }
    }

    public static class AndTest
    extends BinaryTest {
        AndTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) && this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " && " + this.rhs + ")";
        }
    }

    public static class OrTest
    extends BinaryTest {
        OrTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.lhs.evaluate(properties) || this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + " || " + this.rhs + ")";
        }
    }

    public static class CommaTest
    extends BinaryTest {
        CommaTest(Expression lhs, Expression rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            this.lhs.evaluate(properties);
            return this.rhs.evaluate(properties);
        }

        public String toString() {
            return "(" + this.lhs + ", " + this.rhs + ")";
        }
    }

    public static abstract class BinaryTest
    implements Test {
        protected final Expression lhs;
        protected final Expression rhs;

        BinaryTest(Expression lhs, Expression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    public static abstract class UnaryTest
    implements Test {
        protected final Expression operand;

        UnaryTest(Expression operand) {
            this.operand = operand;
        }
    }

    public static class ConstantTest
    implements Test {
        private final boolean value;

        public ConstantTest(boolean value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(Mapping<String, Object> properties) {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static interface Test
    extends Expression {
        public static final Test TRUE = new ConstantTest(true);
        public static final Test FALSE = new ConstantTest(false);

        @Override
        public boolean evaluate(Mapping<String, Object> var1);
    }

    public static interface Expression
    extends Predicate<Mapping<String, Object>> {
        @Override
        public boolean evaluate(Mapping<String, Object> var1);
    }
}

