/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.diff;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.zz.diff.Diff;
import de.unkrig.zz.diff.DocumentDiff;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class AntTask
extends Task {
    private final Diff diff = new Diff();
    @Nullable
    private String property;
    @Nullable
    private File outputFile;
    @Nullable
    private File file1;
    @Nullable
    private File file2;

    public void setRecurseSubdirectories(boolean value) {
        this.diff.setRecurseSubdirectories(value);
    }

    public void setIgnoreWhitespace(boolean value) {
        this.diff.setIgnoreWhitespace(value);
    }

    @Deprecated
    public void setAbsentFileMode(OldAbsentFileMode value) {
        switch (value) {
            case REPORT_AS_ADDED_OR_DELETED: {
                this.setAddedFileMode(Diff.AbsentFileMode.REPORT);
                this.setDeletedFileMode(Diff.AbsentFileMode.REPORT);
                break;
            }
            case COMPARE_ADDED_AND_DELETED_WITH_EMPTY: {
                this.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
                this.setDeletedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
                break;
            }
            case COMPARE_ADDED_WITH_EMPTY: {
                this.setAddedFileMode(Diff.AbsentFileMode.COMPARE_WITH_EMPTY);
                this.setDeletedFileMode(Diff.AbsentFileMode.REPORT);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)value));
            }
        }
    }

    public void setAddedFileMode(Diff.AbsentFileMode value) {
        this.diff.setAddedFileMode(value);
    }

    public void setDeletedFileMode(Diff.AbsentFileMode value) {
        this.diff.setDeletedFileMode(value);
    }

    public void setReportUnchangedFiles(boolean value) {
        this.diff.setReportUnchangedFiles(value);
    }

    public void setLookInto(String value) {
        this.diff.setLookInto(Glob.compile(value, -1610612736));
    }

    public void setDisassembleClassFiles(boolean value) {
        this.diff.setDisassembleClassFiles(value);
    }

    public void setDisassembleClassFilesVerbose(boolean value) {
        this.diff.setDisassembleClassFilesVerbose(value);
    }

    public void setDisassembleClassFilesSourceDirectory(@Nullable File value) {
        this.diff.setDisassembleClassFilesSourceDirectory(value);
    }

    public void setDisassembleClassFilesButHideLines(boolean value) {
        this.diff.setDisassembleClassFilesButHideLines(value);
    }

    public void setDisassembleClassFilesButHideVars(boolean value) {
        this.diff.setDisassembleClassFilesButHideVars(value);
    }

    public void setDisassembleClassFilesSymbolicLabels(boolean value) {
        this.diff.setDisassembleClassFilesSymbolicLabels(value);
    }

    public void setEncoding(String value) {
        this.diff.setCharset(Charset.forName(value));
    }

    public void setDiffMode(Diff.DiffMode value) {
        this.diff.setDiffMode(value);
    }

    public void setContextSize(int n) {
        this.diff.setContextSize(n);
    }

    public void setKeepGoing(boolean value) {
        this.diff.setExceptionHandler(value ? new ExceptionHandler<IOException>(){

            @Override
            public void handle(String path, IOException exception) {
                AntTask.this.log(path + ": " + exception.getMessage(), 0);
            }

            @Override
            public void handle(String path, RuntimeException runtimeException) {
                AntTask.this.log(path + ": " + runtimeException.getMessage(), 0);
            }
        } : ExceptionHandler.defaultHandler());
    }

    public void setSequential(boolean value) {
        this.diff.setSequential(value);
    }

    public void setTokenization(DocumentDiff.Tokenization value) {
        this.diff.setTokenization(value);
    }

    public void setIgnoreCStyleComments(boolean value) {
        this.diff.setIgnoreCStyleComments(value);
    }

    public void setIgnoreCPlusPlusStyleComments(boolean value) {
        this.diff.setIgnoreCPlusPlusStyleComments(value);
    }

    public void setIgnoreDocComments(boolean value) {
        this.diff.setIgnoreDocComments(value);
    }

    public void setOut(File file) {
        this.outputFile = file;
    }

    public void setFile1(File fileOrDirectory) {
        this.file1 = fileOrDirectory;
    }

    public void setFile2(File fileOrDirectory) {
        this.file2 = fileOrDirectory;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setPath(String pathGlob) {
        this.diff.setPathPredicate(Glob.compile(pathGlob, -1610612736));
    }

    public void addConfiguredEquivalentPath(Element__pathRegex element) {
        Pattern pathRegex = element.pathRegex;
        if (pathRegex == null) {
            throw new IllegalArgumentException("'nameRegex' attribute missing for <equivalentPath>");
        }
        this.diff.addEquivalentPath(pathRegex);
    }

    public void addConfiguredEquivalentLine(Element__path_regex element) {
        Pattern regex = element.regex;
        if (regex == null) {
            throw new IllegalArgumentException("'regex' attribute missing for <equivalentline>");
        }
        this.diff.addEquivalentLine(new DocumentDiff.LineEquivalence(element.path, regex));
    }

    public void addConfiguredIgnore(Element__path_regex element) {
        Pattern regex = element.regex;
        if (regex == null) {
            throw new IllegalArgumentException("'regex' attribute missing for <ignore>");
        }
        this.diff.addIgnore(new DocumentDiff.LineEquivalence(element.path, regex));
    }

    public void execute() {
        File file1 = this.file1;
        if (file1 == null) {
            throw new IllegalArgumentException("'file1' attribute missing");
        }
        File file2 = this.file2;
        if (file2 == null) {
            throw new IllegalArgumentException("'file2' attribute missing");
        }
        this.execute2(file1, file2);
    }

    private void execute2(File file1, File file2) {
        try {
            this.execute3(file1, file2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute3(final File file1, final File file2) throws Exception {
        AntTask.execute4(new RunnableWhichThrows<Exception>(){

            @Override
            public void run() throws Exception {
                long differenceCount = AntTask.this.diff.execute(file1.toURI().toURL(), file2.toURI().toURL());
                String property = AntTask.this.property;
                if (property != null && differenceCount == 0L) {
                    AntTask.this.getProject().setProperty(property, "true");
                }
            }
        }, this.outputFile, (ProjectComponent)this);
    }

    private static void execute4(RunnableWhichThrows<Exception> runnable, @Nullable File outputFile, final ProjectComponent component) throws Exception {
        AbstractPrinter printer = new AbstractPrinter(){

            @Override
            public void warn(@Nullable String message) {
                component.log(message, 1);
            }

            @Override
            public void verbose(@Nullable String message) {
                component.log(message, 3);
            }

            @Override
            public void info(@Nullable String message) {
                component.log(message, 2);
            }

            @Override
            public void error(@Nullable String message) {
                component.log(message, 0);
            }

            @Override
            public void debug(@Nullable String message) {
                component.log(message, 4);
            }
        };
        if (outputFile == null) {
            printer.run(runnable);
        } else {
            Printers.redirectToFile(AbstractPrinter.Level.INFO, outputFile, null, runnable);
        }
    }

    @Deprecated
    public static enum OldAbsentFileMode {
        REPORT_AS_ADDED_OR_DELETED,
        COMPARE_ADDED_AND_DELETED_WITH_EMPTY,
        COMPARE_ADDED_WITH_EMPTY;

    }

    public static class Element__path_regex {
        private Glob path = Glob.ANY;
        @Nullable
        private Pattern regex;

        public void setPath(String glob) {
            this.path = Glob.compile(glob, -1610612736);
        }

        public void setRegex(String regex) {
            this.regex = Pattern.compile(regex);
        }
    }

    public static class Element__pathRegex {
        @Nullable
        private Pattern pathRegex;

        public void setPathRegex(String regex) {
            this.pathRegex = Pattern.compile(regex);
        }
    }
}

