/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.jdisasm;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.jdisasm.BytecodeDisassembler;
import de.unkrig.jdisasm.ClassFile;
import de.unkrig.jdisasm.ConstantPool;
import de.unkrig.jdisasm.SignatureParser;
import de.unkrig.jdisasm.protocol.zip.Handler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Disassembler {
    private static final List<ConstantPool.ConstantClassInfo> NO_CONSTANT_CLASS_INFOS = Collections.emptyList();
    private static final List<SignatureParser.ThrowsSignature> NO_THROWS_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.TypeSignature> NO_TYPE_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.ClassTypeSignature> NO_CLASS_TYPE_SIGNATURES = Collections.emptyList();
    private static final List<SignatureParser.FormalTypeParameter> NO_FORMAL_TYPE_PARAMETERS = Collections.emptyList();
    private static final List<ClassFile.ParameterAnnotation> NO_PARAMETER_ANNOTATIONS = Collections.emptyList();
    private PrintWriter pw = new PrintWriter(System.out);
    boolean showClassPoolIndexes;
    boolean dumpConstantPool;
    boolean printAllAttributes;
    boolean printStackMap;
    private File[] sourcePath = new File[0];
    boolean showLineNumbers = true;
    boolean showVariableNames = true;
    boolean symbolicLabels;
    private SignatureParser signatureParser = new SignatureParser();
    private static final Pattern IS_URL = Pattern.compile("\\w\\w+:.*");

    public static void main(String[] args) throws IOException {
        String arg;
        int i;
        Handler.registerMe();
        Disassembler d = new Disassembler();
        for (i = 0; i < args.length && (arg = args[i]).charAt(0) == '-' && arg.length() != 1; ++i) {
            if ("-o".equals(arg)) {
                d.setOut(new FileOutputStream(args[++i]));
                continue;
            }
            if ("-verbose".equals(arg)) {
                d.setVerbose(true);
                continue;
            }
            if ("-src".equals(arg)) {
                d.setSourcePath(Disassembler.splitPath(args[++i]));
                continue;
            }
            if ("-hide-lines".equals(arg)) {
                d.setShowLineNumbers(false);
                continue;
            }
            if ("-hide-vars".equals(arg)) {
                d.setShowVariableNames(false);
                continue;
            }
            if ("-symbolic-labels".equals(arg)) {
                d.setSymbolicLabels(true);
                continue;
            }
            if ("-help".equals(arg)) {
                System.out.printf("Prints a disassembly listing of the given JAVA[TM] class files (or STDIN) to%nSTDOUT.%nUsage:%n  java %1$s [ <option> ] ... [ <class-file-name> | <class-file-url> | '-' ] ...%nValid options are:%n  -o <output-file>   Store disassembly output in a file.%n  -verbose%n  -src <source-path> Interweave the output with the class file's source code.%n  -hide-lines        Don't print line numbers.%n  -hide-vars         Don't resolve local variable names.%n  -symbolic-labels   Use symbolic labels instead of offsets.%n", Disassembler.class.getName());
                System.exit(0);
                continue;
            }
            System.err.println("Unrecognized command line option \"" + arg + "\"; try \"-help\".");
            System.exit(1);
        }
        if (i == args.length) {
            d.disasm(System.in);
        } else {
            while (i < args.length) {
                String name = args[i];
                if ("-".equals(name)) {
                    d.disasm(System.in);
                } else if (IS_URL.matcher(name).matches()) {
                    d.disasm(new URL(name));
                } else {
                    d.disasm(new File(name));
                }
                ++i;
            }
        }
    }

    private static File[] splitPath(@Nullable String path) {
        if (path == null) {
            return new File[0];
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        File dir = new File(st.nextToken());
        if (!st.hasMoreTokens()) {
            return new File[]{dir};
        }
        ArrayList<File> result = new ArrayList<File>();
        result.add(dir);
        while (st.hasMoreTokens()) {
            result.add(new File(st.nextToken()));
        }
        return result.toArray(new File[result.size()]);
    }

    public void setOut(Writer writer) {
        this.pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setOut(OutputStream stream) {
        this.pw = new PrintWriter(stream);
    }

    public void setOut(OutputStream stream, String charsetName) throws UnsupportedEncodingException {
        this.pw = new PrintWriter(new OutputStreamWriter(stream, charsetName));
    }

    public void setVerbose(boolean verbose) {
        this.setShowClassPoolIndexes(verbose);
        this.setConstantPoolDump(verbose);
        this.setPrintAllAttributes(verbose);
        this.setPrintStackMap(verbose);
    }

    public void setShowClassPoolIndexes(boolean showClassPoolIndexes) {
        this.showClassPoolIndexes = showClassPoolIndexes;
    }

    public void setConstantPoolDump(boolean dumpConstantPool) {
        this.dumpConstantPool = dumpConstantPool;
    }

    public void setPrintAllAttributes(boolean printAllAttributes) {
        this.printAllAttributes = printAllAttributes;
    }

    public void setPrintStackMap(boolean printStackMap) {
        this.printStackMap = printStackMap;
    }

    public void setSourcePath(File[] value) {
        this.sourcePath = value;
    }

    @Deprecated
    public void setSourceDirectory(@Nullable File sourceDirectory) {
        File[] fileArray;
        if (sourceDirectory == null) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = sourceDirectory;
        }
        this.setSourcePath(fileArray);
    }

    public void setShowLineNumbers(boolean value) {
        this.showLineNumbers = value;
    }

    @Deprecated
    public void setHideLines(boolean hideLines) {
        this.setShowLineNumbers(!hideLines);
    }

    public void setShowVariableNames(boolean value) {
        this.showVariableNames = value;
    }

    @Deprecated
    public void setHideVars(boolean hideVars) {
        this.setShowVariableNames(!hideVars);
    }

    public void setSymbolicLabels(boolean symbolicLabels) {
        this.symbolicLabels = symbolicLabels;
    }

    private void print(String s) {
        this.pw.print(s);
    }

    private void println() {
        this.pw.println();
    }

    private void println(String s) {
        this.pw.println(s);
    }

    private void printf(String format, Object ... args) {
        this.pw.printf(format, args);
    }

    public void disasm(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.pw.println();
            this.pw.println("// *** Disassembly of '" + file + "'.");
            this.disasm(is);
        }
        catch (IOException ioe) {
            IOException ioe2 = new IOException("Disassembling '" + file + "': " + ioe.getMessage());
            ioe2.initCause(ioe);
            throw ioe2;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Disassembling '" + file + "': " + re.getMessage(), re);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void disasm(URL location) throws IOException {
        InputStream is = location.openConnection().getInputStream();
        try {
            this.pw.println();
            this.pw.println("// *** Disassembly of '" + location + "'.");
            this.disasm(is);
        }
        catch (IOException ioe) {
            IOException ioe2 = new IOException("Disassembling '" + location + "': " + ioe.getMessage());
            ioe2.initCause(ioe);
            throw ioe2;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Disassembling '" + location + "': " + re.getMessage(), re);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void disasm(InputStream stream) throws IOException {
        try {
            this.disassembleClassFile(new DataInputStream(stream));
        }
        finally {
            this.pw.flush();
        }
    }

    private void disassembleClassFile(DataInputStream dis) throws IOException {
        ClassFile.InnerClassesAttribute ica;
        ClassFile.AccessFlags af;
        ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
        ClassFile.RuntimeInvisibleAnnotationsAttribute riaa;
        ClassFile.EnclosingMethodAttribute ema;
        ClassFile cf = new ClassFile(dis);
        this.println();
        this.println("// Class file version = " + cf.majorVersion + "." + cf.minorVersion + " (" + cf.getJdkName() + ")");
        final String tcpn = cf.thisClassName.substring(0, cf.thisClassName.lastIndexOf(46) + 1);
        this.signatureParser = new SignatureParser(new SignatureParser.Options(){

            @Override
            public String beautifyPackageNamePrefix(String packageNamePrefix) {
                return tcpn.equals(packageNamePrefix) || "java.lang.".equals(packageNamePrefix) ? "" : packageNamePrefix;
            }
        });
        cf.setSignatureParser(this.signatureParser);
        if (tcpn.length() > 0) {
            this.println();
            this.println("package " + tcpn.substring(0, tcpn.length() - 1) + ";");
        }
        if ((ema = cf.enclosingMethodAttribute) != null) {
            ConstantPool.ConstantNameAndTypeInfo m = ema.method;
            Iterator<ClassFile.Annotation> methodName = m == null ? "[initializer]" : m.name.bytes;
            this.println();
            this.println("// This class is enclosed by method '" + ema.clasS + ("<init>".equals(methodName) ? "(...)" : "." + methodName + "(...)") + "'.");
        }
        this.println();
        if (cf.accessFlags.is(ClassFile.AccessFlags.FlagType.SYNTHETIC) || cf.syntheticAttribute != null) {
            this.println("// This is a synthetic class.");
        }
        if (cf.deprecatedAttribute != null) {
            this.println("/** @deprecated */");
        }
        if ((riaa = cf.runtimeInvisibleAnnotationsAttribute) != null) {
            for (ClassFile.Annotation a : riaa.annotations) {
                this.println(a.toString());
            }
        }
        if ((rvaa = cf.runtimeVisibleAnnotationsAttribute) != null) {
            for (ClassFile.Annotation a : rvaa.annotations) {
                this.println(a.toString());
            }
        }
        if ((af = cf.accessFlags.remove(ClassFile.AccessFlags.FlagType.SYNCHRONIZED).remove(ClassFile.AccessFlags.FlagType.SYNTHETIC)).is(ClassFile.AccessFlags.FlagType.INTERFACE)) {
            af = af.remove(ClassFile.AccessFlags.FlagType.ABSTRACT);
        }
        if (af.is(ClassFile.AccessFlags.FlagType.ENUM)) {
            af = af.remove(ClassFile.AccessFlags.FlagType.FINAL);
        }
        this.print(Disassembler.typeAccessFlagsToString(af));
        ClassFile.SignatureAttribute sa = cf.signatureAttribute;
        if (sa != null) {
            this.print(this.decodeClassSignature(sa.signature).toString(cf.simpleThisClassName));
        } else {
            this.print(cf.simpleThisClassName);
        }
        String scn = cf.superClassName;
        if (scn != null && !"java.lang.Object".equals(scn)) {
            this.print(" extends " + scn);
        }
        List<String> ifs = cf.interfaceNames;
        if (cf.accessFlags.is(ClassFile.AccessFlags.FlagType.ANNOTATION)) {
            if (ifs.contains("java.lang.annotation.Annotation")) {
                ifs = new ArrayList<String>(ifs);
                ifs.remove("java.lang.annotation.Annotation");
            } else {
                this.print(" /* WARNING: This annotation type does not implement \"java.lang.annotation.Annotation\"! */");
            }
        }
        if (!ifs.isEmpty()) {
            Iterator<String> it = ifs.iterator();
            this.print(" implements " + it.next());
            while (it.hasNext()) {
                this.print(", " + it.next());
            }
        }
        this.println(" {");
        if (this.dumpConstantPool) {
            ConstantPool.ConstantPoolEntry constantPoolEntry;
            this.println();
            this.println("    // Constant pool dump:");
            ConstantPool cp = cf.constantPool;
            for (int i = 1; i < cp.getSize(); i += constantPoolEntry.size()) {
                constantPoolEntry = cp.get((short)i, ConstantPool.ConstantPoolEntry.class);
                this.println("    //   #" + i + ": " + constantPoolEntry.toString());
            }
        }
        if ((ica = cf.innerClassesAttribute) != null) {
            this.println();
            this.println("    // Enclosing/enclosed types:");
            for (ClassFile.InnerClassesAttribute.ClasS clasS : ica.classes) {
                this.println("    //   " + Disassembler.toString(clasS));
            }
        }
        this.disassembleFields(cf.fields);
        ClassFile.SourceFileAttribute sfa = cf.sourceFileAttribute;
        Map<Integer, String> sourceLines = null;
        for (File sourceDirectory : this.sourcePath) {
            if (sfa != null && (sourceLines = Disassembler.loadFile(new File(sourceDirectory, sfa.sourceFile))) != null) break;
            String toplevelClassName = cf.thisClassName;
            int idx = toplevelClassName.indexOf(36);
            if (idx != -1) {
                toplevelClassName = toplevelClassName.substring(0, idx);
            }
            if ((sourceLines = Disassembler.loadFile(new File(sourceDirectory, toplevelClassName.replace('.', File.separatorChar) + ".java"))) != null) break;
        }
        for (ClassFile.Method method : cf.methods) {
            this.disassembleMethod(method, sourceLines);
        }
        this.println("}");
        this.printAttributes(cf.unprocessedAttributes, cf.allAttributes, "// ", AttributeContext.CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<Integer, String> loadFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            return null;
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        LineNumberReader lnr = new LineNumberReader(new FileReader(file));
        try {
            String sl;
            while ((sl = lnr.readLine()) != null) {
                result.put(lnr.getLineNumber(), sl);
            }
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private void disassembleMethod(ClassFile.Method method, @Nullable Map<Integer, String> sourceLines) {
        try {
            ClassFile.CodeAttribute ca;
            ClassFile.AnnotationDefaultAttribute ada;
            Iterator<Object> it;
            ClassFile.ExceptionsAttribute ea;
            SignatureParser.MethodTypeSignature mts;
            ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
            ClassFile.RuntimeInvisibleAnnotationsAttribute riaa;
            this.println();
            if (method.accessFlags.is(ClassFile.AccessFlags.FlagType.SYNTHETIC) || method.syntheticAttribute != null) {
                this.println("    // (Synthetic method)");
            }
            if (method.accessFlags.is(ClassFile.AccessFlags.FlagType.BRIDGE)) {
                this.println("    // (Bridge method)");
            }
            if (method.deprecatedAttribute != null) {
                this.println("    /** @deprecated */");
            }
            if ((riaa = method.runtimeInvisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : riaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            if ((rvaa = method.runtimeVisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : rvaa.annotations) {
                    this.println("    " + a.toString());
                }
            }
            ClassFile.AccessFlags maf = method.accessFlags.remove(ClassFile.AccessFlags.FlagType.SYNTHETIC).remove(ClassFile.AccessFlags.FlagType.BRIDGE).remove(ClassFile.AccessFlags.FlagType.VARARGS);
            if (method.getClassFile().accessFlags.is(ClassFile.AccessFlags.FlagType.INTERFACE)) {
                maf = maf.remove(ClassFile.AccessFlags.FlagType.PUBLIC).remove(ClassFile.AccessFlags.FlagType.ABSTRACT);
            }
            this.print("    " + maf);
            ClassFile.SignatureAttribute sa = method.signatureAttribute;
            SignatureParser.MethodTypeSignature methodTypeSignature = mts = sa == null ? this.decodeMethodDescriptor(method.descriptor) : this.decodeMethodTypeSignature(sa.signature);
            if (!mts.formalTypeParameters.isEmpty()) {
                Iterator<SignatureParser.FormalTypeParameter> it2 = mts.formalTypeParameters.iterator();
                this.print("<" + it2.next());
                while (it2.hasNext()) {
                    this.print(", " + it2.next());
                }
                this.print(">");
            }
            List<ConstantPool.ConstantClassInfo> exceptionNames = (ea = method.exceptionsAttribute) == null ? NO_CONSTANT_CLASS_INFOS : ea.exceptionNames;
            String functionName = method.name;
            if (!("<clinit>".equals(functionName) && method.accessFlags.is(ClassFile.AccessFlags.FlagType.STATIC) && exceptionNames.isEmpty() && mts.formalTypeParameters.isEmpty() && mts.parameterTypes.isEmpty() && mts.returnType == SignatureParser.VOID && mts.thrownTypes.isEmpty())) {
                if ("<init>".equals(functionName) && !method.accessFlags.isAny(ClassFile.AccessFlags.FlagType.ABSTRACT, ClassFile.AccessFlags.FlagType.FINAL, ClassFile.AccessFlags.FlagType.INTERFACE, ClassFile.AccessFlags.FlagType.STATIC) && mts.formalTypeParameters.isEmpty() && mts.returnType == SignatureParser.VOID) {
                    this.print(method.getClassFile().simpleThisClassName);
                    this.printParameters(method.runtimeInvisibleParameterAnnotationsAttribute, method.runtimeVisibleParameterAnnotationsAttribute, method.methodParametersAttribute, mts.parameterTypes, method, (short)1, method.accessFlags.is(ClassFile.AccessFlags.FlagType.VARARGS));
                } else {
                    this.print(mts.returnType + " ");
                    this.print(functionName);
                    this.printParameters(method.runtimeInvisibleParameterAnnotationsAttribute, method.runtimeVisibleParameterAnnotationsAttribute, method.methodParametersAttribute, mts.parameterTypes, method, method.accessFlags.is(ClassFile.AccessFlags.FlagType.STATIC) ? (short)0 : 1, method.accessFlags.is(ClassFile.AccessFlags.FlagType.VARARGS));
                }
            }
            if (!mts.thrownTypes.isEmpty()) {
                it = mts.thrownTypes.iterator();
                this.print(" throws " + it.next());
                while (it.hasNext()) {
                    this.print(", " + it.next());
                }
            } else if (!exceptionNames.isEmpty()) {
                it = exceptionNames.iterator();
                this.print(" throws " + it.next());
                while (it.hasNext()) {
                    this.print(", " + it.next());
                }
            }
            if ((ada = method.annotationDefaultAttribute) != null) {
                this.print("default " + ada.defaultValue);
            }
            if ((ca = method.codeAttribute) == null) {
                this.println(";");
            } else {
                this.println(" {");
                try {
                    new BytecodeDisassembler(new ByteArrayInputStream(ca.code), ca.exceptionTable, ca.lineNumberTableAttribute, ca.stackMapTableAttribute, sourceLines, method, mts.parameterTypes.toArray(new SignatureParser.TypeSignature[mts.parameterTypes.size()]), this).disassembleBytecode(this.pw);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.println("    }");
                this.printAttributes(ca.unprocessedAttributes, ca.allAttributes, "    ", AttributeContext.METHOD);
            }
            this.printAttributes(method.unprocessedAttributes, method.allAttributes, "    // ", AttributeContext.METHOD);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException("Method '" + method.name + "' " + method.descriptor, rte);
        }
    }

    private void disassembleFields(List<ClassFile.Field> fields) {
        for (ClassFile.Field field : fields) {
            ClassFile.SignatureAttribute sa;
            ClassFile.RuntimeVisibleAnnotationsAttribute rvaa;
            this.println();
            ClassFile.RuntimeInvisibleAnnotationsAttribute riaa = field.runtimeInvisibleAnnotationsAttribute;
            if (riaa != null) {
                for (ClassFile.Annotation a : riaa.annotations) {
                    this.println("    " + a);
                }
            }
            if ((rvaa = field.runtimeVisibleAnnotationsAttribute) != null) {
                for (ClassFile.Annotation a : rvaa.annotations) {
                    this.println("    " + a);
                }
            }
            if (field.accessFlags.is(ClassFile.AccessFlags.FlagType.SYNTHETIC) || field.syntheticAttribute != null) {
                this.println("    // (Synthetic field)");
            }
            if (field.deprecatedAttribute != null) {
                this.println("    /** @deprecated */");
            }
            SignatureParser.TypeSignature typeSignature = (sa = field.signatureAttribute) != null ? this.decodeFieldTypeSignature(sa.signature) : this.decodeFieldDescriptor(field.descriptor);
            String prefix = field.accessFlags.remove(ClassFile.AccessFlags.FlagType.SYNTHETIC).toString() + typeSignature;
            ClassFile.ConstantValueAttribute cva = field.constantValueAttribute;
            if (cva == null) {
                this.printf("    %-40s %s;%n", prefix, field.name);
            } else {
                this.printf("    %-40s %-15s = %s;%n", prefix, field.name, cva.constantValue);
            }
            this.printAttributes(field.unprocessedAttributes, field.allAttributes, "    // ", AttributeContext.FIELD);
        }
    }

    private static String toString(ClassFile.InnerClassesAttribute.ClasS c) {
        ConstantPool.ConstantClassInfo oci = c.outerClassInfo;
        ConstantPool.ConstantClassInfo ici = c.innerClassInfo;
        ClassFile.AccessFlags icafs = c.innerClassAccessFlags;
        if (icafs.is(ClassFile.AccessFlags.FlagType.INTERFACE)) {
            icafs = icafs.remove(ClassFile.AccessFlags.FlagType.ABSTRACT).remove(ClassFile.AccessFlags.FlagType.STATIC);
        }
        return oci == null ? "anonymous class " + ici : oci + " { " + Disassembler.typeAccessFlagsToString(icafs) + ici + " }";
    }

    private void printAttributes(List<ClassFile.Attribute> unprocessedAttributes, List<ClassFile.Attribute> allAttributes, String prefix, AttributeContext context) {
        List<ClassFile.Attribute> tmp;
        List<ClassFile.Attribute> list = tmp = this.printAllAttributes ? allAttributes : unprocessedAttributes;
        if (tmp.isEmpty()) {
            return;
        }
        tmp = new ArrayList<ClassFile.Attribute>(tmp);
        Collections.sort(tmp, new Comparator<ClassFile.Attribute>(){

            @Override
            @NotNullByDefault(value=false)
            public int compare(ClassFile.Attribute a1, ClassFile.Attribute a2) {
                return a1.getName().compareTo(a2.getName());
            }
        });
        this.println(prefix + (this.printAllAttributes ? "All attributes:" : "Unprocessed attributes:"));
        PrintAttributeVisitor visitor = new PrintAttributeVisitor(prefix + "  ", context);
        for (ClassFile.Attribute a : tmp) {
            a.accept(visitor);
        }
    }

    private void printParameters(@Nullable ClassFile.RuntimeInvisibleParameterAnnotationsAttribute ripaa, @Nullable ClassFile.RuntimeVisibleParameterAnnotationsAttribute rvpaa, @Nullable ClassFile.MethodParametersAttribute mpa, List<SignatureParser.TypeSignature> parameterTypes, ClassFile.Method method, short firstIndex, boolean varargs) {
        Iterator ipas = (ripaa == null ? NO_PARAMETER_ANNOTATIONS : ripaa.parameterAnnotations).iterator();
        this.print("(");
        Iterator<ClassFile.ParameterAnnotation> vpas = (rvpaa == null ? NO_PARAMETER_ANNOTATIONS : rvpaa.parameterAnnotations).iterator();
        Iterator<Object> ps = (mpa == null ? Collections.emptyList() : mpa.parameters).iterator();
        Iterator<SignatureParser.TypeSignature> it = parameterTypes.iterator();
        if (it.hasNext()) {
            while (true) {
                SignatureParser.TypeSignature pts = it.next();
                if (ipas.hasNext()) {
                    for (ClassFile.Annotation a : ((ClassFile.ParameterAnnotation)ipas.next()).annotations) {
                        this.print(a + " ");
                    }
                }
                if (vpas.hasNext()) {
                    for (ClassFile.Annotation a : vpas.next().annotations) {
                        this.print(a + " ");
                    }
                }
                if (ps.hasNext()) {
                    this.print(((ClassFile.MethodParametersAttribute.Parameter)ps.next()).accessFlags.toString());
                }
                if (varargs && !it.hasNext() && pts instanceof SignatureParser.ArrayTypeSignature) {
                    this.print(((SignatureParser.ArrayTypeSignature)pts).componentTypeSignature + "...");
                } else {
                    this.print(pts.toString());
                }
                this.print(' ' + this.getLocalVariable((short)firstIndex, (int)0, (ClassFile.Method)method).name);
                if (!it.hasNext()) break;
                firstIndex = (short)(firstIndex + 1);
                this.print(", ");
            }
        }
        this.print(")");
    }

    LocalVariable getLocalVariable(short localVariableIndex, int instructionOffset, ClassFile.Method method) {
        int firstParameter;
        int n = firstParameter = method.accessFlags.is(ClassFile.AccessFlags.FlagType.STATIC) ? 0 : 1;
        if (localVariableIndex < firstParameter) {
            return new LocalVariable(null, "this");
        }
        ClassFile.SignatureAttribute sa = method.signatureAttribute;
        SignatureParser.MethodTypeSignature mts = sa != null ? this.decodeMethodTypeSignature(sa.signature) : this.decodeMethodDescriptor(method.descriptor);
        List<SignatureParser.TypeSignature> parameterTypes = mts.parameterTypes;
        int plvi = firstParameter;
        int parameterIndex = -1;
        for (int pi = 0; pi < parameterTypes.size(); ++pi) {
            if (plvi == localVariableIndex) {
                parameterIndex = pi;
                break;
            }
            SignatureParser.TypeSignature pt = parameterTypes.get(pi);
            plvi += pt == SignatureParser.LONG || pt == SignatureParser.DOUBLE ? 2 : 1;
        }
        String defaultName = parameterIndex != -1 ? "p" + parameterIndex : "v" + localVariableIndex;
        ClassFile.CodeAttribute ca = method.codeAttribute;
        if (ca != null) {
            ClassFile.LocalVariableTableAttribute lvta;
            ClassFile.LocalVariableTypeTableAttribute lvtta = ca.localVariableTypeTableAttribute;
            if (lvtta != null) {
                for (ClassFile.LocalVariableTypeTableAttribute.Entry lvtte : lvtta.entries) {
                    if (instructionOffset < lvtte.startPC || instructionOffset > lvtte.startPC + lvtte.length || localVariableIndex != lvtte.index) continue;
                    return new LocalVariable(this.decodeFieldTypeSignature(lvtte.signature), this.showVariableNames ? lvtte.name : defaultName);
                }
            }
            if ((lvta = ca.localVariableTableAttribute) != null) {
                for (ClassFile.LocalVariableTableAttribute.Entry lvte : lvta.entries) {
                    if (instructionOffset < lvte.startPC || instructionOffset > lvte.startPC + lvte.length || localVariableIndex != lvte.index) continue;
                    return new LocalVariable(this.decodeFieldDescriptor(lvte.descriptor), this.showVariableNames ? lvte.name : defaultName);
                }
            }
        }
        ClassFile.MethodParametersAttribute mpa = method.methodParametersAttribute;
        if (parameterIndex != -1 && mpa != null) {
            return new LocalVariable(parameterTypes.get(parameterIndex), this.showVariableNames ? mpa.parameters.get((int)parameterIndex).name : defaultName);
        }
        return new LocalVariable(null, defaultName);
    }

    private SignatureParser.ClassSignature decodeClassSignature(String cs) {
        try {
            return this.signatureParser.decodeClassSignature(cs);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding class signature '" + cs + "': " + e.getMessage());
            return new SignatureParser.ClassSignature(NO_FORMAL_TYPE_PARAMETERS, this.signatureParser.object, NO_CLASS_TYPE_SIGNATURES);
        }
    }

    private SignatureParser.FieldTypeSignature decodeFieldTypeSignature(String fs) {
        try {
            return this.signatureParser.decodeFieldTypeSignature(fs);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding field type signature '" + fs + "': " + e.getMessage());
            return this.signatureParser.object;
        }
    }

    SignatureParser.MethodTypeSignature decodeMethodTypeSignature(String ms) {
        try {
            return this.signatureParser.decodeMethodTypeSignature(ms);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding method type signature '" + ms + "': " + e.getMessage());
            return new SignatureParser.MethodTypeSignature(NO_FORMAL_TYPE_PARAMETERS, NO_TYPE_SIGNATURES, SignatureParser.VOID, NO_THROWS_SIGNATURES);
        }
    }

    SignatureParser.TypeSignature decodeFieldDescriptor(String fd) {
        try {
            return this.signatureParser.decodeFieldDescriptor(fd);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding field descriptor '" + fd + "': " + e.getMessage());
            return SignatureParser.INT;
        }
    }

    SignatureParser.MethodTypeSignature decodeMethodDescriptor(String md) {
        try {
            return this.signatureParser.decodeMethodDescriptor(md);
        }
        catch (SignatureParser.SignatureException e) {
            this.error("Decoding method descriptor '" + md + "': " + e.getMessage());
            return new SignatureParser.MethodTypeSignature(NO_FORMAL_TYPE_PARAMETERS, NO_TYPE_SIGNATURES, SignatureParser.VOID, NO_THROWS_SIGNATURES);
        }
    }

    private void error(String message) {
        this.pw.println("*** Error: " + message);
    }

    private static String typeAccessFlagsToString(ClassFile.AccessFlags af) {
        String result = af.toString();
        if (!(af.is(ClassFile.AccessFlags.FlagType.ENUM) || af.is(ClassFile.AccessFlags.FlagType.ANNOTATION) || af.is(ClassFile.AccessFlags.FlagType.INTERFACE))) {
            result = result + "class ";
        }
        return result;
    }

    class LocalVariable {
        @Nullable
        final SignatureParser.TypeSignature typeSignature;
        final String name;

        LocalVariable(SignatureParser.TypeSignature typeSignature, String name) {
            this.typeSignature = typeSignature;
            this.name = name;
        }

        public String toString() {
            SignatureParser.TypeSignature ts = this.typeSignature;
            return ts == null ? '[' + this.name + ']' : '[' + ts.toString() + ' ' + this.name + ']';
        }
    }

    public class PrintAttributeVisitor
    implements ClassFile.AttributeVisitor {
        private final String prefix;
        private final AttributeContext context;

        public PrintAttributeVisitor(String prefix, AttributeContext context) {
            this.prefix = prefix;
            this.context = context;
        }

        @Override
        public void visit(ClassFile.AnnotationDefaultAttribute ada) {
            Disassembler.this.println(this.prefix + "AnnotationDefault:");
            Disassembler.this.println(this.prefix + "  " + ada.defaultValue.toString());
        }

        @Override
        public void visit(ClassFile.BootstrapMethodsAttribute bma) {
            Disassembler.this.println(this.prefix + "BootstrapMethods:");
            for (ClassFile.BootstrapMethodsAttribute.BootstrapMethod bm : bma.bootstrapMethods) {
                Disassembler.this.println(this.prefix + "  " + bm);
            }
        }

        @Override
        public void visit(ClassFile.CodeAttribute ca) {
            Disassembler.this.println(this.prefix + "Code:");
            Disassembler.this.println(this.prefix + "  max_locals = " + ca.maxLocals);
            Disassembler.this.println(this.prefix + "  max_stack = " + ca.maxStack);
            Disassembler.this.println(this.prefix + "  code = {");
            this.print(ca.code);
            Disassembler.this.println(this.prefix + "  }");
            Disassembler.this.printAttributes(ca.unprocessedAttributes, ca.allAttributes, this.prefix + "  ", AttributeContext.METHOD);
        }

        private void print(byte[] data) {
            for (int i = 0; i < data.length; i += 32) {
                int idx;
                Disassembler.this.print(this.prefix + "   ");
                for (int j = 0; j < 32 && (idx = i + j) < data.length; ++j) {
                    Disassembler.this.printf("%c%02x", new Object[]{Character.valueOf(j == 16 ? (char)'-' : ' '), 0xFF & data[idx]});
                }
                Disassembler.this.println();
            }
        }

        @Override
        public void visit(ClassFile.ConstantValueAttribute cva) {
            Disassembler.this.println(this.prefix + "ConstantValue:");
            Disassembler.this.println(this.prefix + "  constant_value = " + cva.constantValue);
        }

        @Override
        public void visit(ClassFile.DeprecatedAttribute da) {
            Disassembler.this.println(this.prefix + "DeprecatedAttribute:");
            Disassembler.this.println(this.prefix + "  -");
        }

        @Override
        public void visit(ClassFile.EnclosingMethodAttribute ema) {
            Disassembler.this.println(this.prefix + "EnclosingMethod:");
            ConstantPool.ConstantNameAndTypeInfo m = ema.method;
            Disassembler.this.println(this.prefix + "  class/method = " + (m == null ? "(none)" : Disassembler.this.decodeMethodDescriptor(m.descriptor.bytes).toString(ema.clasS.toString(), m.name.bytes)));
        }

        @Override
        public void visit(ClassFile.ExceptionsAttribute ea) {
            Disassembler.this.println(this.prefix + "Exceptions:");
            for (ConstantPool.ConstantClassInfo en : ea.exceptionNames) {
                Disassembler.this.println(this.prefix + "  " + en);
            }
        }

        @Override
        public void visit(ClassFile.InnerClassesAttribute ica) {
            Disassembler.this.println(this.prefix + "InnerClasses:");
            for (ClassFile.InnerClassesAttribute.ClasS c : ica.classes) {
                Disassembler.this.println(this.prefix + "  " + Disassembler.toString(c));
            }
        }

        @Override
        public void visit(ClassFile.LineNumberTableAttribute lnta) {
            Disassembler.this.println(this.prefix + "LineNumberTable:");
            for (ClassFile.LineNumberTableEntry e : lnta.entries) {
                Disassembler.this.println(this.prefix + "  " + e.startPc + " => Line " + e.lineNumber);
            }
        }

        @Override
        public void visit(ClassFile.LocalVariableTableAttribute lvta) {
            Disassembler.this.println(this.prefix + "LocalVariableTable:");
            for (ClassFile.LocalVariableTableAttribute.Entry e : lvta.entries) {
                Disassembler.this.println(this.prefix + "  " + (0xFFFF & e.startPC) + "+" + e.length + ": " + e.index + " = " + Disassembler.this.decodeFieldDescriptor(e.descriptor) + " " + e.name);
            }
        }

        @Override
        public void visit(ClassFile.LocalVariableTypeTableAttribute lvtta) {
            Disassembler.this.println(this.prefix + "LocalVariableTypeTable:");
            for (ClassFile.LocalVariableTypeTableAttribute.Entry e : lvtta.entries) {
                Disassembler.this.println(this.prefix + "  " + e.startPC + "+" + e.length + ": " + e.index + " = " + Disassembler.this.decodeFieldTypeSignature(e.signature) + " " + e.name);
            }
        }

        @Override
        public void visit(ClassFile.MethodParametersAttribute mpa) {
            Disassembler.this.println(this.prefix + "MethodParameters:");
            for (ClassFile.MethodParametersAttribute.Parameter p : mpa.parameters) {
                Disassembler.this.println(this.prefix + "  " + p);
            }
        }

        @Override
        public void visit(ClassFile.RuntimeInvisibleAnnotationsAttribute riaa) {
            Disassembler.this.println(this.prefix + "RuntimeInvisibleAnnotations:");
            for (ClassFile.Annotation a : riaa.annotations) {
                Disassembler.this.println(this.prefix + "  " + a);
            }
        }

        @Override
        public void visit(ClassFile.RuntimeVisibleAnnotationsAttribute rvaa) {
            Disassembler.this.println(this.prefix + "RuntimeVisibleAnnotations:");
            for (ClassFile.Annotation a : rvaa.annotations) {
                Disassembler.this.println(this.prefix + "  " + a);
            }
        }

        @Override
        public void visit(ClassFile.RuntimeInvisibleParameterAnnotationsAttribute ripaa) {
            Disassembler.this.println(this.prefix + "RuntimeInvisibleParameterAnnotations:");
            for (ClassFile.ParameterAnnotation pa : ripaa.parameterAnnotations) {
                for (ClassFile.Annotation a : pa.annotations) {
                    Disassembler.this.println(this.prefix + "  " + a);
                }
            }
        }

        @Override
        public void visit(ClassFile.RuntimeVisibleParameterAnnotationsAttribute rvpaa) {
            Disassembler.this.println(this.prefix + "RuntimeVisibleParameterAnnotations:");
            for (ClassFile.ParameterAnnotation pa : rvpaa.parameterAnnotations) {
                for (ClassFile.Annotation a : pa.annotations) {
                    Disassembler.this.println(this.prefix + "  " + a);
                }
            }
        }

        @Override
        public void visit(ClassFile.SignatureAttribute sa) {
            Disassembler.this.println(this.prefix + "Signature:");
            switch (this.context) {
                case CLASS: {
                    Disassembler.this.println(this.prefix + "  " + Disassembler.this.decodeClassSignature(sa.signature).toString("[this-class]"));
                    break;
                }
                case FIELD: {
                    Disassembler.this.println(this.prefix + "  " + Disassembler.this.decodeFieldTypeSignature(sa.signature).toString());
                    break;
                }
                case METHOD: {
                    Disassembler.this.println(this.prefix + "  " + Disassembler.this.decodeMethodTypeSignature(sa.signature).toString("[declaring-class]", "[this-method]"));
                }
            }
        }

        @Override
        public void visit(ClassFile.SourceFileAttribute sfa) {
            Disassembler.this.println(this.prefix + "SourceFile:");
            Disassembler.this.println(this.prefix + "  " + sfa.sourceFile);
        }

        @Override
        public void visit(ClassFile.StackMapTableAttribute smta) {
            Disassembler.this.println(this.prefix + "StackMapTable:");
            Disassembler.this.println(this.prefix + "  0: append_frame(method parameters)");
            int bytecodeOffset = -1;
            for (ClassFile.StackMapFrame smf : smta.entries) {
                Disassembler.this.println(this.prefix + "  " + (bytecodeOffset += 1 + smf.offsetDelta) + ": " + smf);
            }
        }

        @Override
        public void visit(ClassFile.SyntheticAttribute sa) {
            Disassembler.this.println(this.prefix + "Synthetic:");
            Disassembler.this.println(this.prefix + " -");
        }

        @Override
        public void visit(ClassFile.UnknownAttribute ua) {
            Disassembler.this.println(this.prefix + ua.name + ":");
            Disassembler.this.println(this.prefix + "  data = {");
            this.print(ua.info);
            Disassembler.this.println(this.prefix + "}");
        }
    }

    private static enum AttributeContext {
        CLASS,
        FIELD,
        METHOD;

    }
}

