/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class OptionalMethods {
    private OptionalMethods() {
    }

    public static <R> MethodWrapper0<Object, R, RuntimeException> get0(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName) {
        return OptionalMethods.get0(message, declaringClassLoader, declaringClassName, methodName, null);
    }

    public static <R, EX extends Throwable> MethodWrapper0<Object, R, EX> get0(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, @Nullable Class<EX> checkedException) {
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            return OptionalMethods.get0(message, declaringClassLoader.loadClass(declaringClassName), methodName, checkedException);
        }
        catch (ClassNotFoundException e) {
            return OptionalMethods.missingMethod0(message, declaringClassName, methodName);
        }
    }

    public static <DC, R> MethodWrapper0<DC, R, RuntimeException> get0(@Nullable String message, Class<DC> declaringClass, String methodName) {
        return OptionalMethods.get0(message, declaringClass, methodName, null);
    }

    public static <DC, R, EX extends Throwable> MethodWrapper0<DC, R, EX> get0(@Nullable String message, Class<DC> declaringClass, String methodName, final @Nullable Class<EX> checkedException) {
        try {
            final Method method = declaringClass.getMethod(methodName, new Class[0]);
            return new MethodWrapper0<DC, R, EX>(){

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @Nullable
                public R invoke(@Nullable DC target) throws Throwable {
                    return OptionalMethods.invoke(method, target, checkedException, new Object[0]);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return OptionalMethods.missingMethod0(message, declaringClass.getName(), methodName);
        }
    }

    public static <R, P> MethodWrapper1<?, R, P, RuntimeException> get1(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P> parameterType) {
        return OptionalMethods.get1(message, declaringClassLoader, declaringClassName, methodName, parameterType, null);
    }

    public static <R, P, EX extends Throwable> MethodWrapper1<?, R, P, EX> get1(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P> parameterType, @Nullable Class<EX> checkedException) {
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            return OptionalMethods.get1(message, declaringClassLoader.loadClass(declaringClassName), methodName, parameterType, checkedException);
        }
        catch (ClassNotFoundException cnfe) {
            return OptionalMethods.missingMethod1(message, declaringClassName, methodName, parameterType);
        }
    }

    public static <DC, R, P> MethodWrapper1<DC, R, P, RuntimeException> get1(@Nullable String message, Class<DC> declaringClass, String methodName, Class<P> parameterType) {
        return OptionalMethods.get1(message, declaringClass, methodName, parameterType, null);
    }

    public static <DC, R, P, EX extends Throwable> MethodWrapper1<DC, R, P, EX> get1(@Nullable String message, Class<DC> declaringClass, String methodName, Class<P> parameterType, final @Nullable Class<EX> checkedException) {
        try {
            final Method method = declaringClass.getMethod(methodName, parameterType);
            return new MethodWrapper1<DC, R, P, EX>(){

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @Nullable
                public R invoke(@Nullable DC target, @Nullable P argument) throws Throwable {
                    return OptionalMethods.invoke(method, target, checkedException, new Object[]{argument});
                }
            };
        }
        catch (NoSuchMethodException e) {
            return OptionalMethods.missingMethod1(message, declaringClass.getName(), methodName, parameterType);
        }
    }

    public static <R, P1, P2> MethodWrapper2<?, R, P1, P2, RuntimeException> get2(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P1> parameterType1, Class<P2> parameterType2) {
        return OptionalMethods.get2(message, declaringClassLoader, declaringClassName, methodName, parameterType1, parameterType2, null);
    }

    public static <R, P1, P2, EX extends Throwable> MethodWrapper2<?, R, P1, P2, EX> get2(@Nullable String message, @Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P1> parameterType1, Class<P2> parameterType2, @Nullable Class<EX> checkedException) {
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            return OptionalMethods.get2(message, declaringClassLoader.loadClass(declaringClassName), methodName, parameterType1, parameterType2, checkedException);
        }
        catch (ClassNotFoundException e) {
            return OptionalMethods.missingMethod2(message, declaringClassName, methodName, parameterType1, parameterType2);
        }
    }

    public static <DC, R, P1, P2> MethodWrapper2<DC, R, P1, P2, RuntimeException> get2(@Nullable String message, Class<DC> declaringClass, String methodName, Class<P1> parameterType1, Class<P2> parameterType2) {
        return OptionalMethods.get2(message, declaringClass, methodName, parameterType1, parameterType2, null);
    }

    public static <DC, R, P1, P2, EX extends Throwable> MethodWrapper2<DC, R, P1, P2, EX> get2(@Nullable String message, Class<DC> declaringClass, String methodName, Class<P1> parameterType1, Class<P2> parameterType2, final @Nullable Class<EX> checkedException) {
        Method method;
        try {
            method = declaringClass.getMethod(methodName, parameterType1, parameterType2);
        }
        catch (NoSuchMethodException nsme) {
            try {
                method = declaringClass.getDeclaredMethod(methodName, parameterType1, parameterType2);
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
            }
            catch (NoSuchMethodException nsme2) {
                return OptionalMethods.missingMethod2(message, declaringClass.getName(), methodName, parameterType1, parameterType2);
            }
        }
        final Method finalMethod = method;
        return new MethodWrapper2<DC, R, P1, P2, EX>(){

            @Override
            public boolean isAvailable() {
                return true;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target, @Nullable P1 argument1, @Nullable P2 argument2) throws Throwable {
                return OptionalMethods.invoke(finalMethod, target, checkedException, new Object[]{argument1, argument2});
            }
        };
    }

    private static <DC, R, EX extends Throwable> MethodWrapper0<DC, R, EX> missingMethod0(final @Nullable String explicitMessage, final String declaringClassName, final String methodName) {
        return new MethodWrapper0<DC, R, EX>(){

            @Override
            public boolean isAvailable() {
                return false;
            }

            @Override
            @Nullable
            public R invoke(@Nullable Object target) {
                throw new UnsupportedOperationException(OptionalMethods.cookMessage(explicitMessage, declaringClassName, methodName, new Class[0]));
            }
        };
    }

    private static <DC, R, P, EX extends Throwable> MethodWrapper1<DC, R, P, EX> missingMethod1(final @Nullable String explicitMessage, final String declaringClassName, final String methodName, final Class<P> parameterType) {
        return new MethodWrapper1<DC, R, P, EX>(){

            @Override
            public boolean isAvailable() {
                return false;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target, @Nullable P argument) {
                throw new UnsupportedOperationException(OptionalMethods.cookMessage(explicitMessage, declaringClassName, methodName, new Class[]{parameterType}));
            }
        };
    }

    private static <DC, R, P1, P2, EX extends Throwable> MethodWrapper2<DC, R, P1, P2, EX> missingMethod2(final @Nullable String explicitMessage, final String declaringClassName, final String methodName, final Class<P1> parameterType1, final Class<P2> parameterType2) {
        return new MethodWrapper2<DC, R, P1, P2, EX>(){

            @Override
            public boolean isAvailable() {
                return false;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target, @Nullable P1 argument1, @Nullable P2 argument2) {
                throw new UnsupportedOperationException(OptionalMethods.cookMessage(explicitMessage, declaringClassName, methodName, new Class[]{parameterType1, parameterType2}));
            }
        };
    }

    private static String cookMessage(@Nullable String explicitMessage, String declaringClassName, String methodName, Class<?> ... parameterTypes) {
        if (explicitMessage != null) {
            return explicitMessage;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(declaringClassName).append('.').append(methodName).append('(');
        if (parameterTypes.length >= 1) {
            sb.append(parameterTypes[0]);
            for (int i = 1; i < parameterTypes.length; ++i) {
                sb.append(", ").append(parameterTypes[i]);
            }
        }
        return sb.append(')').toString();
    }

    private static <DC, R, EX extends Throwable> R invoke(Method method, @Nullable DC target, @Nullable Class<EX> checkedException, Object ... arguments) throws EX {
        try {
            return (R)method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            assert (checkedException != null) : "Caught undeclared checked exception " + te;
            assert (checkedException.isAssignableFrom(te.getClass()));
            throw te;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface MethodWrapper2<DC, R, P1, P2, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1, @Nullable P1 var2, @Nullable P2 var3) throws EX;
    }

    public static interface MethodWrapper1<DC, R, P, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1, @Nullable P var2) throws EX;
    }

    public static interface MethodWrapper0<DC, R, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1) throws EX;
    }
}

