/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.OptionalMethods;
import de.unkrig.commons.lang.protocol.NoException;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Characters {
    public static final Predicate<Integer> IS_POSIX_LOWER = Characters.rangePredicate("posixLower", 97, 122);
    public static final Predicate<Integer> IS_POSIX_UPPER = Characters.rangePredicate("posixUpper", 65, 90);
    public static final Predicate<Integer> IS_POSIX_ASCII = Characters.rangePredicate("posixAscii", 0, 127);
    public static final Predicate<Integer> IS_POSIX_ALPHA = new IntegerPredicate("posixAlpha"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90;
        }
    };
    public static final Predicate<Integer> IS_POSIX_DIGIT = Characters.rangePredicate("posixDigit", 48, 57);
    public static final Predicate<Integer> IS_POSIX_ALNUM = new IntegerPredicate("posixAlnum"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp >= 48 && cp <= 57;
        }
    };
    public static final Predicate<Integer> IS_POSIX_PUNCT = new IntegerPredicate("posixPunct"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp >= 33 && cp <= 47 || cp >= 58 && cp <= 64 || cp >= 91 && cp <= 96 || cp >= 123 && cp <= 126;
        }
    };
    public static final Predicate<Integer> IS_POSIX_GRAPH = new IntegerPredicate("posixGraph"){

        @Override
        public boolean evaluate(Integer subject) {
            return IS_POSIX_ALNUM.evaluate(subject) || IS_POSIX_PUNCT.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_POSIX_PRINT = new IntegerPredicate("posixPrint"){

        @Override
        public boolean evaluate(Integer subject) {
            return subject == 32 || IS_POSIX_ALNUM.evaluate(subject) || IS_POSIX_PUNCT.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_POSIX_BLANK = new IntegerPredicate("posixBlank"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp == 32 || cp == 9;
        }
    };
    public static final Predicate<Integer> IS_POSIX_CNTRL = new IntegerPredicate("posixCntrl"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp <= 31 || cp == 127;
        }
    };
    public static final Predicate<Integer> IS_POSIX_XDIGIT = new IntegerPredicate("posixXdigit"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp >= 48 && cp <= 57 || cp >= 97 && cp <= 102 || cp >= 65 && cp <= 70;
        }
    };
    public static final Predicate<Integer> IS_POSIX_SPACE = new IntegerPredicate("posixSpace"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp <= 13 && cp >= 9 || cp == 32;
        }
    };
    public static final Predicate<Integer> IS_ISO_CONTROL = new IntegerPredicate("javaISOControl"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isISOControl(subject);
        }
    };
    public static final Predicate<Integer> IS_SPACE_CHAR = new IntegerPredicate("javaSpaceChar"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isSpaceChar(subject);
        }
    };
    public static final Predicate<Integer> IS_DEFINED = new IntegerPredicate("javaDefined"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isDefined(subject);
        }
    };
    public static final Predicate<Integer> IS_JAVA_IDENTIFIER_START = new IntegerPredicate("isJavaIdentifierStart"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isJavaIdentifierStart(subject);
        }
    };
    public static final Predicate<Integer> IS_JAVA_IDENTIFIER_PART = new IntegerPredicate("isJavaIdentifierPart"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isJavaIdentifierPart(subject);
        }
    };
    public static final Predicate<Integer> IS_IDENTIFIER_IGNORABLE = new IntegerPredicate("isIdentifierIgnorable"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isIdentifierIgnorable(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_IDENTIFIER_START = new IntegerPredicate("isUnicodeIdentifierStart"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isUnicodeIdentifierStart(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_IDENTIFIER_PART = new IntegerPredicate("isUnicodeIdentifierPart"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isUnicodeIdentifierPart(subject);
        }
    };
    public static final Predicate<Integer> IS_LETTER_OR_DIGIT = new IntegerPredicate("javaDefined"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLetterOrDigit(subject);
        }
    };
    public static final Predicate<Integer> IS_WHITESPACE = new IntegerPredicate("javaWhitespace"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isWhitespace(subject);
        }
    };
    public static final Predicate<Integer> IS_HORIZONTAL_WHITESPACE = new IntegerPredicate("horizontalWhitespace"){

        @Override
        public boolean evaluate(Integer subject) {
            return Characters.isHorizontalWhitespace(subject);
        }
    };
    public static final Predicate<Integer> IS_MIRRORED = new IntegerPredicate("mirrored"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isMirrored(subject);
        }
    };
    public static final Predicate<Integer> IS_WORD = new IntegerPredicate("posixWord"){

        @Override
        public boolean evaluate(Integer subject) {
            return Characters.isWordCharacter(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_UNASSIGNED = Characters.unicodeGeneralCategoryPredicate("unicodeUnassigned", (byte)0);
    public static final Predicate<Integer> IS_UNICODE_LETTER = new IntegerPredicate("unicodeLetter"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLetter(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_UPPER = new IntegerPredicate("unicodeUpper"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isUpperCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_LOWER = new IntegerPredicate("unicodeLower"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLowerCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_TITLE = new IntegerPredicate("unicodeTitle"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isTitleCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_MODIFIER_LETTER = Characters.unicodeGeneralCategoryPredicate("unicodeModifier", (byte)4);
    public static final Predicate<Integer> IS_UNICODE_OTHER_LETTER = Characters.unicodeGeneralCategoryPredicate("unicodeOther", (byte)5);
    public static final Predicate<Integer> IS_UNICODE_NON_SPACING_MARK = Characters.unicodeGeneralCategoryPredicate("unicodeNonSpacingNark", (byte)6);
    public static final Predicate<Integer> IS_UNICODE_ENCLOSING_MARK = Characters.unicodeGeneralCategoryPredicate("unicodeEnclosingMark", (byte)7);
    public static final Predicate<Integer> IS_UNICODE_COMBINING_SPACING_MARK = Characters.unicodeGeneralCategoryPredicate("unicodeCombiningSpacingMark", (byte)8);
    public static final Predicate<Integer> IS_UNICODE_DECIMAL_DIGIT_NUMBER = Characters.unicodeGeneralCategoryPredicate("unicodeDecimalDigitNumber", (byte)9);
    public static final Predicate<Integer> IS_UNICODE_LETTER_NUMBER = Characters.unicodeGeneralCategoryPredicate("unicodeLetterNumber", (byte)10);
    public static final Predicate<Integer> IS_UNICODE_OTHER_NUMBER = Characters.unicodeGeneralCategoryPredicate("unicodeOtherNumber", (byte)11);
    public static final Predicate<Integer> IS_UNICODE_SPACE_SEPARATOR = Characters.unicodeGeneralCategoryPredicate("unicodeSpaceSeparator", (byte)12);
    public static final Predicate<Integer> IS_UNICODE_LINE_SEPARATOR = Characters.unicodeGeneralCategoryPredicate("unicodeLineSeparator", (byte)13);
    public static final Predicate<Integer> IS_UNICODE_PARAGRAPH_SEPARATOR = Characters.unicodeGeneralCategoryPredicate("unicodeParagraphSeparator", (byte)14);
    public static final Predicate<Integer> IS_UNICODE_CONTROL = Characters.unicodeGeneralCategoryPredicate("unicodeControl", (byte)15);
    public static final Predicate<Integer> IS_UNICODE_FORMAT = Characters.unicodeGeneralCategoryPredicate("unicodeFormat", (byte)16);
    public static final Predicate<Integer> IS_UNICODE_PRIVATE_USE = Characters.unicodeGeneralCategoryPredicate("unicodePrivateUse", (byte)18);
    public static final Predicate<Integer> IS_UNICODE_SURROGATE = Characters.unicodeGeneralCategoryPredicate("unicodeSurrogate", (byte)19);
    public static final Predicate<Integer> IS_UNICODE_DASH_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeDashPunctuation", (byte)20);
    public static final Predicate<Integer> IS_UNICODE_START_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeStartPunctuation", (byte)21);
    public static final Predicate<Integer> IS_UNICODE_END_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeEndPunctuation", (byte)22);
    public static final Predicate<Integer> IS_UNICODE_CONNECTOR_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeConnectorPunctuation", (byte)23);
    public static final Predicate<Integer> IS_UNICODE_OTHER_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeOtherPunctuation", (byte)24);
    public static final Predicate<Integer> IS_UNICODE_MATH_SYMBOL = Characters.unicodeGeneralCategoryPredicate("unicodeMATH_Symbol", (byte)25);
    public static final Predicate<Integer> IS_UNICODE_CURRENCY_SYMBOL = Characters.unicodeGeneralCategoryPredicate("unicodeCurrencySymbol", (byte)26);
    public static final Predicate<Integer> IS_UNICODE_MODIFIER_SYMBOL = Characters.unicodeGeneralCategoryPredicate("unicodeModifierSymbol", (byte)27);
    public static final Predicate<Integer> IS_UNICODE_OTHER_SYMBOL = Characters.unicodeGeneralCategoryPredicate("unicodeOtherSymbol", (byte)28);
    public static final Predicate<Integer> IS_UNICODE_INITIAL_QUOTE_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeInitialQuotePunctuation", (byte)29);
    public static final Predicate<Integer> IS_UNICODE_FINAL_QUOTE_PUNCTUATION = Characters.unicodeGeneralCategoryPredicate("unicodeFinalQuotePunctuation", (byte)30);
    public static final Predicate<Integer> IS_UNICODE_ALPHA = new IntegerPredicate("unicodeAlpha"){

        @Override
        public boolean evaluate(Integer subject) {
            return Characters.isAlphabetic(subject);
        }
    };
    private static final OptionalMethods.MethodWrapper1<Character, Boolean, Integer, NoException> CHARACTER_IS_ALPHABETIC = OptionalMethods.get1("IsAlphabetic only available in JRE 7+", Character.class, "isAlphabetic", Integer.TYPE, NoException.class);
    public static final Predicate<Integer> IS_UNICODE_IDEOGRAPHIC = new IntegerPredicate("unicodeIdeographic"){

        @Override
        public boolean evaluate(Integer subject) {
            return (Boolean)CHARACTER_IS_IDEOGRAPHIC.invoke(null, subject);
        }
    };
    private static final OptionalMethods.MethodWrapper1<Character, Boolean, Integer, NoException> CHARACTER_IS_IDEOGRAPHIC = OptionalMethods.get1("IsIdeographic only available in JRE 7+", Character.class, "isIdeographic", Integer.TYPE, NoException.class);
    public static final Predicate<Integer> IS_UNICODE_WHITE_SPACE = new IntegerPredicate("unicodeWhiteSpace"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            int type = Character.getType(cp);
            return type == 12 || type == 13 || type == 14 || cp >= 9 && cp <= 13 || cp == 133;
        }

        @Override
        public String toString() {
            return "unicodeWhiteSpace";
        }
    };
    public static final Predicate<Integer> IS_UNICODE_CNTRL = Characters.unicodeGeneralCategoryPredicate("unicodeCntrl", (byte)15);
    public static final Predicate<Integer> IS_UNICODE_PUNCT = new IntegerPredicate("unicodePunct"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            int type = Character.getType(cp);
            return type == 23 || type == 20 || type == 21 || type == 22 || type == 24 || type == 29 || type == 30;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_HEX_DIGIT = new IntegerPredicate("unicodeHexDigit"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return Character.isDigit(cp) || cp >= 48 && cp <= 57 || cp >= 65 && cp <= 70 || cp >= 97 && cp <= 102 || cp >= 65296 && cp <= 65305 || cp >= 65313 && cp <= 65318 || cp >= 65345 && cp <= 65350;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_ASSIGNED = new IntegerPredicate("unicodeAssigned"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.getType(subject) != 0;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_NONCHARACTER = new IntegerPredicate("unicodeNoncharacter"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return (cp & 0xFFFE) == 65534 || cp >= 64976 && cp <= 65007;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_DIGIT = new IntegerPredicate("unicodeDigit"){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isDigit(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_ALNUM = new IntegerPredicate("unicodeAlnum"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return IS_UNICODE_ALPHA.evaluate(cp) || IS_UNICODE_DIGIT.evaluate(cp);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_BLANK = new IntegerPredicate("unicodeBlank"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return Character.getType(cp) == 12 || cp == 9;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_GRAPH = new IntegerPredicate("unicodeGraph"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            int type = Character.getType(cp);
            return type != 12 && type != 13 && type != 14 && type != 15 && type != 19 && type != 0;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_PRINT = new IntegerPredicate("unicodePrint"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return (IS_UNICODE_GRAPH.evaluate(cp) || IS_UNICODE_BLANK.evaluate(cp)) && !IS_UNICODE_CNTRL.evaluate(cp);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_WORD = new IntegerPredicate("unicodeWord"){

        @Override
        public boolean evaluate(Integer subject) {
            return Characters.isUnicodeWord(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_JOIN_CONTROL = new IntegerPredicate("unicodeJoinControl"){

        @Override
        public boolean evaluate(Integer subject) {
            int cp = subject;
            return cp == 8204 || cp == 8205;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_MARK = Characters.unicodeGeneralCategoryPredicate("unicodeMark", (byte)6, (byte)7, 8);
    public static final Predicate<Integer> IS_UNICODE_NUMBER = Characters.unicodeGeneralCategoryPredicate("unicodeNumber", (byte)9, (byte)10, 11);
    public static final Predicate<Integer> IS_UNICODE_SEPARATOR = Characters.unicodeGeneralCategoryPredicate("unicodeSeparator", (byte)12, (byte)13, 14);
    public static final Predicate<Integer> IS_UNICODE_SPECIAL = Characters.unicodeGeneralCategoryPredicate("unicodeSpecial", (byte)15, (byte)16, 18, 19);
    public static final Predicate<Integer> IS_UNICODE_SYMBOL = Characters.unicodeGeneralCategoryPredicate("unicodeSymbol", (byte)25, (byte)26, 27, 28);
    public static final Predicate<Integer> IS_UNICODE_UPPER_LOWER_TITLE = Characters.unicodeGeneralCategoryPredicate("unicodeUpperLowerTitle", (byte)1, (byte)2, 3);
    public static final Predicate<Integer> IS_UNICODE_ALPHA2 = Characters.unicodeGeneralCategoryPredicate("unicodeAlpha2", (byte)1, (byte)2, 3, 4, 5, 9);
    public static final Predicate<Integer> IS_UNICODE_LATIN1 = Characters.rangePredicate("unicodeAlpha2", 0, 255);
    private static final Map<String, Predicate<Integer>> UNICODE_CATEGORIES;
    private static final Map<String, Predicate<Integer>> UNICODE_PROPERTIES;
    private static final Map<String, Predicate<Integer>> UNICODE_PREDEFINED_CHARACTER_CLASSES;
    private static final Map<String, Predicate<Integer>> POSIX_CHARACTER_CLASSES;
    private static final OptionalMethods.MethodWrapper1<?, Object, String, NoException> UNICODE_SCRIPT_FOR_NAME;
    private static final OptionalMethods.MethodWrapper1<?, Object, Integer, NoException> UNICODE_SCRIPT_OF;
    private static final boolean UNICODE_SCRIPT_AVAILABLE;
    private static final Map<Integer, String> SPECIAL_CASES;

    private Characters() {
    }

    @Nullable
    public static Predicate<Integer> javaCharacterClassFromName(String name) {
        return "javaAlphabetic".equals(name) ? IS_UNICODE_ALPHA : ("javaIdeographic".equals(name) ? IS_UNICODE_IDEOGRAPHIC : ("javaLetter".equals(name) ? IS_UNICODE_LETTER : ("javaLowerCase".equals(name) ? IS_UNICODE_LOWER : ("javaUpperCase".equals(name) ? IS_UNICODE_UPPER : ("javaTitleCase".equals(name) ? IS_UNICODE_TITLE : ("javaWhitespace".equals(name) ? IS_WHITESPACE : ("javaMirrored".equals(name) ? IS_MIRRORED : ("javaDigit".equals(name) ? IS_UNICODE_DIGIT : ("javaLetterOrDigit".equals(name) ? IS_LETTER_OR_DIGIT : ("javaDefined".equals(name) ? IS_DEFINED : ("javaJavaIdentifierStart".equals(name) ? IS_JAVA_IDENTIFIER_START : ("javaJavaIdentifierPart".equals(name) ? IS_JAVA_IDENTIFIER_PART : ("javaIdentifierIgnorable".equals(name) ? IS_IDENTIFIER_IGNORABLE : ("javaUnicodeIdentifierStart".equals(name) ? IS_UNICODE_IDENTIFIER_START : ("javaUnicodeIdentifierPart".equals(name) ? IS_UNICODE_IDENTIFIER_PART : ("javaSpaceChar".equals(name) ? IS_SPACE_CHAR : ("javaISOControl".equals(name) ? IS_ISO_CONTROL : null)))))))))))))))));
    }

    public static boolean isHorizontalWhitespace(int codePoint) {
        return " \t\u00a0\u1680\u180e\u202f\u205f\u3000".indexOf(codePoint) != -1 || codePoint >= 8192 && codePoint <= 8202;
    }

    public static boolean isWordCharacter(int codePoint) {
        return codePoint >= 97 && codePoint <= 122 || codePoint >= 65 && codePoint <= 90 || codePoint >= 48 && codePoint <= 57 || codePoint == 95;
    }

    public static boolean isAlphabetic(Integer codePoint) {
        return CHARACTER_IS_ALPHABETIC.invoke(null, codePoint);
    }

    public static boolean isUnicodeWord(int codePoint) {
        int type = Character.getType(codePoint);
        return type >= 1 && type <= 10 || type == 28 && codePoint >= 9398 && codePoint <= 9449 || type == 23 || codePoint == 8204 || codePoint == 8205;
    }

    @Nullable
    public static Predicate<Integer> unicodeCategoryFromName(String name) {
        return UNICODE_CATEGORIES.get(name.toUpperCase(Locale.US));
    }

    @Nullable
    public static Predicate<Integer> unicodeBinaryPropertyFromName(String name) {
        return UNICODE_PROPERTIES.get(name.toUpperCase(Locale.US));
    }

    private static IntegerPredicate unicodeGeneralCategoryPredicate(String toString, final byte generalCategory) {
        return new IntegerPredicate(toString){

            @Override
            public boolean evaluate(Integer subject) {
                return Character.getType(subject) == generalCategory;
            }
        };
    }

    private static IntegerPredicate unicodeGeneralCategoryPredicate(String toString, byte gc1, byte gc2, byte ... gc3) {
        int mask = 1 << gc1 | 1 << gc2;
        for (byte gc : gc3) {
            mask |= 1 << gc;
        }
        final int finalMask = mask;
        return new IntegerPredicate(toString){

            @Override
            public boolean evaluate(Integer subject) {
                return (finalMask & 1 << Character.getType(subject)) != 0;
            }
        };
    }

    private static IntegerPredicate rangePredicate(String toString, final int minCp, final int maxCp) {
        return new IntegerPredicate(toString){

            @Override
            public boolean evaluate(Integer subject) {
                int cp = subject;
                return cp >= minCp && cp <= maxCp;
            }
        };
    }

    @Nullable
    public static Predicate<Integer> unicodePredefinedCharacterClassFromName(String name) {
        return UNICODE_PREDEFINED_CHARACTER_CLASSES.get(name.toUpperCase(Locale.US));
    }

    @Nullable
    public static Predicate<Integer> posixCharacterClassFromName(String name) {
        return POSIX_CHARACTER_CLASSES.get(name.toUpperCase(Locale.US));
    }

    @Nullable
    public static Predicate<Integer> unicodeBlockFromName(String name) {
        Character.UnicodeBlock block;
        try {
            block = Character.UnicodeBlock.forName(name);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return new Predicate<Integer>(){

            @Override
            public boolean evaluate(Integer subject) {
                return Character.UnicodeBlock.of(subject) == block;
            }

            public String toString() {
                return "inUnicodeBlock(" + block + ")";
            }
        };
    }

    public static boolean unicodeScriptAvailable() {
        return UNICODE_SCRIPT_AVAILABLE;
    }

    @Nullable
    public static Predicate<Integer> unicodeScriptPredicate(String name) {
        Object unicodeScript1;
        try {
            unicodeScript1 = UNICODE_SCRIPT_FOR_NAME.invoke(null, name);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return new Predicate<Integer>(){

            @Override
            public boolean evaluate(Integer subject) {
                Object unicodeScript2 = UNICODE_SCRIPT_OF.invoke(null, subject);
                return unicodeScript1 == unicodeScript2;
            }

            public String toString() {
                return "unicodeScript(" + unicodeScript1 + ")";
            }
        };
    }

    @Nullable
    public static String caseInsensitivelyEqualCharacters(int cp) {
        String s = SPECIAL_CASES.get(cp);
        if (s != null) {
            return s;
        }
        int lc = Character.toLowerCase(cp);
        int uc = Character.toUpperCase(cp);
        int tc = Character.toTitleCase(cp);
        if (lc == uc) {
            if (uc == tc) {
                return null;
            }
            return new String(new int[]{lc, tc}, 0, 2);
        }
        if (lc == tc) {
            return new String(new int[]{lc, uc}, 0, 2);
        }
        if (uc == tc) {
            return new String(new int[]{lc, uc}, 0, 2);
        }
        return new String(new int[]{lc, uc, tc}, 0, 3);
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put((Integer)((Object)"CN"), (String)((Object)IS_UNICODE_UNASSIGNED));
        m.put((Integer)((Object)"LU"), (String)((Object)IS_UNICODE_UPPER));
        m.put((Integer)((Object)"LL"), (String)((Object)IS_UNICODE_LOWER));
        m.put((Integer)((Object)"LT"), (String)((Object)IS_UNICODE_TITLE));
        m.put((Integer)((Object)"LM"), (String)((Object)IS_UNICODE_MODIFIER_LETTER));
        m.put((Integer)((Object)"LO"), (String)((Object)IS_UNICODE_OTHER_LETTER));
        m.put((Integer)((Object)"MN"), (String)((Object)IS_UNICODE_NON_SPACING_MARK));
        m.put((Integer)((Object)"ME"), (String)((Object)IS_UNICODE_ENCLOSING_MARK));
        m.put((Integer)((Object)"MC"), (String)((Object)IS_UNICODE_COMBINING_SPACING_MARK));
        m.put((Integer)((Object)"ND"), (String)((Object)IS_UNICODE_DECIMAL_DIGIT_NUMBER));
        m.put((Integer)((Object)"NL"), (String)((Object)IS_UNICODE_LETTER_NUMBER));
        m.put((Integer)((Object)"NO"), (String)((Object)IS_UNICODE_OTHER_NUMBER));
        m.put((Integer)((Object)"ZS"), (String)((Object)IS_UNICODE_SPACE_SEPARATOR));
        m.put((Integer)((Object)"ZL"), (String)((Object)IS_UNICODE_LINE_SEPARATOR));
        m.put((Integer)((Object)"ZP"), (String)((Object)IS_UNICODE_PARAGRAPH_SEPARATOR));
        m.put((Integer)((Object)"CC"), (String)((Object)IS_UNICODE_CONTROL));
        m.put((Integer)((Object)"CF"), (String)((Object)IS_UNICODE_FORMAT));
        m.put((Integer)((Object)"CO"), (String)((Object)IS_UNICODE_PRIVATE_USE));
        m.put((Integer)((Object)"CS"), (String)((Object)IS_UNICODE_SURROGATE));
        m.put((Integer)((Object)"PD"), (String)((Object)IS_UNICODE_DASH_PUNCTUATION));
        m.put((Integer)((Object)"PS"), (String)((Object)IS_UNICODE_START_PUNCTUATION));
        m.put((Integer)((Object)"PE"), (String)((Object)IS_UNICODE_END_PUNCTUATION));
        m.put((Integer)((Object)"PC"), (String)((Object)IS_UNICODE_CONNECTOR_PUNCTUATION));
        m.put((Integer)((Object)"PO"), (String)((Object)IS_UNICODE_OTHER_PUNCTUATION));
        m.put((Integer)((Object)"SM"), (String)((Object)IS_UNICODE_MATH_SYMBOL));
        m.put((Integer)((Object)"SC"), (String)((Object)IS_UNICODE_CURRENCY_SYMBOL));
        m.put((Integer)((Object)"SK"), (String)((Object)IS_UNICODE_MODIFIER_SYMBOL));
        m.put((Integer)((Object)"SO"), (String)((Object)IS_UNICODE_OTHER_SYMBOL));
        m.put((Integer)((Object)"PI"), (String)((Object)IS_UNICODE_INITIAL_QUOTE_PUNCTUATION));
        m.put((Integer)((Object)"PF"), (String)((Object)IS_UNICODE_FINAL_QUOTE_PUNCTUATION));
        m.put((Integer)((Object)"L"), (String)((Object)IS_UNICODE_LETTER));
        m.put((Integer)((Object)"M"), (String)((Object)IS_UNICODE_MARK));
        m.put((Integer)((Object)"N"), (String)((Object)IS_UNICODE_NUMBER));
        m.put((Integer)((Object)"Z"), (String)((Object)IS_UNICODE_SEPARATOR));
        m.put((Integer)((Object)"C"), (String)((Object)IS_UNICODE_SPECIAL));
        m.put((Integer)((Object)"P"), (String)((Object)IS_UNICODE_PUNCT));
        m.put((Integer)((Object)"S"), (String)((Object)IS_UNICODE_SYMBOL));
        m.put((Integer)((Object)"LC"), (String)((Object)IS_UNICODE_UPPER_LOWER_TITLE));
        m.put((Integer)((Object)"LD"), (String)((Object)IS_UNICODE_ALPHA2));
        m.put((Integer)((Object)"L1"), (String)((Object)IS_UNICODE_LATIN1));
        m.put((Integer)((Object)"ALPHABETIC"), (String)((Object)IS_UNICODE_ALPHA));
        m.put((Integer)((Object)"LETTER"), (String)((Object)IS_UNICODE_LETTER));
        m.put((Integer)((Object)"IDEOGRAPHIC"), (String)((Object)IS_UNICODE_IDEOGRAPHIC));
        m.put((Integer)((Object)"LOWERCASE"), (String)((Object)IS_UNICODE_LOWER));
        m.put((Integer)((Object)"UPPERCASE"), (String)((Object)IS_UNICODE_UPPER));
        m.put((Integer)((Object)"TITLECASE"), (String)((Object)IS_UNICODE_TITLE));
        m.put((Integer)((Object)"WHITE_SPACE"), (String)((Object)IS_UNICODE_WHITE_SPACE));
        m.put((Integer)((Object)"CONTROL"), (String)((Object)IS_UNICODE_CNTRL));
        m.put((Integer)((Object)"PUNCTUATION"), (String)((Object)IS_UNICODE_PUNCT));
        m.put((Integer)((Object)"HEX_DIGIT"), (String)((Object)IS_UNICODE_HEX_DIGIT));
        m.put((Integer)((Object)"ASSIGNED"), (String)((Object)IS_UNICODE_ASSIGNED));
        m.put((Integer)((Object)"NONCHARACTER_CODE_POINT"), (String)((Object)IS_UNICODE_NONCHARACTER));
        m.put((Integer)((Object)"DIGIT"), (String)((Object)IS_UNICODE_DIGIT));
        m.put((Integer)((Object)"ALNUM"), (String)((Object)IS_UNICODE_ALNUM));
        m.put((Integer)((Object)"BLANK"), (String)((Object)IS_UNICODE_BLANK));
        m.put((Integer)((Object)"GRAPH"), (String)((Object)IS_UNICODE_GRAPH));
        m.put((Integer)((Object)"PRINT"), (String)((Object)IS_UNICODE_PRINT));
        m.put((Integer)((Object)"WORD"), (String)((Object)IS_UNICODE_WORD));
        m.put((Integer)((Object)"JOIN_CONTROL"), (String)((Object)IS_UNICODE_JOIN_CONTROL));
        m.put((Integer)((Object)"WHITESPACE"), (String)m.get("WHITE_SPACE"));
        m.put((Integer)((Object)"HEXDIGIT"), (String)m.get("HEX_DIGIT"));
        m.put((Integer)((Object)"NONCHARACTERCODEPOINT"), (String)m.get("NONCHARACTER_CODE_POINT"));
        m.put((Integer)((Object)"JOINCONTROL"), (String)m.get("JOIN_CONTROL"));
        UNICODE_CATEGORIES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Integer)((Object)"ALPHABETIC"), (String)((Object)IS_UNICODE_ALPHA));
        m.put((Integer)((Object)"IDEOGRAPHIC"), (String)((Object)IS_UNICODE_IDEOGRAPHIC));
        m.put((Integer)((Object)"LETTER"), (String)((Object)IS_UNICODE_LETTER));
        m.put((Integer)((Object)"LOWERCASE"), (String)((Object)IS_UNICODE_LOWER));
        m.put((Integer)((Object)"UPPERCASE"), (String)((Object)IS_UNICODE_UPPER));
        m.put((Integer)((Object)"TITLECASE"), (String)((Object)IS_UNICODE_TITLE));
        m.put((Integer)((Object)"PUNCTUATION"), (String)((Object)IS_UNICODE_PUNCT));
        m.put((Integer)((Object)"CONTROL"), (String)((Object)IS_UNICODE_CNTRL));
        m.put((Integer)((Object)"WHITE_SPACE"), (String)((Object)IS_UNICODE_WHITE_SPACE));
        m.put((Integer)((Object)"DIGIT"), (String)((Object)IS_UNICODE_DIGIT));
        m.put((Integer)((Object)"HEX_DIGIT"), (String)((Object)IS_UNICODE_HEX_DIGIT));
        m.put((Integer)((Object)"JOIN_CONTROL"), (String)((Object)IS_UNICODE_JOIN_CONTROL));
        m.put((Integer)((Object)"NONCHARACTER_CODE_POINT"), (String)((Object)IS_UNICODE_NONCHARACTER));
        m.put((Integer)((Object)"ASSIGNED"), (String)((Object)IS_UNICODE_ASSIGNED));
        UNICODE_PROPERTIES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Integer)((Object)"LOWER"), (String)((Object)IS_UNICODE_LOWER));
        m.put((Integer)((Object)"UPPER"), (String)((Object)IS_UNICODE_UPPER));
        m.put((Integer)((Object)"ASCII"), (String)((Object)IS_POSIX_ASCII));
        m.put((Integer)((Object)"ALPHA"), (String)((Object)IS_UNICODE_ALPHA));
        m.put((Integer)((Object)"DIGIT"), (String)((Object)IS_UNICODE_DIGIT));
        m.put((Integer)((Object)"ALNUM"), (String)((Object)IS_UNICODE_ALNUM));
        m.put((Integer)((Object)"PUNCT"), (String)((Object)IS_UNICODE_PUNCT));
        m.put((Integer)((Object)"GRAPH"), (String)((Object)IS_UNICODE_GRAPH));
        m.put((Integer)((Object)"PRINT"), (String)((Object)IS_UNICODE_PRINT));
        m.put((Integer)((Object)"BLANK"), (String)((Object)IS_UNICODE_BLANK));
        m.put((Integer)((Object)"CNTRL"), (String)((Object)IS_UNICODE_CNTRL));
        m.put((Integer)((Object)"XDIGIT"), (String)((Object)IS_UNICODE_HEX_DIGIT));
        m.put((Integer)((Object)"SPACE"), (String)((Object)IS_UNICODE_WHITE_SPACE));
        UNICODE_PREDEFINED_CHARACTER_CLASSES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Integer)((Object)"LOWER"), (String)((Object)IS_POSIX_LOWER));
        m.put((Integer)((Object)"UPPER"), (String)((Object)IS_POSIX_UPPER));
        m.put((Integer)((Object)"ASCII"), (String)((Object)IS_POSIX_ASCII));
        m.put((Integer)((Object)"ALPHA"), (String)((Object)IS_POSIX_ALPHA));
        m.put((Integer)((Object)"DIGIT"), (String)((Object)IS_POSIX_DIGIT));
        m.put((Integer)((Object)"ALNUM"), (String)((Object)IS_POSIX_ALNUM));
        m.put((Integer)((Object)"PUNCT"), (String)((Object)IS_POSIX_PUNCT));
        m.put((Integer)((Object)"GRAPH"), (String)((Object)IS_POSIX_GRAPH));
        m.put((Integer)((Object)"PRINT"), (String)((Object)IS_POSIX_PRINT));
        m.put((Integer)((Object)"BLANK"), (String)((Object)IS_POSIX_BLANK));
        m.put((Integer)((Object)"CNTRL"), (String)((Object)IS_POSIX_CNTRL));
        m.put((Integer)((Object)"XDIGIT"), (String)((Object)IS_POSIX_XDIGIT));
        m.put((Integer)((Object)"SPACE"), (String)((Object)IS_POSIX_SPACE));
        POSIX_CHARACTER_CLASSES = Collections.unmodifiableMap(m);
        UNICODE_SCRIPT_FOR_NAME = OptionalMethods.get1("Unicode scripts only available in JRE 7+", null, "java.lang.Character$UnicodeScript", "forName", String.class, null);
        UNICODE_SCRIPT_OF = OptionalMethods.get1("Unicode scripts only available in JRE 7+", null, "java.lang.Character$UnicodeScript", "of", Integer.TYPE, null);
        UNICODE_SCRIPT_AVAILABLE = UNICODE_SCRIPT_FOR_NAME.isAvailable() && UNICODE_SCRIPT_OF.isAvailable();
        m = new HashMap();
        for (String s : new String[]{"Ii\u0130\u0131", "Kk\u212a", "Ss\u017f", "\u00b5\u039c\u03bc", "\u00c5\u00e5\u212b", "\u0345\u0399\u03b9\u1fbe", "\u0392\u03b2\u03d0", "\u0395\u03b5\u03f5", "\u0398\u03b8\u03d1\u03f4", "\u039a\u03ba\u03f0", "\u03a0\u03c0\u03d6", "\u03a1\u03c1\u03f1", "\u03a3\u03c2\u03c3", "\u03a6\u03c6\u03d5", "\u03a9\u03c9\u2126", "\u1e60\u1e61\u1e9b"}) {
            for (char c : s.toCharArray()) {
                m.put(Integer.valueOf(c), s);
            }
        }
        SPECIAL_CASES = m;
    }

    private static abstract class IntegerPredicate
    implements Predicate<Integer> {
        private final String toString;

        IntegerPredicate(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

