/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.junit4.runner.internal;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;

public class RemoteTestClassRunner
extends ParentRunner<Runner> {
    private ObjectOutputStream toSlave;
    private ObjectInputStream fromSlave;
    private Runner delegate;
    private String nameSuffix;

    public RemoteTestClassRunner(Class<?> clasS, @Nullable Runner runWith, String nameSuffix, OutputStream toSlave, InputStream fromSlave) throws Exception {
        super(clasS);
        Class runWithClass = runWith != null ? runWith.getClass() : BlockJUnit4ClassRunner.class;
        this.toSlave = new ObjectOutputStream(toSlave);
        this.toSlave.writeObject(clasS.getName());
        this.toSlave.writeObject(runWithClass.getName());
        this.toSlave.writeObject(nameSuffix);
        this.toSlave.flush();
        this.nameSuffix = nameSuffix;
        this.fromSlave = new ObjectInputStream(fromSlave);
        try {
            this.delegate = runWith != null ? runWith : new BlockJUnit4ClassRunner(clasS);
        }
        catch (Exception e) {
            throw new Exception("clasS=" + clasS, e);
        }
    }

    protected List<Runner> getChildren() {
        return Collections.singletonList(this.delegate);
    }

    @NotNullByDefault(value=false)
    protected Description describeChild(Runner child) {
        assert (child == this.delegate);
        return this.fixDescription(this.delegate.getDescription());
    }

    public Description fixDescription(Description desc) {
        Collection ac = desc.getAnnotations();
        Description result = Description.createSuiteDescription((String)(desc.getDisplayName() + this.nameSuffix), (Serializable)((Object)(desc.getDisplayName() + this.nameSuffix)), ac == null ? null : ac.toArray(new Annotation[ac.size()]));
        for (Description d : desc.getChildren()) {
            result.addChild(this.fixDescription(d));
        }
        return result;
    }

    @NotNullByDefault(value=false)
    protected void runChild(Runner child, RunNotifier notifier) {
        throw new AssertionError();
    }

    protected String getName() {
        return super.getName() + this.nameSuffix;
    }

    @NotNullByDefault(value=false)
    public void run(RunNotifier notifier) {
        try {
            Object o;
            this.toSlave.writeObject(null);
            this.toSlave.flush();
            while ((o = this.fromSlave.readObject()) != null) {
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                String notifierMethodName = (String)o;
                Class[] parameterTypes = (Class[])this.fromSlave.readObject();
                Object[] arguments = (Object[])this.fromSlave.readObject();
                RunNotifier.class.getMethod(notifierMethodName, parameterTypes).invoke((Object)notifier, arguments);
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

