/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.compressors.xz;

import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;

public final class XZCompressionFormat
implements CompressionFormat {
    private static final CompressionFormat INSTANCE = new XZCompressionFormat();

    private XZCompressionFormat() {
    }

    public static CompressionFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "xz";
    }

    @Override
    public boolean isCompressedFileName(String fileName) {
        return XZUtils.isCompressedFilename(fileName);
    }

    @Override
    public String getCompressedFileName(String fileName) {
        return XZUtils.getCompressedFilename(fileName);
    }

    @Override
    public String getUncompressedFileName(String fileName) {
        return XZUtils.getUncompressedFilename(fileName);
    }

    @Override
    public CompressorInputStream compressorInputStream(InputStream is) throws IOException {
        return new XZCompressorInputStream(is);
    }

    @Override
    public CompressorInputStream open(File compressedFile) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(compressedFile));
        try {
            return new XZCompressorInputStream(is);
        }
        catch (IOException ioe) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public CompressorOutputStream compressorOutputStream(OutputStream os) throws IOException {
        return new XZCompressorOutputStream(os);
    }

    @Override
    public CompressorOutputStream create(File compressedFile) throws IOException {
        FileOutputStream os = new FileOutputStream(compressedFile);
        try {
            return new XZCompressorOutputStream(os);
        }
        catch (IOException ioe) {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioe;
        }
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return XZCompressorInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

