/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.org.apache.commons.compress.archivers.jar;

import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.compressors.FileNameUtil;

public final class JarArchiveFormat
implements ArchiveFormat {
    private static final FileNameUtil FILE_NAME_UTIL = new FileNameUtil(Collections.singletonMap(".jar", ""), ".jar");
    private static final ArchiveFormat INSTANCE = new JarArchiveFormat();

    private JarArchiveFormat() {
    }

    public static ArchiveFormat get() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "jar";
    }

    @Override
    public boolean isArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.isCompressedFilename(fileName);
    }

    @Override
    public String getArchiveFileName(String fileName) {
        return FILE_NAME_UTIL.getCompressedFilename(fileName);
    }

    @Override
    public ArchiveInputStream archiveInputStream(InputStream is) {
        return new JarArchiveInputStream(is);
    }

    @Override
    public ArchiveInputStream open(File archiveFile) throws IOException {
        return this.archiveInputStream(new BufferedInputStream(new FileInputStream(archiveFile)));
    }

    @Override
    public ArchiveOutputStream archiveOutputStream(OutputStream os) {
        return new JarArchiveOutputStream(os);
    }

    @Override
    public ArchiveOutputStream create(File archiveFile) throws IOException {
        return new JarArchiveOutputStream(new FileOutputStream(archiveFile));
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof JarArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        while (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        archiveOutputStream.putArchiveEntry(new JarArchiveEntry(name));
        writeContents.consume(archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeDirectoryEntry(ArchiveOutputStream archiveOutputStream, String name) throws IOException {
        if (!(archiveOutputStream instanceof JarArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        if (!name.endsWith("/")) {
            name = name + '/';
        }
        archiveOutputStream.putArchiveEntry(new JarArchiveEntry(name));
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public void writeEntry(ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry, @Nullable String name, ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents) throws IOException {
        if (!(archiveOutputStream instanceof JarArchiveOutputStream)) {
            throw new IllegalArgumentException(archiveOutputStream.getClass().getName());
        }
        JarArchiveEntry njae = new JarArchiveEntry(name != null ? name : archiveEntry.getName());
        njae.setTime(archiveEntry.getLastModifiedDate().getTime());
        if (archiveEntry instanceof JarArchiveEntry) {
            JarArchiveEntry jae = (JarArchiveEntry)archiveEntry;
            njae.setComment(jae.getComment());
            njae.setExternalAttributes(jae.getExternalAttributes());
            njae.setExtraFields(jae.getExtraFields(true));
            njae.setGeneralPurposeBit(jae.getGeneralPurposeBit());
            njae.setInternalAttributes(jae.getInternalAttributes());
            njae.setMethod(jae.getMethod());
        }
        archiveOutputStream.putArchiveEntry(njae);
        if (!archiveEntry.isDirectory()) {
            writeContents.consume(archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    @Override
    public boolean matches(byte[] signature, int signatureLength) {
        return JarArchiveInputStream.matches(signature, signatureLength);
    }

    public String toString() {
        return this.getName();
    }
}

