/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.file.filetransformation;

import de.unkrig.commons.file.CompressUtil;
import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.FileUtil;
import de.unkrig.commons.file.contentstransformation.ContentsTransformations;
import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.file.filetransformation.DirectoryTransformer;
import de.unkrig.commons.file.filetransformation.FileContentsTransformer;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.file.filetransformation.ProxyFileTransformer;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormat;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;

public final class FileTransformations {
    public static final FileTransformer UNCHANGED;

    public static FileTransformer remove() {
        return new FileTransformer(){

            @Override
            public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
                switch (mode) {
                    case CHECK: {
                        throw FileTransformer.NOT_IDENTICAL;
                    }
                    case CHECK_AND_TRANSFORM: {
                        throw (Error)AssertionUtil.fail("Must not invoke 'remove()' in mode CHECK_AND_TRANSFORM");
                    }
                    case TRANSFORM: {
                        if (in.equals(out) && !in.delete()) {
                            throw new IOException("Could not delete '" + in + "'");
                        }
                        return;
                    }
                }
                throw (Error)AssertionUtil.fail("Unexpected mode '" + (Object)((Object)mode) + "'");
            }
        };
    }

    private FileTransformations() {
    }

    public static DirectoryTransformer directoryTreeTransformer(@Nullable Comparator<Object> directoryMemberNameComparator, Predicate<? super String> directoryMemberRemoval, Glob directoryMemberRenaming, DirectoryCombiner directoryCombiner, FileTransformer regularFileTransformer, boolean saveSpace, boolean keepOriginals, ExceptionHandler<IOException> exceptionHandler) {
        ProxyFileTransformer loopback = new ProxyFileTransformer();
        DirectoryTransformer result = FileTransformations.directoryTransformer(regularFileTransformer, directoryMemberNameComparator, directoryMemberRemoval, directoryMemberRenaming, loopback, directoryCombiner, saveSpace, keepOriginals, exceptionHandler);
        loopback.set(result);
        return result;
    }

    private static DirectoryTransformer directoryTransformer(FileTransformer regularFileTransformer, @Nullable Comparator<Object> directoryMemberNameComparator, Predicate<? super String> directoryMemberRemoval, Glob directoryMemberRenaming, FileTransformer directoryMemberTransformer, DirectoryCombiner directoryCombiner, boolean saveSpace, boolean keepOriginals, ExceptionHandler<IOException> exceptionHandler) {
        return new DirectoryTransformer(regularFileTransformer, directoryMemberNameComparator, FileTransformations.renameRemoveFileTransformer(directoryMemberRemoval, directoryMemberRenaming, directoryMemberTransformer, keepOriginals), directoryCombiner, saveSpace, keepOriginals, exceptionHandler);
    }

    public static FileTransformer renameRemoveFileTransformer(final Predicate<? super String> removal, final Glob renaming, final FileTransformer delegate, final boolean keepOriginals) {
        return new FileTransformer(){

            @Override
            public void transform(String path, File inputFile, File outputFile, FileTransformer.Mode mode) throws IOException {
                boolean inPlace = inputFile.equals(outputFile);
                if (removal.evaluate(path)) {
                    if (mode == FileTransformer.Mode.CHECK) {
                        throw FileTransformer.NOT_IDENTICAL;
                    }
                    if (inPlace) {
                        if (keepOriginals) {
                            File origFile = FileTransformations.origFile(inputFile);
                            if (origFile.exists()) {
                                FileUtil.deleteRecursively(origFile);
                            }
                            FileUtil.rename(inputFile, origFile);
                        } else {
                            inputFile.delete();
                        }
                    }
                    return;
                }
                String newPath = renaming.replace(path);
                if (newPath != null) {
                    File newOutputFile = new File(newPath);
                    if (!new File(newPath).getParentFile().equals(inputFile.getParentFile())) {
                        throw new IOException("Cannot rename '" + path + "' across directory boundaries");
                    }
                    newOutputFile = new File(outputFile.getParentFile(), newOutputFile.getName());
                    if (!newOutputFile.equals(outputFile)) {
                        if (mode == FileTransformer.Mode.CHECK) {
                            throw FileTransformer.NOT_IDENTICAL;
                        }
                        delegate.transform(path, inputFile, newOutputFile, mode);
                        if (inPlace) {
                            if (keepOriginals) {
                                File origFile = FileTransformations.origFile(inputFile);
                                if (origFile.exists()) {
                                    FileUtil.deleteRecursively(origFile);
                                }
                                FileUtil.rename(inputFile, origFile);
                            } else {
                                inputFile.delete();
                            }
                        }
                        return;
                    }
                }
                delegate.transform(path, inputFile, outputFile, mode);
            }
        };
    }

    public static FileTransformer compressedAndArchiveFileTransformer(final Predicate<? super String> lookIntoFormat, final Predicate<? super String> archiveEntryRemoval, final Glob archiveEntryRenaming, final ArchiveCombiner archiveCombiner, final ContentsTransformer archiveEntryContentsTransformer, final ContentsTransformer compressedContentsTransformer, final ContentsTransformer normalContentsTransformer, final boolean keepOriginals, final ExceptionHandler<IOException> exceptionHandler) {
        return new FileTransformer(){

            @Override
            public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
                switch (mode) {
                    case CHECK: {
                        FileContentsTransformer.checkIdentity(path, new FileInputStream(in), ContentsTransformations.compressedAndArchiveContentsTransformer(lookIntoFormat, archiveEntryRemoval, archiveEntryRenaming, archiveEntryContentsTransformer, archiveCombiner, compressedContentsTransformer, normalContentsTransformer, exceptionHandler), true);
                        return;
                    }
                    case CHECK_AND_TRANSFORM: {
                        try {
                            this.transform(path, in, out, FileTransformer.Mode.CHECK);
                            if (!in.equals(out)) {
                                IoUtil.copy(in, out);
                            }
                            return;
                        }
                        catch (RuntimeException re) {
                            if (re != FileTransformer.NOT_IDENTICAL) {
                                throw re;
                            }
                            this.transform(path, in, out, FileTransformer.Mode.TRANSFORM);
                            return;
                        }
                    }
                    case TRANSFORM: {
                        if (!in.equals(out)) {
                            this.transform2(path, in, out);
                            return;
                        }
                        File newFile = FileTransformations.newFile(out);
                        if (newFile.exists()) {
                            FileUtil.deleteRecursively(newFile);
                        }
                        this.transform2(path, in, newFile);
                        if (keepOriginals) {
                            File origFile = FileTransformations.origFile(in);
                            if (origFile.exists()) {
                                FileUtil.deleteRecursively(origFile);
                            }
                            FileUtil.rename(in, origFile);
                        } else if (!in.delete()) {
                            throw new IOException("Could not delete '" + in + "'");
                        }
                        FileUtil.rename(newFile, out);
                        return;
                    }
                }
                throw (Error)AssertionUtil.fail("Unexpected mode '" + (Object)((Object)mode) + "'");
            }

            private void transform2(String path, File in, File out) throws IOException {
                CompressUtil.processFile(path, in, lookIntoFormat, FileTransformations.archiveHandler(path, out, archiveEntryRemoval, archiveEntryRenaming, archiveEntryContentsTransformer, archiveCombiner, exceptionHandler), FileTransformations.compressorHandler(path, out, compressedContentsTransformer), FileTransformations.normalContentsHandler(path, out, normalContentsTransformer));
            }

            public String toString() {
                return "compressedAndArchiveFileTransformer";
            }
        };
    }

    public static FileTransformer recursiveCompressedAndArchiveFileTransformer(Predicate<? super String> lookIntoFormat, Predicate<? super String> archiveEntryRemoval, Glob archiveEntryRenaming, ArchiveCombiner archiveCombiner, ContentsTransformer delegate, boolean keepOriginals, ExceptionHandler<IOException> exceptionHandler) {
        ContentsTransformer tmp = ContentsTransformations.recursiveCompressedAndArchiveContentsTransformer(lookIntoFormat, archiveEntryRemoval, archiveEntryRenaming, archiveCombiner, delegate, exceptionHandler);
        return FileTransformations.compressedAndArchiveFileTransformer(lookIntoFormat, archiveEntryRemoval, archiveEntryRenaming, archiveCombiner, tmp, tmp, delegate, keepOriginals, exceptionHandler);
    }

    private static CompressUtil.ArchiveHandler<Void> archiveHandler(final String path, final File out, final Predicate<? super String> archiveEntryRemoval, final Glob archiveEntryRenaming, final ContentsTransformer contentsTransformer, final ArchiveCombiner archiveCombiner, final ExceptionHandler<IOException> exceptionHandler) {
        return new CompressUtil.ArchiveHandler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Void handleArchive(ArchiveInputStream archiveInputStream, ArchiveFormat archiveFormat) throws IOException {
                ArchiveOutputStream aos;
                try {
                    aos = archiveFormat.create(out);
                }
                catch (ArchiveException ae) {
                    throw new IOException(ae);
                }
                try {
                    ContentsTransformations.transformArchive(path, archiveInputStream, aos, archiveEntryRemoval, archiveEntryRenaming, contentsTransformer, archiveCombiner, exceptionHandler);
                    aos.close();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    try {
                        aos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    private static CompressUtil.CompressorHandler<Void> compressorHandler(final String path, final File out, final ContentsTransformer contentsTransformer) {
        return new CompressUtil.CompressorHandler<Void>(){

            @Override
            @Nullable
            public Void handleCompressor(CompressorInputStream compressorInputStream, CompressionFormat compressorFormat) throws IOException {
                FileOutputStream os = new FileOutputStream(out);
                try {
                    contentsTransformer.transform(path + '%', compressorInputStream, compressorFormat.compressorOutputStream(os));
                    os.close();
                    Void void_ = null;
                    return void_;
                }
                catch (CompressorException ce) {
                    throw new IOException(ce);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    private static CompressUtil.NormalContentsHandler<Void> normalContentsHandler(final String path, final File out, final ContentsTransformer contentsTransformer) {
        return new CompressUtil.NormalContentsHandler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Void handleNormalContents(InputStream inputStream) throws IOException {
                FileOutputStream os = new FileOutputStream(out);
                try {
                    contentsTransformer.transform(path, inputStream, os);
                    os.close();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    public static void transform(String[] args, FileTransformer fileTransformer, FileTransformer.Mode mode, ExceptionHandler<IOException> exceptionHandler) throws IOException {
        if (args.length == 0) {
            throw new IOException("Input file name missing");
        }
        if (args.length == 1) {
            File file = new File(args[0]);
            FileTransformations.transformOneFile(file, file, fileTransformer, mode, exceptionHandler);
        } else if (args.length == 2) {
            File in = new File(args[0]);
            File out = new File(args[1]);
            if (out.isDirectory()) {
                FileTransformations.transformOneFile(in, new File(out, in.getName()), fileTransformer, mode, exceptionHandler);
            } else {
                FileTransformations.transformOneFile(in, out, fileTransformer, mode, exceptionHandler);
            }
        } else {
            File outputDirectory = new File(args[args.length - 1]);
            if (!outputDirectory.isDirectory()) {
                throw new IOException("Output directory '" + outputDirectory + "' does not exist");
            }
            for (int i = 0; i < args.length - 1; ++i) {
                File in = new File(args[i]);
                FileTransformations.transformOneFile(in, new File(outputDirectory, in.getName()), fileTransformer, mode, exceptionHandler);
            }
        }
    }

    private static void transformOneFile(File in, File out, FileTransformer fileTransformer, FileTransformer.Mode mode, ExceptionHandler<IOException> exceptionHandler) throws IOException {
        String path = in.getPath();
        try {
            fileTransformer.transform(path, in, out, mode);
        }
        catch (IOException ioe) {
            exceptionHandler.handle(path, ioe);
        }
        catch (RuntimeException re) {
            exceptionHandler.handle(path, re);
        }
    }

    public static File newFile(File file) {
        return new File(file.getParentFile(), "." + file.getName() + ".new");
    }

    public static File origFile(File file) {
        return new File(file.getParentFile(), "." + file.getName() + ".orig");
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        UNCHANGED = new FileTransformer(){

            @Override
            public void transform(String path, File in, File out, FileTransformer.Mode mode) throws IOException {
                switch (mode) {
                    case CHECK: {
                        return;
                    }
                    case CHECK_AND_TRANSFORM: 
                    case TRANSFORM: {
                        if (!in.equals(out)) {
                            IoUtil.copy(in, out);
                        }
                        return;
                    }
                }
                throw (Error)AssertionUtil.fail("Unexpected mode '" + (Object)((Object)mode) + "'");
            }
        };
    }

    public static interface ArchiveCombiner {
        public static final ArchiveCombiner NOP = new ArchiveCombiner(){

            @Override
            public void combineArchive(String archivePath, ConsumerWhichThrows<? super NameAndContents, ? extends IOException> entryAdder) {
            }
        };

        public void combineArchive(String var1, ConsumerWhichThrows<? super NameAndContents, ? extends IOException> var2) throws IOException;
    }

    public static interface DirectoryCombiner {
        public static final DirectoryCombiner NOP = new DirectoryCombiner(){

            @Override
            public void combineDirectory(String directoryPath, ConsumerWhichThrows<? super NameAndContents, ? extends IOException> memberAdder) {
            }
        };

        public void combineDirectory(String var1, ConsumerWhichThrows<? super NameAndContents, ? extends IOException> var2) throws IOException;
    }

    public static interface NameAndContents {
        public String getName();

        public InputStream open() throws FileNotFoundException;
    }
}

