/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch.diff;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.StringStream;
import de.unkrig.zz.patch.diff.DiffException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class DiffParser {
    private static final Pattern DIFF_LINE;
    private static final Pattern CD_FILE_HEADER1;
    private static final Pattern CD_FILE_HEADER2;
    private static final Pattern CD_HUNK_SEPARATOR;
    private static final Pattern CD_HUNK_HEADER1;
    private static final Pattern CD_HUNK_HEADER2;
    private static final Pattern CD_LINE_CHANGE;
    private static final Pattern TD_HUNK_HEADER;
    private static final Pattern TD_LINE_ADDED;
    private static final Pattern TD_LINE_DELETED;
    private static final Pattern TD_SEPARATOR;
    private static final Pattern UD_FILE1_HEADER;
    private static final Pattern UD_FILE2_HEADER;
    private static final Pattern UD_HUNK_HEADER;
    private static final Pattern UD_LINE_CHANGE;

    private DiffParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Differential> parse(File file, Charset charset) throws IOException, StringStream.UnexpectedElementException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        try {
            List<Differential> list = DiffParser.parse(r);
            return list;
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<Differential> parse(Reader r) throws DiffException, IOException, StringStream.UnexpectedElementException {
        StringStream<IOException> ss = new StringStream<IOException>(LineUtil.readLineWithSeparator(r));
        ArrayList<Differential> differentials = new ArrayList<Differential>();
        while (!ss.atEnd()) {
            String fileName1 = null;
            String fileName2 = null;
            if (ss.peekRead(DIFF_LINE)) {
                fileName1 = ss.group(1);
                fileName2 = ss.group(2);
            }
            ArrayList<Hunk> hunks = new ArrayList<Hunk>();
            if (ss.peek(CD_FILE_HEADER1)) {
                ss.read(CD_FILE_HEADER1);
                fileName1 = ss.group(1);
                ss.read(CD_FILE_HEADER2);
                fileName2 = ss.group(1);
                while (ss.peekRead(CD_HUNK_SEPARATOR)) {
                    hunks.add(DiffParser.parseContextDiffHunk(ss));
                }
            } else if (ss.peek(CD_HUNK_SEPARATOR)) {
                while (ss.peekRead(CD_HUNK_SEPARATOR)) {
                    hunks.add(DiffParser.parseContextDiffHunk(ss));
                }
            } else if (ss.peek(TD_HUNK_HEADER)) {
                do {
                    hunks.add(DiffParser.parseTraditionalDiffHunk(ss));
                } while (ss.peek(TD_HUNK_HEADER));
            } else if (ss.peek(UD_FILE1_HEADER)) {
                ss.read(UD_FILE1_HEADER);
                fileName1 = ss.group(1);
                assert (fileName1 != null);
                ss.read(UD_FILE2_HEADER);
                fileName2 = ss.group(1);
                assert (fileName2 != null);
                while (ss.peek(UD_HUNK_HEADER)) {
                    hunks.add(DiffParser.parseUnifiedDiffHunk(ss));
                }
            } else {
                throw new DiffException("Unknown DIFF format '" + ss.peek() + "'");
            }
            differentials.add(new Differential(fileName1, fileName2, hunks));
        }
        return differentials;
    }

    private static Hunk parseUnifiedDiffHunk(StringStream<IOException> ss) throws IOException, DiffException, StringStream.UnexpectedElementException {
        ss.read(UD_HUNK_HEADER);
        int from1 = Integer.parseInt(ss.group(1)) - 1;
        int count1 = Integer.parseInt(ss.group(2));
        int from2 = Integer.parseInt(ss.group(3)) - 1;
        int count2 = Integer.parseInt(ss.group(4));
        ArrayList<LineChange> lineChanges = new ArrayList<LineChange>();
        int lines1 = 0;
        int lines2 = 0;
        block5: while (ss.peekRead(UD_LINE_CHANGE)) {
            String code = ss.group(1);
            assert (code != null);
            String contents = ss.group(2);
            assert (contents != null);
            switch (code.charAt(0)) {
                case '+': {
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                    ++lines2;
                    continue block5;
                }
                case '-': {
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                    ++lines1;
                    continue block5;
                }
                case ' ': {
                    lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                    ++lines1;
                    ++lines2;
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        if (lines1 != count1) {
            throw new DiffException("Unified diff hunk header says " + count1 + " FILE1 lines, but " + lines1 + " lines appear");
        }
        if (lines2 != count2) {
            throw new DiffException("Unified diff hunk header says " + count2 + " FILE2 lines, but " + lines2 + " lines appear");
        }
        return new Hunk(from1, from2, lineChanges);
    }

    private static Hunk parseContextDiffHunk(StringStream<IOException> ss) throws DiffException, IOException, StringStream.UnexpectedElementException {
        ss.read(CD_HUNK_HEADER1);
        int file1From = Integer.parseInt(ss.group(1));
        int file1To = Integer.parseInt(ss.group(2));
        ArrayList<LineChange> lineChanges = new ArrayList<LineChange>();
        if (!ss.peek(CD_HUNK_HEADER2)) {
            block12: for (int i = file1From; i <= file1To; ++i) {
                ss.read(CD_LINE_CHANGE);
                String code = ss.group(1);
                assert (code != null);
                String contents = ss.group(2);
                assert (contents != null);
                switch (code.charAt(0)) {
                    case ' ': {
                        lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                        continue block12;
                    }
                    case '-': {
                        lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                        continue block12;
                    }
                    case '!': {
                        lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                        lineChanges.add(null);
                        continue block12;
                    }
                    case '+': {
                        throw new DiffException("Unexpected '+' line in FILE1 part of context diff hunk");
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        ss.read(CD_HUNK_HEADER2);
        int file2From = Integer.parseInt(ss.group(1));
        int file2To = Integer.parseInt(ss.group(2));
        if (ss.peek(CD_HUNK_SEPARATOR)) {
            for (LineChange lc : lineChanges) {
                if (lc != null) continue;
                throw new DiffException("Context diff hunk has '!' if FILE1 part, but lacks the FILE2 part");
            }
        } else {
            int idx = lineChanges.isEmpty() ? -1 : 0;
            block14: for (int i = file2From; i <= file2To; ++i) {
                ss.read(CD_LINE_CHANGE);
                String code = ss.group(1);
                assert (code != null);
                String contents = ss.group(2);
                assert (contents != null);
                switch (code.charAt(0)) {
                    case ' ': {
                        LineChange lc;
                        if (idx == -1) {
                            lineChanges.add(new LineChange(LineChange.Mode.CONTEXT, contents));
                            continue block14;
                        }
                        while (idx < lineChanges.size() && (lc = (LineChange)lineChanges.get(idx)) != null && lc.mode == LineChange.Mode.DELETED) {
                            ++idx;
                        }
                        if (idx >= lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        if (lineChanges.get(idx) != null && contents.equals(((LineChange)lineChanges.get((int)idx++)).text)) continue block14;
                        throw new DiffException("Inconsistent FILE2 context line '" + contents + "'");
                    }
                    case '+': {
                        LineChange lc;
                        if (idx == -1) {
                            lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                            continue block14;
                        }
                        while (idx < lineChanges.size() && (lc = (LineChange)lineChanges.get(idx)) != null && lc.mode == LineChange.Mode.DELETED) {
                            ++idx;
                        }
                        if (idx > lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        lineChanges.add(idx++, new LineChange(LineChange.Mode.ADDED, contents));
                        continue block14;
                    }
                    case '!': {
                        LineChange lc;
                        if (idx == -1) {
                            throw new DiffException("Unexpected '!' line in context diff");
                        }
                        if (idx + 2 >= lineChanges.size()) {
                            throw new DiffException("Short FILE1 part");
                        }
                        if ((lc = (LineChange)lineChanges.get(idx++)) == null) {
                            throw new DiffException("Unmatched '" + contents + "'");
                        }
                        if (lc.mode != LineChange.Mode.DELETED) {
                            throw new DiffException("'" + contents + "' does not match '" + lc + "'");
                        }
                        lc = (LineChange)lineChanges.get(idx);
                        if (lc != null) {
                            throw new DiffException("'" + contents + "' does not match '" + lc + "'");
                        }
                        lineChanges.set(idx++, new LineChange(LineChange.Mode.ADDED, contents));
                        continue block14;
                    }
                    case '-': {
                        throw new DiffException("Unexpected '-' line in FILE2 part of context diff hunk");
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            if (idx != -1 && idx != lineChanges.size()) {
                throw new DiffException("Short FILE2 part in context diff hunk");
            }
        }
        return new Hunk(file1From - 1, file2From - 1, lineChanges);
    }

    private static Hunk parseTraditionalDiffHunk(StringStream<IOException> ss) throws IOException, DiffException, StringStream.UnexpectedElementException {
        int from2;
        int from1;
        ss.read(TD_HUNK_HEADER);
        String code = ss.group(3);
        assert (code != null && code.length() == 1);
        ArrayList<LineChange> lineChanges = new ArrayList<LineChange>();
        switch (code.charAt(0)) {
            case 'a': {
                from1 = Integer.parseInt(ss.group(1));
                from2 = Integer.parseInt(ss.group(4)) - 1;
                if (ss.group(2) != null) {
                    throw new DiffException("Traditional diff ADD hunk has FILE1 range");
                }
                int to2 = ss.group(5) == null ? from2 + 1 : Integer.parseInt(ss.group(5));
                for (int i = from2; i < to2; ++i) {
                    ss.read(TD_LINE_ADDED);
                    String contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                }
                break;
            }
            case 'd': {
                int to1;
                from1 = Integer.parseInt(ss.group(1)) - 1;
                from2 = Integer.parseInt(ss.group(4));
                int n = to1 = ss.group(2) == null ? from1 + 1 : Integer.parseInt(ss.group(2));
                if (ss.group(5) != null) {
                    throw new DiffException("Traditional diff DELETE hunk has FILE2 range");
                }
                for (int i = from1; i < to1; ++i) {
                    ss.read(TD_LINE_DELETED);
                    String contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                }
                break;
            }
            case 'c': {
                String contents;
                int i;
                from1 = Integer.parseInt(ss.group(1)) - 1;
                from2 = Integer.parseInt(ss.group(4)) - 1;
                int to1 = ss.group(2) == null ? from1 + 1 : Integer.parseInt(ss.group(2));
                int to2 = ss.group(5) == null ? from2 + 1 : Integer.parseInt(ss.group(5));
                for (i = from1; i < to1; ++i) {
                    ss.read(TD_LINE_DELETED);
                    contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.DELETED, contents));
                }
                ss.read(TD_SEPARATOR);
                for (i = from2; i < to2; ++i) {
                    ss.read(TD_LINE_ADDED);
                    contents = ss.group(1);
                    assert (contents != null);
                    lineChanges.add(new LineChange(LineChange.Mode.ADDED, contents));
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new Hunk(from1, from2, lineChanges);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        DIFF_LINE = Pattern.compile("diff.* \\S+ \\S+\\s*");
        CD_FILE_HEADER1 = Pattern.compile("\\*\\*\\* (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        CD_FILE_HEADER2 = Pattern.compile("--- (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        CD_HUNK_SEPARATOR = Pattern.compile("\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\s*");
        CD_HUNK_HEADER1 = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*\\s*");
        CD_HUNK_HEADER2 = Pattern.compile("--- (\\d+),(\\d+) ----\\s*");
        CD_LINE_CHANGE = Pattern.compile("([ \\-\\+!]) (.*)", 32);
        TD_HUNK_HEADER = Pattern.compile("(\\d+)(?:,(\\d+))?([adc])(\\d+)(?:,(\\d+))?\\s*");
        TD_LINE_ADDED = Pattern.compile("> (.*)", 32);
        TD_LINE_DELETED = Pattern.compile("< (.*)", 32);
        TD_SEPARATOR = Pattern.compile("---(.*)", 32);
        UD_FILE1_HEADER = Pattern.compile("--- (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        UD_FILE2_HEADER = Pattern.compile("\\+\\+\\+ (.+?) +\\d\\d\\d\\d-\\d\\d-\\d\\d .*", 32);
        UD_HUNK_HEADER = Pattern.compile("@@ -(\\d+),(\\d+) \\+(\\d+),(\\d+) @@\\s*");
        UD_LINE_CHANGE = Pattern.compile("([\\-\\+ ])(.*)", 32);
    }

    public static class Differential {
        @Nullable
        public final String fileName1;
        @Nullable
        public final String fileName2;
        public final List<Hunk> hunks;

        public Differential(@Nullable String fileName1, @Nullable String fileName2, List<Hunk> hunks) {
            this.fileName1 = fileName1;
            this.fileName2 = fileName2;
            this.hunks = hunks;
        }
    }

    public static class Hunk {
        public final int from1;
        public final int from2;
        public final List<LineChange> lineChanges;

        public Hunk(int from1, int from2, List<LineChange> lineChanges) {
            this.from1 = from1;
            this.from2 = from2;
            this.lineChanges = lineChanges;
        }

        public String toString() {
            return this.from1 + "/" + this.from2 + this.lineChanges;
        }
    }

    public static class LineChange {
        public final Mode mode;
        public final String text;

        public LineChange(Mode mode, String text) {
            this.mode = mode;
            this.text = text;
        }

        public String toString() {
            return (Object)((Object)this.mode) + " " + this.text;
        }

        public static enum Mode {
            CONTEXT,
            ADDED,
            DELETED;

        }
    }
}

