/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.contentstransformation.ContentsTransformer;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.text.pattern.Glob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateContentsTransformer
implements ContentsTransformer {
    private static final Logger LOGGER = Logger.getLogger(UpdateContentsTransformer.class.getName());
    private final Glob updateFile;

    public UpdateContentsTransformer(Glob updateFile) {
        this.updateFile = updateFile;
    }

    @Override
    public void transform(String path, InputStream is, OutputStream os) throws IOException {
        String updateFilePath = this.updateFile.replace(path);
        if (updateFilePath == null) {
            IoUtil.copy(is, os);
        } else {
            LOGGER.log(Level.CONFIG, "Updating ''{0}'' from ''{1}''", new Object[]{path, updateFilePath});
            IoUtil.copy((InputStream)new FileInputStream(new File(updateFilePath)), true, os, false);
        }
    }

    public String toString() {
        return "UPDATE with '" + this.updateFile + "'";
    }
}

