/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.contentstransformation.TextTransformer;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.zz.patch.diff.DiffException;
import de.unkrig.zz.patch.diff.DiffParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchTextTransformer
implements TextTransformer {
    private static final Logger LOGGER = Logger.getLogger(PatchTextTransformer.class.getName());
    private final List<DiffParser.Hunk> hunks;
    private final Condition condition;

    public PatchTextTransformer(List<DiffParser.Hunk> hunks, Condition condition) {
        this.hunks = hunks;
        this.condition = condition;
    }

    public boolean isIdentity() {
        return this.hunks.isEmpty();
    }

    @Override
    public void transform(String path, Reader reader, Writer writer) throws IOException {
        String line;
        if (this.hunks.isEmpty()) {
            IoUtil.copy(reader, writer);
            return;
        }
        LOGGER.log(Level.CONFIG, "{0}: Patch {1} {1,choice,1#hunk|1<hunks}", new Object[]{path, this.hunks.size()});
        ProducerWhichThrows<String, IOException> lineReader = LineUtil.readLineWithSeparator(new BufferedReader(reader));
        int i = 0;
        for (int hunkIndex = 0; hunkIndex < this.hunks.size(); ++hunkIndex) {
            DiffParser.Hunk hunk = this.hunks.get(hunkIndex);
            if (!this.condition.evaluate(path, this.hunks, hunkIndex, hunk, hunk.from1 + 1)) continue;
            if (i > hunk.from1) {
                throw new DiffException("Changes overlap (hunk starts at line " + hunk.from1 + ", but " + i + " lines have already been read)");
            }
            while (i < hunk.from1) {
                String line2 = lineReader.produce();
                if (line2 == null) {
                    throw new DiffException("Hunk begins at line " + hunk.from1 + ", but the file contains only " + i + " lines");
                }
                writer.write(line2);
                ++i;
            }
            block7: for (DiffParser.LineChange lc : hunk.lineChanges) {
                switch (lc.mode) {
                    case CONTEXT: {
                        String line3 = lineReader.produce();
                        if (line3 == null) {
                            throw new DiffException("Context line \"" + lc.text + "\" is past the end-of-file");
                        }
                        if (!lc.text.equals(line3)) {
                            throw new DiffException("Context line mismatch; expected \"" + lc.text + "\", but was \"" + line3 + "\"");
                        }
                        writer.write(lc.text);
                        ++i;
                        continue block7;
                    }
                    case ADDED: {
                        writer.write(lc.text);
                        continue block7;
                    }
                    case DELETED: {
                        String line3 = lineReader.produce();
                        if (line3 == null) {
                            throw new DiffException("Deleted line \"" + lc.text + "\" is beyond the end-of-file");
                        }
                        if (!lc.text.equals(line3)) {
                            throw new DiffException("Deleted line mismatch; expected \"" + lc.text + "\", but was \"" + line3 + "\"");
                        }
                        ++i;
                        continue block7;
                    }
                }
                throw new AssertionError();
            }
            if (hunk.from1 == i) {
                LOGGER.log(Level.CONFIG, "{0}: Patching after line {1}", new Object[]{path, i});
                continue;
            }
            if (hunk.from1 == i - 1) {
                LOGGER.log(Level.CONFIG, "{0}: Patching line {1}", new Object[]{path, i});
                continue;
            }
            LOGGER.log(Level.CONFIG, "{0}: Patching lines {1}...{2}", new Object[]{path, hunk.from1 + 1, i});
        }
        while ((line = lineReader.produce()) != null) {
            writer.write(line);
        }
        writer.flush();
        LOGGER.log(Level.FINE, "{0}: Patched {1,choice,0#{1} hunks|1#{1} hunk|1<{1} hunks}", new Object[]{path, this.hunks.size()});
    }

    public static interface Condition {
        public static final Condition ALWAYS = new Condition(){

            @Override
            public boolean evaluate(String path, List<DiffParser.Hunk> hunks, int hunkIndex, DiffParser.Hunk hunk, int lineNumber) {
                return true;
            }
        };

        public boolean evaluate(String var1, List<DiffParser.Hunk> var2, int var3, DiffParser.Hunk var4, int var5);
    }
}

