/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.zz.patch;

import de.unkrig.commons.file.ExceptionHandler;
import de.unkrig.commons.file.filetransformation.FileTransformations;
import de.unkrig.commons.file.filetransformation.FileTransformer;
import de.unkrig.commons.file.org.apache.commons.compress.archivers.ArchiveFormatFactory;
import de.unkrig.commons.file.org.apache.commons.compress.compressors.CompressionFormatFactory;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.LevelFilteredPrinter;
import de.unkrig.commons.text.Printers;
import de.unkrig.commons.text.StringStream;
import de.unkrig.commons.text.expression.AbstractExpression;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.expression.ExpressionUtil;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;
import de.unkrig.commons.util.annotation.RegexFlags;
import de.unkrig.commons.util.logging.SimpleLogging;
import de.unkrig.zz.patch.Patch;
import de.unkrig.zz.patch.PatchContentsTransformer;
import de.unkrig.zz.patch.PatchTextTransformer;
import de.unkrig.zz.patch.SubstitutionContentsTransformer;
import de.unkrig.zz.patch.UpdateContentsTransformer;
import de.unkrig.zz.patch.diff.DiffParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;

public final class Main {
    private static final ExceptionHandler<IOException> PRINT_AND_CONTINUE = new ExceptionHandler<IOException>(){

        @Override
        public void handle(String path, IOException ioe) {
            Printers.error(path, ioe);
        }

        @Override
        public void handle(String path, RuntimeException rte) {
            if (rte == FileTransformer.NOT_IDENTICAL) {
                Printers.verbose(path);
            } else {
                Printers.error(path, rte);
            }
        }
    };
    private static final ExceptionHandler<IOException> RETHROW = new ExceptionHandler<IOException>(){

        @Override
        public void handle(String path, IOException ioe) throws IOException {
            throw ioe;
        }

        @Override
        public void handle(String path, RuntimeException rte) {
            if (rte == FileTransformer.NOT_IDENTICAL) {
                Printers.verbose(path);
            }
            throw rte;
        }
    };
    private final LevelFilteredPrinter levelFilteredPrinter = new LevelFilteredPrinter();
    private FileTransformer.Mode mode = FileTransformer.Mode.TRANSFORM;
    private final Patch patch = new Patch();
    private Charset inputCharset = Charset.defaultCharset();
    private Charset outputCharset = Charset.defaultCharset();
    private Charset patchFileCharset = Charset.defaultCharset();

    private Main() {
        this.patch.setExceptionHandler(RETHROW);
    }

    public static void main(String[] args) {
        String[] args2;
        final Main main = new Main();
        try {
            args2 = CommandLineOptions.parse(args, main);
        }
        catch (CommandLineOptionException cloe) {
            Printers.error(cloe.getMessage() + ", try \"--help\".");
            System.exit(1);
            return;
        }
        main.levelFilteredPrinter.run(new Runnable(){

            @Override
            public void run() {
                main.main2(args2);
            }
        });
    }

    private void main2(String[] args) {
        try {
            this.main3(args);
        }
        catch (Exception e) {
            if (e == FileTransformer.NOT_IDENTICAL) {
                System.exit(1);
            }
            Printers.error(null, e);
        }
    }

    @CommandLineOption
    public void lookInto(@RegexFlags(value=-1610612736) Glob glob) {
        this.patch.setLookIntoFormat(glob);
    }

    @CommandLineOption
    public void dontSortDirectoryMembers() {
        this.patch.setDirectoryMemberNameComparator(null);
    }

    @CommandLineOption
    public void setPatchFileEncoding(Charset charset) {
        this.patchFileCharset = charset;
    }

    @CommandLineOption(group={FileTransformerModeCommandLineOptionGroup.class})
    public void check() {
        this.mode = FileTransformer.Mode.CHECK;
    }

    @CommandLineOption(group={FileTransformerModeCommandLineOptionGroup.class})
    public void checkBeforeTransformation() {
        this.mode = FileTransformer.Mode.CHECK_AND_TRANSFORM;
    }

    @CommandLineOption
    public void keep() {
        this.patch.setKeepOriginals(true);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addUpdate(@RegexFlags(value=-536870912) Glob specification, UpdateConditions updateConditions) {
        UpdateContentsTransformer contentsTransformer = new UpdateContentsTransformer(specification);
        this.patch.addContentsTransformation(PredicateUtil.and(specification, ExpressionUtil.toPredicate(updateConditions.result, "path")), contentsTransformer);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addSubstitute(@RegexFlags(value=-1610612736) Glob glob, @RegexFlags(value=8) Pattern pattern, String replacement, SubstituteConditions substituteConditions) {
        final Expression condition = substituteConditions.result;
        SubstitutionContentsTransformer contentsTransformer = new SubstitutionContentsTransformer(this.inputCharset, this.outputCharset, pattern, replacement, condition == Expression.TRUE ? SubstitutionContentsTransformer.Condition.ALWAYS : (condition == Expression.FALSE ? SubstitutionContentsTransformer.Condition.NEVER : new SubstitutionContentsTransformer.Condition(){

            @Override
            public boolean evaluate(String path, CharSequence match, int occurrence) {
                try {
                    return ExpressionEvaluator.toBoolean(condition.evaluate(Mappings.mapping("path", path, "match", match, "occurrence", occurrence)));
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
            }

            public String toString() {
                return condition.toString();
            }
        }));
        this.patch.addContentsTransformation(glob, contentsTransformer);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addPatch(@RegexFlags(value=-1610612736) Glob glob, File patchFile, final PatchConditions patchConditions) throws IOException, StringStream.UnexpectedElementException {
        PatchContentsTransformer contentsTransformer = new PatchContentsTransformer(this.inputCharset, this.outputCharset, patchFile, this.patchFileCharset, new PatchTextTransformer.Condition(){

            @Override
            public boolean evaluate(String path, List<DiffParser.Hunk> hunks, int hunkIndex, DiffParser.Hunk hunk, int lineNumber) {
                try {
                    return ExpressionEvaluator.toBoolean(patchConditions.result.evaluate(Mappings.mapping("path", path, "hunks", hunks, "hunkIndex", hunkIndex, "lineNumber", lineNumber)));
                }
                catch (EvaluationException ee) {
                    throw new RuntimeException(ee);
                }
            }
        });
        this.patch.addContentsTransformation(glob, contentsTransformer);
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addRemove(@RegexFlags(value=-1610612736) Glob glob, RemoveConditions removeConditions) {
        this.patch.addRemoval(PredicateUtil.and(glob, ExpressionUtil.toPredicate(removeConditions.result, "path")));
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addRename(final @RegexFlags(value=-536870912) Glob glob, final RenameConditions renameConditions) {
        this.patch.addRenaming(new Glob(){

            @Override
            public boolean matches(String subject) {
                return glob.matches(subject);
            }

            @Override
            @Nullable
            public String replace(String subject) {
                String result = glob.replace(subject);
                return result != null && ExpressionUtil.toPredicate(renameConditions.result, "path").evaluate(subject) ? result : null;
            }
        });
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public void addAdd(@RegexFlags(value=-1610612736) Glob glob, String name, File contentsFile, AddConditions addConditions) {
        this.patch.addAddition(PredicateUtil.and(glob, ExpressionUtil.toPredicate(addConditions.result, "path")), name, contentsFile);
    }

    @CommandLineOption
    public void setInputEncoding(Charset charset) {
        this.inputCharset = charset;
    }

    @CommandLineOption
    public void setOutputEncoding(Charset charset) {
        this.outputCharset = charset;
    }

    @CommandLineOption
    public void setEncoding(Charset charset) {
        this.patchFileCharset = charset;
        this.inputCharset = charset;
        this.outputCharset = charset;
    }

    @CommandLineOption
    public static void help() throws IOException {
        System.setProperty("archive.formats", ArchiveFormatFactory.allFormats().toString());
        System.setProperty("compression.formats", CompressionFormatFactory.allFormats().toString());
        CommandLineOptions.printResource(Main.class, "main(String[]).txt", Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void keepGoing() {
        this.patch.setExceptionHandler(PRINT_AND_CONTINUE);
    }

    @CommandLineOption
    public void noWarn() {
        this.levelFilteredPrinter.setNoWarn();
    }

    @CommandLineOption
    public void quiet() {
        this.levelFilteredPrinter.setQuiet();
    }

    @CommandLineOption
    public void verbose() {
        this.levelFilteredPrinter.setVerbose();
    }

    @CommandLineOption
    public void debug() {
        this.levelFilteredPrinter.setDebug();
    }

    @CommandLineOption(cardinality=CommandLineOption.Cardinality.ANY)
    public static void addLog(String spec) {
        SimpleLogging.configureLoggers(spec);
    }

    private void main3(String[] args) throws IOException {
        if (args.length == 0) {
            if (this.mode != FileTransformer.Mode.TRANSFORM) {
                System.err.println("\"--check\" or \"--check-before-transformation\" cannot be used if the input is STDIN.");
                System.exit(1);
            }
            this.patch.contentsTransformer().transform("-", System.in, System.out);
        } else {
            FileTransformations.transform(args, this.patch.fileTransformer(true, false), this.mode, this.patch.getExceptionHandler());
        }
    }

    public static abstract class Conditions {
        private final String[] variableNames;
        Expression result = Expression.TRUE;

        public Conditions(String ... variableNames) {
            this.variableNames = variableNames;
        }

        @CommandLineOption
        public void addReport(String expression) throws ParseException {
            final Expression reportExpression = new ExpressionEvaluator(this.variableNames).parse(expression);
            this.result = ExpressionUtil.logicalAnd(this.result, new AbstractExpression(){

                @Override
                @Nullable
                public Object evaluate(Mapping<String, ?> variables) throws EvaluationException {
                    Printers.info(String.valueOf(reportExpression.evaluate(variables)));
                    return true;
                }
            });
        }

        @CommandLineOption
        public void addIff(String expression) throws ParseException {
            Expression iffExpression = new ExpressionEvaluator(this.variableNames).parse(expression);
            this.result = ExpressionUtil.logicalAnd(this.result, iffExpression);
        }
    }

    public static class AddConditions
    extends Conditions {
        public AddConditions() {
            super("path");
        }
    }

    public static class RenameConditions
    extends Conditions {
        public RenameConditions() {
            super("path");
        }
    }

    public static class UpdateConditions
    extends Conditions {
        public UpdateConditions() {
            super("path");
        }
    }

    public static class RemoveConditions
    extends Conditions {
        public RemoveConditions() {
            super("path");
        }
    }

    public static class PatchConditions
    extends Conditions {
        public PatchConditions() {
            super("path", "hunks", "hunkIndex", "hunk", "lineNumber");
        }
    }

    public static class SubstituteConditions
    extends Conditions {
        public SubstituteConditions() {
            super("path", "match", "occurrence");
        }
    }

    @CommandLineOptionGroup
    static interface FileTransformerModeCommandLineOptionGroup {
    }
}

